# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from .knowledge_document_search_response import KnowledgeDocumentSearchResponse


class KnowledgeDocumentResponse(KnowledgeDocumentSearchResponse):
    """
    Examples
    --------
    from mavenagi.commons import EntityId
    from mavenagi.knowledge import KnowledgeDocumentResponse

    KnowledgeDocumentResponse(
        knowledge_document_id=EntityId(
            reference_id="getting-started",
            app_id="readme",
            organization_id="acme",
            agent_id="support",
            type="KNOWLEDGE_DOCUMENT",
        ),
        knowledge_base_version_id=EntityId(
            reference_id="versionId",
            app_id="maven",
            organization_id="acme",
            agent_id="support",
            type="KNOWLEDGE_BASE_VERSION",
        ),
        content="## Getting started This is a getting started guide for the help center.",
        title="Getting started",
        metadata={"category": "getting-started"},
    )
    """

    content: str = pydantic.Field()
    """
    The content of the document in markdown format. Not shown directly to users.
    """

    metadata: typing.Dict[str, str] = pydantic.Field()
    """
    Metadata for the knowledge document.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
