# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .base_knowledge_document import BaseKnowledgeDocument


class KnowledgeDocumentSearchResponse(BaseKnowledgeDocument):
    knowledge_document_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="knowledgeDocumentId")] = (
        pydantic.Field()
    )
    """
    ID that uniquely identifies this knowledge document within its knowledge base
    """

    knowledge_base_version_id: typing_extensions.Annotated[
        typing.Optional[EntityId], FieldMetadata(alias="knowledgeBaseVersionId")
    ] = pydantic.Field(default=None)
    """
    ID that uniquely identifies the knowledge base version that contains this document.
    This may be missing on legacy documents.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
