# This file was auto-generated by Fern from our API Definition.

import typing

from ..analytics.types.chart_response import ChartResponse
from ..analytics.types.conversation_chart_request import ConversationChartRequest
from ..analytics.types.conversation_column_definition import ConversationColumnDefinition
from ..analytics.types.conversation_group_by import ConversationGroupBy
from ..analytics.types.conversation_table_response import ConversationTableResponse
from ..analytics.types.time_interval import TimeInterval
from ..conversation.types.conversation_filter import ConversationFilter
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawOrganizationsClient, RawOrganizationsClient
from .types.organization import Organization

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OrganizationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOrganizationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOrganizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOrganizationsClient
        """
        return self._raw_client

    def create(
        self,
        organization_reference_id: str,
        *,
        name: str,
        default_language: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Organization:
        """
        Create a new organization.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        name : str
            The name of the organization.

        default_language : str
            The default language for the organization in ISO 639-1 code format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Organization

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.organizations.create(
            organization_reference_id="organizationReferenceId",
            name="name",
            default_language="defaultLanguage",
        )
        """
        _response = self._raw_client.create(
            organization_reference_id, name=name, default_language=default_language, request_options=request_options
        )
        return _response.data

    def get(
        self, organization_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Organization:
        """
        Get an organization by ID

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Organization

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.organizations.get(
            organization_reference_id="organizationReferenceId",
        )
        """
        _response = self._raw_client.get(organization_reference_id, request_options=request_options)
        return _response.data

    def patch(
        self,
        organization_reference_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        default_language: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Organization:
        """
        Update mutable organization fields.
        All fields will overwrite the existing value on the organization only if provided.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        name : typing.Optional[str]
            The name of the organization.

        default_language : typing.Optional[str]
            The default language for the organization in ISO 639-1 code format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Organization

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.organizations.patch(
            organization_reference_id="organizationReferenceId",
        )
        """
        _response = self._raw_client.patch(
            organization_reference_id, name=name, default_language=default_language, request_options=request_options
        )
        return _response.data

    def delete(
        self, organization_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete an organization.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.organizations.delete(
            organization_reference_id="organizationReferenceId",
        )
        """
        _response = self._raw_client.delete(organization_reference_id, request_options=request_options)
        return _response.data

    def get_conversation_table(
        self,
        *,
        field_groupings: typing.Sequence[ConversationGroupBy],
        column_definitions: typing.Sequence[ConversationColumnDefinition],
        time_grouping: typing.Optional[TimeInterval] = OMIT,
        conversation_filter: typing.Optional[ConversationFilter] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationTableResponse:
        """
        Retrieves structured conversation data across all organizations, formatted as a table,
        allowing users to group, filter, and define specific metrics to display as columns.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        field_groupings : typing.Sequence[ConversationGroupBy]
            Specifies the fields by which data should be grouped. Each unique combination forms a row.
            If multiple fields are provided, the result is grouped by their unique value combinations.
            If empty, all data is aggregated into a single row. |
            Note: The field `CreatedAt` should not be used here, all time-based grouping should be done using the `timeGrouping` field.

        column_definitions : typing.Sequence[ConversationColumnDefinition]
            Specifies the metrics to be displayed as columns. Column headers act as keys, with computed metric values as their mapped values. There needs to be at least one column definition in the table request.

        time_grouping : typing.Optional[TimeInterval]
            Defines the time interval for grouping data. If specified, data is grouped accordingly  based on the time they were created. Example: If set to "DAY," data will be aggregated by day.

        conversation_filter : typing.Optional[ConversationFilter]
            Optional filter applied to refine the conversation data before processing.

        timezone : typing.Optional[str]
            IANA timezone identifier (e.g., "America/Los_Angeles").
            When provided, time-based groupings (e.g., DAY) and date filters are evaluated in this timezone;
            otherwise UTC is used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationTableResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.analytics import (
            ConversationColumnDefinition,
            ConversationGroupBy,
            ConversationMetric_Average,
            ConversationMetric_Count,
            ConversationMetric_Percentile,
        )
        from mavenagi.conversation import ConversationFilter

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.organizations.get_conversation_table(
            conversation_filter=ConversationFilter(
                languages=["en", "es"],
            ),
            time_grouping="DAY",
            field_groupings=[
                ConversationGroupBy(
                    field="Category",
                )
            ],
            column_definitions=[
                ConversationColumnDefinition(
                    header="count",
                    metric=ConversationMetric_Count(),
                ),
                ConversationColumnDefinition(
                    header="avg_first_response_time",
                    metric=ConversationMetric_Average(
                        target_field="FirstResponseTime",
                    ),
                ),
                ConversationColumnDefinition(
                    header="percentile_handle_time",
                    metric=ConversationMetric_Percentile(
                        target_field="HandleTime",
                        percentile=25.0,
                    ),
                ),
            ],
        )
        """
        _response = self._raw_client.get_conversation_table(
            field_groupings=field_groupings,
            column_definitions=column_definitions,
            time_grouping=time_grouping,
            conversation_filter=conversation_filter,
            timezone=timezone,
            request_options=request_options,
        )
        return _response.data

    def get_conversation_chart(
        self, *, request: ConversationChartRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ChartResponse:
        """
        Fetches conversation data across all organizations, visualized in a chart format.
        Supported chart types include pie chart, date histogram, and stacked bar charts.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        request : ConversationChartRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChartResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.analytics import (
            ConversationChartRequest_PieChart,
            ConversationGroupBy,
            ConversationMetric_Count,
        )
        from mavenagi.conversation import ConversationFilter

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.organizations.get_conversation_chart(
            request=ConversationChartRequest_PieChart(
                conversation_filter=ConversationFilter(
                    languages=["en", "es"],
                ),
                group_by=ConversationGroupBy(
                    field="Category",
                ),
                metric=ConversationMetric_Count(),
            ),
        )
        """
        _response = self._raw_client.get_conversation_chart(request=request, request_options=request_options)
        return _response.data


class AsyncOrganizationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOrganizationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOrganizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOrganizationsClient
        """
        return self._raw_client

    async def create(
        self,
        organization_reference_id: str,
        *,
        name: str,
        default_language: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Organization:
        """
        Create a new organization.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        name : str
            The name of the organization.

        default_language : str
            The default language for the organization in ISO 639-1 code format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Organization

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.organizations.create(
                organization_reference_id="organizationReferenceId",
                name="name",
                default_language="defaultLanguage",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            organization_reference_id, name=name, default_language=default_language, request_options=request_options
        )
        return _response.data

    async def get(
        self, organization_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Organization:
        """
        Get an organization by ID

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Organization

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.organizations.get(
                organization_reference_id="organizationReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(organization_reference_id, request_options=request_options)
        return _response.data

    async def patch(
        self,
        organization_reference_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        default_language: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Organization:
        """
        Update mutable organization fields.
        All fields will overwrite the existing value on the organization only if provided.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        name : typing.Optional[str]
            The name of the organization.

        default_language : typing.Optional[str]
            The default language for the organization in ISO 639-1 code format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Organization

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.organizations.patch(
                organization_reference_id="organizationReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            organization_reference_id, name=name, default_language=default_language, request_options=request_options
        )
        return _response.data

    async def delete(
        self, organization_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete an organization.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The reference ID of the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.organizations.delete(
                organization_reference_id="organizationReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(organization_reference_id, request_options=request_options)
        return _response.data

    async def get_conversation_table(
        self,
        *,
        field_groupings: typing.Sequence[ConversationGroupBy],
        column_definitions: typing.Sequence[ConversationColumnDefinition],
        time_grouping: typing.Optional[TimeInterval] = OMIT,
        conversation_filter: typing.Optional[ConversationFilter] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationTableResponse:
        """
        Retrieves structured conversation data across all organizations, formatted as a table,
        allowing users to group, filter, and define specific metrics to display as columns.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        field_groupings : typing.Sequence[ConversationGroupBy]
            Specifies the fields by which data should be grouped. Each unique combination forms a row.
            If multiple fields are provided, the result is grouped by their unique value combinations.
            If empty, all data is aggregated into a single row. |
            Note: The field `CreatedAt` should not be used here, all time-based grouping should be done using the `timeGrouping` field.

        column_definitions : typing.Sequence[ConversationColumnDefinition]
            Specifies the metrics to be displayed as columns. Column headers act as keys, with computed metric values as their mapped values. There needs to be at least one column definition in the table request.

        time_grouping : typing.Optional[TimeInterval]
            Defines the time interval for grouping data. If specified, data is grouped accordingly  based on the time they were created. Example: If set to "DAY," data will be aggregated by day.

        conversation_filter : typing.Optional[ConversationFilter]
            Optional filter applied to refine the conversation data before processing.

        timezone : typing.Optional[str]
            IANA timezone identifier (e.g., "America/Los_Angeles").
            When provided, time-based groupings (e.g., DAY) and date filters are evaluated in this timezone;
            otherwise UTC is used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationTableResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.analytics import (
            ConversationColumnDefinition,
            ConversationGroupBy,
            ConversationMetric_Average,
            ConversationMetric_Count,
            ConversationMetric_Percentile,
        )
        from mavenagi.conversation import ConversationFilter

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.organizations.get_conversation_table(
                conversation_filter=ConversationFilter(
                    languages=["en", "es"],
                ),
                time_grouping="DAY",
                field_groupings=[
                    ConversationGroupBy(
                        field="Category",
                    )
                ],
                column_definitions=[
                    ConversationColumnDefinition(
                        header="count",
                        metric=ConversationMetric_Count(),
                    ),
                    ConversationColumnDefinition(
                        header="avg_first_response_time",
                        metric=ConversationMetric_Average(
                            target_field="FirstResponseTime",
                        ),
                    ),
                    ConversationColumnDefinition(
                        header="percentile_handle_time",
                        metric=ConversationMetric_Percentile(
                            target_field="HandleTime",
                            percentile=25.0,
                        ),
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_conversation_table(
            field_groupings=field_groupings,
            column_definitions=column_definitions,
            time_grouping=time_grouping,
            conversation_filter=conversation_filter,
            timezone=timezone,
            request_options=request_options,
        )
        return _response.data

    async def get_conversation_chart(
        self, *, request: ConversationChartRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ChartResponse:
        """
        Fetches conversation data across all organizations, visualized in a chart format.
        Supported chart types include pie chart, date histogram, and stacked bar charts.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        request : ConversationChartRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChartResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.analytics import (
            ConversationChartRequest_PieChart,
            ConversationGroupBy,
            ConversationMetric_Count,
        )
        from mavenagi.conversation import ConversationFilter

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.organizations.get_conversation_chart(
                request=ConversationChartRequest_PieChart(
                    conversation_filter=ConversationFilter(
                        languages=["en", "es"],
                    ),
                    group_by=ConversationGroupBy(
                        field="Category",
                    ),
                    metric=ConversationMetric_Count(),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_conversation_chart(request=request, request_options=request_options)
        return _response.data
