# This file was auto-generated by Fern from our API Definition.

import typing

from ..commons.types.entity_id_base import EntityIdBase
from ..commons.types.precondition import Precondition
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawSegmentsClient, RawSegmentsClient
from .types.segment_field import SegmentField
from .types.segment_response import SegmentResponse
from .types.segment_status import SegmentStatus
from .types.segments_search_response import SegmentsSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SegmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSegmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSegmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSegmentsClient
        """
        return self._raw_client

    def search(
        self,
        *,
        sort: typing.Optional[SegmentField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentsSearchResponse:
        """
        Parameters
        ----------
        sort : typing.Optional[SegmentField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentsSearchResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.segments.search()
        """
        _response = self._raw_client.search(
            sort=sort, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def create_or_update(
        self,
        *,
        segment_id: EntityIdBase,
        name: str,
        precondition: Precondition,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentResponse:
        """
        Update a segment or create it if it doesn't exist.

        Parameters
        ----------
        segment_id : EntityIdBase
            ID that uniquely identifies this segment

        name : str
            The name of the segment.

        precondition : Precondition
            The precondition that must be met for a conversation message to be included in the segment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import EntityIdBase, Precondition_Group, Precondition_User

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.segments.create_or_update(
            segment_id=EntityIdBase(
                reference_id="admin-users",
            ),
            name="Admin users",
            precondition=Precondition_Group(
                operator="AND",
                preconditions=[
                    Precondition_User(
                        key="userKey",
                    ),
                    Precondition_User(
                        key="userKey2",
                    ),
                ],
            ),
        )
        """
        _response = self._raw_client.create_or_update(
            segment_id=segment_id, name=name, precondition=precondition, request_options=request_options
        )
        return _response.data

    def get(
        self,
        segment_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentResponse:
        """
        Get a segment by its supplied ID

        Parameters
        ----------
        segment_reference_id : str
            The reference ID of the segment to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the segment to get. If not provided, the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.segments.get(
            segment_reference_id="admin-users",
        )
        """
        _response = self._raw_client.get(segment_reference_id, app_id=app_id, request_options=request_options)
        return _response.data

    def patch(
        self,
        segment_reference_id: str,
        *,
        app_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        status: typing.Optional[SegmentStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentResponse:
        """
        Update mutable segment fields

        The `appId` field can be provided to update a segment owned by a different app.
        All other fields will overwrite the existing value on the segment only if provided.

        Parameters
        ----------
        segment_reference_id : str
            The reference ID of the segment to update. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the segment to update. If not provided, the ID of the calling app will be used.

        name : typing.Optional[str]
            The name of the segment.

        precondition : typing.Optional[Precondition]
            The precondition that must be met for a conversation message to be included in the segment.

        status : typing.Optional[SegmentStatus]
            The status of the segment. Segments can only be deactivated if they are not set on any actions or active knowledge bases.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentResponse
            The updated segment

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.segments.patch(
            segment_reference_id="segmentReferenceId",
        )
        """
        _response = self._raw_client.patch(
            segment_reference_id,
            app_id=app_id,
            name=name,
            precondition=precondition,
            status=status,
            request_options=request_options,
        )
        return _response.data


class AsyncSegmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSegmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSegmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSegmentsClient
        """
        return self._raw_client

    async def search(
        self,
        *,
        sort: typing.Optional[SegmentField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentsSearchResponse:
        """
        Parameters
        ----------
        sort : typing.Optional[SegmentField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentsSearchResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.segments.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            sort=sort, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def create_or_update(
        self,
        *,
        segment_id: EntityIdBase,
        name: str,
        precondition: Precondition,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentResponse:
        """
        Update a segment or create it if it doesn't exist.

        Parameters
        ----------
        segment_id : EntityIdBase
            ID that uniquely identifies this segment

        name : str
            The name of the segment.

        precondition : Precondition
            The precondition that must be met for a conversation message to be included in the segment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import EntityIdBase, Precondition_Group, Precondition_User

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.segments.create_or_update(
                segment_id=EntityIdBase(
                    reference_id="admin-users",
                ),
                name="Admin users",
                precondition=Precondition_Group(
                    operator="AND",
                    preconditions=[
                        Precondition_User(
                            key="userKey",
                        ),
                        Precondition_User(
                            key="userKey2",
                        ),
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            segment_id=segment_id, name=name, precondition=precondition, request_options=request_options
        )
        return _response.data

    async def get(
        self,
        segment_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentResponse:
        """
        Get a segment by its supplied ID

        Parameters
        ----------
        segment_reference_id : str
            The reference ID of the segment to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the segment to get. If not provided, the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.segments.get(
                segment_reference_id="admin-users",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(segment_reference_id, app_id=app_id, request_options=request_options)
        return _response.data

    async def patch(
        self,
        segment_reference_id: str,
        *,
        app_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        status: typing.Optional[SegmentStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SegmentResponse:
        """
        Update mutable segment fields

        The `appId` field can be provided to update a segment owned by a different app.
        All other fields will overwrite the existing value on the segment only if provided.

        Parameters
        ----------
        segment_reference_id : str
            The reference ID of the segment to update. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the segment to update. If not provided, the ID of the calling app will be used.

        name : typing.Optional[str]
            The name of the segment.

        precondition : typing.Optional[Precondition]
            The precondition that must be met for a conversation message to be included in the segment.

        status : typing.Optional[SegmentStatus]
            The status of the segment. Segments can only be deactivated if they are not set on any actions or active knowledge bases.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentResponse
            The updated segment

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.segments.patch(
                segment_reference_id="segmentReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            segment_reference_id,
            app_id=app_id,
            name=name,
            precondition=precondition,
            status=status,
            request_options=request_options,
        )
        return _response.data
