# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ...core.serialization import FieldMetadata
from .segment_status import SegmentStatus


class SegmentPatchRequest(UniversalBaseModel):
    app_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="appId")] = pydantic.Field(
        default=None
    )
    """
    The App ID of the segment to update. If not provided, the ID of the calling app will be used.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the segment.
    """

    precondition: typing.Optional["Precondition"] = pydantic.Field(default=None)
    """
    The precondition that must be met for a conversation message to be included in the segment.
    """

    status: typing.Optional[SegmentStatus] = pydantic.Field(default=None)
    """
    The status of the segment. Segments can only be deactivated if they are not set on any actions or active knowledge bases.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
from ...commons.types.precondition import Precondition  # noqa: E402, F401, I001

update_forward_refs(SegmentPatchRequest)
