# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_base import EntityIdBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .segment_base import SegmentBase


class SegmentRequest(SegmentBase):
    """
    Examples
    --------
    from mavenagi.commons import EntityIdBase, Precondition_Group, Precondition_User
    from mavenagi.segments import SegmentRequest

    SegmentRequest(
        segment_id=EntityIdBase(
            reference_id="admin-users",
        ),
        name="Admin users",
        precondition=Precondition_Group(
            operator="AND",
            preconditions=[
                Precondition_User(
                    key="userKey",
                ),
                Precondition_User(
                    key="userKey2",
                ),
            ],
        ),
    )
    """

    segment_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="segmentId")] = pydantic.Field()
    """
    ID that uniquely identifies this segment
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
