# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .segment_base import SegmentBase
from .segment_status import SegmentStatus


class SegmentResponse(SegmentBase):
    """
    Examples
    --------
    from mavenagi.commons import EntityId, Precondition_Group, Precondition_User
    from mavenagi.segments import SegmentResponse

    SegmentResponse(
        segment_id=EntityId(
            reference_id="admin-users",
            app_id="auth-app",
            organization_id="acme",
            agent_id="support",
            type="SEGMENT",
        ),
        name="Admin users",
        status="ACTIVE",
        precondition=Precondition_Group(
            operator="AND",
            preconditions=[
                Precondition_User(
                    key="userKey",
                ),
                Precondition_User(
                    key="userKey2",
                ),
            ],
        ),
    )
    """

    segment_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="segmentId")] = pydantic.Field()
    """
    ID that uniquely identifies this segment
    """

    status: SegmentStatus = pydantic.Field()
    """
    Whether or not the segment is in active use. To preserve historical data, segments can not be deleted.
    
    Only active segments will be evaluated for matching user questions.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
