# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawTranslationsClient, RawTranslationsClient
from .types.translation_response import TranslationResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TranslationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTranslationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTranslationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTranslationsClient
        """
        return self._raw_client

    def translate(
        self, *, text: str, target_language: str, request_options: typing.Optional[RequestOptions] = None
    ) -> TranslationResponse:
        """
        Translate text from one language to another

        Parameters
        ----------
        text : str
            The text to translate

        target_language : str
            The target language to translate to, in ISO 639-1 code format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TranslationResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.translations.translate(
            text="Hello world",
            target_language="es",
        )
        """
        _response = self._raw_client.translate(
            text=text, target_language=target_language, request_options=request_options
        )
        return _response.data


class AsyncTranslationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTranslationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTranslationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTranslationsClient
        """
        return self._raw_client

    async def translate(
        self, *, text: str, target_language: str, request_options: typing.Optional[RequestOptions] = None
    ) -> TranslationResponse:
        """
        Translate text from one language to another

        Parameters
        ----------
        text : str
            The text to translate

        target_language : str
            The target language to translate to, in ISO 639-1 code format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TranslationResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.translations.translate(
                text="Hello world",
                target_language="es",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.translate(
            text=text, target_language=target_language, request_options=request_options
        )
        return _response.data
