# This file was auto-generated by Fern from our API Definition.

import typing

from ..commons.types.entity_id_base import EntityIdBase
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawTriggersClient, RawTriggersClient
from .types.event_trigger_response import EventTriggerResponse
from .types.event_trigger_type import EventTriggerType
from .types.event_triggers_search_response import EventTriggersSearchResponse
from .types.trigger_field import TriggerField

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TriggersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTriggersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTriggersClient
        """
        return self._raw_client

    def search(
        self,
        *,
        sort: typing.Optional[TriggerField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventTriggersSearchResponse:
        """
        Parameters
        ----------
        sort : typing.Optional[TriggerField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggersSearchResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.triggers.search()
        """
        _response = self._raw_client.search(
            sort=sort, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def create_or_update(
        self,
        *,
        trigger_id: EntityIdBase,
        description: str,
        type: EventTriggerType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventTriggerResponse:
        """
        Update an event trigger or create it if it doesn't exist.

        Parameters
        ----------
        trigger_id : EntityIdBase
            ID that uniquely identifies this event trigger

        description : str
            The description of what the event trigger does, shown in the Maven Dashboard

        type : EventTriggerType
            The type of event trigger this app wishes to handle.

            Conversation triggers fire when a conversation is created, after each additional message, and upon deletion events.
            There is a small delay before trigger execution to allow time for conversation analysis to complete.

            Feedback can not be modified, so the feedback trigger fires immediately after feedback is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggerResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import EntityIdBase

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.triggers.create_or_update(
            trigger_id=EntityIdBase(
                reference_id="store-in-snowflake",
            ),
            description="Stores conversation data in Snowflake",
            type="CONVERSATION_CREATED",
        )
        """
        _response = self._raw_client.create_or_update(
            trigger_id=trigger_id, description=description, type=type, request_options=request_options
        )
        return _response.data

    def get(
        self, trigger_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EventTriggerResponse:
        """
        Get an event trigger by its supplied ID

        Parameters
        ----------
        trigger_reference_id : str
            The reference ID of the event trigger to get. All other entity ID fields are inferred from the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggerResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.triggers.get(
            trigger_reference_id="store-in-snowflake",
        )
        """
        _response = self._raw_client.get(trigger_reference_id, request_options=request_options)
        return _response.data

    def delete(self, trigger_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete an event trigger

        Parameters
        ----------
        trigger_reference_id : str
            The reference ID of the event trigger to delete. All other entity ID fields are inferred from the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.triggers.delete(
            trigger_reference_id="store-in-snowflake",
        )
        """
        _response = self._raw_client.delete(trigger_reference_id, request_options=request_options)
        return _response.data

    def partial_update(
        self,
        trigger_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventTriggerResponse:
        """
        Updates an event trigger. Only the enabled field is editable.

        Parameters
        ----------
        trigger_reference_id : str
            The reference ID of the event trigger to update. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the trigger to update. If not provided, the ID of the calling app will be used.

        enabled : typing.Optional[bool]
            Whether the trigger will be called by Maven.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggerResponse
            The updated event trigger

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.triggers.partial_update(
            trigger_reference_id="triggerReferenceId",
        )
        """
        _response = self._raw_client.partial_update(
            trigger_reference_id, app_id=app_id, enabled=enabled, request_options=request_options
        )
        return _response.data


class AsyncTriggersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTriggersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTriggersClient
        """
        return self._raw_client

    async def search(
        self,
        *,
        sort: typing.Optional[TriggerField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventTriggersSearchResponse:
        """
        Parameters
        ----------
        sort : typing.Optional[TriggerField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggersSearchResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.triggers.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            sort=sort, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def create_or_update(
        self,
        *,
        trigger_id: EntityIdBase,
        description: str,
        type: EventTriggerType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventTriggerResponse:
        """
        Update an event trigger or create it if it doesn't exist.

        Parameters
        ----------
        trigger_id : EntityIdBase
            ID that uniquely identifies this event trigger

        description : str
            The description of what the event trigger does, shown in the Maven Dashboard

        type : EventTriggerType
            The type of event trigger this app wishes to handle.

            Conversation triggers fire when a conversation is created, after each additional message, and upon deletion events.
            There is a small delay before trigger execution to allow time for conversation analysis to complete.

            Feedback can not be modified, so the feedback trigger fires immediately after feedback is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggerResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import EntityIdBase

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.triggers.create_or_update(
                trigger_id=EntityIdBase(
                    reference_id="store-in-snowflake",
                ),
                description="Stores conversation data in Snowflake",
                type="CONVERSATION_CREATED",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            trigger_id=trigger_id, description=description, type=type, request_options=request_options
        )
        return _response.data

    async def get(
        self, trigger_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EventTriggerResponse:
        """
        Get an event trigger by its supplied ID

        Parameters
        ----------
        trigger_reference_id : str
            The reference ID of the event trigger to get. All other entity ID fields are inferred from the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggerResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.triggers.get(
                trigger_reference_id="store-in-snowflake",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(trigger_reference_id, request_options=request_options)
        return _response.data

    async def delete(
        self, trigger_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete an event trigger

        Parameters
        ----------
        trigger_reference_id : str
            The reference ID of the event trigger to delete. All other entity ID fields are inferred from the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.triggers.delete(
                trigger_reference_id="store-in-snowflake",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(trigger_reference_id, request_options=request_options)
        return _response.data

    async def partial_update(
        self,
        trigger_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventTriggerResponse:
        """
        Updates an event trigger. Only the enabled field is editable.

        Parameters
        ----------
        trigger_reference_id : str
            The reference ID of the event trigger to update. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the trigger to update. If not provided, the ID of the calling app will be used.

        enabled : typing.Optional[bool]
            Whether the trigger will be called by Maven.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventTriggerResponse
            The updated event trigger

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.triggers.partial_update(
                trigger_reference_id="triggerReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.partial_update(
            trigger_reference_id, app_id=app_id, enabled=enabled, request_options=request_options
        )
        return _response.data
