# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .event_trigger_type import EventTriggerType


class EventTriggerBase(UniversalBaseModel):
    description: str = pydantic.Field()
    """
    The description of what the event trigger does, shown in the Maven Dashboard
    """

    type: EventTriggerType = pydantic.Field()
    """
    The type of event trigger this app wishes to handle.
    
    Conversation triggers fire when a conversation is created, after each additional message, and upon deletion events.
    There is a small delay before trigger execution to allow time for conversation analysis to complete.
    
    Feedback can not be modified, so the feedback trigger fires immediately after feedback is created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
