# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_base import EntityIdBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .event_trigger_base import EventTriggerBase


class EventTriggerRequest(EventTriggerBase):
    """
    Examples
    --------
    from mavenagi.commons import EntityIdBase
    from mavenagi.triggers import EventTriggerRequest

    EventTriggerRequest(
        trigger_id=EntityIdBase(
            reference_id="store-in-snowflake",
        ),
        description="Stores conversation data in Snowflake",
        type="CONVERSATION_CREATED",
    )
    """

    trigger_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="triggerId")] = pydantic.Field()
    """
    ID that uniquely identifies this event trigger
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
