# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .event_trigger_base import EventTriggerBase


class EventTriggerResponse(EventTriggerBase):
    """
    Examples
    --------
    from mavenagi.commons import EntityId
    from mavenagi.triggers import EventTriggerResponse

    EventTriggerResponse(
        trigger_id=EntityId(
            reference_id="store-in-snowflake",
            app_id="snowflake",
            organization_id="acme",
            agent_id="support",
            type="EVENT_TRIGGER",
        ),
        description="Stores conversation data in Snowflake",
        type="CONVERSATION_CREATED",
        enabled=True,
    )
    """

    trigger_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="triggerId")] = pydantic.Field()
    """
    ID that uniquely identifies this event trigger
    """

    enabled: bool = pydantic.Field()
    """
    Whether this trigger will be called by Maven.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
