# This file was auto-generated by Fern from our API Definition.

import typing

from ..commons.types.app_user_identifier import AppUserIdentifier
from ..commons.types.app_user_response import AppUserResponse
from ..commons.types.entity_id_base import EntityIdBase
from ..commons.types.user_data import UserData
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawUsersClient, RawUsersClient
from .types.agent_user import AgentUser
from .types.agent_user_field import AgentUserField
from .types.agent_user_filter import AgentUserFilter
from .types.agent_user_search_response import AgentUserSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsersClient
        """
        return self._raw_client

    def search(
        self,
        *,
        sort: typing.Optional[AgentUserField] = OMIT,
        filter: typing.Optional[AgentUserFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentUserSearchResponse:
        """
        Search across all agent users on an agent.

        Agent users are a merged view of the users created by individual apps.

        Parameters
        ----------
        sort : typing.Optional[AgentUserField]

        filter : typing.Optional[AgentUserFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentUserSearchResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.users.search()
        """
        _response = self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def get_agent_user(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AgentUser:
        """
        Get an agent user by its supplied ID.

        Agent users are a merged view of the users created by individual apps.

        Parameters
        ----------
        user_id : str
            The ID of the agent user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentUser

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.users.get_agent_user(
            user_id="userId",
        )
        """
        _response = self._raw_client.get_agent_user(user_id, request_options=request_options)
        return _response.data

    def create_or_update(
        self,
        *,
        user_id: EntityIdBase,
        identifiers: typing.Sequence[AppUserIdentifier],
        data: typing.Dict[str, UserData],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppUserResponse:
        """
        Update an app user or create it if it doesn't exist.

        Parameters
        ----------
        user_id : EntityIdBase
            ID that uniquely identifies this app user

        identifiers : typing.Sequence[AppUserIdentifier]
            Used to determine whether two users from different apps are the same

        data : typing.Dict[str, UserData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppUserResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import AppUserIdentifier, EntityIdBase, UserData

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.users.create_or_update(
            user_id=EntityIdBase(
                reference_id="user-0",
            ),
            identifiers=[
                AppUserIdentifier(
                    value="joe@myapp.com",
                    type="EMAIL",
                )
            ],
            data={
                "name": UserData(
                    value="Joe",
                    visibility="VISIBLE",
                )
            },
        )
        """
        _response = self._raw_client.create_or_update(
            user_id=user_id, identifiers=identifiers, data=data, request_options=request_options
        )
        return _response.data

    def get(
        self,
        user_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppUserResponse:
        """
        Get an app user by its supplied ID

        Parameters
        ----------
        user_id : str
            The reference ID of the app user to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the app user to get. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppUserResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.users.get(
            user_id="user-0",
        )
        """
        _response = self._raw_client.get(user_id, app_id=app_id, request_options=request_options)
        return _response.data

    def delete(
        self,
        user_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Deletes all identifiers and user data saved by the specified app.
        Does not modify data or identifiers saved by other apps.

        If this user is linked to a user from another app, it will not be unlinked. Unlinking of users is not yet supported.

        <Warning>This is a destructive operation and cannot be undone.</Warning>

        Parameters
        ----------
        user_id : str
            The reference ID of the app user to delete. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the app user to delete. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.users.delete(
            user_id="user-0",
        )
        """
        _response = self._raw_client.delete(user_id, app_id=app_id, request_options=request_options)
        return _response.data


class AsyncUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsersClient
        """
        return self._raw_client

    async def search(
        self,
        *,
        sort: typing.Optional[AgentUserField] = OMIT,
        filter: typing.Optional[AgentUserFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentUserSearchResponse:
        """
        Search across all agent users on an agent.

        Agent users are a merged view of the users created by individual apps.

        Parameters
        ----------
        sort : typing.Optional[AgentUserField]

        filter : typing.Optional[AgentUserFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentUserSearchResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.users.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def get_agent_user(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AgentUser:
        """
        Get an agent user by its supplied ID.

        Agent users are a merged view of the users created by individual apps.

        Parameters
        ----------
        user_id : str
            The ID of the agent user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentUser

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.users.get_agent_user(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_agent_user(user_id, request_options=request_options)
        return _response.data

    async def create_or_update(
        self,
        *,
        user_id: EntityIdBase,
        identifiers: typing.Sequence[AppUserIdentifier],
        data: typing.Dict[str, UserData],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppUserResponse:
        """
        Update an app user or create it if it doesn't exist.

        Parameters
        ----------
        user_id : EntityIdBase
            ID that uniquely identifies this app user

        identifiers : typing.Sequence[AppUserIdentifier]
            Used to determine whether two users from different apps are the same

        data : typing.Dict[str, UserData]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppUserResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import AppUserIdentifier, EntityIdBase, UserData

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.users.create_or_update(
                user_id=EntityIdBase(
                    reference_id="user-0",
                ),
                identifiers=[
                    AppUserIdentifier(
                        value="joe@myapp.com",
                        type="EMAIL",
                    )
                ],
                data={
                    "name": UserData(
                        value="Joe",
                        visibility="VISIBLE",
                    )
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            user_id=user_id, identifiers=identifiers, data=data, request_options=request_options
        )
        return _response.data

    async def get(
        self,
        user_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppUserResponse:
        """
        Get an app user by its supplied ID

        Parameters
        ----------
        user_id : str
            The reference ID of the app user to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the app user to get. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppUserResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.users.get(
                user_id="user-0",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(user_id, app_id=app_id, request_options=request_options)
        return _response.data

    async def delete(
        self,
        user_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Deletes all identifiers and user data saved by the specified app.
        Does not modify data or identifiers saved by other apps.

        If this user is linked to a user from another app, it will not be unlinked. Unlinking of users is not yet supported.

        <Warning>This is a destructive operation and cannot be undone.</Warning>

        Parameters
        ----------
        user_id : str
            The reference ID of the app user to delete. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the app user to delete. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.users.delete(
                user_id="user-0",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id, app_id=app_id, request_options=request_options)
        return _response.data
