# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.app_user_identifier import AppUserIdentifier
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .app_user_summary import AppUserSummary


class AgentUser(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the agent user.
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The date and time the agent user was created
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The date and time the agent user was last updated
    """

    identifiers: typing.List[AppUserIdentifier] = pydantic.Field()
    """
    All identifiers for the agent user. This is a merged set of identifiers from the app created users.
    """

    default_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="defaultName")] = (
        pydantic.Field(default=None)
    )
    """
    A name for the agent user, if one can be determined. 
    The value is derived from the user data provided by individual apps - specifically data fields keyed by `name`, `first_name` or `firstName`.
    """

    users: typing.List[AppUserSummary] = pydantic.Field()
    """
    App created users that are associated with this agent user.
    If two apps create users with the same identifying properties, they will be merged into a single agent user.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
