# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class AgentUserFilter(UniversalBaseModel):
    search: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full-text search query for matching agent users by content. 
    When you search with this parameter, you're performing a full-text search across the user identifiers.
    """

    identifiers: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Filter by identifiers
    """

    is_anonymous: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isAnonymous")] = (
        pydantic.Field(default=None)
    )
    """
    Filter by anonymous users. When true, only anonymous users are returned.
    When false, only non-anonymous users are returned. An anonymous user is one without any identifiers or name data.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
