# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...commons.types.app_user_identifier import AppUserIdentifier
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class AppUserSummary(UniversalBaseModel):
    user_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="userId")] = pydantic.Field()
    """
    App provided user ID.
    """

    identifiers: typing.List[AppUserIdentifier] = pydantic.Field()
    """
    App provided identifiers for the user.
    """

    visible_data: typing_extensions.Annotated[typing.Dict[str, str], FieldMetadata(alias="visibleData")] = (
        pydantic.Field()
    )
    """
    App provided data masked according to the data's visibility type. `HIDDEN` or `PARTIALLY_VISIBLE` data values will be not be fully returned.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
