/*! gstwebrtc-api (https://gitlab.freedesktop.org/gstreamer/gst-plugins-rs/-/tree/main/net/webrtc/gstwebrtc-api), MPL-2.0 License, Copyright (C) 2022 Igalia S.L. <info@igalia.com>, Author: Loïc Le Page <llepage@igalia.com> */
/*! Contains embedded adapter from webrtc-adapter (https://github.com/webrtcHacks/adapter), BSD 3-Clause License, Copyright (c) 2014, The WebRTC project authors. All rights reserved. Copyright (c) 2018, The adapter.js project authors. All rights reserved. */

(()=>{"use strict";var e={539:e=>{const t={generateIdentifier:function(){return Math.random().toString(36).substring(2,12)}};t.localCName=t.generateIdentifier(),t.splitLines=function(e){return e.trim().split("\n").map((e=>e.trim()))},t.splitSections=function(e){return e.split("\nm=").map(((e,t)=>(t>0?"m="+e:e).trim()+"\r\n"))},t.getDescription=function(e){const n=t.splitSections(e);return n&&n[0]},t.getMediaSections=function(e){const n=t.splitSections(e);return n.shift(),n},t.matchPrefix=function(e,n){return t.splitLines(e).filter((e=>0===e.indexOf(n)))},t.parseCandidate=function(e){let t;t=0===e.indexOf("a=candidate:")?e.substring(12).split(" "):e.substring(10).split(" ");const n={foundation:t[0],component:{1:"rtp",2:"rtcp"}[t[1]]||t[1],protocol:t[2].toLowerCase(),priority:parseInt(t[3],10),ip:t[4],address:t[4],port:parseInt(t[5],10),type:t[7]};for(let e=8;e<t.length;e+=2)switch(t[e]){case"raddr":n.relatedAddress=t[e+1];break;case"rport":n.relatedPort=parseInt(t[e+1],10);break;case"tcptype":n.tcpType=t[e+1];break;case"ufrag":n.ufrag=t[e+1],n.usernameFragment=t[e+1];break;default:void 0===n[t[e]]&&(n[t[e]]=t[e+1])}return n},t.writeCandidate=function(e){const t=[];t.push(e.foundation);const n=e.component;"rtp"===n?t.push(1):"rtcp"===n?t.push(2):t.push(n),t.push(e.protocol.toUpperCase()),t.push(e.priority),t.push(e.address||e.ip),t.push(e.port);const r=e.type;return t.push("typ"),t.push(r),"host"!==r&&e.relatedAddress&&e.relatedPort&&(t.push("raddr"),t.push(e.relatedAddress),t.push("rport"),t.push(e.relatedPort)),e.tcpType&&"tcp"===e.protocol.toLowerCase()&&(t.push("tcptype"),t.push(e.tcpType)),(e.usernameFragment||e.ufrag)&&(t.push("ufrag"),t.push(e.usernameFragment||e.ufrag)),"candidate:"+t.join(" ")},t.parseIceOptions=function(e){return e.substring(14).split(" ")},t.parseRtpMap=function(e){let t=e.substring(9).split(" ");const n={payloadType:parseInt(t.shift(),10)};return t=t[0].split("/"),n.name=t[0],n.clockRate=parseInt(t[1],10),n.channels=3===t.length?parseInt(t[2],10):1,n.numChannels=n.channels,n},t.writeRtpMap=function(e){let t=e.payloadType;void 0!==e.preferredPayloadType&&(t=e.preferredPayloadType);const n=e.channels||e.numChannels||1;return"a=rtpmap:"+t+" "+e.name+"/"+e.clockRate+(1!==n?"/"+n:"")+"\r\n"},t.parseExtmap=function(e){const t=e.substring(9).split(" ");return{id:parseInt(t[0],10),direction:t[0].indexOf("/")>0?t[0].split("/")[1]:"sendrecv",uri:t[1],attributes:t.slice(2).join(" ")}},t.writeExtmap=function(e){return"a=extmap:"+(e.id||e.preferredId)+(e.direction&&"sendrecv"!==e.direction?"/"+e.direction:"")+" "+e.uri+(e.attributes?" "+e.attributes:"")+"\r\n"},t.parseFmtp=function(e){const t={};let n;const r=e.substring(e.indexOf(" ")+1).split(";");for(let e=0;e<r.length;e++)n=r[e].trim().split("="),t[n[0].trim()]=n[1];return t},t.writeFmtp=function(e){let t="",n=e.payloadType;if(void 0!==e.preferredPayloadType&&(n=e.preferredPayloadType),e.parameters&&Object.keys(e.parameters).length){const r=[];Object.keys(e.parameters).forEach((t=>{void 0!==e.parameters[t]?r.push(t+"="+e.parameters[t]):r.push(t)})),t+="a=fmtp:"+n+" "+r.join(";")+"\r\n"}return t},t.parseRtcpFb=function(e){const t=e.substring(e.indexOf(" ")+1).split(" ");return{type:t.shift(),parameter:t.join(" ")}},t.writeRtcpFb=function(e){let t="",n=e.payloadType;return void 0!==e.preferredPayloadType&&(n=e.preferredPayloadType),e.rtcpFeedback&&e.rtcpFeedback.length&&e.rtcpFeedback.forEach((e=>{t+="a=rtcp-fb:"+n+" "+e.type+(e.parameter&&e.parameter.length?" "+e.parameter:"")+"\r\n"})),t},t.parseSsrcMedia=function(e){const t=e.indexOf(" "),n={ssrc:parseInt(e.substring(7,t),10)},r=e.indexOf(":",t);return r>-1?(n.attribute=e.substring(t+1,r),n.value=e.substring(r+1)):n.attribute=e.substring(t+1),n},t.parseSsrcGroup=function(e){const t=e.substring(13).split(" ");return{semantics:t.shift(),ssrcs:t.map((e=>parseInt(e,10)))}},t.getMid=function(e){const n=t.matchPrefix(e,"a=mid:")[0];if(n)return n.substring(6)},t.parseFingerprint=function(e){const t=e.substring(14).split(" ");return{algorithm:t[0].toLowerCase(),value:t[1].toUpperCase()}},t.getDtlsParameters=function(e,n){return{role:"auto",fingerprints:t.matchPrefix(e+n,"a=fingerprint:").map(t.parseFingerprint)}},t.writeDtlsParameters=function(e,t){let n="a=setup:"+t+"\r\n";return e.fingerprints.forEach((e=>{n+="a=fingerprint:"+e.algorithm+" "+e.value+"\r\n"})),n},t.parseCryptoLine=function(e){const t=e.substring(9).split(" ");return{tag:parseInt(t[0],10),cryptoSuite:t[1],keyParams:t[2],sessionParams:t.slice(3)}},t.writeCryptoLine=function(e){return"a=crypto:"+e.tag+" "+e.cryptoSuite+" "+("object"==typeof e.keyParams?t.writeCryptoKeyParams(e.keyParams):e.keyParams)+(e.sessionParams?" "+e.sessionParams.join(" "):"")+"\r\n"},t.parseCryptoKeyParams=function(e){if(0!==e.indexOf("inline:"))return null;const t=e.substring(7).split("|");return{keyMethod:"inline",keySalt:t[0],lifeTime:t[1],mkiValue:t[2]?t[2].split(":")[0]:void 0,mkiLength:t[2]?t[2].split(":")[1]:void 0}},t.writeCryptoKeyParams=function(e){return e.keyMethod+":"+e.keySalt+(e.lifeTime?"|"+e.lifeTime:"")+(e.mkiValue&&e.mkiLength?"|"+e.mkiValue+":"+e.mkiLength:"")},t.getCryptoParameters=function(e,n){return t.matchPrefix(e+n,"a=crypto:").map(t.parseCryptoLine)},t.getIceParameters=function(e,n){const r=t.matchPrefix(e+n,"a=ice-ufrag:")[0],i=t.matchPrefix(e+n,"a=ice-pwd:")[0];return r&&i?{usernameFragment:r.substring(12),password:i.substring(10)}:null},t.writeIceParameters=function(e){let t="a=ice-ufrag:"+e.usernameFragment+"\r\na=ice-pwd:"+e.password+"\r\n";return e.iceLite&&(t+="a=ice-lite\r\n"),t},t.parseRtpParameters=function(e){const n={codecs:[],headerExtensions:[],fecMechanisms:[],rtcp:[]},r=t.splitLines(e)[0].split(" ");n.profile=r[2];for(let i=3;i<r.length;i++){const o=r[i],s=t.matchPrefix(e,"a=rtpmap:"+o+" ")[0];if(s){const r=t.parseRtpMap(s),i=t.matchPrefix(e,"a=fmtp:"+o+" ");switch(r.parameters=i.length?t.parseFmtp(i[0]):{},r.rtcpFeedback=t.matchPrefix(e,"a=rtcp-fb:"+o+" ").map(t.parseRtcpFb),n.codecs.push(r),r.name.toUpperCase()){case"RED":case"ULPFEC":n.fecMechanisms.push(r.name.toUpperCase())}}}t.matchPrefix(e,"a=extmap:").forEach((e=>{n.headerExtensions.push(t.parseExtmap(e))}));const i=t.matchPrefix(e,"a=rtcp-fb:* ").map(t.parseRtcpFb);return n.codecs.forEach((e=>{i.forEach((t=>{e.rtcpFeedback.find((e=>e.type===t.type&&e.parameter===t.parameter))||e.rtcpFeedback.push(t)}))})),n},t.writeRtpDescription=function(e,n){let r="";r+="m="+e+" ",r+=n.codecs.length>0?"9":"0",r+=" "+(n.profile||"UDP/TLS/RTP/SAVPF")+" ",r+=n.codecs.map((e=>void 0!==e.preferredPayloadType?e.preferredPayloadType:e.payloadType)).join(" ")+"\r\n",r+="c=IN IP4 0.0.0.0\r\n",r+="a=rtcp:9 IN IP4 0.0.0.0\r\n",n.codecs.forEach((e=>{r+=t.writeRtpMap(e),r+=t.writeFmtp(e),r+=t.writeRtcpFb(e)}));let i=0;return n.codecs.forEach((e=>{e.maxptime>i&&(i=e.maxptime)})),i>0&&(r+="a=maxptime:"+i+"\r\n"),n.headerExtensions&&n.headerExtensions.forEach((e=>{r+=t.writeExtmap(e)})),r},t.parseRtpEncodingParameters=function(e){const n=[],r=t.parseRtpParameters(e),i=-1!==r.fecMechanisms.indexOf("RED"),o=-1!==r.fecMechanisms.indexOf("ULPFEC"),s=t.matchPrefix(e,"a=ssrc:").map((e=>t.parseSsrcMedia(e))).filter((e=>"cname"===e.attribute)),a=s.length>0&&s[0].ssrc;let c;const d=t.matchPrefix(e,"a=ssrc-group:FID").map((e=>e.substring(17).split(" ").map((e=>parseInt(e,10)))));d.length>0&&d[0].length>1&&d[0][0]===a&&(c=d[0][1]),r.codecs.forEach((e=>{if("RTX"===e.name.toUpperCase()&&e.parameters.apt){let t={ssrc:a,codecPayloadType:parseInt(e.parameters.apt,10)};a&&c&&(t.rtx={ssrc:c}),n.push(t),i&&(t=JSON.parse(JSON.stringify(t)),t.fec={ssrc:a,mechanism:o?"red+ulpfec":"red"},n.push(t))}})),0===n.length&&a&&n.push({ssrc:a});let l=t.matchPrefix(e,"b=");return l.length&&(l=0===l[0].indexOf("b=TIAS:")?parseInt(l[0].substring(7),10):0===l[0].indexOf("b=AS:")?1e3*parseInt(l[0].substring(5),10)*.95-16e3:void 0,n.forEach((e=>{e.maxBitrate=l}))),n},t.parseRtcpParameters=function(e){const n={},r=t.matchPrefix(e,"a=ssrc:").map((e=>t.parseSsrcMedia(e))).filter((e=>"cname"===e.attribute))[0];r&&(n.cname=r.value,n.ssrc=r.ssrc);const i=t.matchPrefix(e,"a=rtcp-rsize");n.reducedSize=i.length>0,n.compound=0===i.length;const o=t.matchPrefix(e,"a=rtcp-mux");return n.mux=o.length>0,n},t.writeRtcpParameters=function(e){let t="";return e.reducedSize&&(t+="a=rtcp-rsize\r\n"),e.mux&&(t+="a=rtcp-mux\r\n"),void 0!==e.ssrc&&e.cname&&(t+="a=ssrc:"+e.ssrc+" cname:"+e.cname+"\r\n"),t},t.parseMsid=function(e){let n;const r=t.matchPrefix(e,"a=msid:");if(1===r.length)return n=r[0].substring(7).split(" "),{stream:n[0],track:n[1]};const i=t.matchPrefix(e,"a=ssrc:").map((e=>t.parseSsrcMedia(e))).filter((e=>"msid"===e.attribute));return i.length>0?(n=i[0].value.split(" "),{stream:n[0],track:n[1]}):void 0},t.parseSctpDescription=function(e){const n=t.parseMLine(e),r=t.matchPrefix(e,"a=max-message-size:");let i;r.length>0&&(i=parseInt(r[0].substring(19),10)),isNaN(i)&&(i=65536);const o=t.matchPrefix(e,"a=sctp-port:");if(o.length>0)return{port:parseInt(o[0].substring(12),10),protocol:n.fmt,maxMessageSize:i};const s=t.matchPrefix(e,"a=sctpmap:");if(s.length>0){const e=s[0].substring(10).split(" ");return{port:parseInt(e[0],10),protocol:e[1],maxMessageSize:i}}},t.writeSctpDescription=function(e,t){let n=[];return n="DTLS/SCTP"!==e.protocol?["m="+e.kind+" 9 "+e.protocol+" "+t.protocol+"\r\n","c=IN IP4 0.0.0.0\r\n","a=sctp-port:"+t.port+"\r\n"]:["m="+e.kind+" 9 "+e.protocol+" "+t.port+"\r\n","c=IN IP4 0.0.0.0\r\n","a=sctpmap:"+t.port+" "+t.protocol+" 65535\r\n"],void 0!==t.maxMessageSize&&n.push("a=max-message-size:"+t.maxMessageSize+"\r\n"),n.join("")},t.generateSessionId=function(){return Math.random().toString().substr(2,22)},t.writeSessionBoilerplate=function(e,n,r){let i;const o=void 0!==n?n:2;i=e||t.generateSessionId();return"v=0\r\no="+(r||"thisisadapterortc")+" "+i+" "+o+" IN IP4 127.0.0.1\r\ns=-\r\nt=0 0\r\n"},t.getDirection=function(e,n){const r=t.splitLines(e);for(let e=0;e<r.length;e++)switch(r[e]){case"a=sendrecv":case"a=sendonly":case"a=recvonly":case"a=inactive":return r[e].substring(2)}return n?t.getDirection(n):"sendrecv"},t.getKind=function(e){return t.splitLines(e)[0].split(" ")[0].substring(2)},t.isRejected=function(e){return"0"===e.split(" ",2)[1]},t.parseMLine=function(e){const n=t.splitLines(e)[0].substring(2).split(" ");return{kind:n[0],port:parseInt(n[1],10),protocol:n[2],fmt:n.slice(3).join(" ")}},t.parseOLine=function(e){const n=t.matchPrefix(e,"o=")[0].substring(2).split(" ");return{username:n[0],sessionId:n[1],sessionVersion:parseInt(n[2],10),netType:n[3],addressType:n[4],address:n[5]}},t.isValidSDP=function(e){if("string"!=typeof e||0===e.length)return!1;const n=t.splitLines(e);for(let e=0;e<n.length;e++)if(n[e].length<2||"="!==n[e].charAt(1))return!1;return!0},e.exports=t}},t={};function n(r){var i=t[r];if(void 0!==i)return i.exports;var o=t[r]={exports:{}};return e[r](o,o.exports,n),o.exports}n.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return n.d(t,{a:t}),t},n.d=(e,t)=>{for(var r in t)n.o(t,r)&&!n.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},n.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),n.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},(()=>{var e={};n.r(e),n.d(e,{fixNegotiationNeeded:()=>w,shimAddTrackRemoveTrack:()=>P,shimAddTrackRemoveTrackWithNative:()=>E,shimGetDisplayMedia:()=>y,shimGetSendersWithDtmf:()=>S,shimGetStats:()=>k,shimGetUserMedia:()=>C,shimMediaStream:()=>v,shimOnTrack:()=>b,shimPeerConnection:()=>R,shimSenderReceiverGetStats:()=>T});var t={};n.r(t),n.d(t,{shimAddTransceiver:()=>G,shimCreateAnswer:()=>U,shimCreateOffer:()=>N,shimGetDisplayMedia:()=>x,shimGetParameters:()=>j,shimGetUserMedia:()=>A,shimOnTrack:()=>I,shimPeerConnection:()=>O,shimRTCDataChannel:()=>H,shimReceiverGetStats:()=>M,shimRemoveStream:()=>L,shimSenderGetStats:()=>D});var r={};n.r(r),n.d(r,{shimAudioContext:()=>B,shimCallbacksAPI:()=>J,shimConstraints:()=>q,shimCreateOfferLegacy:()=>V,shimGetUserMedia:()=>K,shimLocalStreamsAPI:()=>F,shimRTCIceServerUrls:()=>W,shimRemoteStreamsAPI:()=>z,shimTrackEventTransceiver:()=>Y});var i={};n.r(i),n.d(i,{removeExtmapAllowMixed:()=>re,shimAddIceCandidateNullOrEmpty:()=>ie,shimConnectionState:()=>ne,shimMaxMessageSize:()=>ee,shimParameterlessSetLocalDescription:()=>oe,shimRTCIceCandidate:()=>$,shimRTCIceCandidateRelayProtocol:()=>Q,shimSendThrowTypeError:()=>te});let o=!0,s=!0;function a(e,t,n){const r=e.match(t);return r&&r.length>=n&&parseInt(r[n],10)}function c(e,t,n){if(!e.RTCPeerConnection)return;const r=e.RTCPeerConnection.prototype,i=r.addEventListener;r.addEventListener=function(e,r){if(e!==t)return i.apply(this,arguments);const o=e=>{const t=n(e);t&&(r.handleEvent?r.handleEvent(t):r(t))};return this._eventMap=this._eventMap||{},this._eventMap[t]||(this._eventMap[t]=new Map),this._eventMap[t].set(r,o),i.apply(this,[e,o])};const o=r.removeEventListener;r.removeEventListener=function(e,n){if(e!==t||!this._eventMap||!this._eventMap[t])return o.apply(this,arguments);if(!this._eventMap[t].has(n))return o.apply(this,arguments);const r=this._eventMap[t].get(n);return this._eventMap[t].delete(n),0===this._eventMap[t].size&&delete this._eventMap[t],0===Object.keys(this._eventMap).length&&delete this._eventMap,o.apply(this,[e,r])},Object.defineProperty(r,"on"+t,{get(){return this["_on"+t]},set(e){this["_on"+t]&&(this.removeEventListener(t,this["_on"+t]),delete this["_on"+t]),e&&this.addEventListener(t,this["_on"+t]=e)},enumerable:!0,configurable:!0})}function d(e){return"boolean"!=typeof e?new Error("Argument type: "+typeof e+". Please use a boolean."):(o=e,e?"adapter.js logging disabled":"adapter.js logging enabled")}function l(e){return"boolean"!=typeof e?new Error("Argument type: "+typeof e+". Please use a boolean."):(s=!e,"adapter.js deprecation warnings "+(e?"disabled":"enabled"))}function h(){if("object"==typeof window){if(o)return;"undefined"!=typeof console&&"function"==typeof console.log&&console.log.apply(console,arguments)}}function p(e,t){s&&console.warn(e+" is deprecated, please use "+t+" instead.")}function u(e){return"[object Object]"===Object.prototype.toString.call(e)}function m(e){return u(e)?Object.keys(e).reduce((function(t,n){const r=u(e[n]),i=r?m(e[n]):e[n],o=r&&!Object.keys(i).length;return void 0===i||o?t:Object.assign(t,{[n]:i})}),{}):e}function _(e,t,n){t&&!n.has(t.id)&&(n.set(t.id,t),Object.keys(t).forEach((r=>{r.endsWith("Id")?_(e,e.get(t[r]),n):r.endsWith("Ids")&&t[r].forEach((t=>{_(e,e.get(t),n)}))})))}function f(e,t,n){const r=n?"outbound-rtp":"inbound-rtp",i=new Map;if(null===t)return i;const o=[];return e.forEach((e=>{"track"===e.type&&e.trackIdentifier===t.id&&o.push(e)})),o.forEach((t=>{e.forEach((n=>{n.type===r&&n.trackId===t.id&&_(e,n,i)}))})),i}const g=h;function C(e,t){const n=e&&e.navigator;if(!n.mediaDevices)return;const r=function(e){if("object"!=typeof e||e.mandatory||e.optional)return e;const t={};return Object.keys(e).forEach((n=>{if("require"===n||"advanced"===n||"mediaSource"===n)return;const r="object"==typeof e[n]?e[n]:{ideal:e[n]};void 0!==r.exact&&"number"==typeof r.exact&&(r.min=r.max=r.exact);const i=function(e,t){return e?e+t.charAt(0).toUpperCase()+t.slice(1):"deviceId"===t?"sourceId":t};if(void 0!==r.ideal){t.optional=t.optional||[];let e={};"number"==typeof r.ideal?(e[i("min",n)]=r.ideal,t.optional.push(e),e={},e[i("max",n)]=r.ideal,t.optional.push(e)):(e[i("",n)]=r.ideal,t.optional.push(e))}void 0!==r.exact&&"number"!=typeof r.exact?(t.mandatory=t.mandatory||{},t.mandatory[i("",n)]=r.exact):["min","max"].forEach((e=>{void 0!==r[e]&&(t.mandatory=t.mandatory||{},t.mandatory[i(e,n)]=r[e])}))})),e.advanced&&(t.optional=(t.optional||[]).concat(e.advanced)),t},i=function(e,i){if(t.version>=61)return i(e);if((e=JSON.parse(JSON.stringify(e)))&&"object"==typeof e.audio){const t=function(e,t,n){t in e&&!(n in e)&&(e[n]=e[t],delete e[t])};t((e=JSON.parse(JSON.stringify(e))).audio,"autoGainControl","googAutoGainControl"),t(e.audio,"noiseSuppression","googNoiseSuppression"),e.audio=r(e.audio)}if(e&&"object"==typeof e.video){let o=e.video.facingMode;o=o&&("object"==typeof o?o:{ideal:o});const s=t.version<66;if(o&&("user"===o.exact||"environment"===o.exact||"user"===o.ideal||"environment"===o.ideal)&&(!n.mediaDevices.getSupportedConstraints||!n.mediaDevices.getSupportedConstraints().facingMode||s)){let t;if(delete e.video.facingMode,"environment"===o.exact||"environment"===o.ideal?t=["back","rear"]:"user"!==o.exact&&"user"!==o.ideal||(t=["front"]),t)return n.mediaDevices.enumerateDevices().then((n=>{let s=(n=n.filter((e=>"videoinput"===e.kind))).find((e=>t.some((t=>e.label.toLowerCase().includes(t)))));return!s&&n.length&&t.includes("back")&&(s=n[n.length-1]),s&&(e.video.deviceId=o.exact?{exact:s.deviceId}:{ideal:s.deviceId}),e.video=r(e.video),g("chrome: "+JSON.stringify(e)),i(e)}))}e.video=r(e.video)}return g("chrome: "+JSON.stringify(e)),i(e)},o=function(e){return t.version>=64?e:{name:{PermissionDeniedError:"NotAllowedError",PermissionDismissedError:"NotAllowedError",InvalidStateError:"NotAllowedError",DevicesNotFoundError:"NotFoundError",ConstraintNotSatisfiedError:"OverconstrainedError",TrackStartError:"NotReadableError",MediaDeviceFailedDueToShutdown:"NotAllowedError",MediaDeviceKillSwitchOn:"NotAllowedError",TabCaptureError:"AbortError",ScreenCaptureError:"AbortError",DeviceCaptureError:"AbortError"}[e.name]||e.name,message:e.message,constraint:e.constraint||e.constraintName,toString(){return this.name+(this.message&&": ")+this.message}}};if(n.getUserMedia=function(e,t,r){i(e,(e=>{n.webkitGetUserMedia(e,t,(e=>{r&&r(o(e))}))}))}.bind(n),n.mediaDevices.getUserMedia){const e=n.mediaDevices.getUserMedia.bind(n.mediaDevices);n.mediaDevices.getUserMedia=function(t){return i(t,(t=>e(t).then((e=>{if(t.audio&&!e.getAudioTracks().length||t.video&&!e.getVideoTracks().length)throw e.getTracks().forEach((e=>{e.stop()})),new DOMException("","NotFoundError");return e}),(e=>Promise.reject(o(e))))))}}}function y(e,t){e.navigator.mediaDevices&&"getDisplayMedia"in e.navigator.mediaDevices||e.navigator.mediaDevices&&("function"==typeof t?e.navigator.mediaDevices.getDisplayMedia=function(n){return t(n).then((t=>{const r=n.video&&n.video.width,i=n.video&&n.video.height,o=n.video&&n.video.frameRate;return n.video={mandatory:{chromeMediaSource:"desktop",chromeMediaSourceId:t,maxFrameRate:o||3}},r&&(n.video.mandatory.maxWidth=r),i&&(n.video.mandatory.maxHeight=i),e.navigator.mediaDevices.getUserMedia(n)}))}:console.error("shimGetDisplayMedia: getSourceId argument is not a function"))}function v(e){e.MediaStream=e.MediaStream||e.webkitMediaStream}function b(e){if("object"==typeof e&&e.RTCPeerConnection&&!("ontrack"in e.RTCPeerConnection.prototype)){Object.defineProperty(e.RTCPeerConnection.prototype,"ontrack",{get(){return this._ontrack},set(e){this._ontrack&&this.removeEventListener("track",this._ontrack),this.addEventListener("track",this._ontrack=e)},enumerable:!0,configurable:!0});const t=e.RTCPeerConnection.prototype.setRemoteDescription;e.RTCPeerConnection.prototype.setRemoteDescription=function(){return this._ontrackpoly||(this._ontrackpoly=t=>{t.stream.addEventListener("addtrack",(n=>{let r;r=e.RTCPeerConnection.prototype.getReceivers?this.getReceivers().find((e=>e.track&&e.track.id===n.track.id)):{track:n.track};const i=new Event("track");i.track=n.track,i.receiver=r,i.transceiver={receiver:r},i.streams=[t.stream],this.dispatchEvent(i)})),t.stream.getTracks().forEach((n=>{let r;r=e.RTCPeerConnection.prototype.getReceivers?this.getReceivers().find((e=>e.track&&e.track.id===n.id)):{track:n};const i=new Event("track");i.track=n,i.receiver=r,i.transceiver={receiver:r},i.streams=[t.stream],this.dispatchEvent(i)}))},this.addEventListener("addstream",this._ontrackpoly)),t.apply(this,arguments)}}else c(e,"track",(e=>(e.transceiver||Object.defineProperty(e,"transceiver",{value:{receiver:e.receiver}}),e)))}function S(e){if("object"==typeof e&&e.RTCPeerConnection&&!("getSenders"in e.RTCPeerConnection.prototype)&&"createDTMFSender"in e.RTCPeerConnection.prototype){const t=function(e,t){return{track:t,get dtmf(){return void 0===this._dtmf&&("audio"===t.kind?this._dtmf=e.createDTMFSender(t):this._dtmf=null),this._dtmf},_pc:e}};if(!e.RTCPeerConnection.prototype.getSenders){e.RTCPeerConnection.prototype.getSenders=function(){return this._senders=this._senders||[],this._senders.slice()};const n=e.RTCPeerConnection.prototype.addTrack;e.RTCPeerConnection.prototype.addTrack=function(e,r){let i=n.apply(this,arguments);return i||(i=t(this,e),this._senders.push(i)),i};const r=e.RTCPeerConnection.prototype.removeTrack;e.RTCPeerConnection.prototype.removeTrack=function(e){r.apply(this,arguments);const t=this._senders.indexOf(e);-1!==t&&this._senders.splice(t,1)}}const n=e.RTCPeerConnection.prototype.addStream;e.RTCPeerConnection.prototype.addStream=function(e){this._senders=this._senders||[],n.apply(this,[e]),e.getTracks().forEach((e=>{this._senders.push(t(this,e))}))};const r=e.RTCPeerConnection.prototype.removeStream;e.RTCPeerConnection.prototype.removeStream=function(e){this._senders=this._senders||[],r.apply(this,[e]),e.getTracks().forEach((e=>{const t=this._senders.find((t=>t.track===e));t&&this._senders.splice(this._senders.indexOf(t),1)}))}}else if("object"==typeof e&&e.RTCPeerConnection&&"getSenders"in e.RTCPeerConnection.prototype&&"createDTMFSender"in e.RTCPeerConnection.prototype&&e.RTCRtpSender&&!("dtmf"in e.RTCRtpSender.prototype)){const t=e.RTCPeerConnection.prototype.getSenders;e.RTCPeerConnection.prototype.getSenders=function(){const e=t.apply(this,[]);return e.forEach((e=>e._pc=this)),e},Object.defineProperty(e.RTCRtpSender.prototype,"dtmf",{get(){return void 0===this._dtmf&&("audio"===this.track.kind?this._dtmf=this._pc.createDTMFSender(this.track):this._dtmf=null),this._dtmf}})}}function k(e){if(!e.RTCPeerConnection)return;const t=e.RTCPeerConnection.prototype.getStats;e.RTCPeerConnection.prototype.getStats=function(){const[e,n,r]=arguments;if(arguments.length>0&&"function"==typeof e)return t.apply(this,arguments);if(0===t.length&&(0===arguments.length||"function"!=typeof e))return t.apply(this,[]);const i=function(e){const t={};return e.result().forEach((e=>{const n={id:e.id,timestamp:e.timestamp,type:{localcandidate:"local-candidate",remotecandidate:"remote-candidate"}[e.type]||e.type};e.names().forEach((t=>{n[t]=e.stat(t)})),t[n.id]=n})),t},o=function(e){return new Map(Object.keys(e).map((t=>[t,e[t]])))};if(arguments.length>=2){const r=function(e){n(o(i(e)))};return t.apply(this,[r,e])}return new Promise(((e,n)=>{t.apply(this,[function(t){e(o(i(t)))},n])})).then(n,r)}}function T(e){if(!("object"==typeof e&&e.RTCPeerConnection&&e.RTCRtpSender&&e.RTCRtpReceiver))return;if(!("getStats"in e.RTCRtpSender.prototype)){const t=e.RTCPeerConnection.prototype.getSenders;t&&(e.RTCPeerConnection.prototype.getSenders=function(){const e=t.apply(this,[]);return e.forEach((e=>e._pc=this)),e});const n=e.RTCPeerConnection.prototype.addTrack;n&&(e.RTCPeerConnection.prototype.addTrack=function(){const e=n.apply(this,arguments);return e._pc=this,e}),e.RTCRtpSender.prototype.getStats=function(){const e=this;return this._pc.getStats().then((t=>f(t,e.track,!0)))}}if(!("getStats"in e.RTCRtpReceiver.prototype)){const t=e.RTCPeerConnection.prototype.getReceivers;t&&(e.RTCPeerConnection.prototype.getReceivers=function(){const e=t.apply(this,[]);return e.forEach((e=>e._pc=this)),e}),c(e,"track",(e=>(e.receiver._pc=e.srcElement,e))),e.RTCRtpReceiver.prototype.getStats=function(){const e=this;return this._pc.getStats().then((t=>f(t,e.track,!1)))}}if(!("getStats"in e.RTCRtpSender.prototype)||!("getStats"in e.RTCRtpReceiver.prototype))return;const t=e.RTCPeerConnection.prototype.getStats;e.RTCPeerConnection.prototype.getStats=function(){if(arguments.length>0&&arguments[0]instanceof e.MediaStreamTrack){const e=arguments[0];let t,n,r;return this.getSenders().forEach((n=>{n.track===e&&(t?r=!0:t=n)})),this.getReceivers().forEach((t=>(t.track===e&&(n?r=!0:n=t),t.track===e))),r||t&&n?Promise.reject(new DOMException("There are more than one sender or receiver for the track.","InvalidAccessError")):t?t.getStats():n?n.getStats():Promise.reject(new DOMException("There is no sender or receiver for the track.","InvalidAccessError"))}return t.apply(this,arguments)}}function E(e){e.RTCPeerConnection.prototype.getLocalStreams=function(){return this._shimmedLocalStreams=this._shimmedLocalStreams||{},Object.keys(this._shimmedLocalStreams).map((e=>this._shimmedLocalStreams[e][0]))};const t=e.RTCPeerConnection.prototype.addTrack;e.RTCPeerConnection.prototype.addTrack=function(e,n){if(!n)return t.apply(this,arguments);this._shimmedLocalStreams=this._shimmedLocalStreams||{};const r=t.apply(this,arguments);return this._shimmedLocalStreams[n.id]?-1===this._shimmedLocalStreams[n.id].indexOf(r)&&this._shimmedLocalStreams[n.id].push(r):this._shimmedLocalStreams[n.id]=[n,r],r};const n=e.RTCPeerConnection.prototype.addStream;e.RTCPeerConnection.prototype.addStream=function(e){this._shimmedLocalStreams=this._shimmedLocalStreams||{},e.getTracks().forEach((e=>{if(this.getSenders().find((t=>t.track===e)))throw new DOMException("Track already exists.","InvalidAccessError")}));const t=this.getSenders();n.apply(this,arguments);const r=this.getSenders().filter((e=>-1===t.indexOf(e)));this._shimmedLocalStreams[e.id]=[e].concat(r)};const r=e.RTCPeerConnection.prototype.removeStream;e.RTCPeerConnection.prototype.removeStream=function(e){return this._shimmedLocalStreams=this._shimmedLocalStreams||{},delete this._shimmedLocalStreams[e.id],r.apply(this,arguments)};const i=e.RTCPeerConnection.prototype.removeTrack;e.RTCPeerConnection.prototype.removeTrack=function(e){return this._shimmedLocalStreams=this._shimmedLocalStreams||{},e&&Object.keys(this._shimmedLocalStreams).forEach((t=>{const n=this._shimmedLocalStreams[t].indexOf(e);-1!==n&&this._shimmedLocalStreams[t].splice(n,1),1===this._shimmedLocalStreams[t].length&&delete this._shimmedLocalStreams[t]})),i.apply(this,arguments)}}function P(e,t){if(!e.RTCPeerConnection)return;if(e.RTCPeerConnection.prototype.addTrack&&t.version>=65)return E(e);const n=e.RTCPeerConnection.prototype.getLocalStreams;e.RTCPeerConnection.prototype.getLocalStreams=function(){const e=n.apply(this);return this._reverseStreams=this._reverseStreams||{},e.map((e=>this._reverseStreams[e.id]))};const r=e.RTCPeerConnection.prototype.addStream;e.RTCPeerConnection.prototype.addStream=function(t){if(this._streams=this._streams||{},this._reverseStreams=this._reverseStreams||{},t.getTracks().forEach((e=>{if(this.getSenders().find((t=>t.track===e)))throw new DOMException("Track already exists.","InvalidAccessError")})),!this._reverseStreams[t.id]){const n=new e.MediaStream(t.getTracks());this._streams[t.id]=n,this._reverseStreams[n.id]=t,t=n}r.apply(this,[t])};const i=e.RTCPeerConnection.prototype.removeStream;function o(e,t){let n=t.sdp;return Object.keys(e._reverseStreams||[]).forEach((t=>{const r=e._reverseStreams[t],i=e._streams[r.id];n=n.replace(new RegExp(i.id,"g"),r.id)})),new RTCSessionDescription({type:t.type,sdp:n})}e.RTCPeerConnection.prototype.removeStream=function(e){this._streams=this._streams||{},this._reverseStreams=this._reverseStreams||{},i.apply(this,[this._streams[e.id]||e]),delete this._reverseStreams[this._streams[e.id]?this._streams[e.id].id:e.id],delete this._streams[e.id]},e.RTCPeerConnection.prototype.addTrack=function(t,n){if("closed"===this.signalingState)throw new DOMException("The RTCPeerConnection's signalingState is 'closed'.","InvalidStateError");const r=[].slice.call(arguments,1);if(1!==r.length||!r[0].getTracks().find((e=>e===t)))throw new DOMException("The adapter.js addTrack polyfill only supports a single  stream which is associated with the specified track.","NotSupportedError");if(this.getSenders().find((e=>e.track===t)))throw new DOMException("Track already exists.","InvalidAccessError");this._streams=this._streams||{},this._reverseStreams=this._reverseStreams||{};const i=this._streams[n.id];if(i)i.addTrack(t),Promise.resolve().then((()=>{this.dispatchEvent(new Event("negotiationneeded"))}));else{const r=new e.MediaStream([t]);this._streams[n.id]=r,this._reverseStreams[r.id]=n,this.addStream(r)}return this.getSenders().find((e=>e.track===t))},["createOffer","createAnswer"].forEach((function(t){const n=e.RTCPeerConnection.prototype[t],r={[t](){const e=arguments;return arguments.length&&"function"==typeof arguments[0]?n.apply(this,[t=>{const n=o(this,t);e[0].apply(null,[n])},t=>{e[1]&&e[1].apply(null,t)},arguments[2]]):n.apply(this,arguments).then((e=>o(this,e)))}};e.RTCPeerConnection.prototype[t]=r[t]}));const s=e.RTCPeerConnection.prototype.setLocalDescription;e.RTCPeerConnection.prototype.setLocalDescription=function(){return arguments.length&&arguments[0].type?(arguments[0]=function(e,t){let n=t.sdp;return Object.keys(e._reverseStreams||[]).forEach((t=>{const r=e._reverseStreams[t],i=e._streams[r.id];n=n.replace(new RegExp(r.id,"g"),i.id)})),new RTCSessionDescription({type:t.type,sdp:n})}(this,arguments[0]),s.apply(this,arguments)):s.apply(this,arguments)};const a=Object.getOwnPropertyDescriptor(e.RTCPeerConnection.prototype,"localDescription");Object.defineProperty(e.RTCPeerConnection.prototype,"localDescription",{get(){const e=a.get.apply(this);return""===e.type?e:o(this,e)}}),e.RTCPeerConnection.prototype.removeTrack=function(e){if("closed"===this.signalingState)throw new DOMException("The RTCPeerConnection's signalingState is 'closed'.","InvalidStateError");if(!e._pc)throw new DOMException("Argument 1 of RTCPeerConnection.removeTrack does not implement interface RTCRtpSender.","TypeError");if(!(e._pc===this))throw new DOMException("Sender was not created by this connection.","InvalidAccessError");let t;this._streams=this._streams||{},Object.keys(this._streams).forEach((n=>{this._streams[n].getTracks().find((t=>e.track===t))&&(t=this._streams[n])})),t&&(1===t.getTracks().length?this.removeStream(this._reverseStreams[t.id]):t.removeTrack(e.track),this.dispatchEvent(new Event("negotiationneeded")))}}function R(e,t){!e.RTCPeerConnection&&e.webkitRTCPeerConnection&&(e.RTCPeerConnection=e.webkitRTCPeerConnection),e.RTCPeerConnection&&t.version<53&&["setLocalDescription","setRemoteDescription","addIceCandidate"].forEach((function(t){const n=e.RTCPeerConnection.prototype[t],r={[t](){return arguments[0]=new("addIceCandidate"===t?e.RTCIceCandidate:e.RTCSessionDescription)(arguments[0]),n.apply(this,arguments)}};e.RTCPeerConnection.prototype[t]=r[t]}))}function w(e,t){c(e,"negotiationneeded",(e=>{const n=e.target;if(!(t.version<72||n.getConfiguration&&"plan-b"===n.getConfiguration().sdpSemantics)||"stable"===n.signalingState)return e}))}function A(e,t){const n=e&&e.navigator,r=e&&e.MediaStreamTrack;if(n.getUserMedia=function(e,t,r){p("navigator.getUserMedia","navigator.mediaDevices.getUserMedia"),n.mediaDevices.getUserMedia(e).then(t,r)},!(t.version>55&&"autoGainControl"in n.mediaDevices.getSupportedConstraints())){const e=function(e,t,n){t in e&&!(n in e)&&(e[n]=e[t],delete e[t])},t=n.mediaDevices.getUserMedia.bind(n.mediaDevices);if(n.mediaDevices.getUserMedia=function(n){return"object"==typeof n&&"object"==typeof n.audio&&(n=JSON.parse(JSON.stringify(n)),e(n.audio,"autoGainControl","mozAutoGainControl"),e(n.audio,"noiseSuppression","mozNoiseSuppression")),t(n)},r&&r.prototype.getSettings){const t=r.prototype.getSettings;r.prototype.getSettings=function(){const n=t.apply(this,arguments);return e(n,"mozAutoGainControl","autoGainControl"),e(n,"mozNoiseSuppression","noiseSuppression"),n}}if(r&&r.prototype.applyConstraints){const t=r.prototype.applyConstraints;r.prototype.applyConstraints=function(n){return"audio"===this.kind&&"object"==typeof n&&(n=JSON.parse(JSON.stringify(n)),e(n,"autoGainControl","mozAutoGainControl"),e(n,"noiseSuppression","mozNoiseSuppression")),t.apply(this,[n])}}}}function x(e,t){e.navigator.mediaDevices&&"getDisplayMedia"in e.navigator.mediaDevices||e.navigator.mediaDevices&&(e.navigator.mediaDevices.getDisplayMedia=function(n){if(!n||!n.video){const e=new DOMException("getDisplayMedia without video constraints is undefined");return e.name="NotFoundError",e.code=8,Promise.reject(e)}return!0===n.video?n.video={mediaSource:t}:n.video.mediaSource=t,e.navigator.mediaDevices.getUserMedia(n)})}function I(e){"object"==typeof e&&e.RTCTrackEvent&&"receiver"in e.RTCTrackEvent.prototype&&!("transceiver"in e.RTCTrackEvent.prototype)&&Object.defineProperty(e.RTCTrackEvent.prototype,"transceiver",{get(){return{receiver:this.receiver}}})}function O(e,t){if("object"!=typeof e||!e.RTCPeerConnection&&!e.mozRTCPeerConnection)return;!e.RTCPeerConnection&&e.mozRTCPeerConnection&&(e.RTCPeerConnection=e.mozRTCPeerConnection),t.version<53&&["setLocalDescription","setRemoteDescription","addIceCandidate"].forEach((function(t){const n=e.RTCPeerConnection.prototype[t],r={[t](){return arguments[0]=new("addIceCandidate"===t?e.RTCIceCandidate:e.RTCSessionDescription)(arguments[0]),n.apply(this,arguments)}};e.RTCPeerConnection.prototype[t]=r[t]}));const n={inboundrtp:"inbound-rtp",outboundrtp:"outbound-rtp",candidatepair:"candidate-pair",localcandidate:"local-candidate",remotecandidate:"remote-candidate"},r=e.RTCPeerConnection.prototype.getStats;e.RTCPeerConnection.prototype.getStats=function(){const[e,i,o]=arguments;return r.apply(this,[e||null]).then((e=>{if(t.version<53&&!i)try{e.forEach((e=>{e.type=n[e.type]||e.type}))}catch(t){if("TypeError"!==t.name)throw t;e.forEach(((t,r)=>{e.set(r,Object.assign({},t,{type:n[t.type]||t.type}))}))}return e})).then(i,o)}}function D(e){if("object"!=typeof e||!e.RTCPeerConnection||!e.RTCRtpSender)return;if(e.RTCRtpSender&&"getStats"in e.RTCRtpSender.prototype)return;const t=e.RTCPeerConnection.prototype.getSenders;t&&(e.RTCPeerConnection.prototype.getSenders=function(){const e=t.apply(this,[]);return e.forEach((e=>e._pc=this)),e});const n=e.RTCPeerConnection.prototype.addTrack;n&&(e.RTCPeerConnection.prototype.addTrack=function(){const e=n.apply(this,arguments);return e._pc=this,e}),e.RTCRtpSender.prototype.getStats=function(){return this.track?this._pc.getStats(this.track):Promise.resolve(new Map)}}function M(e){if("object"!=typeof e||!e.RTCPeerConnection||!e.RTCRtpSender)return;if(e.RTCRtpSender&&"getStats"in e.RTCRtpReceiver.prototype)return;const t=e.RTCPeerConnection.prototype.getReceivers;t&&(e.RTCPeerConnection.prototype.getReceivers=function(){const e=t.apply(this,[]);return e.forEach((e=>e._pc=this)),e}),c(e,"track",(e=>(e.receiver._pc=e.srcElement,e))),e.RTCRtpReceiver.prototype.getStats=function(){return this._pc.getStats(this.track)}}function L(e){e.RTCPeerConnection&&!("removeStream"in e.RTCPeerConnection.prototype)&&(e.RTCPeerConnection.prototype.removeStream=function(e){p("removeStream","removeTrack"),this.getSenders().forEach((t=>{t.track&&e.getTracks().includes(t.track)&&this.removeTrack(t)}))})}function H(e){e.DataChannel&&!e.RTCDataChannel&&(e.RTCDataChannel=e.DataChannel)}function G(e){if("object"!=typeof e||!e.RTCPeerConnection)return;const t=e.RTCPeerConnection.prototype.addTransceiver;t&&(e.RTCPeerConnection.prototype.addTransceiver=function(){this.setParametersPromises=[];let e=arguments[1]&&arguments[1].sendEncodings;void 0===e&&(e=[]),e=[...e];const n=e.length>0;n&&e.forEach((e=>{if("rid"in e){if(!/^[a-z0-9]{0,16}$/i.test(e.rid))throw new TypeError("Invalid RID value provided.")}if("scaleResolutionDownBy"in e&&!(parseFloat(e.scaleResolutionDownBy)>=1))throw new RangeError("scale_resolution_down_by must be >= 1.0");if("maxFramerate"in e&&!(parseFloat(e.maxFramerate)>=0))throw new RangeError("max_framerate must be >= 0.0")}));const r=t.apply(this,arguments);if(n){const{sender:t}=r,n=t.getParameters();(!("encodings"in n)||1===n.encodings.length&&0===Object.keys(n.encodings[0]).length)&&(n.encodings=e,t.sendEncodings=e,this.setParametersPromises.push(t.setParameters(n).then((()=>{delete t.sendEncodings})).catch((()=>{delete t.sendEncodings}))))}return r})}function j(e){if("object"!=typeof e||!e.RTCRtpSender)return;const t=e.RTCRtpSender.prototype.getParameters;t&&(e.RTCRtpSender.prototype.getParameters=function(){const e=t.apply(this,arguments);return"encodings"in e||(e.encodings=[].concat(this.sendEncodings||[{}])),e})}function N(e){if("object"!=typeof e||!e.RTCPeerConnection)return;const t=e.RTCPeerConnection.prototype.createOffer;e.RTCPeerConnection.prototype.createOffer=function(){return this.setParametersPromises&&this.setParametersPromises.length?Promise.all(this.setParametersPromises).then((()=>t.apply(this,arguments))).finally((()=>{this.setParametersPromises=[]})):t.apply(this,arguments)}}function U(e){if("object"!=typeof e||!e.RTCPeerConnection)return;const t=e.RTCPeerConnection.prototype.createAnswer;e.RTCPeerConnection.prototype.createAnswer=function(){return this.setParametersPromises&&this.setParametersPromises.length?Promise.all(this.setParametersPromises).then((()=>t.apply(this,arguments))).finally((()=>{this.setParametersPromises=[]})):t.apply(this,arguments)}}function F(e){if("object"==typeof e&&e.RTCPeerConnection){if("getLocalStreams"in e.RTCPeerConnection.prototype||(e.RTCPeerConnection.prototype.getLocalStreams=function(){return this._localStreams||(this._localStreams=[]),this._localStreams}),!("addStream"in e.RTCPeerConnection.prototype)){const t=e.RTCPeerConnection.prototype.addTrack;e.RTCPeerConnection.prototype.addStream=function(e){this._localStreams||(this._localStreams=[]),this._localStreams.includes(e)||this._localStreams.push(e),e.getAudioTracks().forEach((n=>t.call(this,n,e))),e.getVideoTracks().forEach((n=>t.call(this,n,e)))},e.RTCPeerConnection.prototype.addTrack=function(e,...n){return n&&n.forEach((e=>{this._localStreams?this._localStreams.includes(e)||this._localStreams.push(e):this._localStreams=[e]})),t.apply(this,arguments)}}"removeStream"in e.RTCPeerConnection.prototype||(e.RTCPeerConnection.prototype.removeStream=function(e){this._localStreams||(this._localStreams=[]);const t=this._localStreams.indexOf(e);if(-1===t)return;this._localStreams.splice(t,1);const n=e.getTracks();this.getSenders().forEach((e=>{n.includes(e.track)&&this.removeTrack(e)}))})}}function z(e){if("object"==typeof e&&e.RTCPeerConnection&&("getRemoteStreams"in e.RTCPeerConnection.prototype||(e.RTCPeerConnection.prototype.getRemoteStreams=function(){return this._remoteStreams?this._remoteStreams:[]}),!("onaddstream"in e.RTCPeerConnection.prototype))){Object.defineProperty(e.RTCPeerConnection.prototype,"onaddstream",{get(){return this._onaddstream},set(e){this._onaddstream&&(this.removeEventListener("addstream",this._onaddstream),this.removeEventListener("track",this._onaddstreampoly)),this.addEventListener("addstream",this._onaddstream=e),this.addEventListener("track",this._onaddstreampoly=e=>{e.streams.forEach((e=>{if(this._remoteStreams||(this._remoteStreams=[]),this._remoteStreams.includes(e))return;this._remoteStreams.push(e);const t=new Event("addstream");t.stream=e,this.dispatchEvent(t)}))})}});const t=e.RTCPeerConnection.prototype.setRemoteDescription;e.RTCPeerConnection.prototype.setRemoteDescription=function(){const e=this;return this._onaddstreampoly||this.addEventListener("track",this._onaddstreampoly=function(t){t.streams.forEach((t=>{if(e._remoteStreams||(e._remoteStreams=[]),e._remoteStreams.indexOf(t)>=0)return;e._remoteStreams.push(t);const n=new Event("addstream");n.stream=t,e.dispatchEvent(n)}))}),t.apply(e,arguments)}}}function J(e){if("object"!=typeof e||!e.RTCPeerConnection)return;const t=e.RTCPeerConnection.prototype,n=t.createOffer,r=t.createAnswer,i=t.setLocalDescription,o=t.setRemoteDescription,s=t.addIceCandidate;t.createOffer=function(e,t){const r=arguments.length>=2?arguments[2]:arguments[0],i=n.apply(this,[r]);return t?(i.then(e,t),Promise.resolve()):i},t.createAnswer=function(e,t){const n=arguments.length>=2?arguments[2]:arguments[0],i=r.apply(this,[n]);return t?(i.then(e,t),Promise.resolve()):i};let a=function(e,t,n){const r=i.apply(this,[e]);return n?(r.then(t,n),Promise.resolve()):r};t.setLocalDescription=a,a=function(e,t,n){const r=o.apply(this,[e]);return n?(r.then(t,n),Promise.resolve()):r},t.setRemoteDescription=a,a=function(e,t,n){const r=s.apply(this,[e]);return n?(r.then(t,n),Promise.resolve()):r},t.addIceCandidate=a}function K(e){const t=e&&e.navigator;if(t.mediaDevices&&t.mediaDevices.getUserMedia){const e=t.mediaDevices,n=e.getUserMedia.bind(e);t.mediaDevices.getUserMedia=e=>n(q(e))}!t.getUserMedia&&t.mediaDevices&&t.mediaDevices.getUserMedia&&(t.getUserMedia=function(e,n,r){t.mediaDevices.getUserMedia(e).then(n,r)}.bind(t))}function q(e){return e&&void 0!==e.video?Object.assign({},e,{video:m(e.video)}):e}function W(e){if(!e.RTCPeerConnection)return;const t=e.RTCPeerConnection;e.RTCPeerConnection=function(e,n){if(e&&e.iceServers){const t=[];for(let n=0;n<e.iceServers.length;n++){let r=e.iceServers[n];void 0===r.urls&&r.url?(p("RTCIceServer.url","RTCIceServer.urls"),r=JSON.parse(JSON.stringify(r)),r.urls=r.url,delete r.url,t.push(r)):t.push(e.iceServers[n])}e.iceServers=t}return new t(e,n)},e.RTCPeerConnection.prototype=t.prototype,"generateCertificate"in t&&Object.defineProperty(e.RTCPeerConnection,"generateCertificate",{get:()=>t.generateCertificate})}function Y(e){"object"==typeof e&&e.RTCTrackEvent&&"receiver"in e.RTCTrackEvent.prototype&&!("transceiver"in e.RTCTrackEvent.prototype)&&Object.defineProperty(e.RTCTrackEvent.prototype,"transceiver",{get(){return{receiver:this.receiver}}})}function V(e){const t=e.RTCPeerConnection.prototype.createOffer;e.RTCPeerConnection.prototype.createOffer=function(e){if(e){void 0!==e.offerToReceiveAudio&&(e.offerToReceiveAudio=!!e.offerToReceiveAudio);const t=this.getTransceivers().find((e=>"audio"===e.receiver.track.kind));!1===e.offerToReceiveAudio&&t?"sendrecv"===t.direction?t.setDirection?t.setDirection("sendonly"):t.direction="sendonly":"recvonly"===t.direction&&(t.setDirection?t.setDirection("inactive"):t.direction="inactive"):!0!==e.offerToReceiveAudio||t||this.addTransceiver("audio",{direction:"recvonly"}),void 0!==e.offerToReceiveVideo&&(e.offerToReceiveVideo=!!e.offerToReceiveVideo);const n=this.getTransceivers().find((e=>"video"===e.receiver.track.kind));!1===e.offerToReceiveVideo&&n?"sendrecv"===n.direction?n.setDirection?n.setDirection("sendonly"):n.direction="sendonly":"recvonly"===n.direction&&(n.setDirection?n.setDirection("inactive"):n.direction="inactive"):!0!==e.offerToReceiveVideo||n||this.addTransceiver("video",{direction:"recvonly"})}return t.apply(this,arguments)}}function B(e){"object"!=typeof e||e.AudioContext||(e.AudioContext=e.webkitAudioContext)}var Z=n(539),X=n.n(Z);function $(e){if(!e.RTCIceCandidate||e.RTCIceCandidate&&"foundation"in e.RTCIceCandidate.prototype)return;const t=e.RTCIceCandidate;e.RTCIceCandidate=function(e){if("object"==typeof e&&e.candidate&&0===e.candidate.indexOf("a=")&&((e=JSON.parse(JSON.stringify(e))).candidate=e.candidate.substring(2)),e.candidate&&e.candidate.length){const n=new t(e),r=X().parseCandidate(e.candidate);for(const e in r)e in n||Object.defineProperty(n,e,{value:r[e]});return n.toJSON=function(){return{candidate:n.candidate,sdpMid:n.sdpMid,sdpMLineIndex:n.sdpMLineIndex,usernameFragment:n.usernameFragment}},n}return new t(e)},e.RTCIceCandidate.prototype=t.prototype,c(e,"icecandidate",(t=>(t.candidate&&Object.defineProperty(t,"candidate",{value:new e.RTCIceCandidate(t.candidate),writable:"false"}),t)))}function Q(e){!e.RTCIceCandidate||e.RTCIceCandidate&&"relayProtocol"in e.RTCIceCandidate.prototype||c(e,"icecandidate",(e=>{if(e.candidate){const t=X().parseCandidate(e.candidate.candidate);"relay"===t.type&&(e.candidate.relayProtocol={0:"tls",1:"tcp",2:"udp"}[t.priority>>24])}return e}))}function ee(e,t){if(!e.RTCPeerConnection)return;"sctp"in e.RTCPeerConnection.prototype||Object.defineProperty(e.RTCPeerConnection.prototype,"sctp",{get(){return void 0===this._sctp?null:this._sctp}});const n=e.RTCPeerConnection.prototype.setRemoteDescription;e.RTCPeerConnection.prototype.setRemoteDescription=function(){if(this._sctp=null,"chrome"===t.browser&&t.version>=76){const{sdpSemantics:e}=this.getConfiguration();"plan-b"===e&&Object.defineProperty(this,"sctp",{get(){return void 0===this._sctp?null:this._sctp},enumerable:!0,configurable:!0})}if(function(e){if(!e||!e.sdp)return!1;const t=X().splitSections(e.sdp);return t.shift(),t.some((e=>{const t=X().parseMLine(e);return t&&"application"===t.kind&&-1!==t.protocol.indexOf("SCTP")}))}(arguments[0])){const e=function(e){const t=e.sdp.match(/mozilla...THIS_IS_SDPARTA-(\d+)/);if(null===t||t.length<2)return-1;const n=parseInt(t[1],10);return n!=n?-1:n}(arguments[0]),n=function(e){let n=65536;return"firefox"===t.browser&&(n=t.version<57?-1===e?16384:2147483637:t.version<60?57===t.version?65535:65536:2147483637),n}(e),r=function(e,n){let r=65536;"firefox"===t.browser&&57===t.version&&(r=65535);const i=X().matchPrefix(e.sdp,"a=max-message-size:");return i.length>0?r=parseInt(i[0].substring(19),10):"firefox"===t.browser&&-1!==n&&(r=2147483637),r}(arguments[0],e);let i;i=0===n&&0===r?Number.POSITIVE_INFINITY:0===n||0===r?Math.max(n,r):Math.min(n,r);const o={};Object.defineProperty(o,"maxMessageSize",{get:()=>i}),this._sctp=o}return n.apply(this,arguments)}}function te(e){if(!e.RTCPeerConnection||!("createDataChannel"in e.RTCPeerConnection.prototype))return;function t(e,t){const n=e.send;e.send=function(){const r=arguments[0],i=r.length||r.size||r.byteLength;if("open"===e.readyState&&t.sctp&&i>t.sctp.maxMessageSize)throw new TypeError("Message too large (can send a maximum of "+t.sctp.maxMessageSize+" bytes)");return n.apply(e,arguments)}}const n=e.RTCPeerConnection.prototype.createDataChannel;e.RTCPeerConnection.prototype.createDataChannel=function(){const e=n.apply(this,arguments);return t(e,this),e},c(e,"datachannel",(e=>(t(e.channel,e.target),e)))}function ne(e){if(!e.RTCPeerConnection||"connectionState"in e.RTCPeerConnection.prototype)return;const t=e.RTCPeerConnection.prototype;Object.defineProperty(t,"connectionState",{get(){return{completed:"connected",checking:"connecting"}[this.iceConnectionState]||this.iceConnectionState},enumerable:!0,configurable:!0}),Object.defineProperty(t,"onconnectionstatechange",{get(){return this._onconnectionstatechange||null},set(e){this._onconnectionstatechange&&(this.removeEventListener("connectionstatechange",this._onconnectionstatechange),delete this._onconnectionstatechange),e&&this.addEventListener("connectionstatechange",this._onconnectionstatechange=e)},enumerable:!0,configurable:!0}),["setLocalDescription","setRemoteDescription"].forEach((e=>{const n=t[e];t[e]=function(){return this._connectionstatechangepoly||(this._connectionstatechangepoly=e=>{const t=e.target;if(t._lastConnectionState!==t.connectionState){t._lastConnectionState=t.connectionState;const n=new Event("connectionstatechange",e);t.dispatchEvent(n)}return e},this.addEventListener("iceconnectionstatechange",this._connectionstatechangepoly)),n.apply(this,arguments)}}))}function re(e,t){if(!e.RTCPeerConnection)return;if("chrome"===t.browser&&t.version>=71)return;if("safari"===t.browser&&t.version>=605)return;const n=e.RTCPeerConnection.prototype.setRemoteDescription;e.RTCPeerConnection.prototype.setRemoteDescription=function(t){if(t&&t.sdp&&-1!==t.sdp.indexOf("\na=extmap-allow-mixed")){const n=t.sdp.split("\n").filter((e=>"a=extmap-allow-mixed"!==e.trim())).join("\n");e.RTCSessionDescription&&t instanceof e.RTCSessionDescription?arguments[0]=new e.RTCSessionDescription({type:t.type,sdp:n}):t.sdp=n}return n.apply(this,arguments)}}function ie(e,t){if(!e.RTCPeerConnection||!e.RTCPeerConnection.prototype)return;const n=e.RTCPeerConnection.prototype.addIceCandidate;n&&0!==n.length&&(e.RTCPeerConnection.prototype.addIceCandidate=function(){return arguments[0]?("chrome"===t.browser&&t.version<78||"firefox"===t.browser&&t.version<68||"safari"===t.browser)&&arguments[0]&&""===arguments[0].candidate?Promise.resolve():n.apply(this,arguments):(arguments[1]&&arguments[1].apply(null),Promise.resolve())})}function oe(e,t){if(!e.RTCPeerConnection||!e.RTCPeerConnection.prototype)return;const n=e.RTCPeerConnection.prototype.setLocalDescription;n&&0!==n.length&&(e.RTCPeerConnection.prototype.setLocalDescription=function(){let e=arguments[0]||{};if("object"!=typeof e||e.type&&e.sdp)return n.apply(this,arguments);if(e={type:e.type,sdp:e.sdp},!e.type)switch(this.signalingState){case"stable":case"have-local-offer":case"have-remote-pranswer":e.type="offer";break;default:e.type="answer"}if(e.sdp||"offer"!==e.type&&"answer"!==e.type)return n.apply(this,[e]);return("offer"===e.type?this.createOffer:this.createAnswer).apply(this).then((e=>n.apply(this,[e])))})}!function({window:n}={},o={shimChrome:!0,shimFirefox:!0,shimSafari:!0}){const s=h,c=function(e){const t={browser:null,version:null};if(void 0===e||!e.navigator)return t.browser="Not a browser.",t;const{navigator:n}=e;if(n.mozGetUserMedia)t.browser="firefox",t.version=a(n.userAgent,/Firefox\/(\d+)\./,1);else if(n.webkitGetUserMedia||!1===e.isSecureContext&&e.webkitRTCPeerConnection)t.browser="chrome",t.version=a(n.userAgent,/Chrom(e|ium)\/(\d+)\./,2);else{if(!e.RTCPeerConnection||!n.userAgent.match(/AppleWebKit\/(\d+)\./))return t.browser="Not a supported browser.",t;t.browser="safari",t.version=a(n.userAgent,/AppleWebKit\/(\d+)\./,1),t.supportsUnifiedPlan=e.RTCRtpTransceiver&&"currentDirection"in e.RTCRtpTransceiver.prototype}return t}(n),p={browserDetails:c,commonShim:i,extractVersion:a,disableLog:d,disableWarnings:l,sdp:Z};switch(c.browser){case"chrome":if(!e||!R||!o.shimChrome)return s("Chrome shim is not included in this adapter release."),p;if(null===c.version)return s("Chrome shim can not determine version, not shimming."),p;s("adapter.js shimming chrome."),p.browserShim=e,ie(n,c),oe(n),C(n,c),v(n),R(n,c),b(n),P(n,c),S(n),k(n),T(n),w(n,c),$(n),Q(n),ne(n),ee(n,c),te(n),re(n,c);break;case"firefox":if(!t||!O||!o.shimFirefox)return s("Firefox shim is not included in this adapter release."),p;s("adapter.js shimming firefox."),p.browserShim=t,ie(n,c),oe(n),A(n,c),O(n,c),I(n),L(n),D(n),M(n),H(n),G(n),j(n),N(n),U(n),$(n),ne(n),ee(n,c),te(n);break;case"safari":if(!r||!o.shimSafari)return s("Safari shim is not included in this adapter release."),p;s("adapter.js shimming safari."),p.browserShim=r,ie(n,c),oe(n),W(n),V(n),J(n),F(n),z(n),Y(n),K(n),B(n),$(n),Q(n),ee(n,c),te(n),re(n,c);break;default:s("Unsupported browser!")}}({window:"undefined"==typeof window?void 0:window});const se=Object.freeze({meta:null,signalingServerUrl:"ws://127.0.0.1:8443",reconnectionTimeout:2500,webrtcConfig:{iceServers:[{urls:["stun:stun.l.google.com:19302","stun:stun1.l.google.com:19302"]}]}}),ae={idle:0,connecting:1,streaming:2,closed:3};Object.freeze(ae);const ce=ae;class de extends EventTarget{constructor(e,t){super(),this._peerId=e,this._sessionId="",this._comChannel=t,this._state=ce.idle,this._rtcPeerConnection=null}get peerId(){return this._peerId}get sessionId(){return this._sessionId}get state(){return this._state}get rtcPeerConnection(){return this._rtcPeerConnection}close(){this._state!==ce.closed&&(this._state!==ce.idle&&this._comChannel&&this._sessionId&&this._comChannel.send({type:"endSession",sessionId:this._sessionId}),this._state=ce.closed,this.dispatchEvent(new Event("stateChanged")),this._comChannel=null,this._rtcPeerConnection&&(this._rtcPeerConnection.close(),this._rtcPeerConnection=null,this.dispatchEvent(new Event("rtcPeerConnectionChanged"))),this.dispatchEvent(new Event("closed")))}}const le=de,he=Object.freeze({32:"space",33:"exclam",34:"quotedbl",35:"numbersign",36:"dollar",37:"percent",38:"ampersand",39:"apostrophe",40:"parenleft",41:"parenright",42:"asterisk",43:"plus",44:"comma",45:"minus",46:"period",47:"slash",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",58:"colon",59:"semicolon",60:"less",61:"equal",62:"greater",63:"question",64:"at",65:"A",66:"B",67:"C",68:"D",69:"E",70:"F",71:"G",72:"H",73:"I",74:"J",75:"K",76:"L",77:"M",78:"N",79:"O",80:"P",81:"Q",82:"R",83:"S",84:"T",85:"U",86:"V",87:"W",88:"X",89:"Y",90:"Z",91:"bracketleft",92:"backslash",93:"bracketright",94:"asciicircum",95:"underscore",96:"grave",97:"a",98:"b",99:"c",100:"d",101:"e",102:"f",103:"g",104:"h",105:"i",106:"j",107:"k",108:"l",109:"m",110:"n",111:"o",112:"p",113:"q",114:"r",115:"s",116:"t",117:"u",118:"v",119:"w",120:"x",121:"y",122:"z",123:"braceleft",124:"bar",125:"braceright",126:"asciitilde",160:"nobreakspace",161:"exclamdown",162:"cent",163:"sterling",164:"currency",165:"yen",166:"brokenbar",167:"section",168:"diaeresis",169:"copyright",170:"ordfeminine",171:"guillemotleft",172:"notsign",173:"hyphen",174:"registered",175:"macron",176:"degree",177:"plusminus",178:"twosuperior",179:"threesuperior",180:"acute",181:"mu",182:"paragraph",183:"periodcentered",184:"cedilla",185:"onesuperior",186:"masculine",187:"guillemotright",188:"onequarter",189:"onehalf",190:"threequarters",191:"questiondown",192:"Agrave",193:"Aacute",194:"Acircumflex",195:"Atilde",196:"Adiaeresis",197:"Aring",198:"AE",199:"Ccedilla",200:"Egrave",201:"Eacute",202:"Ecircumflex",203:"Ediaeresis",204:"Igrave",205:"Iacute",206:"Icircumflex",207:"Idiaeresis",208:"ETH",209:"Ntilde",210:"Ograve",211:"Oacute",212:"Ocircumflex",213:"Otilde",214:"Odiaeresis",215:"multiply",216:"Ooblique",217:"Ugrave",218:"Uacute",219:"Ucircumflex",220:"Udiaeresis",221:"Yacute",222:"THORN",223:"ssharp",224:"agrave",225:"aacute",226:"acircumflex",227:"atilde",228:"adiaeresis",229:"aring",230:"ae",231:"ccedilla",232:"egrave",233:"eacute",234:"ecircumflex",235:"ediaeresis",236:"igrave",237:"iacute",238:"icircumflex",239:"idiaeresis",240:"eth",241:"ntilde",242:"ograve",243:"oacute",244:"ocircumflex",245:"otilde",246:"odiaeresis",247:"division",248:"oslash",249:"ugrave",250:"uacute",251:"ucircumflex",252:"udiaeresis",253:"yacute",254:"thorn",255:"ydiaeresis",260:"Aogonek",728:"breve",321:"Lstroke",317:"Lcaron",346:"Sacute",352:"Scaron",350:"Scedilla",356:"Tcaron",377:"Zacute",381:"Zcaron",379:"Zabovedot",261:"aogonek",731:"ogonek",322:"lstroke",318:"lcaron",347:"sacute",711:"caron",353:"scaron",351:"scedilla",357:"tcaron",378:"zacute",733:"doubleacute",382:"zcaron",380:"zabovedot",340:"Racute",258:"Abreve",313:"Lacute",262:"Cacute",268:"Ccaron",280:"Eogonek",282:"Ecaron",270:"Dcaron",272:"Dstroke",323:"Nacute",327:"Ncaron",336:"Odoubleacute",344:"Rcaron",366:"Uring",368:"Udoubleacute",354:"Tcedilla",341:"racute",259:"abreve",314:"lacute",263:"cacute",269:"ccaron",281:"eogonek",283:"ecaron",271:"dcaron",273:"dstroke",324:"nacute",328:"ncaron",337:"odoubleacute",345:"rcaron",367:"uring",369:"udoubleacute",355:"tcedilla",729:"abovedot",294:"Hstroke",292:"Hcircumflex",304:"Iabovedot",286:"Gbreve",308:"Jcircumflex",295:"hstroke",293:"hcircumflex",305:"idotless",287:"gbreve",309:"jcircumflex",266:"Cabovedot",264:"Ccircumflex",288:"Gabovedot",284:"Gcircumflex",364:"Ubreve",348:"Scircumflex",267:"cabovedot",265:"ccircumflex",289:"gabovedot",285:"gcircumflex",365:"ubreve",349:"scircumflex",312:"kra",342:"Rcedilla",296:"Itilde",315:"Lcedilla",274:"Emacron",290:"Gcedilla",358:"Tslash",343:"rcedilla",297:"itilde",316:"lcedilla",275:"emacron",291:"gcedilla",359:"tslash",330:"ENG",331:"eng",256:"Amacron",302:"Iogonek",278:"Eabovedot",298:"Imacron",325:"Ncedilla",332:"Omacron",310:"Kcedilla",370:"Uogonek",360:"Utilde",362:"Umacron",257:"amacron",303:"iogonek",279:"eabovedot",299:"imacron",326:"ncedilla",333:"omacron",311:"kcedilla",371:"uogonek",361:"utilde",363:"umacron",8254:"overline",12290:"kana_fullstop",12300:"kana_openingbracket",12301:"kana_closingbracket",12289:"kana_comma",12539:"kana_conjunctive",12530:"kana_WO",12449:"kana_a",12451:"kana_i",12453:"kana_u",12455:"kana_e",12457:"kana_o",12515:"kana_ya",12517:"kana_yu",12519:"kana_yo",12483:"kana_tsu",12540:"prolongedsound",12450:"kana_A",12452:"kana_I",12454:"kana_U",12456:"kana_E",12458:"kana_O",12459:"kana_KA",12461:"kana_KI",12463:"kana_KU",12465:"kana_KE",12467:"kana_KO",12469:"kana_SA",12471:"kana_SHI",12473:"kana_SU",12475:"kana_SE",12477:"kana_SO",12479:"kana_TA",12481:"kana_CHI",12484:"kana_TSU",12486:"kana_TE",12488:"kana_TO",12490:"kana_NA",12491:"kana_NI",12492:"kana_NU",12493:"kana_NE",12494:"kana_NO",12495:"kana_HA",12498:"kana_HI",12501:"kana_FU",12504:"kana_HE",12507:"kana_HO",12510:"kana_MA",12511:"kana_MI",12512:"kana_MU",12513:"kana_ME",12514:"kana_MO",12516:"kana_YA",12518:"kana_YU",12520:"kana_YO",12521:"kana_RA",12522:"kana_RI",12523:"kana_RU",12524:"kana_RE",12525:"kana_RO",12527:"kana_WA",12531:"kana_N",12443:"voicedsound",12444:"semivoicedsound",1548:"Arabic_comma",1563:"Arabic_semicolon",1567:"Arabic_question_mark",1569:"Arabic_hamza",1570:"Arabic_maddaonalef",1571:"Arabic_hamzaonalef",1572:"Arabic_hamzaonwaw",1573:"Arabic_hamzaunderalef",1574:"Arabic_hamzaonyeh",1575:"Arabic_alef",1576:"Arabic_beh",1577:"Arabic_tehmarbuta",1578:"Arabic_teh",1579:"Arabic_theh",1580:"Arabic_jeem",1581:"Arabic_hah",1582:"Arabic_khah",1583:"Arabic_dal",1584:"Arabic_thal",1585:"Arabic_ra",1586:"Arabic_zain",1587:"Arabic_seen",1588:"Arabic_sheen",1589:"Arabic_sad",1590:"Arabic_dad",1591:"Arabic_tah",1592:"Arabic_zah",1593:"Arabic_ain",1594:"Arabic_ghain",1600:"Arabic_tatweel",1601:"Arabic_feh",1602:"Arabic_qaf",1603:"Arabic_kaf",1604:"Arabic_lam",1605:"Arabic_meem",1606:"Arabic_noon",1607:"Arabic_ha",1608:"Arabic_waw",1609:"Arabic_alefmaksura",1610:"Arabic_yeh",1611:"Arabic_fathatan",1612:"Arabic_dammatan",1613:"Arabic_kasratan",1614:"Arabic_fatha",1615:"Arabic_damma",1616:"Arabic_kasra",1617:"Arabic_shadda",1618:"Arabic_sukun",1106:"Serbian_dje",1107:"Macedonia_gje",1105:"Cyrillic_io",1108:"Ukrainian_ie",1109:"Macedonia_dse",1110:"Ukrainian_i",1111:"Ukrainian_yi",1112:"Cyrillic_je",1113:"Cyrillic_lje",1114:"Cyrillic_nje",1115:"Serbian_tshe",1116:"Macedonia_kje",1118:"Byelorussian_shortu",1119:"Cyrillic_dzhe",8470:"numerosign",1026:"Serbian_DJE",1027:"Macedonia_GJE",1025:"Cyrillic_IO",1028:"Ukrainian_IE",1029:"Macedonia_DSE",1030:"Ukrainian_I",1031:"Ukrainian_YI",1032:"Cyrillic_JE",1033:"Cyrillic_LJE",1034:"Cyrillic_NJE",1035:"Serbian_TSHE",1036:"Macedonia_KJE",1038:"Byelorussian_SHORTU",1039:"Cyrillic_DZHE",1102:"Cyrillic_yu",1072:"Cyrillic_a",1073:"Cyrillic_be",1094:"Cyrillic_tse",1076:"Cyrillic_de",1077:"Cyrillic_ie",1092:"Cyrillic_ef",1075:"Cyrillic_ghe",1093:"Cyrillic_ha",1080:"Cyrillic_i",1081:"Cyrillic_shorti",1082:"Cyrillic_ka",1083:"Cyrillic_el",1084:"Cyrillic_em",1085:"Cyrillic_en",1086:"Cyrillic_o",1087:"Cyrillic_pe",1103:"Cyrillic_ya",1088:"Cyrillic_er",1089:"Cyrillic_es",1090:"Cyrillic_te",1091:"Cyrillic_u",1078:"Cyrillic_zhe",1074:"Cyrillic_ve",1100:"Cyrillic_softsign",1099:"Cyrillic_yeru",1079:"Cyrillic_ze",1096:"Cyrillic_sha",1101:"Cyrillic_e",1097:"Cyrillic_shcha",1095:"Cyrillic_che",1098:"Cyrillic_hardsign",1070:"Cyrillic_YU",1040:"Cyrillic_A",1041:"Cyrillic_BE",1062:"Cyrillic_TSE",1044:"Cyrillic_DE",1045:"Cyrillic_IE",1060:"Cyrillic_EF",1043:"Cyrillic_GHE",1061:"Cyrillic_HA",1048:"Cyrillic_I",1049:"Cyrillic_SHORTI",1050:"Cyrillic_KA",1051:"Cyrillic_EL",1052:"Cyrillic_EM",1053:"Cyrillic_EN",1054:"Cyrillic_O",1055:"Cyrillic_PE",1071:"Cyrillic_YA",1056:"Cyrillic_ER",1057:"Cyrillic_ES",1058:"Cyrillic_TE",1059:"Cyrillic_U",1046:"Cyrillic_ZHE",1042:"Cyrillic_VE",1068:"Cyrillic_SOFTSIGN",1067:"Cyrillic_YERU",1047:"Cyrillic_ZE",1064:"Cyrillic_SHA",1069:"Cyrillic_E",1065:"Cyrillic_SHCHA",1063:"Cyrillic_CHE",1066:"Cyrillic_HARDSIGN",902:"Greek_ALPHAaccent",904:"Greek_EPSILONaccent",905:"Greek_ETAaccent",906:"Greek_IOTAaccent",938:"Greek_IOTAdiaeresis",908:"Greek_OMICRONaccent",910:"Greek_UPSILONaccent",939:"Greek_UPSILONdieresis",911:"Greek_OMEGAaccent",901:"Greek_accentdieresis",8213:"Greek_horizbar",940:"Greek_alphaaccent",941:"Greek_epsilonaccent",942:"Greek_etaaccent",943:"Greek_iotaaccent",970:"Greek_iotadieresis",912:"Greek_iotaaccentdieresis",972:"Greek_omicronaccent",973:"Greek_upsilonaccent",971:"Greek_upsilondieresis",944:"Greek_upsilonaccentdieresis",974:"Greek_omegaaccent",913:"Greek_ALPHA",914:"Greek_BETA",915:"Greek_GAMMA",916:"Greek_DELTA",917:"Greek_EPSILON",918:"Greek_ZETA",919:"Greek_ETA",920:"Greek_THETA",921:"Greek_IOTA",922:"Greek_KAPPA",923:"Greek_LAMBDA",924:"Greek_MU",925:"Greek_NU",926:"Greek_XI",927:"Greek_OMICRON",928:"Greek_PI",929:"Greek_RHO",931:"Greek_SIGMA",932:"Greek_TAU",933:"Greek_UPSILON",934:"Greek_PHI",935:"Greek_CHI",936:"Greek_PSI",937:"Greek_OMEGA",945:"Greek_alpha",946:"Greek_beta",947:"Greek_gamma",948:"Greek_delta",949:"Greek_epsilon",950:"Greek_zeta",951:"Greek_eta",952:"Greek_theta",953:"Greek_iota",954:"Greek_kappa",955:"Greek_lambda",956:"Greek_mu",957:"Greek_nu",958:"Greek_xi",959:"Greek_omicron",960:"Greek_pi",961:"Greek_rho",963:"Greek_sigma",962:"Greek_finalsmallsigma",964:"Greek_tau",965:"Greek_upsilon",966:"Greek_phi",967:"Greek_chi",968:"Greek_psi",969:"Greek_omega",9143:"leftradical",8992:"topintegral",8993:"botintegral",9121:"topleftsqbracket",9123:"botleftsqbracket",9124:"toprightsqbracket",9126:"botrightsqbracket",9115:"topleftparens",9117:"botleftparens",9118:"toprightparens",9120:"botrightparens",9128:"leftmiddlecurlybrace",9132:"rightmiddlecurlybrace",8804:"lessthanequal",8800:"notequal",8805:"greaterthanequal",8747:"integral",8756:"therefore",8733:"variation",8734:"infinity",8711:"nabla",8764:"approximate",8771:"similarequal",8660:"ifonlyif",8658:"implies",8801:"identical",8730:"radical",8834:"includedin",8835:"includes",8745:"intersection",8746:"union",8743:"logicaland",8744:"logicalor",8706:"partialderivative",402:"function",8592:"leftarrow",8593:"uparrow",8594:"rightarrow",8595:"downarrow",9670:"soliddiamond",9618:"checkerboard",9225:"ht",9228:"ff",9229:"cr",9226:"lf",9252:"nl",9227:"vt",9496:"lowrightcorner",9488:"uprightcorner",9484:"upleftcorner",9492:"lowleftcorner",9532:"crossinglines",9146:"horizlinescan1",9147:"horizlinescan3",9472:"horizlinescan5",9148:"horizlinescan7",9149:"horizlinescan9",9500:"leftt",9508:"rightt",9524:"bott",9516:"topt",9474:"vertbar",8195:"emspace",8194:"enspace",8196:"em3space",8197:"em4space",8199:"digitspace",8200:"punctspace",8201:"thinspace",8202:"hairspace",8212:"emdash",8211:"endash",9251:"signifblank",8230:"ellipsis",8229:"doubbaselinedot",8531:"onethird",8532:"twothirds",8533:"onefifth",8534:"twofifths",8535:"threefifths",8536:"fourfifths",8537:"onesixth",8538:"fivesixths",8453:"careof",8210:"figdash",10216:"leftanglebracket",10217:"rightanglebracket",8539:"oneeighth",8540:"threeeighths",8541:"fiveeighths",8542:"seveneighths",8482:"trademark",9747:"signaturemark",9665:"leftopentriangle",9655:"rightopentriangle",9647:"emopenrectangle",8216:"leftsinglequotemark",8217:"rightsinglequotemark",8220:"leftdoublequotemark",8221:"rightdoublequotemark",8478:"prescription",8242:"minutes",8243:"seconds",10013:"latincross",9644:"filledrectbullet",9664:"filledlefttribullet",9654:"filledrighttribullet",9679:"emfilledcircle",9646:"emfilledrect",9702:"enopencircbullet",9643:"enopensquarebullet",9645:"openrectbullet",9651:"opentribulletup",9661:"opentribulletdown",9734:"openstar",8226:"enfilledcircbullet",9642:"enfilledsqbullet",9650:"filledtribulletup",9660:"filledtribulletdown",9756:"leftpointer",9758:"rightpointer",9827:"club",9830:"diamond",9829:"heart",10016:"maltesecross",8224:"dagger",8225:"doubledagger",10003:"checkmark",10007:"ballotcross",9839:"musicalsharp",9837:"musicalflat",9794:"malesymbol",9792:"femalesymbol",9742:"telephone",8981:"telephonerecorder",8471:"phonographcopyright",8248:"caret",8218:"singlelowquotemark",8222:"doublelowquotemark",8869:"downtack",8970:"downstile",8728:"jot",9109:"quad",8868:"uptack",9675:"circle",8968:"upstile",8866:"lefttack",8867:"righttack",8215:"hebrew_doublelowline",1488:"hebrew_aleph",1489:"hebrew_beth",1490:"hebrew_gimmel",1491:"hebrew_daleth",1492:"hebrew_he",1493:"hebrew_waw",1494:"hebrew_zayin",1495:"hebrew_het",1496:"hebrew_teth",1497:"hebrew_yod",1498:"hebrew_finalkaph",1499:"hebrew_kaph",1500:"hebrew_lamed",1501:"hebrew_finalmem",1502:"hebrew_mem",1503:"hebrew_finalnun",1504:"hebrew_nun",1505:"hebrew_samekh",1506:"hebrew_ayin",1507:"hebrew_finalpe",1508:"hebrew_pe",1509:"hebrew_finalzadi",1510:"hebrew_zadi",1511:"hebrew_qoph",1512:"hebrew_resh",1513:"hebrew_shin",1514:"hebrew_taw",3585:"Thai_kokai",3586:"Thai_khokhai",3587:"Thai_khokhuat",3588:"Thai_khokhwai",3589:"Thai_khokhon",3590:"Thai_khorakhang",3591:"Thai_ngongu",3592:"Thai_chochan",3593:"Thai_choching",3594:"Thai_chochang",3595:"Thai_soso",3596:"Thai_chochoe",3597:"Thai_yoying",3598:"Thai_dochada",3599:"Thai_topatak",3600:"Thai_thothan",3601:"Thai_thonangmontho",3602:"Thai_thophuthao",3603:"Thai_nonen",3604:"Thai_dodek",3605:"Thai_totao",3606:"Thai_thothung",3607:"Thai_thothahan",3608:"Thai_thothong",3609:"Thai_nonu",3610:"Thai_bobaimai",3611:"Thai_popla",3612:"Thai_phophung",3613:"Thai_fofa",3614:"Thai_phophan",3615:"Thai_fofan",3616:"Thai_phosamphao",3617:"Thai_moma",3618:"Thai_yoyak",3619:"Thai_rorua",3620:"Thai_ru",3621:"Thai_loling",3622:"Thai_lu",3623:"Thai_wowaen",3624:"Thai_sosala",3625:"Thai_sorusi",3626:"Thai_sosua",3627:"Thai_hohip",3628:"Thai_lochula",3629:"Thai_oang",3630:"Thai_honokhuk",3631:"Thai_paiyannoi",3632:"Thai_saraa",3633:"Thai_maihanakat",3634:"Thai_saraaa",3635:"Thai_saraam",3636:"Thai_sarai",3637:"Thai_saraii",3638:"Thai_saraue",3639:"Thai_sarauee",3640:"Thai_sarau",3641:"Thai_sarauu",3642:"Thai_phinthu",3647:"Thai_baht",3648:"Thai_sarae",3649:"Thai_saraae",3650:"Thai_sarao",3651:"Thai_saraaimaimuan",3652:"Thai_saraaimaimalai",3653:"Thai_lakkhangyao",3654:"Thai_maiyamok",3655:"Thai_maitaikhu",3656:"Thai_maiek",3657:"Thai_maitho",3658:"Thai_maitri",3659:"Thai_maichattawa",3660:"Thai_thanthakhat",3661:"Thai_nikhahit",3664:"Thai_leksun",3665:"Thai_leknung",3666:"Thai_leksong",3667:"Thai_leksam",3668:"Thai_leksi",3669:"Thai_lekha",3670:"Thai_lekhok",3671:"Thai_lekchet",3672:"Thai_lekpaet",3673:"Thai_lekkao",12593:"Hangul_Kiyeog",12594:"Hangul_SsangKiyeog",12595:"Hangul_KiyeogSios",12596:"Hangul_Nieun",12597:"Hangul_NieunJieuj",12598:"Hangul_NieunHieuh",12599:"Hangul_Dikeud",12600:"Hangul_SsangDikeud",12601:"Hangul_Rieul",12602:"Hangul_RieulKiyeog",12603:"Hangul_RieulMieum",12604:"Hangul_RieulPieub",12605:"Hangul_RieulSios",12606:"Hangul_RieulTieut",12607:"Hangul_RieulPhieuf",12608:"Hangul_RieulHieuh",12609:"Hangul_Mieum",12610:"Hangul_Pieub",12611:"Hangul_SsangPieub",12612:"Hangul_PieubSios",12613:"Hangul_Sios",12614:"Hangul_SsangSios",12615:"Hangul_Ieung",12616:"Hangul_Jieuj",12617:"Hangul_SsangJieuj",12618:"Hangul_Cieuc",12619:"Hangul_Khieuq",12620:"Hangul_Tieut",12621:"Hangul_Phieuf",12622:"Hangul_Hieuh",12623:"Hangul_A",12624:"Hangul_AE",12625:"Hangul_YA",12626:"Hangul_YAE",12627:"Hangul_EO",12628:"Hangul_E",12629:"Hangul_YEO",12630:"Hangul_YE",12631:"Hangul_O",12632:"Hangul_WA",12633:"Hangul_WAE",12634:"Hangul_OE",12635:"Hangul_YO",12636:"Hangul_U",12637:"Hangul_WEO",12638:"Hangul_WE",12639:"Hangul_WI",12640:"Hangul_YU",12641:"Hangul_EU",12642:"Hangul_YI",12643:"Hangul_I",4520:"Hangul_J_Kiyeog",4521:"Hangul_J_SsangKiyeog",4522:"Hangul_J_KiyeogSios",4523:"Hangul_J_Nieun",4524:"Hangul_J_NieunJieuj",4525:"Hangul_J_NieunHieuh",4526:"Hangul_J_Dikeud",4527:"Hangul_J_Rieul",4528:"Hangul_J_RieulKiyeog",4529:"Hangul_J_RieulMieum",4530:"Hangul_J_RieulPieub",4531:"Hangul_J_RieulSios",4532:"Hangul_J_RieulTieut",4533:"Hangul_J_RieulPhieuf",4534:"Hangul_J_RieulHieuh",4535:"Hangul_J_Mieum",4536:"Hangul_J_Pieub",4537:"Hangul_J_PieubSios",4538:"Hangul_J_Sios",4539:"Hangul_J_SsangSios",4540:"Hangul_J_Ieung",4541:"Hangul_J_Jieuj",4542:"Hangul_J_Cieuc",4543:"Hangul_J_Khieuq",4544:"Hangul_J_Tieut",4545:"Hangul_J_Phieuf",4546:"Hangul_J_Hieuh",12653:"Hangul_RieulYeorinHieuh",12657:"Hangul_SunkyeongeumMieum",12664:"Hangul_SunkyeongeumPieub",12671:"Hangul_PanSios",12673:"Hangul_KkogjiDalrinIeung",12676:"Hangul_SunkyeongeumPhieuf",12678:"Hangul_YeorinHieuh",12685:"Hangul_AraeA",12686:"Hangul_AraeAE",4587:"Hangul_J_PanSios",4592:"Hangul_J_KkogjiDalrinIeung",4601:"Hangul_J_YeorinHieuh",338:"OE",339:"oe",376:"Ydiaeresis",8352:"EcuSign",8353:"ColonSign",8354:"CruzeiroSign",8355:"FFrancSign",8356:"LiraSign",8357:"MillSign",8358:"NairaSign",8359:"PesetaSign",8360:"RupeeSign",8361:"WonSign",8362:"NewSheqelSign",8363:"DongSign",8364:"EuroSign",768:"dead_grave",769:"dead_acute",770:"dead_circumflex",771:"dead_tilde",772:"dead_macron",774:"dead_breve",775:"dead_abovedot",776:"dead_diaeresis",778:"dead_abovering",779:"dead_doubleacute",780:"dead_caron",807:"dead_cedilla",808:"dead_ogonek",837:"dead_iota",12441:"dead_voiced_sound",12442:"dead_semivoiced_sound",8:"BackSpace",9:"Tab",10:"Linefeed",11:"Clear",13:"Return",19:"Pause",20:"Scroll_Lock",21:"Sys_Req",27:"Escape",1169:"Ukrainian_ghe_with_upturn",1168:"Ukrainian_GHE_WITH_UPTURN",1415:"Armenian_ligature_ew",1417:"Armenian_verjaket",1373:"Armenian_but",1418:"Armenian_yentamna",1372:"Armenian_amanak",1371:"Armenian_shesht",1374:"Armenian_paruyk",1329:"Armenian_AYB",1377:"Armenian_ayb",1330:"Armenian_BEN",1378:"Armenian_ben",1331:"Armenian_GIM",1379:"Armenian_gim",1332:"Armenian_DA",1380:"Armenian_da",1333:"Armenian_YECH",1381:"Armenian_yech",1334:"Armenian_ZA",1382:"Armenian_za",1335:"Armenian_E",1383:"Armenian_e",1336:"Armenian_AT",1384:"Armenian_at",1337:"Armenian_TO",1385:"Armenian_to",1338:"Armenian_ZHE",1386:"Armenian_zhe",1339:"Armenian_INI",1387:"Armenian_ini",1340:"Armenian_LYUN",1388:"Armenian_lyun",1341:"Armenian_KHE",1389:"Armenian_khe",1342:"Armenian_TSA",1390:"Armenian_tsa",1343:"Armenian_KEN",1391:"Armenian_ken",1344:"Armenian_HO",1392:"Armenian_ho",1345:"Armenian_DZA",1393:"Armenian_dza",1346:"Armenian_GHAT",1394:"Armenian_ghat",1347:"Armenian_TCHE",1395:"Armenian_tche",1348:"Armenian_MEN",1396:"Armenian_men",1349:"Armenian_HI",1397:"Armenian_hi",1350:"Armenian_NU",1398:"Armenian_nu",1351:"Armenian_SHA",1399:"Armenian_sha",1352:"Armenian_VO",1400:"Armenian_vo",1353:"Armenian_CHA",1401:"Armenian_cha",1354:"Armenian_PE",1402:"Armenian_pe",1355:"Armenian_JE",1403:"Armenian_je",1356:"Armenian_RA",1404:"Armenian_ra",1357:"Armenian_SE",1405:"Armenian_se",1358:"Armenian_VEV",1406:"Armenian_vev",1359:"Armenian_TYUN",1407:"Armenian_tyun",1360:"Armenian_RE",1408:"Armenian_re",1361:"Armenian_TSO",1409:"Armenian_tso",1362:"Armenian_VYUN",1410:"Armenian_vyun",1363:"Armenian_PYUR",1411:"Armenian_pyur",1364:"Armenian_KE",1412:"Armenian_ke",1365:"Armenian_O",1413:"Armenian_o",1366:"Armenian_FE",1414:"Armenian_fe",1370:"Armenian_apostrophe",4304:"Georgian_an",4305:"Georgian_ban",4306:"Georgian_gan",4307:"Georgian_don",4308:"Georgian_en",4309:"Georgian_vin",4310:"Georgian_zen",4311:"Georgian_tan",4312:"Georgian_in",4313:"Georgian_kan",4314:"Georgian_las",4315:"Georgian_man",4316:"Georgian_nar",4317:"Georgian_on",4318:"Georgian_par",4319:"Georgian_zhar",4320:"Georgian_rae",4321:"Georgian_san",4322:"Georgian_tar",4323:"Georgian_un",4324:"Georgian_phar",4325:"Georgian_khar",4326:"Georgian_ghan",4327:"Georgian_qar",4328:"Georgian_shin",4329:"Georgian_chin",4330:"Georgian_can",4331:"Georgian_jil",4332:"Georgian_cil",4333:"Georgian_char",4334:"Georgian_xan",4335:"Georgian_jhan",4336:"Georgian_hae",4337:"Georgian_he",4338:"Georgian_hie",4339:"Georgian_we",4340:"Georgian_har",4341:"Georgian_hoe",4342:"Georgian_fi",7682:"Babovedot",7683:"babovedot",7690:"Dabovedot",7808:"Wgrave",7810:"Wacute",7691:"dabovedot",7922:"Ygrave",7710:"Fabovedot",7711:"fabovedot",7744:"Mabovedot",7745:"mabovedot",7766:"Pabovedot",7809:"wgrave",7767:"pabovedot",7811:"wacute",7776:"Sabovedot",7923:"ygrave",7812:"Wdiaeresis",7813:"wdiaeresis",7777:"sabovedot",372:"Wcircumflex",7786:"Tabovedot",374:"Ycircumflex",373:"wcircumflex",7787:"tabovedot",375:"ycircumflex",1776:"Farsi_0",1777:"Farsi_1",1778:"Farsi_2",1779:"Farsi_3",1780:"Farsi_4",1781:"Farsi_5",1782:"Farsi_6",1783:"Farsi_7",1784:"Farsi_8",1785:"Farsi_9",1642:"Arabic_percent",1648:"Arabic_superscript_alef",1657:"Arabic_tteh",1662:"Arabic_peh",1670:"Arabic_tcheh",1672:"Arabic_ddal",1681:"Arabic_rreh",1748:"Arabic_fullstop",1632:"Arabic_0",1633:"Arabic_1",1634:"Arabic_2",1635:"Arabic_3",1636:"Arabic_4",1637:"Arabic_5",1638:"Arabic_6",1639:"Arabic_7",1640:"Arabic_8",1641:"Arabic_9",1619:"Arabic_madda_above",1620:"Arabic_hamza_above",1621:"Arabic_hamza_below",1688:"Arabic_jeh",1700:"Arabic_veh",1705:"Arabic_keheh",1711:"Arabic_gaf",1722:"Arabic_noon_ghunna",1726:"Arabic_heh_doachashmee",1740:"Farsi_yeh",1746:"Arabic_yeh_baree",1729:"Arabic_heh_goal",1170:"Cyrillic_GHE_bar",1174:"Cyrillic_ZHE_descender",1178:"Cyrillic_KA_descender",1180:"Cyrillic_KA_vertstroke",1186:"Cyrillic_EN_descender",1198:"Cyrillic_U_straight",1200:"Cyrillic_U_straight_bar",1202:"Cyrillic_HA_descender",1206:"Cyrillic_CHE_descender",1208:"Cyrillic_CHE_vertstroke",1210:"Cyrillic_SHHA",1240:"Cyrillic_SCHWA",1250:"Cyrillic_I_macron",1256:"Cyrillic_O_bar",1262:"Cyrillic_U_macron",1171:"Cyrillic_ghe_bar",1175:"Cyrillic_zhe_descender",1179:"Cyrillic_ka_descender",1181:"Cyrillic_ka_vertstroke",1187:"Cyrillic_en_descender",1199:"Cyrillic_u_straight",1201:"Cyrillic_u_straight_bar",1203:"Cyrillic_ha_descender",1207:"Cyrillic_che_descender",1209:"Cyrillic_che_vertstroke",1211:"Cyrillic_shha",1241:"Cyrillic_schwa",1251:"Cyrillic_i_macron",1257:"Cyrillic_o_bar",1263:"Cyrillic_u_macron",7818:"Xabovedot",300:"Ibreve",437:"Zstroke",486:"Gcaron",415:"Obarred",7819:"xabovedot",301:"ibreve",438:"zstroke",487:"gcaron",466:"ocaron",629:"obarred",399:"SCHWA",601:"schwa",7734:"Lbelowdot",7735:"lbelowdot",7840:"Abelowdot",7841:"abelowdot",7842:"Ahook",7843:"ahook",7844:"Acircumflexacute",7845:"acircumflexacute",7846:"Acircumflexgrave",7847:"acircumflexgrave",7848:"Acircumflexhook",7849:"acircumflexhook",7850:"Acircumflextilde",7851:"acircumflextilde",7852:"Acircumflexbelowdot",7853:"acircumflexbelowdot",7854:"Abreveacute",7855:"abreveacute",7856:"Abrevegrave",7857:"abrevegrave",7858:"Abrevehook",7859:"abrevehook",7860:"Abrevetilde",7861:"abrevetilde",7862:"Abrevebelowdot",7863:"abrevebelowdot",7864:"Ebelowdot",7865:"ebelowdot",7866:"Ehook",7867:"ehook",7868:"Etilde",7869:"etilde",7870:"Ecircumflexacute",7871:"ecircumflexacute",7872:"Ecircumflexgrave",7873:"ecircumflexgrave",7874:"Ecircumflexhook",7875:"ecircumflexhook",7876:"Ecircumflextilde",7877:"ecircumflextilde",7878:"Ecircumflexbelowdot",7879:"ecircumflexbelowdot",7880:"Ihook",7881:"ihook",7882:"Ibelowdot",7883:"ibelowdot",7884:"Obelowdot",7885:"obelowdot",7886:"Ohook",7887:"ohook",7888:"Ocircumflexacute",7889:"ocircumflexacute",7890:"Ocircumflexgrave",7891:"ocircumflexgrave",7892:"Ocircumflexhook",7893:"ocircumflexhook",7894:"Ocircumflextilde",7895:"ocircumflextilde",7896:"Ocircumflexbelowdot",7897:"ocircumflexbelowdot",7898:"Ohornacute",7899:"ohornacute",7900:"Ohorngrave",7901:"ohorngrave",7902:"Ohornhook",7903:"ohornhook",7904:"Ohorntilde",7905:"ohorntilde",7906:"Ohornbelowdot",7907:"ohornbelowdot",7908:"Ubelowdot",7909:"ubelowdot",7910:"Uhook",7911:"uhook",7912:"Uhornacute",7913:"uhornacute",7914:"Uhorngrave",7915:"uhorngrave",7916:"Uhornhook",7917:"uhornhook",7918:"Uhorntilde",7919:"uhorntilde",7920:"Uhornbelowdot",7921:"uhornbelowdot",7924:"Ybelowdot",7925:"ybelowdot",7926:"Yhook",7927:"yhook",7928:"Ytilde",7929:"ytilde",416:"Ohorn",417:"ohorn",431:"Uhorn",432:"uhorn",803:"dead_belowdot",777:"dead_hook",795:"dead_horn"}),pe=Object.freeze({AltLeft:"Alt_L",AltRight:"Alt_R",ArrowDown:"Down",ArrowLeft:"Left",ArrowRight:"Right",ArrowUp:"Up",Backspace:"BackSpace",CapsLock:"Caps_Lock",ControlLeft:"Control_L",ControlRight:"Control_R",Enter:"Return",HyperLeft:"Hyper_L",HyperRight:"Hyper_R",NumLock:"Num_Lock",NumpadEnter:"Return",MetaLeft:"Meta_L",MetaRight:"Meta_R",PageDown:"Page_Down",PageUp:"Page_Up",ScrollLock:"Scroll_Lock",ShiftLeft:"Shift_L",ShiftRight:"Shift_R",SuperLeft:"Super_L",SuperRight:"Super_R"}),ue=new Set(["Clear","Copy","Cut","Delete","End","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","Home","Insert","Paste","Redo","Tab","Undo"]);function me(e,t){var n="Unidentified";if(1===e.length){const t=e.charCodeAt(0);t in he&&(n=he[t])}else t in pe?n=pe[t]:ue.has(t)&&(n=t);return n}const _e=Object.freeze(["wheel","contextmenu","mousemove","mousedown","mouseup","touchstart","touchend","touchmove","touchcancel","keyup","keydown"]),fe=Object.freeze({mousemove:"MouseMove",mousedown:"MouseButtonPress",mouseup:"MouseButtonRelease"}),ge=Object.freeze({touchstart:"TouchDown",touchend:"TouchUp",touchmove:"TouchMotion",touchcancel:"TouchUp"}),Ce=Object.freeze({keydown:"KeyPress",keyup:"KeyRelease"});function ye(e){const t=[];return e.altKey&&t.push("mod1-mask"),e.ctrlKey&&t.push("control-mask"),e.metaKey&&t.push("meta-mask"),e.shiftKey&&t.push("shift-mask"),t.join("+")}class ve extends EventTarget{constructor(e,t){super(),this._rtcDataChannel=e,this._consumerSession=t,this._videoElement=null,this._videoElementComputedStyle=null,this._videoElementKeyboard=null,this._lastTouchEventTimestamp=0,this._requestCounter=0,e.addEventListener("close",(()=>{this._rtcDataChannel===e&&this.close()})),e.addEventListener("error",(t=>{if(this._rtcDataChannel===e){const e=t.error;this.dispatchEvent(new ErrorEvent("error",{message:e&&e.message||"Remote controller error",error:e||new Error("unknown error on the remote controller data channel")}))}})),e.addEventListener("message",(e=>{try{const t=JSON.parse(e.data);"ControlResponseMessage"===t.type?this.dispatchEvent(new CustomEvent("controlResponse",{detail:t})):"InfoMessage"===t.type&&this.dispatchEvent(new CustomEvent("info",{detail:t}))}catch(e){this.dispatchEvent(new ErrorEvent("error",{message:"cannot parse control message from signaling server",error:e}))}}))}get rtcDataChannel(){return this._rtcDataChannel}get consumerSession(){return this._consumerSession}get videoElement(){return this._videoElement}attachVideoElement(e){if(e instanceof HTMLVideoElement&&e!==this._videoElement){this._videoElement&&this.attachVideoElement(null),this._videoElement=e,this._videoElementComputedStyle=window.getComputedStyle(e);for(const t of _e)e.addEventListener(t,this);e.setAttribute("tabindex","0")}else if(null===e&&this._videoElement){const e=this._videoElement;e.removeAttribute("tabindex"),this._videoElement=null,this._videoElementComputedStyle=null,this._lastTouchEventTimestamp=0;for(const t of _e)e.removeEventListener(t,this)}}sendControlRequest(e){try{if(!e||"object"!=typeof e&&"string"!=typeof e)throw new Error("invalid request");if(!this._rtcDataChannel)throw new Error("remote controller data channel is closed");let t={id:this._requestCounter++,request:e};return this._rtcDataChannel.send(JSON.stringify(t)),t.id}catch(e){return this.dispatchEvent(new ErrorEvent("error",{message:`cannot send control message over session ${this._consumerSession.sessionId} remote controller`,error:e})),-1}}close(){this.attachVideoElement(null);const e=this._rtcDataChannel;this._rtcDataChannel=null,e&&(e.close(),this.dispatchEvent(new Event("closed")))}_sendGstNavigationEvent(e){let t={type:"navigationEvent",event:e};this.sendControlRequest(t)}_computeVideoMousePosition(e){const t={x:0,y:0};if(!this._videoElement||this._videoElement.videoWidth<=0||this._videoElement.videoHeight<=0)return t;const n=parseFloat(this._videoElementComputedStyle.paddingLeft),r=parseFloat(this._videoElementComputedStyle.paddingRight),i=parseFloat(this._videoElementComputedStyle.paddingTop),o=parseFloat(this._videoElementComputedStyle.paddingBottom);if("offsetX"in e&&"offsetY"in e)t.x=e.offsetX-n,t.y=e.offsetY-i;else{const r=this._videoElement.getBoundingClientRect(),o={left:parseFloat(this._videoElementComputedStyle.borderLeftWidth),top:parseFloat(this._videoElementComputedStyle.borderTopWidth)};t.x=e.clientX-r.left-o.left-n,t.y=e.clientY-r.top-o.top-i}const s={x:this._videoElement.clientWidth-(n+r),y:this._videoElement.clientHeight-(i+o)},a=Math.min(s.x/this._videoElement.videoWidth,s.y/this._videoElement.videoHeight);s.x=Math.max(.5*(s.x-this._videoElement.videoWidth*a),0),s.y=Math.max(.5*(s.y-this._videoElement.videoHeight*a),0);const c=0!==a?1/a:0;return t.x=(t.x-s.x)*c,t.y=(t.y-s.y)*c,t.x=Math.min(Math.max(t.x,0),this._videoElement.videoWidth),t.y=Math.min(Math.max(t.y,0),this._videoElement.videoHeight),t}handleEvent(e){if(this._videoElement)switch(e.type){case"wheel":e.preventDefault();{const t=this._computeVideoMousePosition(e);this._sendGstNavigationEvent({event:"MouseScroll",x:t.x,y:t.y,delta_x:-e.deltaX,delta_y:-e.deltaY,modifier_state:ye(e)})}break;case"contextmenu":e.preventDefault();break;case"mousemove":case"mousedown":case"mouseup":e.preventDefault();{const t=this._computeVideoMousePosition(e),n={event:fe[e.type],x:t.x,y:t.y,modifier_state:ye(e)};"mousemove"!==e.type&&(n.button=e.button+1,"mousedown"===e.type&&0===e.button&&this._videoElement.focus()),this._sendGstNavigationEvent(n)}break;case"touchstart":case"touchend":case"touchmove":case"touchcancel":for(const t of e.changedTouches){const n=this._computeVideoMousePosition(t),r={event:ge[e.type],identifier:t.identifier,x:n.x,y:n.y,modifier_state:ye(e)};!("force"in t)||"touchstart"!==e.type&&"touchmove"!==e.type||(r.pressure=t.force),this._sendGstNavigationEvent(r)}e.timeStamp>this._lastTouchEventTimestamp&&(this._lastTouchEventTimestamp=e.timeStamp,this._sendGstNavigationEvent({event:"TouchFrame",modifier_state:ye(e)}));break;case"keyup":case"keydown":e.preventDefault();{const t={event:Ce[e.type],key:me(e.key,e.code),modifier_state:ye(e)};this._sendGstNavigationEvent(t)}}}}const be=ve;const Se=class extends le{constructor(e,t,n){super(e,t),this._streams=[],this._remoteController=null,this._pendingCandidates=[],this._mungeStereoHack=!1,this._offerOptions=n,this.addEventListener("closed",(()=>{this._streams=[],this._pendingCandidates=[],this._remoteController&&this._remoteController.close()}))}set mungeStereoHack(e){"boolean"==typeof e&&(this._mungeStereoHack=e)}get streams(){return this._streams}get remoteController(){return this._remoteController}connect(){if(!this._comChannel||this._state===ce.closed)return!1;if(this._state!==ce.idle)return!0;if(this._offerOptions)this.ensurePeerConnection(),this._rtcPeerConnection.createDataChannel("control"),this._rtcPeerConnection.createOffer(this._offerOptions).then((e=>{if(this._rtcPeerConnection&&e)return this._rtcPeerConnection.setLocalDescription(e);throw new Error("cannot send local offer to WebRTC peer")})).then((()=>{if(this._rtcPeerConnection&&this._comChannel){const e={type:"startSession",peerId:this._peerId,offer:this._rtcPeerConnection.localDescription.toJSON().sdp};if(!this._comChannel.send(e))throw new Error("cannot send startSession message to signaling server");this._state=ce.connecting,this.dispatchEvent(new Event("stateChanged"))}})).catch((e=>{this._state!==ce.closed&&(this.dispatchEvent(new ErrorEvent("error",{message:"an unrecoverable error occurred during SDP handshake",error:e})),this.close())}));else{const e={type:"startSession",peerId:this._peerId};if(!this._comChannel.send(e))return this.dispatchEvent(new ErrorEvent("error",{message:"cannot connect consumer session",error:new Error("cannot send startSession message to signaling server")})),this.close(),!1;this._state=ce.connecting,this.dispatchEvent(new Event("stateChanged"))}return!0}onSessionStarted(e,t){if(this._peerId===e&&this._state===ce.connecting&&!this._sessionId){console.log("Session started",this._sessionId),this._sessionId=t;for(const e of this._pendingCandidates)console.log("Sending delayed ICE with session id",this._sessionId),this._comChannel.send({type:"peer",sessionId:this._sessionId,ice:e.toJSON()});this._pendingCandidates=[]}}ensurePeerConnection(){if(!this._rtcPeerConnection){const e=new RTCPeerConnection(this._comChannel.webrtcConfig);this._rtcPeerConnection=e,e.ontrack=t=>{if(this._rtcPeerConnection===e&&t.streams&&t.streams.length>0){this._state===ce.connecting&&(this._state=ce.streaming,this.dispatchEvent(new Event("stateChanged")));let e=!1;for(const n of t.streams)this._streams.includes(n)||(this._streams.push(n),e=!0);e&&this.dispatchEvent(new Event("streamsChanged"))}},e.ondatachannel=e=>{const t=e.channel;if(t&&"control"===t.label){if(this._remoteController){const e=this._remoteController;this._remoteController=null,e.close()}const e=new be(t,this);this._remoteController=e,this.dispatchEvent(new Event("remoteControllerChanged")),e.addEventListener("closed",(()=>{this._remoteController===e&&(this._remoteController=null,this.dispatchEvent(new Event("remoteControllerChanged")))}))}},e.onicecandidate=t=>{this._rtcPeerConnection===e&&t.candidate&&this._comChannel&&(this._sessionId?(console.log("Sending ICE with session id",this._sessionId),this._comChannel.send({type:"peer",sessionId:this._sessionId,ice:t.candidate.toJSON()})):this._pendingCandidates.push(t.candidate))},this.dispatchEvent(new Event("rtcPeerConnectionChanged"))}}mungeStereo(e,t){const n=/a=fmtp:.* sprop-stereo/g;let r=new Set;for(const t of e.matchAll(n)){const e=t[0].match(/a=fmtp:(\d+) .*/);e&&r.add(e[1])}for(const e of r){const n=new RegExp("a=fmtp:"+e+".*stereo");t.match(n)||(t=t.replaceAll("a=fmtp:"+e,"a=fmtp:"+e+" stereo=1;"))}return t}onSessionPeerMessage(e){if(this._state!==ce.closed&&this._comChannel&&this._sessionId)if(this.ensurePeerConnection(),e.sdp)this._offerOptions?this._rtcPeerConnection.setRemoteDescription(e.sdp).then((()=>{console.log("done")})).catch((e=>{this._state!==ce.closed&&(this.dispatchEvent(new ErrorEvent("error",{message:"an unrecoverable error occurred during SDP handshake",error:e})),this.close())})):this._rtcPeerConnection.setRemoteDescription(e.sdp).then((()=>this._rtcPeerConnection?this._rtcPeerConnection.createAnswer():null)).then((t=>this._rtcPeerConnection&&t?(this._mungeStereoHack&&(t.sdp=this.mungeStereo(e.sdp.sdp,t.sdp)),this._rtcPeerConnection.setLocalDescription(t)):null)).then((()=>{if(this._rtcPeerConnection&&this._comChannel){console.log("Sending SDP with session id",this._sessionId);const e={type:"peer",sessionId:this._sessionId,sdp:this._rtcPeerConnection.localDescription.toJSON()};if(!this._comChannel.send(e))throw new Error("cannot send local SDP configuration to WebRTC peer")}})).catch((e=>{this._state!==ce.closed&&(this.dispatchEvent(new ErrorEvent("error",{message:"an unrecoverable error occurred during SDP handshake",error:e})),this.close())}));else{if(!e.ice)throw new Error(`invalid empty peer message received from consumer session ${this._sessionId}`);{const t=new RTCIceCandidate(e.ice);this._rtcPeerConnection.addIceCandidate(t).catch((e=>{this._state!==ce.closed&&(this.dispatchEvent(new ErrorEvent("error",{message:"an unrecoverable error occurred during ICE handshake",error:e})),this.close())}))}}}};class ke extends le{constructor(e,t,n,r){super(e,n),this._sessionId=t,this._state=ce.streaming;const i=new RTCPeerConnection(this._comChannel.webrtcConfig);this._rtcPeerConnection=i;for(const e of r.getTracks())i.addTrack(e,r);i.onicecandidate=e=>{this._rtcPeerConnection===i&&e.candidate&&this._comChannel&&this._comChannel.send({type:"peer",sessionId:this._sessionId,ice:e.candidate.toJSON()})},this.dispatchEvent(new Event("rtcPeerConnectionChanged")),i.setLocalDescription().then((()=>{if(this._rtcPeerConnection===i&&this._comChannel){const e={type:"peer",sessionId:this._sessionId,sdp:this._rtcPeerConnection.localDescription.toJSON()};if(!this._comChannel.send(e))throw new Error("cannot send local SDP configuration to WebRTC peer")}})).catch((e=>{this._state!==ce.closed&&(this.dispatchEvent(new ErrorEvent("error",{message:"an unrecoverable error occurred during SDP handshake",error:e})),this.close())}))}onSessionPeerMessage(e){if(this._state!==ce.closed&&this._rtcPeerConnection)if(e.sdp)this._rtcPeerConnection.setRemoteDescription(e.sdp).catch((e=>{this._state!==ce.closed&&(this.dispatchEvent(new ErrorEvent("error",{message:"an unrecoverable error occurred during SDP handshake",error:e})),this.close())}));else{if(!e.ice)throw new Error(`invalid empty peer message received from producer's client session ${this._peerId}`);{const t=new RTCIceCandidate(e.ice);this._rtcPeerConnection.addIceCandidate(t).catch((e=>{this._state!==ce.closed&&(this.dispatchEvent(new ErrorEvent("error",{message:"an unrecoverable error occurred during ICE handshake",error:e})),this.close())}))}}}}class Te extends EventTarget{constructor(e,t){super(),this._comChannel=e,this._stream=t,this._state=ce.idle,this._clientSessions={}}get stream(){return this._stream}get state(){return this._state}start(){if(!this._comChannel||this._state===ce.closed)return!1;if(this._state!==ce.idle)return!0;const e={type:"setPeerStatus",roles:["listener","producer"],meta:this._comChannel.meta};return this._comChannel.send(e)?(this._state=ce.connecting,this.dispatchEvent(new Event("stateChanged")),!0):(this.dispatchEvent(new ErrorEvent("error",{message:"cannot start producer session",error:new Error("cannot register producer to signaling server")})),this.close(),!1)}close(){if(this._state!==ce.closed){for(const e of this._stream.getTracks())e.stop();this._state!==ce.idle&&this._comChannel&&this._comChannel.send({type:"setPeerStatus",roles:["listener"],meta:this._comChannel.meta}),this._state=ce.closed,this.dispatchEvent(new Event("stateChanged")),this._comChannel=null,this._stream=null;for(const e of Object.values(this._clientSessions))e.close();this._clientSessions={},this.dispatchEvent(new Event("closed"))}}onProducerRegistered(){this._state===ce.connecting&&(this._state=ce.streaming,this.dispatchEvent(new Event("stateChanged")))}onStartSessionMessage(e){if(this._comChannel&&this._stream&&!(e.sessionId in this._clientSessions)){const t=new ke(e.peerId,e.sessionId,this._comChannel,this._stream);this._clientSessions[e.sessionId]=t,t.addEventListener("closed",(e=>{const n=e.target.sessionId;n in this._clientSessions&&this._clientSessions[n]===t&&(delete this._clientSessions[n],this.dispatchEvent(new CustomEvent("clientConsumerRemoved",{detail:t})))})),t.addEventListener("error",(e=>{this.dispatchEvent(new ErrorEvent("error",{message:`error from client consumer ${e.target.peerId}: ${e.message}`,error:e.error}))})),this.dispatchEvent(new CustomEvent("clientConsumerAdded",{detail:t}))}}onEndSessionMessage(e){e.sessionId in this._clientSessions&&this._clientSessions[e.sessionId].close()}onSessionPeerMessage(e){e.sessionId in this._clientSessions&&this._clientSessions[e.sessionId].onSessionPeerMessage(e)}}const Ee=Te,Pe=Object.freeze({welcome:"welcome",peerStatusChanged:"peerStatusChanged",list:"list",sessionStarted:"sessionStarted",peer:"peer",startSession:"startSession",endSession:"endSession",error:"error"});function Re(e,t){if(!e||"object"!=typeof e)return null;const n={id:"",meta:{}};if(e.id&&"string"==typeof e.id)n.id=e.id;else{if(!e.peerId||"string"!=typeof e.peerId)return null;n.id=e.peerId}return n.id===t?null:(e.meta&&"object"==typeof e.meta&&(n.meta=e.meta),Object.freeze(n.meta),Object.freeze(n))}class we extends EventTarget{constructor(e,t,n){super(),this._meta=t,this._webrtcConfig=n,this._ws=new WebSocket(e),this._ready=!1,this._channelId="",this._producerSession=null,this._consumerSessions={},this._ws.onerror=e=>{this.dispatchEvent(new ErrorEvent("error",{message:e.message||"WebSocket error",error:e.error||new Error(this._ready?"transportation error":"cannot connect to signaling server")})),this.close()},this._ws.onclose=()=>{this._ready=!1,this._channelId="",this._ws=null,this.closeAllConsumerSessions(),this._producerSession&&(this._producerSession.close(),this._producerSession=null),this.dispatchEvent(new Event("closed"))},this._ws.onmessage=e=>{try{const n=JSON.parse(e.data);if(n&&"object"==typeof n)switch(n.type){case Pe.welcome:this._channelId=n.peerId;try{this._ws.send(JSON.stringify({type:"setPeerStatus",roles:["listener"],meta:t}))}catch(e){this.dispatchEvent(new ErrorEvent("error",{message:"cannot initialize connection to signaling server",error:e})),this.close()}break;case Pe.peerStatusChanged:if(n.peerId===this._channelId)!this._ready&&n.roles.includes("listener")&&(this._ready=!0,this.dispatchEvent(new Event("ready")),this.send({type:"list"})),this._producerSession&&n.roles.includes("producer")&&this._producerSession.onProducerRegistered();else{const e=Re(n,this._channelId);e&&(n.roles.includes("producer")?this.dispatchEvent(new CustomEvent("producerAdded",{detail:e})):this.dispatchEvent(new CustomEvent("producerRemoved",{detail:e})))}break;case Pe.list:for(const e of n.producers){const t=Re(e,this._channelId);t&&this.dispatchEvent(new CustomEvent("producerAdded",{detail:t}))}break;case Pe.sessionStarted:{const e=this.getConsumerSession(n.peerId);e&&(delete this._consumerSessions[n.peerId],e.onSessionStarted(n.peerId,n.sessionId),e.sessionId&&!(e.sessionId in this._consumerSessions)?this._consumerSessions[e.sessionId]=e:e.close())}break;case Pe.peer:{const e=this.getConsumerSession(n.sessionId);e?e.onSessionPeerMessage(n):this._producerSession&&this._producerSession.onSessionPeerMessage(n)}break;case Pe.startSession:this._producerSession&&this._producerSession.onStartSessionMessage(n);break;case Pe.endSession:{const e=this.getConsumerSession(n.sessionId);e?e.close():this._producerSession&&this._producerSession.onEndSessionMessage(n)}break;case Pe.error:this.dispatchEvent(new ErrorEvent("error",{message:"error received from signaling server",error:new Error(n.details)}));break;default:throw new Error(`unknown message type: "${n.type}"`)}}catch(e){this.dispatchEvent(new ErrorEvent("error",{message:"cannot parse incoming message from signaling server",error:e}))}}}get meta(){return this._meta}get webrtcConfig(){return this._webrtcConfig}get ready(){return this._ready}get channelId(){return this._channelId}get producerSession(){return this._producerSession}createProducerSession(e){if(!(this._ready&&e instanceof MediaStream))return null;if(this._producerSession)return this._producerSession.stream===e?this._producerSession:null;const t=new Ee(this,e);return this._producerSession=t,t.addEventListener("closed",(()=>{this._producerSession===t&&(this._producerSession=null)})),t}createConsumerSession(e,t){if(!this._ready||!e||"string"!=typeof e)return null;if(t&&"object"!=typeof t&&(t=void 0),e in this._consumerSessions)return this._consumerSessions[e];for(const t of Object.values(this._consumerSessions))if(t.peerId===e)return t;const n=new Se(e,this,t);return this._consumerSessions[e]=n,n.addEventListener("closed",(e=>{let t=e.target.sessionId;t||(t=e.target.peerId),t in this._consumerSessions&&this._consumerSessions[t]===n&&delete this._consumerSessions[t]})),n}getConsumerSession(e){return e in this._consumerSessions?this._consumerSessions[e]:null}closeAllConsumerSessions(){for(const e of Object.values(this._consumerSessions))e.close();this._consumerSessions={}}send(e){if(this._ready&&e&&"object"==typeof e)try{return this._ws.send(JSON.stringify(e)),!0}catch(e){this.dispatchEvent(new ErrorEvent("error",{message:"cannot send message to signaling server",error:e}))}return!1}close(){this._ws&&(this._ready=!1,this._channelId="",this._ws.close(),this.closeAllConsumerSessions(),this._producerSession&&(this._producerSession.close(),this._producerSession=null))}}const Ae=we;class xe{constructor(e){this._channel=null,this._producers={},this._connectionListeners=[],this._producersListeners=[];const t=Object.assign({},se);e&&"object"==typeof e&&Object.assign(t,e),"object"!=typeof t.meta&&(t.meta=null),this._config=t,this.connectChannel()}registerConnectionListener(e){return!(!e||"object"!=typeof e||"function"!=typeof e.connected||"function"!=typeof e.disconnected)&&(this._connectionListeners.includes(e)||this._connectionListeners.push(e),!0)}unregisterConnectionListener(e){const t=this._connectionListeners.indexOf(e);return t>=0&&(this._connectionListeners.splice(t,1),!0)}unregisterAllConnectionListeners(){this._connectionListeners=[]}createProducerSession(e){return this._channel?this._channel.createProducerSession(e):null}getAvailableProducers(){return Object.values(this._producers)}registerProducersListener(e){return!(!e||"object"!=typeof e||"function"!=typeof e.producerAdded||"function"!=typeof e.producerRemoved)&&(this._producersListeners.includes(e)||this._producersListeners.push(e),!0)}unregisterProducersListener(e){const t=this._producersListeners.indexOf(e);return t>=0&&(this._producersListeners.splice(t,1),!0)}unregisterAllProducersListeners(){this._producersListeners=[]}createConsumerSession(e){return this._channel?this._channel.createConsumerSession(e):null}createConsumerSessionWithOfferOptions(e,t){return this._channel?this._channel.createConsumerSession(e,t):null}connectChannel(){if(this._channel){const e=this._channel;this._channel=null,e.close();for(const e in this._producers)this.triggerProducerRemoved(e);this._producers={},this.triggerDisconnected()}this._channel=new Ae(this._config.signalingServerUrl,this._config.meta,this._config.webrtcConfig),this._channel.addEventListener("error",(e=>{e.target===this._channel&&console.error(e.message,e.error)})),this._channel.addEventListener("closed",(e=>{if(e.target===this._channel){this._channel=null;for(const e in this._producers)this.triggerProducerRemoved(e);this._producers={},this.triggerDisconnected(),this._config.reconnectionTimeout>0&&window.setTimeout((()=>{this.connectChannel()}),this._config.reconnectionTimeout)}})),this._channel.addEventListener("ready",(e=>{e.target===this._channel&&this.triggerConnected(this._channel.channelId)})),this._channel.addEventListener("producerAdded",(e=>{e.target===this._channel&&this.triggerProducerAdded(e.detail)})),this._channel.addEventListener("producerRemoved",(e=>{e.target===this._channel&&this.triggerProducerRemoved(e.detail.id)}))}triggerConnected(e){for(const t of this._connectionListeners)try{t.connected(e)}catch(e){console.error("a listener callback should not throw any exception",e)}}triggerDisconnected(){for(const e of this._connectionListeners)try{e.disconnected()}catch(e){console.error("a listener callback should not throw any exception",e)}}triggerProducerAdded(e){if(!(e.id in this._producers)){this._producers[e.id]=e;for(const t of this._producersListeners)try{t.producerAdded(e)}catch(e){console.error("a listener callback should not throw any exception",e)}}}triggerProducerRemoved(e){if(e in this._producers){const t=this._producers[e];delete this._producers[e];for(const e of this._producersListeners)try{e.producerRemoved(t)}catch(e){console.error("a listener callback should not throw any exception",e)}}}}xe.SessionState=ce;const Ie=xe;window.GstWebRTCAPI||(window.GstWebRTCAPI=Ie)})()})();
//# sourceMappingURL=gstwebrtc-api-2.0.0.min.js.map