"""v1

Revision ID: 1051ea08f476
Revises: 
Create Date: 2025-08-11 20:42:07.214630

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '1051ea08f476'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('Log',
    sa.Column('date', sa.DateTime(), nullable=False),
    sa.Column('actionCode', sa.String(length=16), nullable=False),
    sa.Column('userId', sa.Integer(), nullable=False),
    sa.Column('userName', sa.String(length=64), nullable=False),
    sa.Column('tableName', sa.String(length=16), nullable=False),
    sa.Column('recordId', sa.Integer(), nullable=False),
    sa.Column('changes', sa.JSON(), nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_Log')),
    sa.UniqueConstraint('id', name=op.f('uq_Log_id')),
    mysql_charset='utf8mb4',
    mysql_collate='utf8mb4_unicode_ci'
    )
    op.create_table('Operation',
    sa.Column('id', sa.String(length=32), nullable=False),
    sa.Column('name', sa.String(length=32), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_Operation')),
    sa.UniqueConstraint('id', name=op.f('uq_Operation_id')),
    mysql_charset='utf8mb4',
    mysql_collate='utf8mb4_unicode_ci'
    )
    op.create_table('Role',
    sa.Column('name', sa.String(length=32), nullable=False),
    sa.Column('deleted', sa.Boolean(), server_default='0', nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_Role')),
    sa.UniqueConstraint('id', name=op.f('uq_Role_id')),
    mysql_charset='utf8mb4',
    mysql_collate='utf8mb4_unicode_ci'
    )
    op.create_table('User',
    sa.Column('login', sa.String(length=64), nullable=False),
    sa.Column('password', sa.String(length=128), nullable=False),
    sa.Column('name', sa.String(length=64), nullable=False),
    sa.Column('deleted', sa.Boolean(), server_default='0', nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_User')),
    sa.UniqueConstraint('id', name=op.f('uq_User_id')),
    mysql_charset='utf8mb4',
    mysql_collate='utf8mb4_unicode_ci'
    )
    with op.batch_alter_table('User', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_User_login'), ['login'], unique=True)

    op.create_table('Image',
    sa.Column('name', sa.String(length=128), nullable=False),
    sa.Column('type', sa.String(length=16), nullable=False),
    sa.Column('creationDate', sa.DateTime(), nullable=False),
    sa.Column('deletionDate', sa.DateTime(), nullable=True),
    sa.Column('createdById', sa.Integer(), nullable=False),
    sa.Column('deleted', sa.Boolean(), server_default='0', nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.ForeignKeyConstraint(['createdById'], ['User.id'], name=op.f('fk_Image_createdById_User')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_Image')),
    sa.UniqueConstraint('id', name=op.f('uq_Image_id')),
    mysql_charset='utf8mb4',
    mysql_collate='utf8mb4_unicode_ci'
    )
    op.create_table('Permission',
    sa.Column('roleId', sa.Integer(), nullable=False),
    sa.Column('operationId', sa.String(length=32), nullable=False),
    sa.ForeignKeyConstraint(['operationId'], ['Operation.id'], name=op.f('fk_Permission_operationId_Operation')),
    sa.ForeignKeyConstraint(['roleId'], ['Role.id'], name=op.f('fk_Permission_roleId_Role')),
    sa.PrimaryKeyConstraint('roleId', 'operationId', name=op.f('pk_Permission')),
    mysql_charset='utf8mb4',
    mysql_collate='utf8mb4_unicode_ci'
    )
    op.create_table('UserRole',
    sa.Column('userId', sa.Integer(), nullable=False),
    sa.Column('roleId', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['roleId'], ['Role.id'], name=op.f('fk_UserRole_roleId_Role')),
    sa.ForeignKeyConstraint(['userId'], ['User.id'], name=op.f('fk_UserRole_userId_User')),
    sa.PrimaryKeyConstraint('userId', 'roleId', name=op.f('pk_UserRole')),
    mysql_charset='utf8mb4',
    mysql_collate='utf8mb4_unicode_ci'
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('UserRole')
    op.drop_table('Permission')
    op.drop_table('Image')
    with op.batch_alter_table('User', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_User_login'))

    op.drop_table('User')
    op.drop_table('Role')
    op.drop_table('Operation')
    op.drop_table('Log')
    # ### end Alembic commands ###
