# SiEPIC-Tools

- SiEPIC-Tools - for silicon photonics layout, design, verification and circuit simulation
- Developed within the <a href="http://www.siepic.ubc.ca">SiEPIC</a> program, by <a href="https://ca.linkedin.com/in/chrostowski">Lukas Chrostowski</a>, with contributions from many others.
- This is a package implemented using Python using <a href="http://www.klayout.de">KLayout</a> in the graphical interface, as well as stand-alone Python using PyPI and "import SiEPIC".
- Instruction on design, layout, fabrication, test, data analysis for silicon photonics provided in the edX course: <a href="http://edx.org/course/silicon-photonics-design-fabrication-ubcx-phot1x">Silicon Photonics Design, Fabrication and Data Analysis</a> and textbook <a href="http://www.cambridge.org/ca/academic/subjects/engineering/electronic-optoelectronic-devices-and-nanotechnology/silicon-photonics-design-devices-systems">Silicon Photonics Design: From Devices to Systems</a> by Lukas Chrostowski and Michael Hochberg.
- Process Design Kits that use KLayout SiEPIC-Tools are available for multiple foundries including 
<a href="https://www.cmc.ca/amf-silicon-photonics-general-purpose/">AMF</a>, 
<a href="https://www.aimphotonics.com/">AIM Photonics</a>, 
<a href="https://www.towersemi.com/">Tower Semiconductor</a>, 
<a href="https://www.ligentec.com//">Ligentec</a>, 
<a href="https://www.appliednt.com/nanosoi-fabrication-service">Applied Nanotools Inc.</a>, and 
<a href="https://www.siepic.ca/fabrication">SiEPICfab</a>.
- Citing this work:  
  - Lukas Chrostowski, Zeqin Lu, Jonas Flueckiger, Xu Wang, Jackson Klein, Amy Liu, Jaspreet Jhoja, James Pond,
"<a href=https://doi.org/10.1117/12.2230376>Design and simulation of silicon photonic schematics and layouts</a>," Proc. SPIE 9891, Silicon Photonics and Photonic Integrated Circuits V, 989114 (May 13, 2016); doi:10.1117/12.2230376.
  - Lukas Chrostowski, Hossam Shoman, Mustafa Hammood, Han Yun,  Jaspreet Jhoja, Enxiao Luan,  Stephen Lin, Ajay Mistry, Donald Witt, Nicolas A. F. Jaeger, Sudip Shekhar,  Hasitha Jayatilleka, Philippe Jean, Simon B.-de Villers, Jonathan Cauchon, Wei Shi,  Cameron Horvath, Jocelyn N. Westwood-Bachman, Kevin Setzer, Mirwais Aktary, N. Shane Patrick, Richard Bojko, Amin Khavasi, Xu Wang, Thomas Ferreira de Lima,  Alexander N. Tait, Paul R. Prucnal, David E. Hagan, Doris Stevanovic, Andy P. Knights, "<a href="https://doi.org/10.1109/JSTQE.2019.2917501">Silicon Photonic Circuit Design Using Rapid Prototyping Foundry Process Design Kits</a>" IEEE Journal of Selected Topics in Quantum Electronics, Volume: 25, Issue: 5, Sept.-Oct. 2019. (<a href="https://www.dropbox.com/s/i1z4ackr3q7fz1l/2019_JSTQE_foundry.pdf?dl=1">PDF</a>)

