# Generated by Django 3.2.25 on 2024-12-13 22:28

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('saas', '0020_v0_20_0'),
    ]

    operations = [
        migrations.AddField(
            model_name='charge',
            name='claim_code',
            field=models.SlugField(help_text='Unique code used to retrieve the invoice / charge', null=True),
        ),
        migrations.AlterField(
            model_name='charge',
            name='processor',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='charges', to=settings.SAAS_ORGANIZATION_MODEL),
        ),
        migrations.AlterField(
            model_name='charge',
            name='processor_key',
            field=models.SlugField(help_text='Unique identifier returned by the payment processor', max_length=255, null=True, unique=True),
        ),
        migrations.CreateModel(
            name='SubscriptionUse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('expiring_quota', models.PositiveIntegerField(default=0, help_text='Number of use events that expire at the end of the current period')),
                ('rollover_quota', models.PositiveIntegerField(default=0, help_text='Number of use events that rollover to the next period')),
                ('used_quantity', models.PositiveIntegerField(default=0, help_text='Number of use events generated over the life of the subscription')),
                ('extra', models.TextField(help_text='Extra meta data (can be stringify JSON)', null=True)),
                ('subscription', models.ForeignKey(help_text='Subscription usage is added to', on_delete=django.db.models.deletion.CASCADE, related_name='uses', to='saas.subscription')),
                ('use', models.ForeignKey(help_text='UseCharge refered to', on_delete=django.db.models.deletion.CASCADE, to='saas.usecharge')),
            ],
        ),
    ]
