"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.application_service import ApplicationService
from agilicus_api.model.application_service_common_stats import ApplicationServiceCommonStats
from agilicus_api.model.database_resource import DatabaseResource
from agilicus_api.model.desktop_client_configuration import DesktopClientConfiguration
from agilicus_api.model.desktop_resource import DesktopResource
from agilicus_api.model.desktop_server_configuration import DesktopServerConfiguration
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.file_share_service import FileShareService
from agilicus_api.model.list_application_services_response import ListApplicationServicesResponse
from agilicus_api.model.list_database_resources_response import ListDatabaseResourcesResponse
from agilicus_api.model.list_desktop_resources_response import ListDesktopResourcesResponse
from agilicus_api.model.list_file_share_services_response import ListFileShareServicesResponse
from agilicus_api.model.list_ssh_resources_response import ListSSHResourcesResponse
from agilicus_api.model.list_service_forwarders_response import ListServiceForwardersResponse
from agilicus_api.model.raw_token import RawToken
from agilicus_api.model.ssh_resource import SSHResource
from agilicus_api.model.service_forwarder import ServiceForwarder
from agilicus_api.model.usage_metric import UsageMetric


class ApplicationServicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_application_service(
            self,
            application_service,
            **kwargs
        ):
            """Create an ApplicationService  # noqa: E501

            It is expected that owners for an organisation will provide connectivity to an ApplicationService by defining one here, then adding a reference to an Application's Environment in the ApplicationService's `assignments` list. To see the list of ApplicationServices for which a given Application Environment has access, see that Environment's read only `applications_services` list.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_application_service(application_service, async_req=True)
            >>> result = thread.get()

            Args:
                application_service (ApplicationService):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application_service'] = \
                application_service
            return self.call_with_http_info(**kwargs)

        if self.create_application_service is None:
            self.create_application_service = _Endpoint(
                settings={
                    'response_type': (ApplicationService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services',
                    'operation_id': 'create_application_service',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'application_service',
                    ],
                    'required': [
                        'application_service',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'application_service':
                            (ApplicationService,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'application_service': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_application_service
            )

        def __create_application_service_token(
            self,
            app_service_id,
            org_id,
            **kwargs
        ):
            """create a token for an application service  # noqa: E501

            Create a token for an application service  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_application_service_token(app_service_id, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_service_id (str): Application Service unique identifier
                org_id (str): Organisation unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RawToken
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_service_id'] = \
                app_service_id
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.create_application_service_token is None:
            self.create_application_service_token = _Endpoint(
                settings={
                    'response_type': (RawToken,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services/{app_service_id}/token',
                    'operation_id': 'create_application_service_token',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_service_id',
                        'org_id',
                    ],
                    'required': [
                        'app_service_id',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_service_id',
                        'org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_service_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_service_id': 'app_service_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_service_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__create_application_service_token
            )

        def __create_client_configuration(
            self,
            resource_id,
            **kwargs
        ):
            """Create a client configuration  # noqa: E501

            Create a client configuration file. This file may be downloaded and used by the appropriate client to connect to the DesktopResource. If you provide the id of user who wants to connect, the file will contain credentials which may be used to prove their authorization to access the DesktopResource. The DesktopClientConfiguration is not stored in the system. Subsequent calls to create a new DesktopClientConfiguration will lead to a new one being generated.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_client_configuration(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                desktop_client_configuration (DesktopClientConfiguration): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DesktopClientConfiguration
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.create_client_configuration is None:
            self.create_client_configuration = _Endpoint(
                settings={
                    'response_type': (DesktopClientConfiguration,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/desktop_resources/{resource_id}/client_configurations',
                    'operation_id': 'create_client_configuration',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'desktop_client_configuration',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'desktop_client_configuration':
                            (DesktopClientConfiguration,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'desktop_client_configuration': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_client_configuration
            )

        def __create_database_resource(
            self,
            database_resource,
            **kwargs
        ):
            """Create a DatabaseResource  # noqa: E501

            Administrators can allow remote connectivity to a database using a DatabaseResource. Make sure to expose the DatabaseResource through a connector by setting the `connector_id`. You can create multiple DatabaseResource objects for a given database, with different settings.  The name of the DatabaseResource uniquely identifies it.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_database_resource(database_resource, async_req=True)
            >>> result = thread.get()

            Args:
                database_resource (DatabaseResource):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DatabaseResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['database_resource'] = \
                database_resource
            return self.call_with_http_info(**kwargs)

        if self.create_database_resource is None:
            self.create_database_resource = _Endpoint(
                settings={
                    'response_type': (DatabaseResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/database_resources',
                    'operation_id': 'create_database_resource',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'database_resource',
                    ],
                    'required': [
                        'database_resource',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'database_resource':
                            (DatabaseResource,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'database_resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_database_resource
            )

        def __create_desktop_resource(
            self,
            desktop_resource,
            **kwargs
        ):
            """Create a DesktopResource  # noqa: E501

            Administrators for an organisation can allow remote connectivity to a desktop by creating a DesktopResource using this endpoint. Make sure to expose the DesktopResource through a connector by setting the `connector_id`. You can create multiple DesktopResource objects. for a given desktop. The name of the DesktopResource uniquely identifies it.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_desktop_resource(desktop_resource, async_req=True)
            >>> result = thread.get()

            Args:
                desktop_resource (DesktopResource):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DesktopResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['desktop_resource'] = \
                desktop_resource
            return self.call_with_http_info(**kwargs)

        if self.create_desktop_resource is None:
            self.create_desktop_resource = _Endpoint(
                settings={
                    'response_type': (DesktopResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/desktop_resources',
                    'operation_id': 'create_desktop_resource',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'desktop_resource',
                    ],
                    'required': [
                        'desktop_resource',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'desktop_resource':
                            (DesktopResource,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'desktop_resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_desktop_resource
            )

        def __create_file_share_service(
            self,
            file_share_service,
            **kwargs
        ):
            """Create an FileShareService  # noqa: E501

            It is expected that owners for an organisation will provide connectivity to an FileShareService by defining one here, then adding a reference to an Application's Environment in the FileShareService's `assignments` list. To see the list of FileShareServices for which a given Application Environment has access, see that Environment's read only `applications_services` list.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_file_share_service(file_share_service, async_req=True)
            >>> result = thread.get()

            Args:
                file_share_service (FileShareService):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileShareService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_share_service'] = \
                file_share_service
            return self.call_with_http_info(**kwargs)

        if self.create_file_share_service is None:
            self.create_file_share_service = _Endpoint(
                settings={
                    'response_type': (FileShareService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_share_services',
                    'operation_id': 'create_file_share_service',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_share_service',
                    ],
                    'required': [
                        'file_share_service',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_share_service':
                            (FileShareService,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'file_share_service': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_file_share_service
            )

        def __create_server_configuration(
            self,
            resource_id,
            **kwargs
        ):
            """Create a server configuration  # noqa: E501

            Create a server configuration file. This file may be downloaded and used by the appropriate server to configures itself to expose the DesktopResource. The file is returned immediately in the response. It is not persisted.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_server_configuration(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                desktop_server_configuration (DesktopServerConfiguration): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DesktopServerConfiguration
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.create_server_configuration is None:
            self.create_server_configuration = _Endpoint(
                settings={
                    'response_type': (DesktopServerConfiguration,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/desktop_resources/{resource_id}/server_configurations',
                    'operation_id': 'create_server_configuration',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'desktop_server_configuration',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'desktop_server_configuration':
                            (DesktopServerConfiguration,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'desktop_server_configuration': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_server_configuration
            )

        def __create_service_forwarder(
            self,
            service_forwarder,
            **kwargs
        ):
            """Create an ServiceForwarder  # noqa: E501

            Create an ServiceForwarder  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_service_forwarder(service_forwarder, async_req=True)
            >>> result = thread.get()

            Args:
                service_forwarder (ServiceForwarder):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ServiceForwarder
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_forwarder'] = \
                service_forwarder
            return self.call_with_http_info(**kwargs)

        if self.create_service_forwarder is None:
            self.create_service_forwarder = _Endpoint(
                settings={
                    'response_type': (ServiceForwarder,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_forwarders',
                    'operation_id': 'create_service_forwarder',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_forwarder',
                    ],
                    'required': [
                        'service_forwarder',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_forwarder':
                            (ServiceForwarder,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'service_forwarder': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_service_forwarder
            )

        def __create_ssh_resource(
            self,
            ssh_resource,
            **kwargs
        ):
            """Create a SSHResource  # noqa: E501

            Administrators can allow remote connectivity to a machine via the SSH protocol by creating a SSHResource using this endpoint. Make sure to expose the SSHResource through a connector by setting the `connector_id`. You can create multiple SSHResource objects. for a given machine. The name of the SSHResource uniquely identifies it.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_ssh_resource(ssh_resource, async_req=True)
            >>> result = thread.get()

            Args:
                ssh_resource (SSHResource):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SSHResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['ssh_resource'] = \
                ssh_resource
            return self.call_with_http_info(**kwargs)

        if self.create_ssh_resource is None:
            self.create_ssh_resource = _Endpoint(
                settings={
                    'response_type': (SSHResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ssh_resources',
                    'operation_id': 'create_ssh_resource',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'ssh_resource',
                    ],
                    'required': [
                        'ssh_resource',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'ssh_resource':
                            (SSHResource,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'ssh_resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_ssh_resource
            )

        def __delete_application_service(
            self,
            app_service_id,
            org_id,
            **kwargs
        ):
            """Remove an ApplicationService  # noqa: E501

            Remove an ApplicationService  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_application_service(app_service_id, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_service_id (str): Application Service unique identifier
                org_id (str): Organisation unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_service_id'] = \
                app_service_id
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.delete_application_service is None:
            self.delete_application_service = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services/{app_service_id}',
                    'operation_id': 'delete_application_service',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_service_id',
                        'org_id',
                    ],
                    'required': [
                        'app_service_id',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_service_id',
                        'org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_service_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_service_id': 'app_service_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_service_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_application_service
            )

        def __delete_database_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Remove a DatabaseResource  # noqa: E501

            Remove a DatabaseResource. After removal, users will no longer be able to access the DatabaseResource. Existing connections to the DatabaseResource may persist for some time afterwards.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_database_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.delete_database_resource is None:
            self.delete_database_resource = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/database_resources/{resource_id}',
                    'operation_id': 'delete_database_resource',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_database_resource
            )

        def __delete_desktop_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Remove a DesktopResource  # noqa: E501

            Remove a DesktopResource. After removal, users will no longer be able to access the DesktopResource. Existing connections to the DesktopResource may persist for some time afterwards.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_desktop_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.delete_desktop_resource is None:
            self.delete_desktop_resource = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/desktop_resources/{resource_id}',
                    'operation_id': 'delete_desktop_resource',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_desktop_resource
            )

        def __delete_file_share_service(
            self,
            file_share_service_id,
            **kwargs
        ):
            """Remove an FileShareService  # noqa: E501

            Remove an FileShareService  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_file_share_service(file_share_service_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_share_service_id (str): FileShareService unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_share_service_id'] = \
                file_share_service_id
            return self.call_with_http_info(**kwargs)

        if self.delete_file_share_service is None:
            self.delete_file_share_service = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_share_services/{file_share_service_id}',
                    'operation_id': 'delete_file_share_service',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_share_service_id',
                        'org_id',
                    ],
                    'required': [
                        'file_share_service_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'file_share_service_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('file_share_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_share_service_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_share_service_id': 'file_share_service_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_share_service_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_file_share_service
            )

        def __delete_service_forwarder(
            self,
            service_forwarder_id,
            **kwargs
        ):
            """Remove an ServiceForwarder  # noqa: E501

            Remove an ServiceForwarder  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_service_forwarder(service_forwarder_id, async_req=True)
            >>> result = thread.get()

            Args:
                service_forwarder_id (str): Service Forwarder unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_forwarder_id'] = \
                service_forwarder_id
            return self.call_with_http_info(**kwargs)

        if self.delete_service_forwarder is None:
            self.delete_service_forwarder = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_forwarders/{service_forwarder_id}',
                    'operation_id': 'delete_service_forwarder',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_forwarder_id',
                        'org_id',
                    ],
                    'required': [
                        'service_forwarder_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'service_forwarder_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('service_forwarder_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_forwarder_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'service_forwarder_id': 'service_forwarder_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'service_forwarder_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_service_forwarder
            )

        def __delete_ssh_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Remove a SSHResource  # noqa: E501

            Remove a SSHResource. After removal, users will no longer be able to access the SSHResource. Existing connections to the SSHResource may persist for some time afterwards.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_ssh_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.delete_ssh_resource is None:
            self.delete_ssh_resource = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ssh_resources/{resource_id}',
                    'operation_id': 'delete_ssh_resource',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_ssh_resource
            )

        def __get_application_service(
            self,
            app_service_id,
            org_id,
            **kwargs
        ):
            """Get a single ApplicationService  # noqa: E501

            Get a single ApplicationService  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_application_service(app_service_id, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_service_id (str): Application Service unique identifier
                org_id (str): Organisation unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_service_id'] = \
                app_service_id
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_application_service is None:
            self.get_application_service = _Endpoint(
                settings={
                    'response_type': (ApplicationService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services/{app_service_id}',
                    'operation_id': 'get_application_service',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_service_id',
                        'org_id',
                    ],
                    'required': [
                        'app_service_id',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_service_id',
                        'org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_service_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_service_id': 'app_service_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_service_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_application_service
            )

        def __get_application_service_stats(
            self,
            app_service_id,
            org_id,
            **kwargs
        ):
            """Get ApplicationServiceStats  # noqa: E501

            Gets the most recent stats published for an ApplicationService, aggregated across connector intsances.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_application_service_stats(app_service_id, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_service_id (str): Application Service unique identifier
                org_id (str): Organisation unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationServiceCommonStats
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_service_id'] = \
                app_service_id
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_application_service_stats is None:
            self.get_application_service_stats = _Endpoint(
                settings={
                    'response_type': (ApplicationServiceCommonStats,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services/{app_service_id}/stats',
                    'operation_id': 'get_application_service_stats',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_service_id',
                        'org_id',
                    ],
                    'required': [
                        'app_service_id',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_service_id',
                        'org_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('org_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_service_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'app_service_id': 'app_service_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'app_service_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_application_service_stats
            )

        def __get_application_service_usage_metrics(
            self,
            org_id,
            **kwargs
        ):
            """Get application service metrics  # noqa: E501

            Retrieves all application service metrics related to the org_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_application_service_usage_metrics(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UsageMetric
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_application_service_usage_metrics is None:
            self.get_application_service_usage_metrics = _Endpoint(
                settings={
                    'response_type': (UsageMetric,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services/usage_metrics',
                    'operation_id': 'get_application_service_usage_metrics',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_application_service_usage_metrics
            )

        def __get_database_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Get a single DatabaseResource  # noqa: E501

            Get the details of a single DatabaseResource. Specify the id of the organisation which owns this resource to ensure you have permission.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_database_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DatabaseResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.get_database_resource is None:
            self.get_database_resource = _Endpoint(
                settings={
                    'response_type': (DatabaseResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/database_resources/{resource_id}',
                    'operation_id': 'get_database_resource',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_database_resource
            )

        def __get_desktop_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Get a single DesktopResource  # noqa: E501

            Get the details of a single DesktopResource. Specify the id of the organisation which owns this resource to ensure you have permission.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_desktop_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DesktopResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.get_desktop_resource is None:
            self.get_desktop_resource = _Endpoint(
                settings={
                    'response_type': (DesktopResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/desktop_resources/{resource_id}',
                    'operation_id': 'get_desktop_resource',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_desktop_resource
            )

        def __get_file_share_service(
            self,
            file_share_service_id,
            **kwargs
        ):
            """Get a single FileShareService  # noqa: E501

            Get a single FileShareService  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_file_share_service(file_share_service_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_share_service_id (str): FileShareService unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileShareService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_share_service_id'] = \
                file_share_service_id
            return self.call_with_http_info(**kwargs)

        if self.get_file_share_service is None:
            self.get_file_share_service = _Endpoint(
                settings={
                    'response_type': (FileShareService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_share_services/{file_share_service_id}',
                    'operation_id': 'get_file_share_service',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_share_service_id',
                        'org_id',
                    ],
                    'required': [
                        'file_share_service_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'file_share_service_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('file_share_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_share_service_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'file_share_service_id': 'file_share_service_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'file_share_service_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_file_share_service
            )

        def __get_file_share_usage_metrics(
            self,
            org_id,
            **kwargs
        ):
            """Get file share service metrics  # noqa: E501

            Retrieves all file share service metrics related to the org_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_file_share_usage_metrics(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UsageMetric
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_file_share_usage_metrics is None:
            self.get_file_share_usage_metrics = _Endpoint(
                settings={
                    'response_type': (UsageMetric,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_share_services/usage_metrics',
                    'operation_id': 'get_file_share_usage_metrics',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_file_share_usage_metrics
            )

        def __get_service_forwarder(
            self,
            service_forwarder_id,
            **kwargs
        ):
            """Get a single ServiceForwarder  # noqa: E501

            Get a single ServiceForwarder  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_service_forwarder(service_forwarder_id, async_req=True)
            >>> result = thread.get()

            Args:
                service_forwarder_id (str): Service Forwarder unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ServiceForwarder
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_forwarder_id'] = \
                service_forwarder_id
            return self.call_with_http_info(**kwargs)

        if self.get_service_forwarder is None:
            self.get_service_forwarder = _Endpoint(
                settings={
                    'response_type': (ServiceForwarder,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_forwarders/{service_forwarder_id}',
                    'operation_id': 'get_service_forwarder',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_forwarder_id',
                        'org_id',
                    ],
                    'required': [
                        'service_forwarder_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'service_forwarder_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('service_forwarder_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_forwarder_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'service_forwarder_id': 'service_forwarder_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'service_forwarder_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_service_forwarder
            )

        def __get_ssh_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Get a single SSHResource  # noqa: E501

            Get the details of a single SSHResource. Specify the id of the organisation which owns this resource to ensure you have permission.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ssh_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SSHResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.get_ssh_resource is None:
            self.get_ssh_resource = _Endpoint(
                settings={
                    'response_type': (SSHResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ssh_resources/{resource_id}',
                    'operation_id': 'get_ssh_resource',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_ssh_resource
            )

        def __list_application_services(
            self,
            **kwargs
        ):
            """Get a subset of the ApplicationServices  # noqa: E501

            Retrieves all ApplicationServices owned by the Organisation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_application_services(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                updated_since (datetime): query since updated. [optional]
                protocol_type (str): ApplicationService protocol type. [optional]
                protocol_type_list ([str]): list of application service protocol types to query for. [optional]
                name (str): Query the service by name. [optional]
                hostname (str): hostname query lookup. [optional]
                hostname_or_service_name (str): Perform a query based on the following       (hostname == hostname_or_service_name)            OR       (servicename == hostname_or_service_name AND hostname == localhost) . [optional]
                port (int): ApplicationService port query lookup. [optional]
                show_status (bool): Whether the return value should include the status for included objects. If false the query may run faster but will not include status information. . [optional] if omitted the server will use the default value of False
                external_hostname_or_service (str): Find a service(s) that are exposed publicly with the provided name or as a service name.  This query can be used for external clients to determine if a host is configured to be proxied by Agilicus. . [optional]
                show_connector_services (bool): include application services that are also connector services . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListApplicationServicesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_application_services is None:
            self.list_application_services = _Endpoint(
                settings={
                    'response_type': (ListApplicationServicesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services',
                    'operation_id': 'list_application_services',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'updated_since',
                        'protocol_type',
                        'protocol_type_list',
                        'name',
                        'hostname',
                        'hostname_or_service_name',
                        'port',
                        'show_status',
                        'external_hostname_or_service',
                        'show_connector_services',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'protocol_type',
                        'protocol_type_list',
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                        ('protocol_type',): {

                            "IP": "ip",
                            "FILESHARE": "fileshare",
                            "DESKTOP": "desktop",
                            "SSH": "ssh",
                            "DATABASE": "database"
                        },
                        ('protocol_type_list',): {

                            "IP": "ip",
                            "FILESHARE": "fileshare",
                            "DESKTOP": "desktop",
                            "SSH": "ssh",
                            "DATABASE": "database"
                        },
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'updated_since':
                            (datetime,),
                        'protocol_type':
                            (str,),
                        'protocol_type_list':
                            ([str],),
                        'name':
                            (str,),
                        'hostname':
                            (str,),
                        'hostname_or_service_name':
                            (str,),
                        'port':
                            (int,),
                        'show_status':
                            (bool,),
                        'external_hostname_or_service':
                            (str,),
                        'show_connector_services':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'updated_since': 'updated_since',
                        'protocol_type': 'protocol_type',
                        'protocol_type_list': 'protocol_type_list',
                        'name': 'name',
                        'hostname': 'hostname',
                        'hostname_or_service_name': 'hostname_or_service_name',
                        'port': 'port',
                        'show_status': 'show_status',
                        'external_hostname_or_service': 'external_hostname_or_service',
                        'show_connector_services': 'show_connector_services',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'updated_since': 'query',
                        'protocol_type': 'query',
                        'protocol_type_list': 'query',
                        'name': 'query',
                        'hostname': 'query',
                        'hostname_or_service_name': 'query',
                        'port': 'query',
                        'show_status': 'query',
                        'external_hostname_or_service': 'query',
                        'show_connector_services': 'query',
                    },
                    'collection_format_map': {
                        'protocol_type_list': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_application_services
            )

        def __list_database_resources(
            self,
            **kwargs
        ):
            """Get a subset of the DatabaseResource objects.  # noqa: E501

            Retrieves DatabaseResource objects owned by the Organisation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_database_resources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                name (str): The name of the resource to query for. [optional]
                connector_id (str): connector id in query. [optional]
                updated_since (datetime): query since updated. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                name_slug (str): The slug of the resource to query for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListDatabaseResourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_database_resources is None:
            self.list_database_resources = _Endpoint(
                settings={
                    'response_type': (ListDatabaseResourcesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/database_resources',
                    'operation_id': 'list_database_resources',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'name',
                        'connector_id',
                        'updated_since',
                        'limit',
                        'org_ids',
                        'resource_id',
                        'page_at_id',
                        'name_slug',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'name',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('name',): {
                            'max_length': 100,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-_.:]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'connector_id':
                            (str,),
                        'updated_since':
                            (datetime,),
                        'limit':
                            (int,),
                        'org_ids':
                            ([str],),
                        'resource_id':
                            (str,),
                        'page_at_id':
                            (str,),
                        'name_slug':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'name': 'name',
                        'connector_id': 'connector_id',
                        'updated_since': 'updated_since',
                        'limit': 'limit',
                        'org_ids': 'org_ids',
                        'resource_id': 'resource_id',
                        'page_at_id': 'page_at_id',
                        'name_slug': 'name_slug',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'name': 'query',
                        'connector_id': 'query',
                        'updated_since': 'query',
                        'limit': 'query',
                        'org_ids': 'query',
                        'resource_id': 'query',
                        'page_at_id': 'query',
                        'name_slug': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_database_resources
            )

        def __list_desktop_resources(
            self,
            **kwargs
        ):
            """Get a subset of the DesktopResource objects.  # noqa: E501

            Retrieves DesktopResource objects owned by the Organisation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_desktop_resources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                name (str): The name of the resource to query for. [optional]
                connector_id (str): connector id in query. [optional]
                updated_since (datetime): query since updated. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                name_slug (str): The slug of the resource to query for. [optional]
                desktop_type (str): The type of desktop search for.. [optional]
                has_remote_app (bool): Only return desktops with configured remote apps. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListDesktopResourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_desktop_resources is None:
            self.list_desktop_resources = _Endpoint(
                settings={
                    'response_type': (ListDesktopResourcesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/desktop_resources',
                    'operation_id': 'list_desktop_resources',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'name',
                        'connector_id',
                        'updated_since',
                        'limit',
                        'org_ids',
                        'resource_id',
                        'page_at_id',
                        'name_slug',
                        'desktop_type',
                        'has_remote_app',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'desktop_type',
                    ],
                    'validation': [
                        'name',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('name',): {
                            'max_length': 100,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-_.:]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('desktop_type',): {

                            "RDP": "rdp",
                            "VNC": "vnc"
                        },
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'connector_id':
                            (str,),
                        'updated_since':
                            (datetime,),
                        'limit':
                            (int,),
                        'org_ids':
                            ([str],),
                        'resource_id':
                            (str,),
                        'page_at_id':
                            (str,),
                        'name_slug':
                            (str,),
                        'desktop_type':
                            (str,),
                        'has_remote_app':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'name': 'name',
                        'connector_id': 'connector_id',
                        'updated_since': 'updated_since',
                        'limit': 'limit',
                        'org_ids': 'org_ids',
                        'resource_id': 'resource_id',
                        'page_at_id': 'page_at_id',
                        'name_slug': 'name_slug',
                        'desktop_type': 'desktop_type',
                        'has_remote_app': 'has_remote_app',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'name': 'query',
                        'connector_id': 'query',
                        'updated_since': 'query',
                        'limit': 'query',
                        'org_ids': 'query',
                        'resource_id': 'query',
                        'page_at_id': 'query',
                        'name_slug': 'query',
                        'desktop_type': 'query',
                        'has_remote_app': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_desktop_resources
            )

        def __list_file_share_services(
            self,
            **kwargs
        ):
            """Get a subset of the FileShareServices  # noqa: E501

            Retrieves all FileShareServices owned by the Organisation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_file_share_services(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                name (str): Query the service by name. [optional]
                connector_id (str): connector id in query. [optional]
                updated_since (datetime): query since updated. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListFileShareServicesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_file_share_services is None:
            self.list_file_share_services = _Endpoint(
                settings={
                    'response_type': (ListFileShareServicesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_share_services',
                    'operation_id': 'list_file_share_services',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'name',
                        'connector_id',
                        'updated_since',
                        'limit',
                        'org_ids',
                        'resource_id',
                        'page_at_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'connector_id':
                            (str,),
                        'updated_since':
                            (datetime,),
                        'limit':
                            (int,),
                        'org_ids':
                            ([str],),
                        'resource_id':
                            (str,),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'name': 'name',
                        'connector_id': 'connector_id',
                        'updated_since': 'updated_since',
                        'limit': 'limit',
                        'org_ids': 'org_ids',
                        'resource_id': 'resource_id',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'name': 'query',
                        'connector_id': 'query',
                        'updated_since': 'query',
                        'limit': 'query',
                        'org_ids': 'query',
                        'resource_id': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_file_share_services
            )

        def __list_service_forwarders(
            self,
            **kwargs
        ):
            """Get a subset of the ServiceForwarder objects  # noqa: E501

            Retrieves all ServiceForwarder objects owned by the Organisation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_service_forwarders(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                name (str): Query the service by name. [optional]
                app_service_id (str): Application Service unique identifier. [optional]
                connector_id (str): connector id in query. [optional]
                app_service_connector_id (str): application service connector id in query. [optional]
                updated_since (datetime): query since updated. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListServiceForwardersResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_service_forwarders is None:
            self.list_service_forwarders = _Endpoint(
                settings={
                    'response_type': (ListServiceForwardersResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_forwarders',
                    'operation_id': 'list_service_forwarders',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'name',
                        'app_service_id',
                        'connector_id',
                        'app_service_connector_id',
                        'updated_since',
                        'limit',
                        'org_ids',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_service_id',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'app_service_id':
                            (str,),
                        'connector_id':
                            (str,),
                        'app_service_connector_id':
                            (str,),
                        'updated_since':
                            (datetime,),
                        'limit':
                            (int,),
                        'org_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'name': 'name',
                        'app_service_id': 'app_service_id',
                        'connector_id': 'connector_id',
                        'app_service_connector_id': 'app_service_connector_id',
                        'updated_since': 'updated_since',
                        'limit': 'limit',
                        'org_ids': 'org_ids',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'name': 'query',
                        'app_service_id': 'query',
                        'connector_id': 'query',
                        'app_service_connector_id': 'query',
                        'updated_since': 'query',
                        'limit': 'query',
                        'org_ids': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_service_forwarders
            )

        def __list_ssh_resources(
            self,
            **kwargs
        ):
            """Get a subset of the SSHResource objects.  # noqa: E501

            Retrieves SSHResource objects owned by the Organisation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ssh_resources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                name (str): The name of the resource to query for. [optional]
                connector_id (str): connector id in query. [optional]
                updated_since (datetime): query since updated. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                name_slug (str): The slug of the resource to query for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListSSHResourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_ssh_resources is None:
            self.list_ssh_resources = _Endpoint(
                settings={
                    'response_type': (ListSSHResourcesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ssh_resources',
                    'operation_id': 'list_ssh_resources',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'name',
                        'connector_id',
                        'updated_since',
                        'limit',
                        'org_ids',
                        'resource_id',
                        'page_at_id',
                        'name_slug',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'name',
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('name',): {
                            'max_length': 100,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-_.:]+$',  # noqa: E501
                            },
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'name':
                            (str,),
                        'connector_id':
                            (str,),
                        'updated_since':
                            (datetime,),
                        'limit':
                            (int,),
                        'org_ids':
                            ([str],),
                        'resource_id':
                            (str,),
                        'page_at_id':
                            (str,),
                        'name_slug':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'name': 'name',
                        'connector_id': 'connector_id',
                        'updated_since': 'updated_since',
                        'limit': 'limit',
                        'org_ids': 'org_ids',
                        'resource_id': 'resource_id',
                        'page_at_id': 'page_at_id',
                        'name_slug': 'name_slug',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'name': 'query',
                        'connector_id': 'query',
                        'updated_since': 'query',
                        'limit': 'query',
                        'org_ids': 'query',
                        'resource_id': 'query',
                        'page_at_id': 'query',
                        'name_slug': 'query',
                    },
                    'collection_format_map': {
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_ssh_resources
            )

        def __replace_application_service(
            self,
            app_service_id,
            **kwargs
        ):
            """Create or update an Application Service.  # noqa: E501

            Create or update an Application Service.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_application_service(app_service_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_service_id (str): Application Service unique identifier

            Keyword Args:
                application_service (ApplicationService): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_service_id'] = \
                app_service_id
            return self.call_with_http_info(**kwargs)

        if self.replace_application_service is None:
            self.replace_application_service = _Endpoint(
                settings={
                    'response_type': (ApplicationService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v2/application_services/{app_service_id}',
                    'operation_id': 'replace_application_service',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'app_service_id',
                        'application_service',
                    ],
                    'required': [
                        'app_service_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_service_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'app_service_id':
                            (str,),
                        'application_service':
                            (ApplicationService,),
                    },
                    'attribute_map': {
                        'app_service_id': 'app_service_id',
                    },
                    'location_map': {
                        'app_service_id': 'path',
                        'application_service': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_application_service
            )

        def __replace_database_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Create or update a DatabaseResource.  # noqa: E501

            Create or update a DatabaseResource.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_database_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                database_resource (DatabaseResource): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DatabaseResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.replace_database_resource is None:
            self.replace_database_resource = _Endpoint(
                settings={
                    'response_type': (DatabaseResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/database_resources/{resource_id}',
                    'operation_id': 'replace_database_resource',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'database_resource',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'database_resource':
                            (DatabaseResource,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'database_resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_database_resource
            )

        def __replace_desktop_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Create or update a DesktopResource.  # noqa: E501

            Create or update a DesktopResource.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_desktop_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                desktop_resource (DesktopResource): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DesktopResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.replace_desktop_resource is None:
            self.replace_desktop_resource = _Endpoint(
                settings={
                    'response_type': (DesktopResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/desktop_resources/{resource_id}',
                    'operation_id': 'replace_desktop_resource',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'desktop_resource',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'desktop_resource':
                            (DesktopResource,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'desktop_resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_desktop_resource
            )

        def __replace_file_share_service(
            self,
            file_share_service_id,
            **kwargs
        ):
            """Create or update an FileShareService.  # noqa: E501

            Create or update an FileShareService.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_file_share_service(file_share_service_id, async_req=True)
            >>> result = thread.get()

            Args:
                file_share_service_id (str): FileShareService unique identifier

            Keyword Args:
                file_share_service (FileShareService): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileShareService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['file_share_service_id'] = \
                file_share_service_id
            return self.call_with_http_info(**kwargs)

        if self.replace_file_share_service is None:
            self.replace_file_share_service = _Endpoint(
                settings={
                    'response_type': (FileShareService,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/file_share_services/{file_share_service_id}',
                    'operation_id': 'replace_file_share_service',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'file_share_service_id',
                        'file_share_service',
                    ],
                    'required': [
                        'file_share_service_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'file_share_service_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('file_share_service_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'file_share_service_id':
                            (str,),
                        'file_share_service':
                            (FileShareService,),
                    },
                    'attribute_map': {
                        'file_share_service_id': 'file_share_service_id',
                    },
                    'location_map': {
                        'file_share_service_id': 'path',
                        'file_share_service': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_file_share_service
            )

        def __replace_service_forwarder(
            self,
            service_forwarder_id,
            **kwargs
        ):
            """Create or update an ServiceForwarder.  # noqa: E501

            Create or update an ServiceForwarder.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_service_forwarder(service_forwarder_id, async_req=True)
            >>> result = thread.get()

            Args:
                service_forwarder_id (str): Service Forwarder unique identifier

            Keyword Args:
                service_forwarder (ServiceForwarder): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ServiceForwarder
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_forwarder_id'] = \
                service_forwarder_id
            return self.call_with_http_info(**kwargs)

        if self.replace_service_forwarder is None:
            self.replace_service_forwarder = _Endpoint(
                settings={
                    'response_type': (ServiceForwarder,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/service_forwarders/{service_forwarder_id}',
                    'operation_id': 'replace_service_forwarder',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_forwarder_id',
                        'service_forwarder',
                    ],
                    'required': [
                        'service_forwarder_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'service_forwarder_id',
                    ]
                },
                root_map={
                    'validations': {
                        ('service_forwarder_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_forwarder_id':
                            (str,),
                        'service_forwarder':
                            (ServiceForwarder,),
                    },
                    'attribute_map': {
                        'service_forwarder_id': 'service_forwarder_id',
                    },
                    'location_map': {
                        'service_forwarder_id': 'path',
                        'service_forwarder': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_service_forwarder
            )

        def __replace_ssh_resource(
            self,
            resource_id,
            **kwargs
        ):
            """Create or update a SSHResource.  # noqa: E501

            Create or update a SSHResource.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_ssh_resource(resource_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_id (str): The id of the resource to access

            Keyword Args:
                ssh_resource (SSHResource): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SSHResource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_id'] = \
                resource_id
            return self.call_with_http_info(**kwargs)

        if self.replace_ssh_resource is None:
            self.replace_ssh_resource = _Endpoint(
                settings={
                    'response_type': (SSHResource,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/ssh_resources/{resource_id}',
                    'operation_id': 'replace_ssh_resource',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_id',
                        'ssh_resource',
                    ],
                    'required': [
                        'resource_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_id':
                            (str,),
                        'ssh_resource':
                            (SSHResource,),
                    },
                    'attribute_map': {
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'resource_id': 'path',
                        'ssh_resource': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_ssh_resource
            )

    create_application_service = None 
    create_application_service_token = None 
    create_client_configuration = None 
    create_database_resource = None 
    create_desktop_resource = None 
    create_file_share_service = None 
    create_server_configuration = None 
    create_service_forwarder = None 
    create_ssh_resource = None 
    delete_application_service = None 
    delete_database_resource = None 
    delete_desktop_resource = None 
    delete_file_share_service = None 
    delete_service_forwarder = None 
    delete_ssh_resource = None 
    get_application_service = None 
    get_application_service_stats = None 
    get_application_service_usage_metrics = None 
    get_database_resource = None 
    get_desktop_resource = None 
    get_file_share_service = None 
    get_file_share_usage_metrics = None 
    get_service_forwarder = None 
    get_ssh_resource = None 
    list_application_services = None 
    list_database_resources = None 
    list_desktop_resources = None 
    list_file_share_services = None 
    list_service_forwarders = None 
    list_ssh_resources = None 
    replace_application_service = None 
    replace_database_resource = None 
    replace_desktop_resource = None 
    replace_file_share_service = None 
    replace_service_forwarder = None 
    replace_ssh_resource = None 
