"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.billing_account import BillingAccount
from agilicus_api.model.billing_checkout_session import BillingCheckoutSession
from agilicus_api.model.billing_portal_link import BillingPortalLink
from agilicus_api.model.billing_subscription_cancel_detail import BillingSubscriptionCancelDetail
from agilicus_api.model.create_billing_checkout_session import CreateBillingCheckoutSession
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_domains_response import ListDomainsResponse
from agilicus_api.model.list_features_response import ListFeaturesResponse
from agilicus_api.model.list_guid_metadata_response import ListGuidMetadataResponse
from agilicus_api.model.list_orgs_response import ListOrgsResponse
from agilicus_api.model.org_fixup import OrgFixup
from agilicus_api.model.organisation import Organisation
from agilicus_api.model.organisation_admin import OrganisationAdmin
from agilicus_api.model.organisation_capabilities import OrganisationCapabilities
from agilicus_api.model.organisation_status import OrganisationStatus
from agilicus_api.model.organisation_system_options import OrganisationSystemOptions
from agilicus_api.model.reconcile_org_default_policy_request import ReconcileOrgDefaultPolicyRequest
from agilicus_api.model.reconcile_org_default_policy_response import ReconcileOrgDefaultPolicyResponse
from agilicus_api.model.reconcile_sub_org_issuer_request import ReconcileSubOrgIssuerRequest
from agilicus_api.model.usage_metrics import UsageMetrics


class OrganisationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __cancel_subscription(
            self,
            org_id,
            **kwargs
        ):
            """Cancel the billing subscription for this organisation  # noqa: E501

            Cancel the billing subscription for this organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.cancel_subscription(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                billing_subscription_cancel_detail (BillingSubscriptionCancelDetail): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingSubscriptionCancelDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.cancel_subscription is None:
            self.cancel_subscription = _Endpoint(
                settings={
                    'response_type': (BillingSubscriptionCancelDetail,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/cancel_subscription',
                    'operation_id': 'cancel_subscription',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'billing_subscription_cancel_detail',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'billing_subscription_cancel_detail':
                            (BillingSubscriptionCancelDetail,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'billing_subscription_cancel_detail': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__cancel_subscription
            )

        def __create_billing_portal_link(
            self,
            org_id,
            billing_portal_link,
            **kwargs
        ):
            """Create a link to the billing portal  # noqa: E501

            Creates a temporary, one-time-use link to the billing system's self-serve portal.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_billing_portal_link(org_id, billing_portal_link, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                billing_portal_link (BillingPortalLink):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingPortalLink
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['billing_portal_link'] = \
                billing_portal_link
            return self.call_with_http_info(**kwargs)

        if self.create_billing_portal_link is None:
            self.create_billing_portal_link = _Endpoint(
                settings={
                    'response_type': (BillingPortalLink,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/billing_portal_links',
                    'operation_id': 'create_billing_portal_link',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'billing_portal_link',
                    ],
                    'required': [
                        'org_id',
                        'billing_portal_link',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'billing_portal_link':
                            (BillingPortalLink,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'billing_portal_link': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_billing_portal_link
            )

        def __create_blocking_upgrade_orgs_task(
            self,
            **kwargs
        ):
            """utility to upgrade organisations  # noqa: E501

            utility to upgrade organisations  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_blocking_upgrade_orgs_task(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.create_blocking_upgrade_orgs_task is None:
            self.create_blocking_upgrade_orgs_task = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/upgrade',
                    'operation_id': 'create_blocking_upgrade_orgs_task',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__create_blocking_upgrade_orgs_task
            )

        def __create_checkout_session(
            self,
            org_id,
            **kwargs
        ):
            """Create a session checkout  # noqa: E501

            Create a session checkout  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_checkout_session(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                create_billing_checkout_session (CreateBillingCheckoutSession): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingCheckoutSession
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.create_checkout_session is None:
            self.create_checkout_session = _Endpoint(
                settings={
                    'response_type': (BillingCheckoutSession,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/billing_checkout',
                    'operation_id': 'create_checkout_session',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'create_billing_checkout_session',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'create_billing_checkout_session':
                            (CreateBillingCheckoutSession,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'create_billing_checkout_session': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_checkout_session
            )

        def __create_org(
            self,
            organisation_admin,
            **kwargs
        ):
            """Create an organisation  # noqa: E501

            Create an organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_org(organisation_admin, async_req=True)
            >>> result = thread.get()

            Args:
                organisation_admin (OrganisationAdmin):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Organisation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organisation_admin'] = \
                organisation_admin
            return self.call_with_http_info(**kwargs)

        if self.create_org is None:
            self.create_org = _Endpoint(
                settings={
                    'response_type': (Organisation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs',
                    'operation_id': 'create_org',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'organisation_admin',
                    ],
                    'required': [
                        'organisation_admin',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'organisation_admin':
                            (OrganisationAdmin,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'organisation_admin': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_org
            )

        def __create_reconcile_org_default_policy(
            self,
            reconcile_org_default_policy_request,
            **kwargs
        ):
            """Reconciles one or more org's default policies  # noqa: E501

            Ensures that the requested organisations have the proper defaults for their policies.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_reconcile_org_default_policy(reconcile_org_default_policy_request, async_req=True)
            >>> result = thread.get()

            Args:
                reconcile_org_default_policy_request (ReconcileOrgDefaultPolicyRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ReconcileOrgDefaultPolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['reconcile_org_default_policy_request'] = \
                reconcile_org_default_policy_request
            return self.call_with_http_info(**kwargs)

        if self.create_reconcile_org_default_policy is None:
            self.create_reconcile_org_default_policy = _Endpoint(
                settings={
                    'response_type': (ReconcileOrgDefaultPolicyResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/reconcile_org_default_policy',
                    'operation_id': 'create_reconcile_org_default_policy',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'reconcile_org_default_policy_request',
                    ],
                    'required': [
                        'reconcile_org_default_policy_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'reconcile_org_default_policy_request':
                            (ReconcileOrgDefaultPolicyRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'reconcile_org_default_policy_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_reconcile_org_default_policy
            )

        def __create_sub_org(
            self,
            org_id,
            organisation,
            **kwargs
        ):
            """Create a sub organisation  # noqa: E501

            Create a sub organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_sub_org(org_id, organisation, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                organisation (Organisation):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Organisation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['organisation'] = \
                organisation
            return self.call_with_http_info(**kwargs)

        if self.create_sub_org is None:
            self.create_sub_org = _Endpoint(
                settings={
                    'response_type': (Organisation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/orgs',
                    'operation_id': 'create_sub_org',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'organisation',
                    ],
                    'required': [
                        'org_id',
                        'organisation',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'organisation':
                            (Organisation,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'organisation': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_sub_org
            )

        def __delete_sub_org(
            self,
            org_id,
            sub_org_id,
            **kwargs
        ):
            """Delete a sub organisation  # noqa: E501

            Delete a sub organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_sub_org(org_id, sub_org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                sub_org_id (str): Sub Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['sub_org_id'] = \
                sub_org_id
            return self.call_with_http_info(**kwargs)

        if self.delete_sub_org is None:
            self.delete_sub_org = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/orgs/{sub_org_id}',
                    'operation_id': 'delete_sub_org',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'sub_org_id',
                    ],
                    'required': [
                        'org_id',
                        'sub_org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'sub_org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'sub_org_id': 'sub_org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'sub_org_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_sub_org
            )

        def __get_inherent_capabilities(
            self,
            org_id,
            **kwargs
        ):
            """Get the inherent capabilities for an org  # noqa: E501

            Gets the inherent capabilities for an organisation. Inherent capabilities are what an organisation can do. They cannot be changed by the organisation. Instead, they serve to limit the configurable capabilities of the organisation. An organisation's capabilities are the intersection of its inherent_capabilities and its configured_capabilities. If an organisation has not configured capabilities, they will be inherited from the parent. Similarly, if an organisation has no enabled inherent_capabilities they will be inherited from the parent.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_inherent_capabilities(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OrganisationCapabilities
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_inherent_capabilities is None:
            self.get_inherent_capabilities = _Endpoint(
                settings={
                    'response_type': (OrganisationCapabilities,),
                    'auth': [],
                    'endpoint_path': '/v1/orgs/{org_id}/inherent_capabilities',
                    'operation_id': 'get_inherent_capabilities',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_inherent_capabilities
            )

        def __get_org(
            self,
            org_id,
            **kwargs
        ):
            """Get a single organisation  # noqa: E501

            Get a single organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_org(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                get_system_options (bool): Retrieve organisation system options. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Organisation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_org is None:
            self.get_org = _Endpoint(
                settings={
                    'response_type': (Organisation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}',
                    'operation_id': 'get_org',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'get_system_options',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'get_system_options':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'get_system_options': 'get_system_options',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'get_system_options': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_org
            )

        def __get_org_billing_account(
            self,
            org_id,
            **kwargs
        ):
            """Get the billing account associated with the organisation  # noqa: E501

            Get the billing account associated with the organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_org_billing_account(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                get_subscription_data (bool): In billing response, return subscription data. [optional] if omitted the server will use the default value of False
                get_customer_data (bool): In billing response, return customer data. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BillingAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_org_billing_account is None:
            self.get_org_billing_account = _Endpoint(
                settings={
                    'response_type': (BillingAccount,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/billing_account',
                    'operation_id': 'get_org_billing_account',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'get_subscription_data',
                        'get_customer_data',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'get_subscription_data':
                            (bool,),
                        'get_customer_data':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'get_subscription_data': 'get_subscription_data',
                        'get_customer_data': 'get_customer_data',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'get_subscription_data': 'query',
                        'get_customer_data': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_org_billing_account
            )

        def __get_org_features(
            self,
            org_id,
            **kwargs
        ):
            """all features associated with organisation  # noqa: E501

            all features associated with organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_org_features(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListFeaturesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_org_features is None:
            self.get_org_features = _Endpoint(
                settings={
                    'response_type': (ListFeaturesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/features',
                    'operation_id': 'get_org_features',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_org_features
            )

        def __get_org_status(
            self,
            org_id,
            **kwargs
        ):
            """Get the status of an organisation  # noqa: E501

            Get the status of an organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_org_status(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OrganisationStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_org_status is None:
            self.get_org_status = _Endpoint(
                settings={
                    'response_type': (OrganisationStatus,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/status',
                    'operation_id': 'get_org_status',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_org_status
            )

        def __get_system_options(
            self,
            org_id,
            **kwargs
        ):
            """Get organisation system options  # noqa: E501

            Get organisation system options  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_system_options(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OrganisationSystemOptions
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_system_options is None:
            self.get_system_options = _Endpoint(
                settings={
                    'response_type': (OrganisationSystemOptions,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/system_options',
                    'operation_id': 'get_system_options',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_system_options
            )

        def __get_usage_metrics(
            self,
            org_id,
            **kwargs
        ):
            """Get all usage metrics for an organisation  # noqa: E501

            Get all usage metrics for an organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_usage_metrics(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UsageMetrics
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_usage_metrics is None:
            self.get_usage_metrics = _Endpoint(
                settings={
                    'response_type': (UsageMetrics,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/usage_metrics',
                    'operation_id': 'get_usage_metrics',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_usage_metrics
            )

        def __list_email_domains(
            self,
            org_id,
            **kwargs
        ):
            """List all unique email domains for users that are inside an organisation  # noqa: E501

            List all unique email domains for users that are inside an organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_email_domains(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListDomainsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.list_email_domains is None:
            self.list_email_domains = _Endpoint(
                settings={
                    'response_type': (ListDomainsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/domains',
                    'operation_id': 'list_email_domains',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_email_domains
            )

        def __list_org_guid_mapping(
            self,
            **kwargs
        ):
            """Get all org guids and a unique name mapping  # noqa: E501

            Get all org guids and a unique name mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_org_guid_mapping(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                previous_guid (str): Pagination based query with the guid as the key. To get the initial entries supply an empty string.. [optional]
                updated_since (datetime): query since updated. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListGuidMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_org_guid_mapping is None:
            self.list_org_guid_mapping = _Endpoint(
                settings={
                    'response_type': (ListGuidMetadataResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/guids',
                    'operation_id': 'list_org_guid_mapping',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'limit',
                        'previous_guid',
                        'updated_since',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                        'previous_guid':
                            (str,),
                        'updated_since':
                            (datetime,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'limit': 'limit',
                        'previous_guid': 'previous_guid',
                        'updated_since': 'updated_since',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'limit': 'query',
                        'previous_guid': 'query',
                        'updated_since': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_org_guid_mapping
            )

        def __list_orgs(
            self,
            **kwargs
        ):
            """Get all organisations  # noqa: E501

            Get all organisations  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_orgs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                organisation (str): Organisation Name. [optional]
                issuer (str): Organisation issuer. [optional]
                list_children (bool): Controls whether or not children of the matching resources are returned in the listing. . [optional] if omitted the server will use the default value of False
                updated_since (datetime): query since updated. [optional]
                suborg_updated (bool): query any orgs who are updated or have their suborgs updated. [optional]
                enabled (bool): query any orgs which are enabled. [optional]
                billing_account_id (str, none_type): Billing account Unique identifier to search for. If `\"\"`, search for something that does not have a billing account. . [optional]
                shard (str): Hosting shard name. [optional]
                cluster (str): Hosting cluster name. [optional]
                subdomain (str): query based on organisation subdomain . [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                get_system_options (bool): Retrieve organisation system options. [optional] if omitted the server will use the default value of False
                point_of_presence_name_list ([str]): point of presence name list query. [optional]
                region_name_list ([str]): region name list query. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListOrgsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_orgs is None:
            self.list_orgs = _Endpoint(
                settings={
                    'response_type': (ListOrgsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs',
                    'operation_id': 'list_orgs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'organisation',
                        'issuer',
                        'list_children',
                        'updated_since',
                        'suborg_updated',
                        'enabled',
                        'billing_account_id',
                        'shard',
                        'cluster',
                        'subdomain',
                        'page_at_id',
                        'get_system_options',
                        'point_of_presence_name_list',
                        'region_name_list',
                    ],
                    'required': [],
                    'nullable': [
                        'billing_account_id',
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'organisation':
                            (str,),
                        'issuer':
                            (str,),
                        'list_children':
                            (bool,),
                        'updated_since':
                            (datetime,),
                        'suborg_updated':
                            (bool,),
                        'enabled':
                            (bool,),
                        'billing_account_id':
                            (str, none_type,),
                        'shard':
                            (str,),
                        'cluster':
                            (str,),
                        'subdomain':
                            (str,),
                        'page_at_id':
                            (str,),
                        'get_system_options':
                            (bool,),
                        'point_of_presence_name_list':
                            ([str],),
                        'region_name_list':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'organisation': 'organisation',
                        'issuer': 'issuer',
                        'list_children': 'list_children',
                        'updated_since': 'updated_since',
                        'suborg_updated': 'suborg_updated',
                        'enabled': 'enabled',
                        'billing_account_id': 'billing_account_id',
                        'shard': 'shard',
                        'cluster': 'cluster',
                        'subdomain': 'subdomain',
                        'page_at_id': 'page_at_id',
                        'get_system_options': 'get_system_options',
                        'point_of_presence_name_list': 'point_of_presence_name_list',
                        'region_name_list': 'region_name_list',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'organisation': 'query',
                        'issuer': 'query',
                        'list_children': 'query',
                        'updated_since': 'query',
                        'suborg_updated': 'query',
                        'enabled': 'query',
                        'billing_account_id': 'query',
                        'shard': 'query',
                        'cluster': 'query',
                        'subdomain': 'query',
                        'page_at_id': 'query',
                        'get_system_options': 'query',
                        'point_of_presence_name_list': 'query',
                        'region_name_list': 'query',
                    },
                    'collection_format_map': {
                        'point_of_presence_name_list': 'multi',
                        'region_name_list': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_orgs
            )

        def __list_sub_orgs(
            self,
            org_id,
            **kwargs
        ):
            """Get all sub organisations  # noqa: E501

            Get all sub organisations  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_sub_orgs(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                updated_since (datetime): query since updated. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListOrgsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.list_sub_orgs is None:
            self.list_sub_orgs = _Endpoint(
                settings={
                    'response_type': (ListOrgsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/orgs',
                    'operation_id': 'list_sub_orgs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'limit',
                        'updated_since',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                        'updated_since':
                            (datetime,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'limit': 'limit',
                        'updated_since': 'updated_since',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'limit': 'query',
                        'updated_since': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_sub_orgs
            )

        def __org_fixup(
            self,
            org_id,
            org_fixup,
            **kwargs
        ):
            """Fixup an org, if required  # noqa: E501

            Fixup an org, if required   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.org_fixup(org_id, org_fixup, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                org_fixup (OrgFixup):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OrgFixup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['org_fixup'] = \
                org_fixup
            return self.call_with_http_info(**kwargs)

        if self.org_fixup is None:
            self.org_fixup = _Endpoint(
                settings={
                    'response_type': (OrgFixup,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/fixup',
                    'operation_id': 'org_fixup',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'org_fixup',
                    ],
                    'required': [
                        'org_id',
                        'org_fixup',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'org_fixup':
                            (OrgFixup,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'org_fixup': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__org_fixup
            )

        def __reconcile_sub_org_issuer(
            self,
            org_id,
            sub_org_id,
            reconcile_sub_org_issuer_request,
            **kwargs
        ):
            """Creates an issuer for the sub org  # noqa: E501

            Allocates or removes an issuer for the suborg.  Allocating an issuer allows the suborg to have its own issuer configuration. Note that at most one issuer may be created this way. If an issuer already exists it will be reclaimed and updated.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reconcile_sub_org_issuer(org_id, sub_org_id, reconcile_sub_org_issuer_request, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                sub_org_id (str): Sub Organisation Unique identifier
                reconcile_sub_org_issuer_request (ReconcileSubOrgIssuerRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Organisation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['sub_org_id'] = \
                sub_org_id
            kwargs['reconcile_sub_org_issuer_request'] = \
                reconcile_sub_org_issuer_request
            return self.call_with_http_info(**kwargs)

        if self.reconcile_sub_org_issuer is None:
            self.reconcile_sub_org_issuer = _Endpoint(
                settings={
                    'response_type': (Organisation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/orgs/{sub_org_id}/issuer',
                    'operation_id': 'reconcile_sub_org_issuer',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'sub_org_id',
                        'reconcile_sub_org_issuer_request',
                    ],
                    'required': [
                        'org_id',
                        'sub_org_id',
                        'reconcile_sub_org_issuer_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'sub_org_id':
                            (str,),
                        'reconcile_sub_org_issuer_request':
                            (ReconcileSubOrgIssuerRequest,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'sub_org_id': 'sub_org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'sub_org_id': 'path',
                        'reconcile_sub_org_issuer_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__reconcile_sub_org_issuer
            )

        def __replace_org(
            self,
            org_id,
            **kwargs
        ):
            """Create or update an organisation  # noqa: E501

            Create or update an organisation  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_org(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                organisation (Organisation): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.replace_org is None:
            self.replace_org = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}',
                    'operation_id': 'replace_org',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'organisation',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'organisation':
                            (Organisation,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'organisation': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_org
            )

        def __replace_system_options(
            self,
            org_id,
            organisation_system_options,
            **kwargs
        ):
            """Update organisation system options  # noqa: E501

            Update organisation system options   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_system_options(org_id, organisation_system_options, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier
                organisation_system_options (OrganisationSystemOptions):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OrganisationSystemOptions
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['organisation_system_options'] = \
                organisation_system_options
            return self.call_with_http_info(**kwargs)

        if self.replace_system_options is None:
            self.replace_system_options = _Endpoint(
                settings={
                    'response_type': (OrganisationSystemOptions,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/system_options',
                    'operation_id': 'replace_system_options',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'organisation_system_options',
                    ],
                    'required': [
                        'org_id',
                        'organisation_system_options',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'organisation_system_options':
                            (OrganisationSystemOptions,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'organisation_system_options': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_system_options
            )

        def __set_inherent_capabilities(
            self,
            org_id,
            **kwargs
        ):
            """Set the inherent capabilities for an org  # noqa: E501

            Sets the inherent capabilities for an organisation.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.set_inherent_capabilities(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                organisation_capabilities (OrganisationCapabilities): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OrganisationCapabilities
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.set_inherent_capabilities is None:
            self.set_inherent_capabilities = _Endpoint(
                settings={
                    'response_type': (OrganisationCapabilities,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/{org_id}/inherent_capabilities',
                    'operation_id': 'set_inherent_capabilities',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'organisation_capabilities',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'organisation_capabilities':
                            (OrganisationCapabilities,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'organisation_capabilities': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__set_inherent_capabilities
            )

        def __validate_new_org(
            self,
            organisation_admin,
            **kwargs
        ):
            """Validate that the requested org is available  # noqa: E501

            Validate that the requested org is available  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.validate_new_org(organisation_admin, async_req=True)
            >>> result = thread.get()

            Args:
                organisation_admin (OrganisationAdmin):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organisation_admin'] = \
                organisation_admin
            return self.call_with_http_info(**kwargs)

        if self.validate_new_org is None:
            self.validate_new_org = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/orgs/validate_new_org',
                    'operation_id': 'validate_new_org',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'organisation_admin',
                    ],
                    'required': [
                        'organisation_admin',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'organisation_admin':
                            (OrganisationAdmin,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'organisation_admin': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__validate_new_org
            )

    cancel_subscription = None 
    create_billing_portal_link = None 
    create_blocking_upgrade_orgs_task = None 
    create_checkout_session = None 
    create_org = None 
    create_reconcile_org_default_policy = None 
    create_sub_org = None 
    delete_sub_org = None 
    get_inherent_capabilities = None 
    get_org = None 
    get_org_billing_account = None 
    get_org_features = None 
    get_org_status = None 
    get_system_options = None 
    get_usage_metrics = None 
    list_email_domains = None 
    list_org_guid_mapping = None 
    list_orgs = None 
    list_sub_orgs = None 
    org_fixup = None 
    reconcile_sub_org_issuer = None 
    replace_org = None 
    replace_system_options = None 
    set_inherent_capabilities = None 
    validate_new_org = None 
