"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError



class ShareDetailedStats(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('requests_read',): {
            'inclusive_minimum': 0,
        },
        ('requests_create',): {
            'inclusive_minimum': 0,
        },
        ('requests_modify',): {
            'inclusive_minimum': 0,
        },
        ('requests_delete',): {
            'inclusive_minimum': 0,
        },
        ('requests_lock',): {
            'inclusive_minimum': 0,
        },
        ('requests_other',): {
            'inclusive_minimum': 0,
        },
        ('failure_not_found',): {
            'inclusive_minimum': 0,
        },
        ('failure_permission',): {
            'inclusive_minimum': 0,
        },
        ('failure_other',): {
            'inclusive_minimum': 0,
        },
    }

    @property
    def requests_read(self):
       return self.get("requests_read")

    @requests_read.setter
    def requests_read(self, new_value):
       self.requests_read = new_value

    @property
    def requests_create(self):
       return self.get("requests_create")

    @requests_create.setter
    def requests_create(self, new_value):
       self.requests_create = new_value

    @property
    def requests_modify(self):
       return self.get("requests_modify")

    @requests_modify.setter
    def requests_modify(self, new_value):
       self.requests_modify = new_value

    @property
    def requests_delete(self):
       return self.get("requests_delete")

    @requests_delete.setter
    def requests_delete(self, new_value):
       self.requests_delete = new_value

    @property
    def requests_lock(self):
       return self.get("requests_lock")

    @requests_lock.setter
    def requests_lock(self, new_value):
       self.requests_lock = new_value

    @property
    def requests_other(self):
       return self.get("requests_other")

    @requests_other.setter
    def requests_other(self, new_value):
       self.requests_other = new_value

    @property
    def failure_not_found(self):
       return self.get("failure_not_found")

    @failure_not_found.setter
    def failure_not_found(self, new_value):
       self.failure_not_found = new_value

    @property
    def failure_permission(self):
       return self.get("failure_permission")

    @failure_permission.setter
    def failure_permission(self, new_value):
       self.failure_permission = new_value

    @property
    def failure_other(self):
       return self.get("failure_other")

    @failure_other.setter
    def failure_other(self, new_value):
       self.failure_other = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'requests_read': (int,),  # noqa: E501
            'requests_create': (int,),  # noqa: E501
            'requests_modify': (int,),  # noqa: E501
            'requests_delete': (int,),  # noqa: E501
            'requests_lock': (int,),  # noqa: E501
            'requests_other': (int,),  # noqa: E501
            'failure_not_found': (int,),  # noqa: E501
            'failure_permission': (int,),  # noqa: E501
            'failure_other': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'requests_read': 'requests_read',  # noqa: E501
        'requests_create': 'requests_create',  # noqa: E501
        'requests_modify': 'requests_modify',  # noqa: E501
        'requests_delete': 'requests_delete',  # noqa: E501
        'requests_lock': 'requests_lock',  # noqa: E501
        'requests_other': 'requests_other',  # noqa: E501
        'failure_not_found': 'failure_not_found',  # noqa: E501
        'failure_permission': 'failure_permission',  # noqa: E501
        'failure_other': 'failure_other',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """ShareDetailedStats - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            requests_read (int): The number of requests which read a file or directory. . [optional]  # noqa: E501
            requests_create (int): The number of requests which created a file or directory . [optional]  # noqa: E501
            requests_modify (int): The number of requests which modified a file or directory . [optional]  # noqa: E501
            requests_delete (int): The number of requests which deleted a file or directory . [optional]  # noqa: E501
            requests_lock (int): The number of requests which locked a file or directory . [optional]  # noqa: E501
            requests_other (int): The number of requests which performed an operation not broken out in to a specific counter . [optional]  # noqa: E501
            failure_not_found (int): The number of requests which failed because the connector could not find the share . [optional]  # noqa: E501
            failure_permission (int): The number of requests which failed because the connector did not have permission to access the share . [optional]  # noqa: E501
            failure_other (int): The number of requests which failed for an unspecified reason. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ShareDetailedStats - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            requests_read (int): The number of requests which read a file or directory. . [optional]  # noqa: E501
            requests_create (int): The number of requests which created a file or directory . [optional]  # noqa: E501
            requests_modify (int): The number of requests which modified a file or directory . [optional]  # noqa: E501
            requests_delete (int): The number of requests which deleted a file or directory . [optional]  # noqa: E501
            requests_lock (int): The number of requests which locked a file or directory . [optional]  # noqa: E501
            requests_other (int): The number of requests which performed an operation not broken out in to a specific counter . [optional]  # noqa: E501
            failure_not_found (int): The number of requests which failed because the connector could not find the share . [optional]  # noqa: E501
            failure_permission (int): The number of requests which failed because the connector did not have permission to access the share . [optional]  # noqa: E501
            failure_other (int): The number of requests which failed for an unspecified reason. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

