"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.08.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.certificates_api import CertificatesApi  # noqa: E501


class TestCertificatesApi(unittest.TestCase):
    """CertificatesApi unit test stubs"""

    def setUp(self):
        self.api = CertificatesApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_cert(self):
        """Test case for create_cert

        Creates a X509Certificate  # noqa: E501
        """
        pass

    def test_create_cert_tracker(self):
        """Test case for create_cert_tracker

        Creates a CertificateTracker  # noqa: E501
        """
        pass

    def test_create_cert_tracker_cert(self):
        """Test case for create_cert_tracker_cert

        Creates a X509Certificate associated to a CertificateTracker  # noqa: E501
        """
        pass

    def test_delete_agent_csr(self):
        """Test case for delete_agent_csr

        Delete a CertSigningReq  # noqa: E501
        """
        pass

    def test_delete_cert(self):
        """Test case for delete_cert

        Delete a X509Certificate  # noqa: E501
        """
        pass

    def test_delete_cert_tracker(self):
        """Test case for delete_cert_tracker

        Delete a CertificateTracker  # noqa: E501
        """
        pass

    def test_delete_csr(self):
        """Test case for delete_csr

        Delete a CertSigningReq  # noqa: E501
        """
        pass

    def test_get_cert(self):
        """Test case for get_cert

        Get a X509Certificate  # noqa: E501
        """
        pass

    def test_get_cert_tracker(self):
        """Test case for get_cert_tracker

        Get a CertificateTracker  # noqa: E501
        """
        pass

    def test_get_csr(self):
        """Test case for get_csr

        Get a CertSigningReq  # noqa: E501
        """
        pass

    def test_list_cert_trackers(self):
        """Test case for list_cert_trackers

        list certificate trackers  # noqa: E501
        """
        pass

    def test_list_certs(self):
        """Test case for list_certs

        list certificates  # noqa: E501
        """
        pass

    def test_list_csr(self):
        """Test case for list_csr

        list certificate signing requests  # noqa: E501
        """
        pass

    def test_list_root_certs(self):
        """Test case for list_root_certs

        list root certificates  # noqa: E501
        """
        pass

    def test_reissue_cert_for_csr(self):
        """Test case for reissue_cert_for_csr

        Creates a CertSigningRequestReissue  # noqa: E501
        """
        pass

    def test_replace_cert_tracker(self):
        """Test case for replace_cert_tracker

        Update a CertificateTracker  # noqa: E501
        """
        pass

    def test_replace_csr(self):
        """Test case for replace_csr

        Update a CertSigningReq  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
