"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fc = require("fast-check");
const scalingcommon = require("../lib");
class ArbitraryCompleteIntervals extends fc.Arbitrary {
    generate(mrng) {
        const ret = scalingcommon.generateArbitraryIntervals(mrng);
        return new fc.Shrinkable(scalingcommon.normalizeIntervals(ret.intervals, ret.absolute));
    }
}
exports.ArbitraryCompleteIntervals = ArbitraryCompleteIntervals;
function arbitrary_complete_intervals() {
    return new ArbitraryCompleteIntervals();
}
exports.arbitrary_complete_intervals = arbitrary_complete_intervals;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxpQ0FBa0M7QUFDbEMsd0NBQXlDO0FBRXpDLE1BQWEsMEJBQTJCLFNBQVEsRUFBRSxDQUFDLFNBQWtEO0lBQzVGLFFBQVEsQ0FBQyxJQUFlO1FBQzdCLE1BQU0sR0FBRyxHQUFHLGFBQWEsQ0FBQywwQkFBMEIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMzRCxPQUFPLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsa0JBQWtCLENBQUMsR0FBRyxDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMxRixDQUFDO0NBQ0Y7QUFMRCxnRUFLQztBQUVELFNBQWdCLDRCQUE0QjtJQUMxQyxPQUFPLElBQUksMEJBQTBCLEVBQUUsQ0FBQztBQUMxQyxDQUFDO0FBRkQsb0VBRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZmMgPSByZXF1aXJlKCdmYXN0LWNoZWNrJyk7XG5pbXBvcnQgc2NhbGluZ2NvbW1vbiA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5leHBvcnQgY2xhc3MgQXJiaXRyYXJ5Q29tcGxldGVJbnRlcnZhbHMgZXh0ZW5kcyBmYy5BcmJpdHJhcnk8c2NhbGluZ2NvbW1vbi5Db21wbGV0ZVNjYWxpbmdJbnRlcnZhbFtdPiB7XG4gIHB1YmxpYyBnZW5lcmF0ZShtcm5nOiBmYy5SYW5kb20pOiBmYy5TaHJpbmthYmxlPHNjYWxpbmdjb21tb24uQ29tcGxldGVTY2FsaW5nSW50ZXJ2YWxbXT4ge1xuICAgIGNvbnN0IHJldCA9IHNjYWxpbmdjb21tb24uZ2VuZXJhdGVBcmJpdHJhcnlJbnRlcnZhbHMobXJuZyk7XG4gICAgcmV0dXJuIG5ldyBmYy5TaHJpbmthYmxlKHNjYWxpbmdjb21tb24ubm9ybWFsaXplSW50ZXJ2YWxzKHJldC5pbnRlcnZhbHMsIHJldC5hYnNvbHV0ZSkpO1xuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhcmJpdHJhcnlfY29tcGxldGVfaW50ZXJ2YWxzKCkge1xuICByZXR1cm4gbmV3IEFyYml0cmFyeUNvbXBsZXRlSW50ZXJ2YWxzKCk7XG59XG4iXX0=