"""Added some cascades

Revision ID: 2b5bddd207ae
Revises: 298430e7849d
Create Date: 2024-11-07 14:34:56.132740

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '2b5bddd207ae'
down_revision = '298430e7849d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        with op.batch_alter_table('alerts', schema=None) as batch_op:
            batch_op.drop_constraint('alert_cot', type_='foreignkey')
    except:
        pass
    try:
        with op.batch_alter_table('alerts', schema=None) as batch_op:
            batch_op.drop_constraint('alert_point', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('alerts', schema=None) as batch_op:
            batch_op.drop_constraint('alert_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('alerts', schema=None) as batch_op:
        batch_op.create_foreign_key('alert_point', 'points', ['point_id'], ['id'], ondelete='CASCADE')
        batch_op.create_foreign_key('alert_eud', 'euds', ['sender_uid'], ['uid'], ondelete='CASCADE')
        batch_op.create_foreign_key('alert_cot', 'cot', ['cot_id'], ['id'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('casevac', schema=None) as batch_op:
            batch_op.drop_constraint('casevac_cot', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('casevac', schema=None) as batch_op:
            batch_op.drop_constraint('casevac_point', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('casevac', schema=None) as batch_op:
            batch_op.drop_constraint('casevac_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('casevac', schema=None) as batch_op:
        batch_op.create_foreign_key('casevac_cot', 'cot', ['cot_id'], ['id'], ondelete='CASCADE')
        batch_op.create_foreign_key('casevac_eud', 'euds', ['sender_uid'], ['uid'], ondelete='CASCADE')
        batch_op.create_foreign_key('casevac_point', 'points', ['point_id'], ['id'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('certificates', schema=None) as batch_op:
            batch_op.drop_constraint('certificate_eud', type_='foreignkey')
    except BaseException as e:
        print(f"Shit failed {e}")

    with op.batch_alter_table('certificates', schema=None) as batch_op:
        batch_op.create_foreign_key('certificate_eud', 'euds', ['eud_uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('markers', schema=None) as batch_op:
            batch_op.drop_constraint('marker_cot', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('markers', schema=None) as batch_op:
            batch_op.drop_constraint('marker_point', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('markers', schema=None) as batch_op:
            batch_op.drop_constraint('marker_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('markers', schema=None) as batch_op:
        batch_op.create_foreign_key('markers_cot', 'cot', ['cot_id'], ['id'], ondelete='CASCADE')
        batch_op.create_foreign_key('markers_eud', 'euds', ['parent_uid'], ['uid'], ondelete='CASCADE')
        batch_op.create_foreign_key('markers_point', 'points', ['point_id'], ['id'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('points', schema=None) as batch_op:
            batch_op.drop_constraint('point_cot', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('points', schema=None) as batch_op:
            batch_op.drop_constraint('point_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('points', schema=None) as batch_op:
        batch_op.create_foreign_key('point_cot', 'cot', ['cot_id'], ['id'], ondelete='CASCADE')
        batch_op.create_foreign_key('point_eud', 'euds', ['device_uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('rb_lines', schema=None) as batch_op:
            batch_op.drop_constraint('rb_line_cot', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('rb_lines', schema=None) as batch_op:
            batch_op.drop_constraint('rb_line_point', type_='foreignkey')
    except:
        pass

    try:
        with op.batch_alter_table('rb_lines', schema=None) as batch_op:
            batch_op.drop_constraint('rb_line_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('rb_lines', schema=None) as batch_op:
        batch_op.create_foreign_key('rb_line_cot', 'cot', ['cot_id'], ['id'], ondelete='CASCADE')
        batch_op.create_foreign_key('rb_line_eud', 'euds', ['sender_uid'], ['uid'], ondelete='CASCADE')
        batch_op.create_foreign_key('rb_line_point', 'points', ['point_id'], ['id'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('zmist', schema=None) as batch_op:
            batch_op.drop_constraint('zmist_casevac', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('zmist', schema=None) as batch_op:
        batch_op.create_foreign_key('zmist_casevac', 'casevac', ['casevac_uid'], ['uid'], ondelete='CASCADE')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('zmist', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key(None, 'casevac', ['casevac_uid'], ['uid'])

    with op.batch_alter_table('rb_lines', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key(None, 'euds', ['sender_uid'], ['uid'])
        batch_op.create_foreign_key(None, 'cot', ['cot_id'], ['id'])
        batch_op.create_foreign_key(None, 'points', ['point_id'], ['id'])

    with op.batch_alter_table('points', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key(None, 'cot', ['cot_id'], ['id'])
        batch_op.create_foreign_key(None, 'euds', ['device_uid'], ['uid'])

    with op.batch_alter_table('markers', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key(None, 'cot', ['cot_id'], ['id'])
        batch_op.create_foreign_key(None, 'points', ['point_id'], ['id'])
        batch_op.create_foreign_key(None, 'euds', ['parent_uid'], ['uid'])

    with op.batch_alter_table('certificates', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key(None, 'euds', ['eud_uid'], ['uid'])

    with op.batch_alter_table('casevac', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key(None, 'cot', ['cot_id'], ['id'])
        batch_op.create_foreign_key(None, 'points', ['point_id'], ['id'])
        batch_op.create_foreign_key(None, 'euds', ['sender_uid'], ['uid'])

    with op.batch_alter_table('apscheduler_jobs', schema=None) as batch_op:
        batch_op.alter_column('id',
               existing_type=sa.String(length=255),
               type_=sa.VARCHAR(length=191),
               existing_nullable=False)

    with op.batch_alter_table('alerts', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key(None, 'points', ['point_id'], ['id'])
        batch_op.create_foreign_key(None, 'cot', ['cot_id'], ['id'])
        batch_op.create_foreign_key(None, 'euds', ['sender_uid'], ['uid'])

    # ### end Alembic commands ###
