"""Initial Migration

Revision ID: 4c7909c34d4e
Revises: 
Create Date: 2024-05-24 04:08:57.447120

"""
from alembic import op
import sqlalchemy as sa
import flask_security
import logging
logger = logging.getLogger('OpenTAKServer')
logger.disabled = False


# revision identifiers, used by Alembic.
revision = '4c7909c34d4e'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('chatrooms',
    sa.Column('id', sa.String(length=255), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('group_owner', sa.String(length=255), nullable=True),
    sa.Column('parent', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )

    op.create_table('icons',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('iconset_uid', sa.String(length=255), nullable=True),
    sa.Column('filename', sa.String(length=255), nullable=True),
    sa.Column('groupName', sa.String(length=255), nullable=True),
    sa.Column('type2525b', sa.String(length=255), nullable=True),
    sa.Column('useCnt', sa.Integer(), nullable=True),
    sa.Column('bitmap', sa.LargeBinary(), nullable=True),
    sa.Column('shadow', sa.LargeBinary(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )

    op.create_table('role',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=80), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.Column('permissions', flask_security.datastore.AsaList(), nullable=True),
    sa.Column('update_datetime', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )

    op.create_table('user',
    sa.Column('email', sa.String(length=255), nullable=True),
    sa.Column('fs_webauthn_user_handle', sa.String(length=64), nullable=True),
    sa.Column('mf_recovery_codes', flask_security.datastore.AsaList(), nullable=True),
    sa.Column('password', sa.String(length=255), nullable=True),
    sa.Column('us_phone_number', sa.String(length=128), nullable=True),
    sa.Column('username', sa.String(length=255), nullable=True),
    sa.Column('us_totp_secrets', sa.Text(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('active', sa.Boolean(), nullable=False),
    sa.Column('fs_uniquifier', sa.String(length=64), nullable=False),
    sa.Column('confirmed_at', sa.DateTime(), nullable=True),
    sa.Column('last_login_at', sa.DateTime(), nullable=True),
    sa.Column('current_login_at', sa.DateTime(), nullable=True),
    sa.Column('last_login_ip', sa.String(length=64), nullable=True),
    sa.Column('current_login_ip', sa.String(length=64), nullable=True),
    sa.Column('login_count', sa.Integer(), nullable=True),
    sa.Column('tf_primary_method', sa.String(length=64), nullable=True),
    sa.Column('tf_totp_secret', sa.String(length=255), nullable=True),
    sa.Column('tf_phone_number', sa.String(length=128), nullable=True),
    sa.Column('create_datetime', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('update_datetime', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('fs_uniquifier'),
    sa.UniqueConstraint('fs_webauthn_user_handle'),
    sa.UniqueConstraint('us_phone_number'),
    sa.UniqueConstraint('username')
    )

    op.create_table('roles_users',
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('role_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['role.id'], name="role"),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], name="user")
    )

    op.create_table('teams',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('chatroom_id', sa.String(length=255), nullable=True),
    sa.ForeignKeyConstraint(['chatroom_id'], ['chatrooms.id'], name="team_chatroom"),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )

    op.create_table('web_authn',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('credential_id', sa.LargeBinary(length=1024), nullable=False),
    sa.Column('public_key', sa.LargeBinary(), nullable=False),
    sa.Column('sign_count', sa.Integer(), nullable=True),
    sa.Column('transports', flask_security.datastore.AsaList(), nullable=True),
    sa.Column('backup_state', sa.Boolean(), nullable=False),
    sa.Column('device_type', sa.String(length=64), nullable=False),
    sa.Column('extensions', sa.String(length=255), nullable=True),
    sa.Column('create_datetime', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('lastuse_datetime', sa.DateTime(), nullable=False),
    sa.Column('name', sa.String(length=64), nullable=False),
    sa.Column('usage', sa.String(length=64), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], name="web_authn_user", ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('web_authn', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_web_authn_credential_id'), ['credential_id'], unique=True)

    op.create_table('euds',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('callsign', sa.String(length=255), unique=True),
    sa.Column('device', sa.String(length=255), nullable=True),
    sa.Column('os', sa.String(length=255), nullable=True),
    sa.Column('platform', sa.String(length=255), nullable=True),
    sa.Column('version', sa.String(length=255), nullable=True),
    sa.Column('phone_number', sa.Integer(), nullable=True),
    sa.Column('last_event_time', sa.DateTime(), nullable=True),
    sa.Column('last_status', sa.String(length=255), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('team_id', sa.Integer(), nullable=True),
    sa.Column('team_role', sa.String(length=255), nullable=True),
    sa.ForeignKeyConstraint(['team_id'], ['teams.id'], name="eud_team"),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], name="eud_user"),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uid')
    )

    op.create_table('chatrooms_uids',
    sa.Column('chatroom_id', sa.String(length=255), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['chatroom_id'], ['chatrooms.id'], name="chatroom_uids"),
    sa.ForeignKeyConstraint(['uid'], ['euds.uid'], name="chatroom_eud"),
    sa.PrimaryKeyConstraint('chatroom_id', 'uid')
    )

    op.create_table('cot',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('how', sa.String(length=255), nullable=True),
    sa.Column('type', sa.String(length=255), nullable=True),
    sa.Column('sender_callsign', sa.String(length=255), nullable=False),
    sa.Column('sender_device_name', sa.String(length=255), nullable=True),
    sa.Column('sender_uid', sa.String(length=255), nullable=True),
    sa.Column('recipients', sa.JSON(), nullable=True),
    sa.Column('timestamp', sa.DateTime(), nullable=False),
    sa.Column('start', sa.DateTime(), nullable=False),
    sa.Column('stale', sa.DateTime(), nullable=False),
    sa.Column('xml', sa.TEXT, nullable=False),
    sa.ForeignKeyConstraint(['sender_uid'], ['euds.uid'], name="cot_eud"),
    sa.PrimaryKeyConstraint('id')
    )

    op.create_table('data_packages',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('filename', sa.String(length=255), nullable=False),
    sa.Column('hash', sa.String(length=255), nullable=False),
    sa.Column('creator_uid', sa.String(length=255), nullable=False),
    sa.Column('submission_time', sa.DateTime(), nullable=False),
    sa.Column('submission_user', sa.Integer(), nullable=True),
    sa.Column('keywords', sa.String(length=255), nullable=True),
    sa.Column('mime_type', sa.String(length=255), nullable=False),
    sa.Column('size', sa.Integer(), nullable=False),
    sa.Column('tool', sa.String(length=255), nullable=True),
    sa.Column('expiration', sa.String(length=255), nullable=True),
    sa.ForeignKeyConstraint(['creator_uid'], ['euds.uid'], name="data_packages_eud"),
    sa.ForeignKeyConstraint(['submission_user'], ['user.id'], name="data_packages_user"),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('filename'),
    sa.UniqueConstraint('hash')
    )

    op.create_table('certificates',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('common_name', sa.String(length=255), nullable=False),
    sa.Column('eud_uid', sa.String(length=255), nullable=True),
    sa.Column('data_package_id', sa.Integer(), nullable=True),
    sa.Column('callsign', sa.String(length=255), nullable=True),
    sa.Column('username', sa.String(length=255), nullable=True),
    sa.Column('expiration_date', sa.DateTime(), nullable=False),
    sa.Column('server_address', sa.String(length=255), nullable=False),
    sa.Column('server_port', sa.Integer(), nullable=False),
    sa.Column('truststore_filename', sa.String(length=255), nullable=False),
    sa.Column('user_cert_filename', sa.String(length=255), nullable=False),
    sa.Column('csr', sa.String(length=255), nullable=True),
    sa.Column('cert_password', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['data_package_id'], ['data_packages.id'], name="certificate_data_package"),
    sa.ForeignKeyConstraint(['eud_uid'], ['euds.uid'], name="certificate_eud"),
    sa.ForeignKeyConstraint(['username'], ['user.username'], name="certificate_user"),
    sa.PrimaryKeyConstraint('id')
    )

    op.create_table('points',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('device_uid', sa.String(length=255), nullable=False),
    sa.Column('latitude', sa.Float(), nullable=True),
    sa.Column('longitude', sa.Float(), nullable=True),
    sa.Column('ce', sa.Float(), nullable=True),
    sa.Column('hae', sa.Float(), nullable=True),
    sa.Column('le', sa.Float(), nullable=True),
    sa.Column('course', sa.Float(), nullable=True),
    sa.Column('speed', sa.Float(), nullable=True),
    sa.Column('location_source', sa.String(length=255), nullable=True),
    sa.Column('battery', sa.Float(), nullable=True),
    sa.Column('timestamp', sa.DateTime(), nullable=False),
    sa.Column('azimuth', sa.Float(), nullable=True),
    sa.Column('fov', sa.Float(), nullable=True),
    sa.Column('cot_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['cot_id'], ['cot.id'], name="point_cot"),
    sa.ForeignKeyConstraint(['device_uid'], ['euds.uid'], name="point_eud"),
    sa.PrimaryKeyConstraint('id')
    )

    op.create_table('video_streams',
    sa.Column('path', sa.String(length=255), nullable=False),
    sa.Column('protocol', sa.String(length=255), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('network_timeout', sa.Integer(), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=True),
    sa.Column('buffer_time', sa.Integer(), nullable=True),
    sa.Column('rover_port', sa.Integer(), nullable=True),
    sa.Column('rtsp_reliable', sa.Integer(), nullable=True),
    sa.Column('ignore_embedded_klv', sa.Boolean(), nullable=True),
    sa.Column('alias', sa.String(length=255), nullable=True),
    sa.Column('preferred_mac_address', sa.String(length=255), nullable=True),
    sa.Column('preferred_interface_address', sa.String(length=255), nullable=True),
    sa.Column('username', sa.String(length=255), nullable=True),
    sa.Column('xml', sa.String(length=255), nullable=True),
    sa.Column('ready', sa.Boolean(), nullable=False),
    sa.Column('mediamtx_settings', sa.String(length=255), nullable=False),
    sa.Column('cot_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['cot_id'], ['cot.id'], name="video_stream_cot"),
    sa.ForeignKeyConstraint(['username'], ['user.username'], name="video_stream_user"),
    sa.PrimaryKeyConstraint('path')
    )

    op.create_table('alerts',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('sender_uid', sa.String(length=255), nullable=False),
    sa.Column('start_time', sa.DateTime(), nullable=False),
    sa.Column('cancel_time', sa.DateTime(), nullable=True),
    sa.Column('alert_type', sa.String(length=255), nullable=False),
    sa.Column('point_id', sa.Integer(), nullable=True),
    sa.Column('cot_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['cot_id'], ['cot.id'], name="alert_cot"),
    sa.ForeignKeyConstraint(['point_id'], ['points.id'], name="alert_point"),
    sa.ForeignKeyConstraint(['sender_uid'], ['euds.uid'], name="alert_eud"),
    sa.PrimaryKeyConstraint('id')
    )

    op.create_table('casevac',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('sender_uid', sa.String(length=255), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('timestamp', sa.DateTime(), nullable=False),
    sa.Column('ambulatory', sa.Integer(), nullable=True),
    sa.Column('casevac', sa.Boolean(), nullable=True),
    sa.Column('child', sa.Integer(), nullable=True),
    sa.Column('enemy', sa.String(length=255), nullable=True),
    sa.Column('epw', sa.Integer(), nullable=True),
    sa.Column('equipment_detail', sa.String(length=255), nullable=True),
    sa.Column('equipment_none', sa.Boolean(), nullable=True),
    sa.Column('equipment_other', sa.Boolean(), nullable=True),
    sa.Column('extraction_equipment', sa.Boolean(), nullable=True),
    sa.Column('freq', sa.Float(), nullable=True),
    sa.Column('friendlies', sa.String(length=255), nullable=True),
    sa.Column('hlz_marking', sa.Integer(), nullable=True),
    sa.Column('hlz_remarks', sa.String(length=255), nullable=True),
    sa.Column('hoist', sa.Boolean(), nullable=True),
    sa.Column('litter', sa.Integer(), nullable=True),
    sa.Column('marked_by', sa.String(length=255), nullable=True),
    sa.Column('medline_remarks', sa.String(length=255), nullable=True),
    sa.Column('nonus_civilian', sa.Integer(), nullable=True),
    sa.Column('nonus_military', sa.Integer(), nullable=True),
    sa.Column('obstacles', sa.String(length=255), nullable=True),
    sa.Column('priority', sa.Integer(), nullable=True),
    sa.Column('routine', sa.Integer(), nullable=True),
    sa.Column('security', sa.Integer(), nullable=True),
    sa.Column('terrain_loose', sa.Boolean(), nullable=True),
    sa.Column('terrain_other', sa.Boolean(), nullable=True),
    sa.Column('terrain_other_detail', sa.String(length=255), nullable=True),
    sa.Column('terrain_detail', sa.String(length=255), nullable=True),
    sa.Column('terrain_none', sa.Boolean(), nullable=True),
    sa.Column('terrain_rough', sa.Boolean(), nullable=True),
    sa.Column('terrain_slope', sa.Boolean(), nullable=True),
    sa.Column('terrain_slope_dir', sa.String(length=255), nullable=True),
    sa.Column('title', sa.String(length=255), nullable=False),
    sa.Column('urgent', sa.Integer(), nullable=True),
    sa.Column('us_civilian', sa.Integer(), nullable=True),
    sa.Column('us_military', sa.Integer(), nullable=True),
    sa.Column('ventilator', sa.Boolean(), nullable=True),
    sa.Column('winds_are_from', sa.String(length=255), nullable=True),
    sa.Column('zone_prot_selection', sa.Integer(), nullable=True),
    sa.Column('point_id', sa.Integer(), nullable=True),
    sa.Column('cot_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['cot_id'], ['cot.id'], name="casevac_cot"),
    sa.ForeignKeyConstraint(['point_id'], ['points.id'], name="casevac_point"),
    sa.ForeignKeyConstraint(['sender_uid'], ['euds.uid'], name="casevac_eud"),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uid')
    )

    op.create_table('geochat',
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('chatroom_id', sa.String(length=255), nullable=False),
    sa.Column('sender_uid', sa.String(length=255), nullable=False),
    sa.Column('remarks', sa.String(length=255), nullable=False),
    sa.Column('timestamp', sa.DateTime(), nullable=False),
    sa.Column('point_id', sa.Integer(), nullable=False),
    sa.Column('cot_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['chatroom_id'], ['chatrooms.id'], name="geochat_chatroom"),
    sa.ForeignKeyConstraint(['cot_id'], ['cot.id'], name="geochat_cot"),
    sa.ForeignKeyConstraint(['point_id'], ['points.id'], name="geochat_point"),
    sa.ForeignKeyConstraint(['sender_uid'], ['euds.uid'], name="geochat_eud"),
    sa.PrimaryKeyConstraint('uid')
    )

    op.create_table('markers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('affiliation', sa.String(length=255), nullable=True),
    sa.Column('battle_dimension', sa.String(length=255), nullable=True),
    sa.Column('point_id', sa.Integer(), nullable=False),
    sa.Column('callsign', sa.String(length=255), nullable=True),
    sa.Column('readiness', sa.Boolean(), nullable=True),
    sa.Column('argb', sa.Integer(), nullable=True),
    sa.Column('color_hex', sa.String(length=255), nullable=True),
    sa.Column('iconset_path', sa.String(length=255), nullable=True),
    sa.Column('parent_callsign', sa.String(length=255), nullable=True),
    sa.Column('production_time', sa.String(length=255), nullable=True),
    sa.Column('relation', sa.String(length=255), nullable=True),
    sa.Column('relation_type', sa.String(length=255), nullable=True),
    sa.Column('location_source', sa.String(length=255), nullable=True),
    sa.Column('icon_id', sa.Integer(), nullable=True),
    sa.Column('parent_uid', sa.String(length=255), nullable=True),
    sa.Column('remarks', sa.String(length=255), nullable=True),
    sa.Column('cot_id', sa.Integer(), nullable=True),
    sa.Column('mil_std_2525c', sa.String(length=255), nullable=True),
    sa.ForeignKeyConstraint(['cot_id'], ['cot.id'], name="marker_cot"),
    sa.ForeignKeyConstraint(['icon_id'], ['icons.id'], name="marker_icon"),
    sa.ForeignKeyConstraint(['parent_uid'], ['euds.uid'], name="marker_eud"),
    sa.ForeignKeyConstraint(['point_id'], ['points.id'], name="marker_point"),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uid')
    )

    op.create_table('rb_lines',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('sender_uid', sa.String(length=255), nullable=False),
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('timestamp', sa.DateTime(), nullable=False),
    sa.Column('range', sa.Float(), nullable=False),
    sa.Column('bearing', sa.Float(), nullable=False),
    sa.Column('inclination', sa.Float(), nullable=True),
    sa.Column('anchor_uid', sa.String(length=255), nullable=True),
    sa.Column('range_units', sa.Integer(), nullable=True),
    sa.Column('bearing_units', sa.Integer(), nullable=True),
    sa.Column('north_ref', sa.Integer(), nullable=True),
    sa.Column('color', sa.Integer(), nullable=True),
    sa.Column('color_hex', sa.String(length=255), nullable=True),
    sa.Column('callsign', sa.String(length=255), nullable=True),
    sa.Column('stroke_color', sa.Integer(), nullable=True),
    sa.Column('stroke_weight', sa.Float(), nullable=True),
    sa.Column('stroke_style', sa.String(length=255), nullable=True),
    sa.Column('labels_on', sa.Boolean(), nullable=True),
    sa.Column('point_id', sa.Integer(), nullable=True),
    sa.Column('cot_id', sa.Integer(), nullable=True),
    sa.Column('end_latitude', sa.Float(), nullable=True),
    sa.Column('end_longitude', sa.Float(), nullable=True),
    sa.ForeignKeyConstraint(['cot_id'], ['cot.id'], name="rb_line_cot"),
    sa.ForeignKeyConstraint(['point_id'], ['points.id'], name="rb_line_point"),
    sa.ForeignKeyConstraint(['sender_uid'], ['euds.uid'], name="rb_line_eud"),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uid')
    )

    op.create_table('video_recordings',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('segment_path', sa.String(length=255), nullable=False),
    sa.Column('path', sa.String(length=255), nullable=False),
    sa.Column('in_progress', sa.Boolean(), nullable=False),
    sa.Column('start_time', sa.DateTime(), nullable=True),
    sa.Column('stop_time', sa.DateTime(), nullable=True),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('width', sa.Integer(), nullable=True),
    sa.Column('height', sa.Integer(), nullable=True),
    sa.Column('video_codec', sa.String(length=255), nullable=True),
    sa.Column('video_bitrate', sa.Integer(), nullable=True),
    sa.Column('audio_codec', sa.String(length=255), nullable=True),
    sa.Column('audio_bitrate', sa.Integer(), nullable=True),
    sa.Column('audio_samplerate', sa.Integer(), nullable=True),
    sa.Column('audio_channels', sa.Integer(), nullable=True),
    sa.Column('file_size', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['path'], ['video_streams.path'], name="video_recording_video_stream"),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('segment_path')
    )

    op.create_table('zmist',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('i', sa.String(length=255), nullable=True),
    sa.Column('m', sa.String(length=255), nullable=True),
    sa.Column('s', sa.String(length=255), nullable=True),
    sa.Column('t', sa.String(length=255), nullable=True),
    sa.Column('title', sa.String(length=255), nullable=True),
    sa.Column('z', sa.Integer(), nullable=True),
    sa.Column('casevac_uid', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['casevac_uid'], ['casevac.uid'], name="zmist_casevac"),
    sa.PrimaryKeyConstraint('id')
    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('zmist')
    op.drop_table('video_recordings')
    op.drop_table('rb_lines')
    op.drop_table('markers')
    op.drop_table('geochat')
    op.drop_table('casevac')
    op.drop_table('alerts')
    op.drop_table('video_streams')
    op.drop_table('points')
    op.drop_table('certificates')
    op.drop_table('data_packages')
    op.drop_table('cot')
    op.drop_table('chatrooms_uids')
    op.drop_table('euds')
    with op.batch_alter_table('web_authn', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_web_authn_credential_id'))

    op.drop_table('web_authn')
    op.drop_table('teams')
    op.drop_table('roles_users')
    op.drop_table('user')
    op.drop_table('role')
    op.drop_table('icons')
    op.drop_table('chatrooms')
    # ### end Alembic commands ###
