"""Set install on enrollment and connection to nullable

Revision ID: 6af2256c568d
Revises: 34d5df698b81
Create Date: 2024-09-20 20:17:28.926142

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '6af2256c568d'
down_revision = '34d5df698b81'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.alter_column('install_on_enrollment',
               existing_type=sa.BOOLEAN(),
               nullable=True)
        batch_op.alter_column('install_on_connection',
               existing_type=sa.BOOLEAN(),
               nullable=True)

    with op.batch_alter_table('device_profiles', schema=None) as batch_op:
        batch_op.alter_column('enrollment',
               existing_type=sa.BOOLEAN(),
               nullable=True)
        batch_op.alter_column('connection',
               existing_type=sa.BOOLEAN(),
               nullable=True)
        try:
            batch_op.drop_column('id')
        except BaseException as e:
            print(f"Failed to drop euds.id column: {e}")
            pass

    with op.batch_alter_table('packages', schema=None) as batch_op:
        batch_op.alter_column('install_on_enrollment',
               existing_type=sa.BOOLEAN(),
               nullable=True)
        batch_op.alter_column('install_on_connection',
               existing_type=sa.BOOLEAN(),
               nullable=True)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('packages', schema=None) as batch_op:
        batch_op.alter_column('install_on_connection',
               existing_type=sa.BOOLEAN(),
               nullable=False)
        batch_op.alter_column('install_on_enrollment',
               existing_type=sa.BOOLEAN(),
               nullable=False)

    with op.batch_alter_table('device_profiles', schema=None) as batch_op:
        batch_op.add_column(sa.Column('id', sa.INTEGER(), nullable=False))
        batch_op.alter_column('connection',
               existing_type=sa.BOOLEAN(),
               nullable=False)
        batch_op.alter_column('enrollment',
               existing_type=sa.BOOLEAN(),
               nullable=False)

    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.alter_column('install_on_connection',
               existing_type=sa.BOOLEAN(),
               nullable=False)
        batch_op.alter_column('install_on_enrollment',
               existing_type=sa.BOOLEAN(),
               nullable=False)

    # ### end Alembic commands ###
