"""More cascades

Revision ID: 795ebb9262d8
Revises: 2b5bddd207ae
Create Date: 2024-11-07 19:14:25.263371

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '795ebb9262d8'
down_revision = '2b5bddd207ae'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        with op.batch_alter_table('certificates', schema=None) as batch_op:
            batch_op.drop_constraint('certificate_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('certificates', schema=None) as batch_op:
        batch_op.create_foreign_key('certificate_eud', 'euds', ['eud_uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('chatrooms_uids', schema=None) as batch_op:
            batch_op.drop_constraint('chatroom_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('chatrooms_uids', schema=None) as batch_op:
        batch_op.create_foreign_key('chatroom_eud', 'euds', ['uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('cot', schema=None) as batch_op:
            batch_op.drop_constraint('cot_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('cot', schema=None) as batch_op:
        batch_op.create_foreign_key('cot_eud', 'euds', ['sender_uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('data_packages', schema=None) as batch_op:
            batch_op.drop_constraint('data_packages_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.create_foreign_key('data_packages_eud', 'euds', ['creator_uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('geochat', schema=None) as batch_op:
            batch_op.drop_constraint('geochat_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('geochat', schema=None) as batch_op:
        batch_op.create_foreign_key('geochat_eud', 'euds', ['sender_uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('groups_euds', schema=None) as batch_op:
            batch_op.drop_constraint('group_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('groups_euds', schema=None) as batch_op:
        batch_op.create_foreign_key('group_eud', 'euds', ['eud_uid'], ['uid'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('mission_invitations', schema=None) as batch_op:
            batch_op.drop_constraint('mission_invitation_callsign', type_='foreignkey')
            batch_op.drop_constraint('mission_invitation_eud', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('mission_invitations', schema=None) as batch_op:
        batch_op.create_foreign_key('mission_invitation_eud', 'euds', ['client_uid'], ['uid'], ondelete='CASCADE')
        batch_op.create_foreign_key('mission_invitation_callsign', 'euds', ['callsign'], ['callsign'], ondelete='CASCADE')

    try:
        with op.batch_alter_table('missions', schema=None) as batch_op:
            batch_op.drop_constraint('mission_creator', type_='foreignkey')
    except:
        pass

    with op.batch_alter_table('missions', schema=None) as batch_op:
        batch_op.create_foreign_key('mission_creator', 'euds', ['creator_uid'], ['uid'], ondelete='CASCADE')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('missions', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('mission_creator', 'euds', ['creator_uid'], ['uid'])

    with op.batch_alter_table('mission_invitations', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('mission_invitation_eud', 'euds', ['client_uid'], ['uid'])
        batch_op.create_foreign_key('mission_invitation_callsign', 'euds', ['callsign'], ['callsign'])

    with op.batch_alter_table('groups_euds', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('group_eud', 'euds', ['eud_uid'], ['uid'])

    with op.batch_alter_table('geochat', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('geochat_eud', 'euds', ['sender_uid'], ['uid'])

    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('data_packages_eud', 'euds', ['creator_uid'], ['uid'])

    with op.batch_alter_table('cot', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('cot_eud', 'euds', ['sender_uid'], ['uid'])

    with op.batch_alter_table('chatrooms_uids', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('chatroom_eud', 'euds', ['uid'], ['uid'])

    with op.batch_alter_table('certificates', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.create_foreign_key('certificate_eud', 'euds', ['eud_uid'], ['uid'])

    # ### end Alembic commands ###
