"""Changed phone_number column to BigInteger for MySQL compatibility

Revision ID: 7e9f5d2c193d
Revises: 8787888a028f
Create Date: 2024-10-25 17:37:42.637254

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '7e9f5d2c193d'
down_revision = '8787888a028f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('euds', schema=None) as batch_op:
        batch_op.alter_column('callsign',
               existing_type=sa.String(length=255),
               nullable=True)
        batch_op.alter_column('phone_number',
               existing_type=sa.INTEGER(),
               type_=sa.BigInteger(),
               existing_nullable=True)
    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.alter_column('creator_uid',
              existing_type=sa.String(length=255),
              nullable=True)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('euds', schema=None) as batch_op:
        batch_op.alter_column('phone_number',
               existing_type=sa.BigInteger(),
               type_=sa.INTEGER(),
               existing_nullable=True)
        batch_op.alter_column('callsign',
               existing_type=sa.String(length=255),
               nullable=True)
    with op.batch_alter_table('data_packages', schema=None) as batch_op:
        batch_op.alter_column('creator_uid',
              existing_type=sa.String(length=255),
              nullable=False)

    # ### end Alembic commands ###
