"""Added mission_uids table

Revision ID: 807c3ca8e7d0
Revises: bde915ea136e
Create Date: 2024-10-11 16:53:44.954118

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision = '807c3ca8e7d0'
down_revision = 'bde915ea136e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('mission_uids',
    sa.Column('uid', sa.String(length=255), nullable=False),
    sa.Column('mission_name', sa.String(length=255), nullable=True),
    sa.Column('timestamp', sa.DateTime(), nullable=True),
    sa.Column('creator_uid', sa.String(length=255), nullable=True),
    sa.Column('cot_type', sa.String(length=255), nullable=True),
    sa.Column('callsign', sa.String(length=255), nullable=True),
    sa.Column('iconset_path', sa.String(length=255), nullable=True),
    sa.Column('color', sa.String(length=255), nullable=True),
    sa.Column('latitude', sa.Float(), nullable=True),
    sa.Column('longitude', sa.Float(), nullable=True),
    sa.ForeignKeyConstraint(['mission_name'], ['missions.name'], ),
    sa.PrimaryKeyConstraint('uid')
    )
    op.drop_table('mission_logs')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('mission_logs',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('content', sa.String(length=255), nullable=False),
    sa.Column('creator_uid', sa.String(length=255), nullable=False),
    sa.Column('entry_uid', sa.String(length=255), nullable=False),
    sa.Column('server_time', sa.DATETIME(), nullable=False),
    sa.Column('dtg', sa.DATETIME(), nullable=False),
    sa.Column('created', sa.DATETIME(), nullable=False),
    sa.Column('keywords', sqlite.JSON(), nullable=False),
    sa.Column('mission_name', sa.String(length=255), nullable=True),
    sa.Column('content_hash', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_table('mission_uids')
    # ### end Alembic commands ###
