"""Fixes to support MariaDB

Revision ID: 8787888a028f
Revises: f6dfc571d31c
Create Date: 2024-10-25 15:44:27.370608

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '8787888a028f'
down_revision = 'f6dfc571d31c'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('cot', schema=None) as batch_op:
        batch_op.alter_column('xml',
               existing_type=sa.String(length=255),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('euds', schema=None) as batch_op:
        batch_op.alter_column('meshtastic_id',
               existing_type=sa.INTEGER(),
               type_=sa.BigInteger(),
               existing_nullable=True)

    with op.batch_alter_table('points', schema=None) as batch_op:
        batch_op.alter_column('device_uid',
              existing_type=sa.String(length=255),
              nullable=True)

    with op.batch_alter_table('missions', schema=None) as batch_op:
        batch_op.create_foreign_key('mission_creator', 'euds', ['creator_uid'], ['uid'])

    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.add_column(sa.Column('eud_uid', sa.String(length=255), nullable=False))
        batch_op.create_foreign_key('eud', 'euds', ['eud_uid'], ['uid'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('missions', schema=None) as batch_op:
        batch_op.drop_constraint('mission_creator', type_='foreignkey')

    with op.batch_alter_table('euds', schema=None) as batch_op:
        batch_op.alter_column('meshtastic_id',
               existing_type=sa.BigInteger(),
               type_=sa.INTEGER(),
               existing_nullable=True)

    with op.batch_alter_table('cot', schema=None) as batch_op:
        batch_op.alter_column('xml',
               existing_type=sa.TEXT(),
               type_=sa.String(length=255),
               existing_nullable=False)

    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.drop_constraint('eud', type_='foreignkey')
        batch_op.drop_column('eud_uid')

    with op.batch_alter_table('points', schema=None) as batch_op:
        batch_op.alter_column('device_uid',
              existing_type=sa.String(length=255),
              nullable=False)

    # ### end Alembic commands ###
