"""Added tokens table

Revision ID: d68964dab66b
Revises: b0c97a4ce0df
Create Date: 2025-05-07 02:26:29.670335

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'd68964dab66b'
down_revision = 'b0c97a4ce0df'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tokens',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('username', sa.String(length=255), nullable=True),
                    sa.Column('max_uses', sa.Integer(), nullable=True),
                    sa.Column('total_uses', sa.Integer(), nullable=True),
                    sa.Column('creation', sa.BigInteger(), nullable=False),
                    sa.Column('not_before', sa.BigInteger(), nullable=True),
                    sa.Column('expiration', sa.BigInteger(), nullable=True),
                    sa.Column('disabled', sa.Boolean(), nullable=True),
                    sa.Column('token_hash', sa.String(length=255), nullable=False),
                    sa.ForeignKeyConstraint(['username'], ['user.username'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('token_hash'),
                    sa.UniqueConstraint('username')
                    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    op.drop_table('tokens')
    # ### end Alembic commands ###
