"""Meshtastic Support

Revision ID: d91957bb59a0
Revises: 4c7909c34d4e
Create Date: 2024-05-24 04:16:20.765489

"""
from alembic import op
import sqlalchemy as sa
import logging
logger = logging.getLogger('OpenTAKServer')
logger.disabled = False


# revision identifiers, used by Alembic.
revision = 'd91957bb59a0'
down_revision = '4c7909c34d4e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        op.create_table('iconsets',
        sa.Column('id', sa.INTEGER(), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('uid', sa.String(length=255), nullable=True),
        sa.Column('version', sa.Integer(), nullable=True),
        sa.Column('defaultFriendly', sa.String(length=255), nullable=True),
        sa.Column('defaultHostile', sa.String(length=255), nullable=True),
        sa.Column('defaultNeutral', sa.String(length=255), nullable=True),
        sa.Column('defaultUnknown', sa.String(length=255), nullable=True),
        sa.Column('selectedGroup', sa.String(length=255), nullable=True),
        sa.PrimaryKeyConstraint('id')
        )
    except sa.exc.OperationalError:
        logger.warning('iconsets table already exists, skipping')

    try:
        op.create_table('meshtastic_channels',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('psk', sa.String(length=255), nullable=True),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('uplink_enabled', sa.Boolean(), nullable=False),
        sa.Column('downlink_enabled', sa.Boolean(), nullable=False),
        sa.Column('position_precision', sa.Integer(), nullable=False),
        sa.Column('lora_region', sa.Integer(), nullable=False),
        sa.Column('lora_hop_limit', sa.Integer(), nullable=False),
        sa.Column('lora_tx_enabled', sa.Boolean(), nullable=False),
        sa.Column('lora_tx_power', sa.Integer(), nullable=False),
        sa.Column('lora_sx126x_rx_boosted_gain', sa.Boolean(), nullable=False),
        sa.Column('modem_preset', sa.Integer(), nullable=False),
        sa.Column('url', sa.String(length=255), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('url')
        )

        with op.batch_alter_table('euds', schema=None) as batch_op:
            batch_op.add_column(sa.Column('meshtastic_id', sa.Integer(), nullable=True))
            batch_op.add_column(sa.Column('meshtastic_macaddr', sa.String(length=255), nullable=True))
    except sa.exc.OperationalError:
        logger.warning('Meshtastic table already exists, skipping')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table('euds', schema=None) as batch_op:
        batch_op.drop_column('meshtastic_macaddr')
        batch_op.drop_column('meshtastic_id')

    op.drop_table('meshtastic_channels')
    op.drop_table('iconsets')
    # ### end Alembic commands ###
