"""Fixes for the packages table, added group_eud table

Revision ID: f107b45529ba
Revises: 7e9f5d2c193d
Create Date: 2024-10-28 14:36:54.189219

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'f107b45529ba'
down_revision = '7e9f5d2c193d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('groups_euds',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('group_id', sa.Integer(), nullable=False),
    sa.Column('direction', sa.String(length=255), nullable=False),
    sa.Column('active', sa.Boolean(), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.Column('eud_uid', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['eud_uid'], ['euds.uid'], name="group_eud"),
    sa.ForeignKeyConstraint(['group_id'], ['groups.id'], name="group"),
    sa.PrimaryKeyConstraint('id')
    )

    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.drop_constraint('eud', type_='foreignkey')
        batch_op.drop_column('description')
        batch_op.drop_column('active')
        batch_op.drop_column('direction')
        batch_op.drop_column('eud_uid')

    with op.batch_alter_table('packages', schema=None) as batch_op:
        batch_op.alter_column('description',
               existing_type=sa.Integer(),
               type_=sa.String(length=255),
               existing_nullable=True)
        batch_op.alter_column('apk_hash',
               existing_type=sa.Integer(),
               type_=sa.String(length=255),
               existing_nullable=True)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('packages', schema=None) as batch_op:
        batch_op.alter_column('apk_hash',
               existing_type=sa.String(length=255),
               type_=sa.Integer(),
               existing_nullable=True)
        batch_op.alter_column('description',
               existing_type=sa.String(length=255),
               type_=sa.Integer(),
               existing_nullable=True)

    with op.batch_alter_table('groups', schema=None) as batch_op:
        batch_op.add_column(sa.Column('eud_uid', sa.String(length=255), nullable=False))
        batch_op.add_column(sa.Column('direction', sa.String(length=255), nullable=False))
        batch_op.add_column(sa.Column('active', sa.Boolean(), autoincrement=False, nullable=False))
        batch_op.add_column(sa.Column('description', sa.String(length=255), nullable=True))
        batch_op.create_foreign_key('eud', 'euds', ['eud_uid'], ['uid'])

    op.drop_table('groups_euds')
    # ### end Alembic commands ###
