# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'Oauth',
]

@pulumi.output_type
class Oauth(dict):
    def __init__(__self__, *,
                 oauth_identity_pool_id: _builtins.str,
                 oauth_external_access_token: Optional[_builtins.str] = None,
                 oauth_external_client_id: Optional[_builtins.str] = None,
                 oauth_external_client_secret: Optional[_builtins.str] = None,
                 oauth_external_token_scope: Optional[_builtins.str] = None,
                 oauth_external_token_url: Optional[_builtins.str] = None,
                 oauth_sts_token_expired_in_seconds: Optional[_builtins.str] = None):
        """
        :param _builtins.str oauth_identity_pool_id: OAuth identity pool id used for processing external token and exchange STS token, registered with Confluent Cloud.
        :param _builtins.str oauth_external_access_token: OAuth existing static access token already fetched from external Identity Provider.
        :param _builtins.str oauth_external_client_id: OAuth token application client id from external Identity Provider.
        :param _builtins.str oauth_external_client_secret: OAuth token application client secret from external Identity Provider.
        :param _builtins.str oauth_external_token_scope: OAuth client application scope, this is a required field when using Microsoft Azure Entra ID as the identity provider.
        :param _builtins.str oauth_external_token_url: OAuth token URL to fetch access token from external Identity Provider.
        :param _builtins.str oauth_sts_token_expired_in_seconds: OAuth STS access token expired in second from Confluent Cloud
        """
        pulumi.set(__self__, "oauth_identity_pool_id", oauth_identity_pool_id)
        if oauth_external_access_token is not None:
            pulumi.set(__self__, "oauth_external_access_token", oauth_external_access_token)
        if oauth_external_client_id is not None:
            pulumi.set(__self__, "oauth_external_client_id", oauth_external_client_id)
        if oauth_external_client_secret is not None:
            pulumi.set(__self__, "oauth_external_client_secret", oauth_external_client_secret)
        if oauth_external_token_scope is not None:
            pulumi.set(__self__, "oauth_external_token_scope", oauth_external_token_scope)
        if oauth_external_token_url is not None:
            pulumi.set(__self__, "oauth_external_token_url", oauth_external_token_url)
        if oauth_sts_token_expired_in_seconds is not None:
            pulumi.set(__self__, "oauth_sts_token_expired_in_seconds", oauth_sts_token_expired_in_seconds)

    @_builtins.property
    @pulumi.getter(name="oauthIdentityPoolId")
    def oauth_identity_pool_id(self) -> _builtins.str:
        """
        OAuth identity pool id used for processing external token and exchange STS token, registered with Confluent Cloud.
        """
        return pulumi.get(self, "oauth_identity_pool_id")

    @_builtins.property
    @pulumi.getter(name="oauthExternalAccessToken")
    def oauth_external_access_token(self) -> Optional[_builtins.str]:
        """
        OAuth existing static access token already fetched from external Identity Provider.
        """
        return pulumi.get(self, "oauth_external_access_token")

    @_builtins.property
    @pulumi.getter(name="oauthExternalClientId")
    def oauth_external_client_id(self) -> Optional[_builtins.str]:
        """
        OAuth token application client id from external Identity Provider.
        """
        return pulumi.get(self, "oauth_external_client_id")

    @_builtins.property
    @pulumi.getter(name="oauthExternalClientSecret")
    def oauth_external_client_secret(self) -> Optional[_builtins.str]:
        """
        OAuth token application client secret from external Identity Provider.
        """
        return pulumi.get(self, "oauth_external_client_secret")

    @_builtins.property
    @pulumi.getter(name="oauthExternalTokenScope")
    def oauth_external_token_scope(self) -> Optional[_builtins.str]:
        """
        OAuth client application scope, this is a required field when using Microsoft Azure Entra ID as the identity provider.
        """
        return pulumi.get(self, "oauth_external_token_scope")

    @_builtins.property
    @pulumi.getter(name="oauthExternalTokenUrl")
    def oauth_external_token_url(self) -> Optional[_builtins.str]:
        """
        OAuth token URL to fetch access token from external Identity Provider.
        """
        return pulumi.get(self, "oauth_external_token_url")

    @_builtins.property
    @pulumi.getter(name="oauthStsTokenExpiredInSeconds")
    def oauth_sts_token_expired_in_seconds(self) -> Optional[_builtins.str]:
        """
        OAuth STS access token expired in second from Confluent Cloud
        """
        return pulumi.get(self, "oauth_sts_token_expired_in_seconds")


