# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IpFilterArgs', 'IpFilter']

@pulumi.input_type
class IpFilterArgs:
    def __init__(__self__, *,
                 filter_name: pulumi.Input[_builtins.str],
                 ip_groups: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 resource_group: pulumi.Input[_builtins.str],
                 operation_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IpFilter resource.
        :param pulumi.Input[_builtins.str] filter_name: A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_groups: A list of IP Groups.
        :param pulumi.Input[_builtins.str] resource_group: Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operation_groups: Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        :param pulumi.Input[_builtins.str] resource_scope: A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        pulumi.set(__self__, "filter_name", filter_name)
        pulumi.set(__self__, "ip_groups", ip_groups)
        pulumi.set(__self__, "resource_group", resource_group)
        if operation_groups is not None:
            pulumi.set(__self__, "operation_groups", operation_groups)
        if resource_scope is not None:
            pulumi.set(__self__, "resource_scope", resource_scope)

    @_builtins.property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> pulumi.Input[_builtins.str]:
        """
        A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        """
        return pulumi.get(self, "filter_name")

    @filter_name.setter
    def filter_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_name", value)

    @_builtins.property
    @pulumi.getter(name="ipGroups")
    def ip_groups(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of IP Groups.
        """
        return pulumi.get(self, "ip_groups")

    @ip_groups.setter
    def ip_groups(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ip_groups", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Input[_builtins.str]:
        """
        Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="operationGroups")
    def operation_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        """
        return pulumi.get(self, "operation_groups")

    @operation_groups.setter
    def operation_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "operation_groups", value)

    @_builtins.property
    @pulumi.getter(name="resourceScope")
    def resource_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        return pulumi.get(self, "resource_scope")

    @resource_scope.setter
    def resource_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_scope", value)


@pulumi.input_type
class _IpFilterState:
    def __init__(__self__, *,
                 filter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 operation_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpFilter resources.
        :param pulumi.Input[_builtins.str] filter_name: A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_groups: A list of IP Groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operation_groups: Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        :param pulumi.Input[_builtins.str] resource_group: Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        :param pulumi.Input[_builtins.str] resource_scope: A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        if filter_name is not None:
            pulumi.set(__self__, "filter_name", filter_name)
        if ip_groups is not None:
            pulumi.set(__self__, "ip_groups", ip_groups)
        if operation_groups is not None:
            pulumi.set(__self__, "operation_groups", operation_groups)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_scope is not None:
            pulumi.set(__self__, "resource_scope", resource_scope)

    @_builtins.property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        """
        return pulumi.get(self, "filter_name")

    @filter_name.setter
    def filter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_name", value)

    @_builtins.property
    @pulumi.getter(name="ipGroups")
    def ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP Groups.
        """
        return pulumi.get(self, "ip_groups")

    @ip_groups.setter
    def ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_groups", value)

    @_builtins.property
    @pulumi.getter(name="operationGroups")
    def operation_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        """
        return pulumi.get(self, "operation_groups")

    @operation_groups.setter
    def operation_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "operation_groups", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="resourceScope")
    def resource_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        return pulumi.get(self, "resource_scope")

    @resource_scope.setter
    def resource_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_scope", value)


@pulumi.type_token("confluentcloud:index/ipFilter:IpFilter")
class IpFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 operation_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `IpFilter` provides an IP Filter resource that enables creating, editing, and deleting IP Filters on Confluent Cloud.

        > **Note:** See [IP Filtering on Confluent Cloud](https://docs.confluent.io/cloud/current/security/access-control/ip-filtering/overview.html) for more details about the IP Filtering feature, its prerequisites, and its limitations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        management_filter = confluentcloud.IpFilter("management-filter",
            filter_name="Management API Rules",
            resource_group="management",
            ip_groups=[example["id"]])
        multiple_filter = confluentcloud.IpFilter("multiple-filter",
            filter_name="Management, Schema, Flink API Rules",
            resource_group="multiple",
            operation_groups=[
                "MANAGEMENT",
                "SCHEMA",
                "FLINK",
            ],
            ip_groups=[example["id"]])
        ```

        ## Import

        You can import an IP Filter by using IP Filter ID, for example:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/ipFilter:IpFilter example ipf-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] filter_name: A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_groups: A list of IP Groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operation_groups: Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        :param pulumi.Input[_builtins.str] resource_group: Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        :param pulumi.Input[_builtins.str] resource_scope: A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `IpFilter` provides an IP Filter resource that enables creating, editing, and deleting IP Filters on Confluent Cloud.

        > **Note:** See [IP Filtering on Confluent Cloud](https://docs.confluent.io/cloud/current/security/access-control/ip-filtering/overview.html) for more details about the IP Filtering feature, its prerequisites, and its limitations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        management_filter = confluentcloud.IpFilter("management-filter",
            filter_name="Management API Rules",
            resource_group="management",
            ip_groups=[example["id"]])
        multiple_filter = confluentcloud.IpFilter("multiple-filter",
            filter_name="Management, Schema, Flink API Rules",
            resource_group="multiple",
            operation_groups=[
                "MANAGEMENT",
                "SCHEMA",
                "FLINK",
            ],
            ip_groups=[example["id"]])
        ```

        ## Import

        You can import an IP Filter by using IP Filter ID, for example:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/ipFilter:IpFilter example ipf-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param IpFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 operation_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpFilterArgs.__new__(IpFilterArgs)

            if filter_name is None and not opts.urn:
                raise TypeError("Missing required property 'filter_name'")
            __props__.__dict__["filter_name"] = filter_name
            if ip_groups is None and not opts.urn:
                raise TypeError("Missing required property 'ip_groups'")
            __props__.__dict__["ip_groups"] = ip_groups
            __props__.__dict__["operation_groups"] = operation_groups
            if resource_group is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group'")
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["resource_scope"] = resource_scope
        super(IpFilter, __self__).__init__(
            'confluentcloud:index/ipFilter:IpFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filter_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            operation_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            resource_scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpFilter':
        """
        Get an existing IpFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] filter_name: A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_groups: A list of IP Groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operation_groups: Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        :param pulumi.Input[_builtins.str] resource_group: Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        :param pulumi.Input[_builtins.str] resource_scope: A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpFilterState.__new__(_IpFilterState)

        __props__.__dict__["filter_name"] = filter_name
        __props__.__dict__["ip_groups"] = ip_groups
        __props__.__dict__["operation_groups"] = operation_groups
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["resource_scope"] = resource_scope
        return IpFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        """
        return pulumi.get(self, "filter_name")

    @_builtins.property
    @pulumi.getter(name="ipGroups")
    def ip_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IP Groups.
        """
        return pulumi.get(self, "ip_groups")

    @_builtins.property
    @pulumi.getter(name="operationGroups")
    def operation_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        """
        return pulumi.get(self, "operation_groups")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[_builtins.str]:
        """
        Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceScope")
    def resource_scope(self) -> pulumi.Output[_builtins.str]:
        """
        A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        return pulumi.get(self, "resource_scope")

