# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 cloud: pulumi.Input[_builtins.str],
                 connection_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 environment: pulumi.Input['NetworkEnvironmentArgs'],
                 region: pulumi.Input[_builtins.str],
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config: Optional[pulumi.Input['NetworkDnsConfigArgs']] = None,
                 gcps: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]]] = None,
                 reserved_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider in which the network exists. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: The list of connection types that may be used with the network. Accepted connection types are: `PEERING`, `TRANSITGATEWAY`, and `PRIVATELINK`.
        :param pulumi.Input['NetworkEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] region: The cloud provider region where the network exists.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]] aws: (Optional Configuration Block) The AWS-specific network details if available. It supports the following:
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]] azures: (Optional Configuration Block) The Azure-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] cidr: The IPv4 CIDR block to be used for the network. Must be `/16`. Required for VPC peering and AWS TransitGateway.
        :param pulumi.Input[_builtins.str] display_name: The name of the Network.
        :param pulumi.Input['NetworkDnsConfigArgs'] dns_config: Network DNS config. It applies only to the PRIVATELINK network connection type.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]] gcps: (Optional Configuration Block) The GCP-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] reserved_cidr: The reserved IPv4 CIDR block to be used for the network. Must be `/24`. If not specified, Confluent Cloud Network uses `172.20.255.0/24`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]] zone_infos: Each item represents information related to a single zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: The 3 availability zones for this network. They can optionally be specified for AWS networks
               used with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP
               networks used with Peering. Otherwise, they are automatically chosen by Confluent Cloud.
               On AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html), for example, `use1-az3`.
               On GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones), for example, `us-central1-c`.
               On Azure, zones are Confluent-chosen names (for example, `1`, `2`, `3`) since Azure does not have universal zone identifiers.
        """
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "connection_types", connection_types)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "region", region)
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azures is not None:
            pulumi.set(__self__, "azures", azures)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if gcps is not None:
            pulumi.set(__self__, "gcps", gcps)
        if reserved_cidr is not None:
            pulumi.set(__self__, "reserved_cidr", reserved_cidr)
        if zone_infos is not None:
            pulumi.set(__self__, "zone_infos", zone_infos)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud service provider in which the network exists. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of connection types that may be used with the network. Accepted connection types are: `PEERING`, `TRANSITGATEWAY`, and `PRIVATELINK`.
        """
        return pulumi.get(self, "connection_types")

    @connection_types.setter
    def connection_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "connection_types", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['NetworkEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['NetworkEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud provider region where the network exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]]]:
        """
        (Optional Configuration Block) The AWS-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]]]):
        pulumi.set(self, "aws", value)

    @_builtins.property
    @pulumi.getter
    def azures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]]]:
        """
        (Optional Configuration Block) The Azure-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "azures")

    @azures.setter
    def azures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]]]):
        pulumi.set(self, "azures", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 CIDR block to be used for the network. Must be `/16`. Required for VPC peering and AWS TransitGateway.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['NetworkDnsConfigArgs']]:
        """
        Network DNS config. It applies only to the PRIVATELINK network connection type.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['NetworkDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @_builtins.property
    @pulumi.getter
    def gcps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]]]:
        """
        (Optional Configuration Block) The GCP-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "gcps")

    @gcps.setter
    def gcps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]]]):
        pulumi.set(self, "gcps", value)

    @_builtins.property
    @pulumi.getter(name="reservedCidr")
    def reserved_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reserved IPv4 CIDR block to be used for the network. Must be `/24`. If not specified, Confluent Cloud Network uses `172.20.255.0/24`.
        """
        return pulumi.get(self, "reserved_cidr")

    @reserved_cidr.setter
    def reserved_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_cidr", value)

    @_builtins.property
    @pulumi.getter(name="zoneInfos")
    def zone_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]]]:
        """
        Each item represents information related to a single zone.
        """
        return pulumi.get(self, "zone_infos")

    @zone_infos.setter
    def zone_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]]]):
        pulumi.set(self, "zone_infos", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The 3 availability zones for this network. They can optionally be specified for AWS networks
        used with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP
        networks used with Peering. Otherwise, they are automatically chosen by Confluent Cloud.
        On AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html), for example, `use1-az3`.
        On GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones), for example, `us-central1-c`.
        On Azure, zones are Confluent-chosen names (for example, `1`, `2`, `3`) since Azure does not have universal zone identifiers.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config: Optional[pulumi.Input['NetworkDnsConfigArgs']] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['NetworkEnvironmentArgs']] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGatewayArgs']]]] = None,
                 gcps: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 zonal_subdomains: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]] aws: (Optional Configuration Block) The AWS-specific network details if available. It supports the following:
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]] azures: (Optional Configuration Block) The Azure-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] cidr: The IPv4 CIDR block to be used for the network. Must be `/16`. Required for VPC peering and AWS TransitGateway.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider in which the network exists. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: The list of connection types that may be used with the network. Accepted connection types are: `PEERING`, `TRANSITGATEWAY`, and `PRIVATELINK`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Network.
        :param pulumi.Input['NetworkDnsConfigArgs'] dns_config: Network DNS config. It applies only to the PRIVATELINK network connection type.
        :param pulumi.Input[_builtins.str] dns_domain: (Optional String) The root DNS domain for the network, for example, `pr123a.us-east-2.aws.confluent.cloud` if applicable. Present on Networks that support Private Link.
        :param pulumi.Input[_builtins.str] endpoint_suffix: (Optional String) The endpoint suffix for the network, if applicable. It can take various forms (for example, `.pr1jy6.us-east-2.aws.confluent.cloud` or `-pr1jy6.us-east-2.aws.confluent.cloud`). Full service endpoints can be constructed by appending the service identifier to the beginning of the endpoint suffix. 
               - The Flink REST API endpoint can be constructed by adding `flink` — that is, `https://flink` + `endpoint_suffix`; namely, `https://flink.pr1jy6.us-east-2.aws.confluent.cloud` or `https://flink${data.confluent_network.main.endpoint_suffix}`
               - The Schema Registry REST API endpoint can be constructed by adding the Schema Registry Cluster ID — that is, `https://lsrc-abc123` + `endpoint_suffix`; namely, `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud` or `https://${data.confluent_schema_registry_cluster.example.id}${data.confluent_network.main.endpoint_suffix}`.
        :param pulumi.Input['NetworkEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkGatewayArgs']]] gateways: (Optional Configuration Block) supports the following:
        :param pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]] gcps: (Optional Configuration Block) The GCP-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] region: The cloud provider region where the network exists.
        :param pulumi.Input[_builtins.str] reserved_cidr: The reserved IPv4 CIDR block to be used for the network. Must be `/24`. If not specified, Confluent Cloud Network uses `172.20.255.0/24`.
        :param pulumi.Input[_builtins.str] resource_name: (Required String) The Confluent Resource Name of the Network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] zonal_subdomains: (Optional Map) The DNS subdomain for each zone. Present on networks that support Private Link. Keys are zone names, for example, `use2-az1` and values are DNS domains, for example, `use2-az1.pr123a.us-east-2.aws.confluent.cloud`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]] zone_infos: Each item represents information related to a single zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: The 3 availability zones for this network. They can optionally be specified for AWS networks
               used with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP
               networks used with Peering. Otherwise, they are automatically chosen by Confluent Cloud.
               On AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html), for example, `use1-az3`.
               On GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones), for example, `us-central1-c`.
               On Azure, zones are Confluent-chosen names (for example, `1`, `2`, `3`) since Azure does not have universal zone identifiers.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azures is not None:
            pulumi.set(__self__, "azures", azures)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if connection_types is not None:
            pulumi.set(__self__, "connection_types", connection_types)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if endpoint_suffix is not None:
            pulumi.set(__self__, "endpoint_suffix", endpoint_suffix)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if gcps is not None:
            pulumi.set(__self__, "gcps", gcps)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_cidr is not None:
            pulumi.set(__self__, "reserved_cidr", reserved_cidr)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if zonal_subdomains is not None:
            pulumi.set(__self__, "zonal_subdomains", zonal_subdomains)
        if zone_infos is not None:
            pulumi.set(__self__, "zone_infos", zone_infos)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]]]:
        """
        (Optional Configuration Block) The AWS-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAwArgs']]]]):
        pulumi.set(self, "aws", value)

    @_builtins.property
    @pulumi.getter
    def azures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]]]:
        """
        (Optional Configuration Block) The Azure-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "azures")

    @azures.setter
    def azures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAzureArgs']]]]):
        pulumi.set(self, "azures", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 CIDR block to be used for the network. Must be `/16`. Required for VPC peering and AWS TransitGateway.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud service provider in which the network exists. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of connection types that may be used with the network. Accepted connection types are: `PEERING`, `TRANSITGATEWAY`, and `PRIVATELINK`.
        """
        return pulumi.get(self, "connection_types")

    @connection_types.setter
    def connection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connection_types", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['NetworkDnsConfigArgs']]:
        """
        Network DNS config. It applies only to the PRIVATELINK network connection type.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['NetworkDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional String) The root DNS domain for the network, for example, `pr123a.us-east-2.aws.confluent.cloud` if applicable. Present on Networks that support Private Link.
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_domain", value)

    @_builtins.property
    @pulumi.getter(name="endpointSuffix")
    def endpoint_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional String) The endpoint suffix for the network, if applicable. It can take various forms (for example, `.pr1jy6.us-east-2.aws.confluent.cloud` or `-pr1jy6.us-east-2.aws.confluent.cloud`). Full service endpoints can be constructed by appending the service identifier to the beginning of the endpoint suffix. 
        - The Flink REST API endpoint can be constructed by adding `flink` — that is, `https://flink` + `endpoint_suffix`; namely, `https://flink.pr1jy6.us-east-2.aws.confluent.cloud` or `https://flink${data.confluent_network.main.endpoint_suffix}`
        - The Schema Registry REST API endpoint can be constructed by adding the Schema Registry Cluster ID — that is, `https://lsrc-abc123` + `endpoint_suffix`; namely, `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud` or `https://${data.confluent_schema_registry_cluster.example.id}${data.confluent_network.main.endpoint_suffix}`.
        """
        return pulumi.get(self, "endpoint_suffix")

    @endpoint_suffix.setter
    def endpoint_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_suffix", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['NetworkEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['NetworkEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGatewayArgs']]]]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGatewayArgs']]]]):
        pulumi.set(self, "gateways", value)

    @_builtins.property
    @pulumi.getter
    def gcps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]]]:
        """
        (Optional Configuration Block) The GCP-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "gcps")

    @gcps.setter
    def gcps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkGcpArgs']]]]):
        pulumi.set(self, "gcps", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud provider region where the network exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedCidr")
    def reserved_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reserved IPv4 CIDR block to be used for the network. Must be `/24`. If not specified, Confluent Cloud Network uses `172.20.255.0/24`.
        """
        return pulumi.get(self, "reserved_cidr")

    @reserved_cidr.setter
    def reserved_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_cidr", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) The Confluent Resource Name of the Network.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="zonalSubdomains")
    def zonal_subdomains(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Optional Map) The DNS subdomain for each zone. Present on networks that support Private Link. Keys are zone names, for example, `use2-az1` and values are DNS domains, for example, `use2-az1.pr123a.us-east-2.aws.confluent.cloud`.
        """
        return pulumi.get(self, "zonal_subdomains")

    @zonal_subdomains.setter
    def zonal_subdomains(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zonal_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="zoneInfos")
    def zone_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]]]:
        """
        Each item represents information related to a single zone.
        """
        return pulumi.get(self, "zone_infos")

    @zone_infos.setter
    def zone_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkZoneInfoArgs']]]]):
        pulumi.set(self, "zone_infos", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The 3 availability zones for this network. They can optionally be specified for AWS networks
        used with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP
        networks used with Peering. Otherwise, they are automatically chosen by Confluent Cloud.
        On AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html), for example, `use1-az3`.
        On GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones), for example, `us-central1-c`.
        On Azure, zones are Confluent-chosen names (for example, `1`, `2`, `3`) since Azure does not have universal zone identifiers.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("confluentcloud:index/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAwArgs', 'NetworkAwArgsDict']]]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAzureArgs', 'NetworkAzureArgsDict']]]]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config: Optional[pulumi.Input[Union['NetworkDnsConfigArgs', 'NetworkDnsConfigArgsDict']]] = None,
                 environment: Optional[pulumi.Input[Union['NetworkEnvironmentArgs', 'NetworkEnvironmentArgsDict']]] = None,
                 gcps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkGcpArgs', 'NetworkGcpArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkZoneInfoArgs', 'NetworkZoneInfoArgsDict']]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Example Network that supports Private Link Connections
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        aws_private_link = confluentcloud.Network("aws-private-link",
            display_name="AWS Private Link Network",
            cloud="AWS",
            region="us-east-1",
            connection_types=["PRIVATELINK"],
            zones=[
                "use1-az1",
                "use1-az2",
                "use1-az6",
            ],
            environment={
                "id": development.id,
            })
        ```

        ### Example Network that supports Peering Connections
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        azure_peering = confluentcloud.Network("azure-peering",
            display_name="Azure Peering Network",
            cloud="AZURE",
            region="eastus2",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        ```

        ### Example Network that supports Private Service Connect Connections
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        gcp_private_service_connect = confluentcloud.Network("gcp-private-service-connect",
            display_name="GCP Private Service Connect Network",
            cloud="GCP",
            region="us-central1",
            connection_types=["PRIVATELINK"],
            zones=[
                "us-central1-a",
                "us-central1-b",
                "us-central1-c",
            ],
            environment={
                "id": development.id,
            },
            dns_config={
                "resolution": "PRIVATE",
            })
        ```

        ### Example Network that supports Transit Gateway Endpoints
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        aws_transit_gateway_attachment = confluentcloud.Network("aws-transit-gateway-attachment",
            display_name="AWS Transit Gateway Attachment Network",
            cloud="AWS",
            region="us-east-1",
            cidr="10.10.0.0/16",
            connection_types=["TRANSITGATEWAY"],
            environment={
                "id": development.id,
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Network` resource:
          * dedicated-privatelink-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-privatelink-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using RBAC
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vnet-peering-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs

        ## Import

        You can import a Network by using Environment ID and Network ID, in the format `<Environment ID>/<Network ID>`. The following example shows how to import a Network:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/network:Network my_network env-abc123/n-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAwArgs', 'NetworkAwArgsDict']]]] aws: (Optional Configuration Block) The AWS-specific network details if available. It supports the following:
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAzureArgs', 'NetworkAzureArgsDict']]]] azures: (Optional Configuration Block) The Azure-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] cidr: The IPv4 CIDR block to be used for the network. Must be `/16`. Required for VPC peering and AWS TransitGateway.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider in which the network exists. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: The list of connection types that may be used with the network. Accepted connection types are: `PEERING`, `TRANSITGATEWAY`, and `PRIVATELINK`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Network.
        :param pulumi.Input[Union['NetworkDnsConfigArgs', 'NetworkDnsConfigArgsDict']] dns_config: Network DNS config. It applies only to the PRIVATELINK network connection type.
        :param pulumi.Input[Union['NetworkEnvironmentArgs', 'NetworkEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkGcpArgs', 'NetworkGcpArgsDict']]]] gcps: (Optional Configuration Block) The GCP-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] region: The cloud provider region where the network exists.
        :param pulumi.Input[_builtins.str] reserved_cidr: The reserved IPv4 CIDR block to be used for the network. Must be `/24`. If not specified, Confluent Cloud Network uses `172.20.255.0/24`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkZoneInfoArgs', 'NetworkZoneInfoArgsDict']]]] zone_infos: Each item represents information related to a single zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: The 3 availability zones for this network. They can optionally be specified for AWS networks
               used with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP
               networks used with Peering. Otherwise, they are automatically chosen by Confluent Cloud.
               On AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html), for example, `use1-az3`.
               On GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones), for example, `us-central1-c`.
               On Azure, zones are Confluent-chosen names (for example, `1`, `2`, `3`) since Azure does not have universal zone identifiers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Example Network that supports Private Link Connections
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        aws_private_link = confluentcloud.Network("aws-private-link",
            display_name="AWS Private Link Network",
            cloud="AWS",
            region="us-east-1",
            connection_types=["PRIVATELINK"],
            zones=[
                "use1-az1",
                "use1-az2",
                "use1-az6",
            ],
            environment={
                "id": development.id,
            })
        ```

        ### Example Network that supports Peering Connections
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        azure_peering = confluentcloud.Network("azure-peering",
            display_name="Azure Peering Network",
            cloud="AZURE",
            region="eastus2",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        ```

        ### Example Network that supports Private Service Connect Connections
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        gcp_private_service_connect = confluentcloud.Network("gcp-private-service-connect",
            display_name="GCP Private Service Connect Network",
            cloud="GCP",
            region="us-central1",
            connection_types=["PRIVATELINK"],
            zones=[
                "us-central1-a",
                "us-central1-b",
                "us-central1-c",
            ],
            environment={
                "id": development.id,
            },
            dns_config={
                "resolution": "PRIVATE",
            })
        ```

        ### Example Network that supports Transit Gateway Endpoints
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        aws_transit_gateway_attachment = confluentcloud.Network("aws-transit-gateway-attachment",
            display_name="AWS Transit Gateway Attachment Network",
            cloud="AWS",
            region="us-east-1",
            cidr="10.10.0.0/16",
            connection_types=["TRANSITGATEWAY"],
            environment={
                "id": development.id,
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Network` resource:
          * dedicated-privatelink-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-privatelink-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using RBAC
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vnet-peering-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs

        ## Import

        You can import a Network by using Environment ID and Network ID, in the format `<Environment ID>/<Network ID>`. The following example shows how to import a Network:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/network:Network my_network env-abc123/n-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAwArgs', 'NetworkAwArgsDict']]]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAzureArgs', 'NetworkAzureArgsDict']]]]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config: Optional[pulumi.Input[Union['NetworkDnsConfigArgs', 'NetworkDnsConfigArgsDict']]] = None,
                 environment: Optional[pulumi.Input[Union['NetworkEnvironmentArgs', 'NetworkEnvironmentArgsDict']]] = None,
                 gcps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkGcpArgs', 'NetworkGcpArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkZoneInfoArgs', 'NetworkZoneInfoArgsDict']]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["azures"] = azures
            __props__.__dict__["cidr"] = cidr
            if cloud is None and not opts.urn:
                raise TypeError("Missing required property 'cloud'")
            __props__.__dict__["cloud"] = cloud
            if connection_types is None and not opts.urn:
                raise TypeError("Missing required property 'connection_types'")
            __props__.__dict__["connection_types"] = connection_types
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dns_config"] = dns_config
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["gcps"] = gcps
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_cidr"] = reserved_cidr
            __props__.__dict__["zone_infos"] = zone_infos
            __props__.__dict__["zones"] = zones
            __props__.__dict__["dns_domain"] = None
            __props__.__dict__["endpoint_suffix"] = None
            __props__.__dict__["gateways"] = None
            __props__.__dict__["resource_name"] = None
            __props__.__dict__["zonal_subdomains"] = None
        super(Network, __self__).__init__(
            'confluentcloud:index/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAwArgs', 'NetworkAwArgsDict']]]]] = None,
            azures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAzureArgs', 'NetworkAzureArgsDict']]]]] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            cloud: Optional[pulumi.Input[_builtins.str]] = None,
            connection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_config: Optional[pulumi.Input[Union['NetworkDnsConfigArgs', 'NetworkDnsConfigArgsDict']]] = None,
            dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['NetworkEnvironmentArgs', 'NetworkEnvironmentArgsDict']]] = None,
            gateways: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkGatewayArgs', 'NetworkGatewayArgsDict']]]]] = None,
            gcps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkGcpArgs', 'NetworkGcpArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
            zonal_subdomains: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zone_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkZoneInfoArgs', 'NetworkZoneInfoArgsDict']]]]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAwArgs', 'NetworkAwArgsDict']]]] aws: (Optional Configuration Block) The AWS-specific network details if available. It supports the following:
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAzureArgs', 'NetworkAzureArgsDict']]]] azures: (Optional Configuration Block) The Azure-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] cidr: The IPv4 CIDR block to be used for the network. Must be `/16`. Required for VPC peering and AWS TransitGateway.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider in which the network exists. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_types: The list of connection types that may be used with the network. Accepted connection types are: `PEERING`, `TRANSITGATEWAY`, and `PRIVATELINK`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Network.
        :param pulumi.Input[Union['NetworkDnsConfigArgs', 'NetworkDnsConfigArgsDict']] dns_config: Network DNS config. It applies only to the PRIVATELINK network connection type.
        :param pulumi.Input[_builtins.str] dns_domain: (Optional String) The root DNS domain for the network, for example, `pr123a.us-east-2.aws.confluent.cloud` if applicable. Present on Networks that support Private Link.
        :param pulumi.Input[_builtins.str] endpoint_suffix: (Optional String) The endpoint suffix for the network, if applicable. It can take various forms (for example, `.pr1jy6.us-east-2.aws.confluent.cloud` or `-pr1jy6.us-east-2.aws.confluent.cloud`). Full service endpoints can be constructed by appending the service identifier to the beginning of the endpoint suffix. 
               - The Flink REST API endpoint can be constructed by adding `flink` — that is, `https://flink` + `endpoint_suffix`; namely, `https://flink.pr1jy6.us-east-2.aws.confluent.cloud` or `https://flink${data.confluent_network.main.endpoint_suffix}`
               - The Schema Registry REST API endpoint can be constructed by adding the Schema Registry Cluster ID — that is, `https://lsrc-abc123` + `endpoint_suffix`; namely, `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud` or `https://${data.confluent_schema_registry_cluster.example.id}${data.confluent_network.main.endpoint_suffix}`.
        :param pulumi.Input[Union['NetworkEnvironmentArgs', 'NetworkEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkGatewayArgs', 'NetworkGatewayArgsDict']]]] gateways: (Optional Configuration Block) supports the following:
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkGcpArgs', 'NetworkGcpArgsDict']]]] gcps: (Optional Configuration Block) The GCP-specific network details if available. It supports the following:
        :param pulumi.Input[_builtins.str] region: The cloud provider region where the network exists.
        :param pulumi.Input[_builtins.str] reserved_cidr: The reserved IPv4 CIDR block to be used for the network. Must be `/24`. If not specified, Confluent Cloud Network uses `172.20.255.0/24`.
        :param pulumi.Input[_builtins.str] resource_name_: (Required String) The Confluent Resource Name of the Network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] zonal_subdomains: (Optional Map) The DNS subdomain for each zone. Present on networks that support Private Link. Keys are zone names, for example, `use2-az1` and values are DNS domains, for example, `use2-az1.pr123a.us-east-2.aws.confluent.cloud`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkZoneInfoArgs', 'NetworkZoneInfoArgsDict']]]] zone_infos: Each item represents information related to a single zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: The 3 availability zones for this network. They can optionally be specified for AWS networks
               used with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP
               networks used with Peering. Otherwise, they are automatically chosen by Confluent Cloud.
               On AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html), for example, `use1-az3`.
               On GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones), for example, `us-central1-c`.
               On Azure, zones are Confluent-chosen names (for example, `1`, `2`, `3`) since Azure does not have universal zone identifiers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azures"] = azures
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["connection_types"] = connection_types
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_config"] = dns_config
        __props__.__dict__["dns_domain"] = dns_domain
        __props__.__dict__["endpoint_suffix"] = endpoint_suffix
        __props__.__dict__["environment"] = environment
        __props__.__dict__["gateways"] = gateways
        __props__.__dict__["gcps"] = gcps
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_cidr"] = reserved_cidr
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["zonal_subdomains"] = zonal_subdomains
        __props__.__dict__["zone_infos"] = zone_infos
        __props__.__dict__["zones"] = zones
        return Network(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Sequence['outputs.NetworkAw']]:
        """
        (Optional Configuration Block) The AWS-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "aws")

    @_builtins.property
    @pulumi.getter
    def azures(self) -> pulumi.Output[Sequence['outputs.NetworkAzure']]:
        """
        (Optional Configuration Block) The Azure-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "azures")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv4 CIDR block to be used for the network. Must be `/16`. Required for VPC peering and AWS TransitGateway.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud service provider in which the network exists. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of connection types that may be used with the network. Accepted connection types are: `PEERING`, `TRANSITGATEWAY`, and `PRIVATELINK`.
        """
        return pulumi.get(self, "connection_types")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Network.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> pulumi.Output['outputs.NetworkDnsConfig']:
        """
        Network DNS config. It applies only to the PRIVATELINK network connection type.
        """
        return pulumi.get(self, "dns_config")

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> pulumi.Output[_builtins.str]:
        """
        (Optional String) The root DNS domain for the network, for example, `pr123a.us-east-2.aws.confluent.cloud` if applicable. Present on Networks that support Private Link.
        """
        return pulumi.get(self, "dns_domain")

    @_builtins.property
    @pulumi.getter(name="endpointSuffix")
    def endpoint_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        (Optional String) The endpoint suffix for the network, if applicable. It can take various forms (for example, `.pr1jy6.us-east-2.aws.confluent.cloud` or `-pr1jy6.us-east-2.aws.confluent.cloud`). Full service endpoints can be constructed by appending the service identifier to the beginning of the endpoint suffix. 
        - The Flink REST API endpoint can be constructed by adding `flink` — that is, `https://flink` + `endpoint_suffix`; namely, `https://flink.pr1jy6.us-east-2.aws.confluent.cloud` or `https://flink${data.confluent_network.main.endpoint_suffix}`
        - The Schema Registry REST API endpoint can be constructed by adding the Schema Registry Cluster ID — that is, `https://lsrc-abc123` + `endpoint_suffix`; namely, `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud` or `https://${data.confluent_schema_registry_cluster.example.id}${data.confluent_network.main.endpoint_suffix}`.
        """
        return pulumi.get(self, "endpoint_suffix")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.NetworkEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> pulumi.Output[Sequence['outputs.NetworkGateway']]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "gateways")

    @_builtins.property
    @pulumi.getter
    def gcps(self) -> pulumi.Output[Sequence['outputs.NetworkGcp']]:
        """
        (Optional Configuration Block) The GCP-specific network details if available. It supports the following:
        """
        return pulumi.get(self, "gcps")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud provider region where the network exists.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservedCidr")
    def reserved_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The reserved IPv4 CIDR block to be used for the network. Must be `/24`. If not specified, Confluent Cloud Network uses `172.20.255.0/24`.
        """
        return pulumi.get(self, "reserved_cidr")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) The Confluent Resource Name of the Network.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="zonalSubdomains")
    def zonal_subdomains(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Optional Map) The DNS subdomain for each zone. Present on networks that support Private Link. Keys are zone names, for example, `use2-az1` and values are DNS domains, for example, `use2-az1.pr123a.us-east-2.aws.confluent.cloud`.
        """
        return pulumi.get(self, "zonal_subdomains")

    @_builtins.property
    @pulumi.getter(name="zoneInfos")
    def zone_infos(self) -> pulumi.Output[Sequence['outputs.NetworkZoneInfo']]:
        """
        Each item represents information related to a single zone.
        """
        return pulumi.get(self, "zone_infos")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The 3 availability zones for this network. They can optionally be specified for AWS networks
        used with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP
        networks used with Peering. Otherwise, they are automatically chosen by Confluent Cloud.
        On AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html), for example, `use1-az3`.
        On GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones), for example, `us-central1-c`.
        On Azure, zones are Confluent-chosen names (for example, `1`, `2`, `3`) since Azure does not have universal zone identifiers.
        """
        return pulumi.get(self, "zones")

