option_condition_dict = {
    201: 'Canceled',
    202: 'Late and Out Of Sequence',
    203: 'Last and Canceled',
    204: 'Late',
    205: 'Opening Trade and Canceled',
    206: 'Opening Trade, Late, and Out Of Sequence',
    207: 'Only Trade and Canceled',
    208: 'Opening Trade and Late',
    209: 'Automatic Execution',
    210: 'Reopening Trade',
    219: 'Intermarket Sweep Order',
    227: 'Single Leg Auction Non ISO',
    228: 'Single Leg Auction ISO',
    229: 'Single Leg Cross Non ISO',
    230: 'Single Leg Cross ISO',
    231: 'Single Leg Floor Trade',
    232: 'Multi Leg auto-electronic trade',
    233: 'Multi Leg Auction',
    234: 'Multi Leg Cross',
    235: 'Multi Leg floor trade',
    236: 'Multi Leg auto-electronic trade against single leg(s)',
    237: 'Stock Options Auction',
    238: 'Multi Leg Auction against single leg(s)',
    239: 'Multi Leg floor trade against single leg(s)',
    240: 'Stock Options auto-electronic trade',
    241: 'Stock Options Cross',
    242: 'Stock Options floor trade',
    243: 'Stock Options auto-electronic trade against single leg(s)',
    244: 'Stock Options Auction against single leg(s)',
    245: 'Stock Options floor trade against single leg(s)',
    246: 'Multi Leg Floor Trade of Proprietary Products',
    247: 'Multilateral Compression Trade of Proprietary Products',
    248: 'Extended Hours Trade',
}
crypto_conditions_dict = {

 0: 'Regular Trade', 
 1: 'Sell Side', 
 2: 'Buy Side'}
quote_conditions = {
    -1: "Invalid",
    0: "Regular",
    1: "RegularTwoSidedOpen",
    2: "RegularOneSidedOpen",
    3: "SlowAsk",
    4: "SlowBid",
    5: "SlowBidAsk",
    6: "SlowDueLRPBid",
    7: "SlowDueLRPAsk",
    8: "SlowDueNYSELRP",
    9: "SlowDueSetSlowListBidAsk",
    10: "ManualAskAutomatedBid",
    11: "ManualBidAutomatedAsk",
    12: "ManualBidAndAsk",
    13: "Opening",
    14: "Closing",
    15: "Closed",
    16: "Resume",
    17: "FastTrading",
    18: "TradingRangeIndication",
    19: "MarketMakerQuotesClosed",
    20: "NonFirm",
    21: "NewsDissemination",
    22: "OrderInflux",
    23: "OrderImbalance",
    24: "DueToRelatedSecurityNewsDissemination",
    25: "DueToRelatedSecurityNewsPending",
    26: "AdditionalInformation",
    27: "NewsPending",
    28: "AdditionalInformationDueToRelatedSecurity",
    29: "DueToRelatedSecurity",
    30: "InViewOfCommon",
    31: "EquipmentChangeover",
    32: "NoOpenNoResponse",
    33: "SubPennyTrading",
    34: "AutomatedBidNoOfferNoBid",
    35: "LULDPriceBand",
    36: "MarketWideCircuitBreakerLevel1",
    37: "MarketWideCircuitBreakerLevel2",
    38: "MarketWideCircuitBreakerLevel3",
    39: "RepublishedLULDPriceBand",
    40: "OnDemandAuction",
    41: "CashOnlySettlement",
    42: "NextDaySettlement",
    43: "LULDTradingPause",
    71: "SLowDuelRPBidAsk",
    80: "Cancel",
    81: "Corrected_Price",
    82: "SIPGenerated",
    83: "Unknown",
    84: "Crossed_Market",
    85: "Locked_Market",
    86: "Depth_On_Offer_Side",
    87: "Depth_On_Bid_Side",
    88: "Depth_On_Bid_And_Offer",
    89: "Pre_Opening_Indication",
    90: "Syndicate_Bid",
    91: "Pre_Syndicate_Bid",
    92: "Penalty_Bid"
}
option_condition_desc_dict = {
    
    "Canceled": "Transaction previously reported (other than as the last or opening report for the particular option contract) is now to be canceled.",
    "Late and Out Of Sequence": "Transaction is being reported late and is out of sequence; i.e., later transactions have been reported for the particular option contract.",
    "Last and Canceled": "Transaction is the last reported for the particular option contract and is now canceled.",
    "Late": "Transaction is being reported late, but is in the correct sequence; i.e., no later transactions have been reported for the particular option contract.",
    "Opening Trade and Canceled": "Transaction was the first one (opening) reported this day for this particular option contract. Although later transactions have been reported, this transaction is now to be canceled.",
    "Opening Trade, Late, and Out Of Sequence": "Transaction is a late report of the opening trade and is out of sequence; i.e., other transactions have been reported for the particular option contract.",
    "Only Trade and Canceled": "Transaction was the only one reported this day for the particular option contract and is now to be canceled.",
    "Opening Trade and Late": "Transaction is a late report of the opening trade, but is in the correct sequence; i.e., no other transactions have been reported for the particular option contract.",
    "Automatic Execution": "Transaction was executed electronically. Prefix appears solely for information; process as a regular transaction.",
    "Reopening Trade": "Transaction is a reopening of an option contract in which trading has been previously halted. Prefix appears solely for information; process as a regular transaction.",
    "Intermarket Sweep Order": "Transaction was the execution of an order identified as an Intermarket Sweep Order. Process like normal transaction.",
    "Single Leg Auction Non ISO": "Transaction was the execution of an electronic order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Single Leg Auction ISO": "Transaction was the execution of an Intermarket Sweep electronic order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism marked as ISO.",
    "Single Leg Cross Non ISO": "Transaction was the execution of an electronic order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross and QCC with a single option leg.",
    "Single Leg Cross ISO": "Transaction was the execution of an Intermarket Sweep electronic order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross.",
    "Single Leg Floor Trade": "Transaction represents a non-electronic trade executed on a trading floor. Execution of Paired and Non-Paired Auctions and Cross orders on an exchange floor are also included in this category.",
    "Multi Leg auto-electronic trade": "Transaction represents an electronic execution of a multi-leg order traded in a complex order book.",
    "Multi Leg Auction": "Transaction was the execution of an electronic multi-leg order which was stopped at a price and traded in a two-sided auction mechanism that goes through an exposure period in a complex order book. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Multi Leg Cross": "Transaction was the execution of an electronic multi-leg order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross and QCC with two or more options legs.",
    "Multi Leg floor trade": "Transaction represents a non-electronic multi-leg order trade executed against other multi-leg order(s) on a trading floor. Execution of Paired and Non-Paired Auctions and Cross orders on an exchange floor are also included in this category.",
    "Multi Leg auto-electronic trade against single leg(s)": "Transaction represents an electronic execution of a multi-leg order traded against single leg orders/quotes.",
    "Stock Options Auction": "Transaction was the execution of an electronic multi-leg stock/options order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period in a complex order book. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Multi Leg Auction against single leg(s)": "Transaction was the execution of an electronic multi-leg order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period and trades against single leg orders/quotes. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Multi Leg floor trade against single leg(s)": "Transaction represents a non-electronic multi-leg order trade executed on a trading floor against single leg orders/quotes. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Stock Options auto-electronic trade": "Transaction represents the an electronic execution of a multi-leg stock/options order traded in a complex order book.",
    "Stock Options Cross": "Transaction was the execution of an electronic multi-leg stock/options order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross.",
    "Stock Options floor trade": "Transaction represents a non-electronic multi-leg order stock/options trade executed on a trading floor in a complex order book. Execution of Paired and Non-Paired Auctions and Cross orders on an exchange floor are also included in this category.",
    "Stock Options auto-electronic trade against single leg(s)": "Transaction represents an electronic execution of a multi-leg stock/options order traded against single leg orders/quotes.",
    "Stock Options Auction against single leg(s)": "Transaction was the execution of an electronic multi-leg stock/options order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure perod and trades against single leg orders/quotes. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Stock Options floor trade against single leg(s)": "Transaction represents a non-electronic multi-leg stock/options order trade executed on a trading floor against single leg orders/quotes. Execution of Paired and Non-Paired Auctions on an exchange floor are also included in this category.",
    "Multi Leg Floor Trade of Proprietary Products": "Transaction represents execution of a proprietary product non-electronic multi-leg order with at least 3 legs. The trade price may be outside the current NBBO.",
    "Multilateral Compression Trade of Proprietary Products": "Transaction represents an execution in a proprietary product done as part of a multilateral compression. Trades are executed outside of regular trading hours at prices derived from end of day markets. Trades do not update Open High, Low, and Closing Prices.",
    "Extended Hours Trade": "Transaction represents a trade that was executed outside of regular market hours. Trades do not update Open, High, Low, and Closing Prices."
}

stock_condition_dict = {
    0: 'Regular Sale',
    1: 'Acquisition',
    2: 'Average Price Trade',
    3: 'Automatic Execution',
    4: 'Bunched Trade',
    5: 'Bunched Sold Trade',
    7: 'Cash Sale',
    8: 'Closing Prints',
    9: 'Cross Trade',
    10: 'Derivatively Priced',
    11: 'Distribution',
    12: 'Form T',
    13: 'Extended Trading Hours (Sold Out of Sequence)',
    14: 'Intermarket Sweep',
    15: 'Market Center Official Close',
    16: 'Market Center Official Open',
    17: 'Market Center Opening Trade',
    18: 'Market Center Reopening Trade',
    19: 'Market Center Closing Trade',
    20: 'Next Day',
    21: 'Price Variation Trade',
    22: 'Prior Reference Price',
    23: 'Rule 155 Trade (AMEX)',
    24: 'Rule 127 NYSE',
    25: 'Opening Prints',
    27: 'Stopped Stock (Regular Trade)',
    28: 'Re-Opening Prints',
    29: 'Seller',
    30: 'Sold Last',
    33: 'Sold (out of Sequence)',
    34: 'Split Trade',
    35: 'Stock Option Trade',
    36: 'Yellow Flag Regular Trade',
    37: 'Odd Lot Trade',
    38: 'Corrected Consolidated Close (per listing market)',
    40: 'Held',
    41: 'Trade Thru Exempt',
    46: 'Contingent Trade',
    52: 'Contingent Trade',
    53: 'Qualified Contingent Trade',
    59: 'Placeholder for 611 exempt',
    60: 'SSR in Effect',}

stuff={'Corrected Consolidated Close (per listing market)': 'Corrected Consolidated Close (per listing market)',
    'Cash Only Settlement': 'Cash Only Settlement',
    'Closing Prints': 'Closing Prints',
    'Slow Due Set Slow List Bid Ask': 'Slow Due Set Slow List Bid Ask',
    'Manual Bid and Ask': 'Manual Bid and Ask',
    'Multi Leg auto-electronic trade': 'Multi Leg auto-electronic trade',
    'Single Leg Auction Non ISO': 'Single Leg Auction Non ISO',
    'Multi Leg Auction': 'Multi Leg Auction',
    'Automatic Execution': 'Automatic Execution',
}

stock_condition_desc_dict = {
    'Regular Sale': 'Regular Sale - A trade made without stated conditions is deemed regular way for settlement on the third business day following the transaction date.',
    'Financially Deficient': 'Financially Deficient - Company doesnt meet minimum listing requirements',
    'Acquisition': 'Acquisition - A transaction made on the Exchange as a result of an Exchange acquisition.',
    'Average Price Trade': 'Average Price Trade - A trade where the price reported is based upon an average of the prices for transactions in a security during all or any portion of the trading day.',
    'Automatic Execution': 'Automatic Execution - A sale condition code that identifies a NYSE trade that has been automatically executed without the potential benefit of price improvement.',
    'Bunched Trade': 'Bunched Trade - The combining of multiple odd-lot or round-lot orders for the same security so that they can all be executed at the same time. All affected clients must agree to the bunching before the order is submitted. Bunched trades may also be referred to as block trades.',
    'Bunched Sold Trade': 'Bunched Sold Trade - A bunched trade that is reported late.',
    'Cash Sale': 'Cash Sale - A transaction which requires delivery of securities and payment on the same day the trade takes place.',
    'Closing Prints': 'Closing Prints - The Participant Closing Price represents the last qualifying trade paid for a security by a Participant during the trading day.',
    'Cross Trade': 'Cross Trade - Indicates that the trade resulted from a Market Center’s crossing session.',
    'Derivatively Priced': 'Derivatively Priced - The transaction that constituted the trade-through was the execution of an order at a price that was not based, directly or indirectly, on the quoted price of the NMS stock at the time of execution, and for which the material terms were not reasonably determinable at the time the commitment to execute the order was made (REG NMS 611b7).',
    'Distribution': 'Distribution stock refers to a large blocks of a security that are carefully sold into the market gradually in smaller blocks so as to inundate the market with sell orders for the security and driving down its price.',
    'Form T': 'Form T - Identifies a trade that was executed outside of regular primary market hours and is reported as an extended hours trade.',
    'Short Sale Restriction In Effect': 'The stock has declined by more than 10% in one trading session - which triggered the Short Sale Rule. This ticker cannot be shorted on a down-tick, and the SSR rule will be active for the day it triggered as well as the following day until the end of the day.',
    'Extended Trading Hours (Sold Out of Sequence)': 'Extended Hours (Sold out of Sequence) - Identifies a trade that takes place outside of regular market hours and is reported as an extended hours trade out of sequence and at a time different from the actual transaction time.',
    'Intermarket Sweep': 'A trade that occurs as a result of an order being routed to multiple markets to obtain the best price',
    'Market Center Official Close': 'Market Center Official Close - Indicates the ‘Official’ closing value as determined by a Market Center. This transaction report will contain the market center generated closing price.',
    'Market Center Official Open': 'Market Center Official Open - Indicates the ‘Official’ opening value as determined by a Market Center. This transaction report will contain the market center generated opening price.',
    'Market Center Opening Trade': 'Market Center Opening Trade - The trade that constituted the trade-through was a single priced opening transaction by the Market Center (REG NMS Rule 611b3).',
    'Market Center Reopening Trade': 'Market Center Reopening Trade - The trade that constituted the trade-through was a single priced reopening transaction by the Market Center (REG NMS Rule 611b3).',
    'Market Center Closing Trade': 'Market Center Closing Trade - The transaction that constituted the trade-through was a single priced closing transaction by the Market Center (REG NMS Rule 611b3).',
    'Next Day': 'Next Day - A transaction that requires the delivery of securities on the first business day following the trade date.',
    'Price Variation Trade': 'A trade that occurs as a result of a price change',
    'No Open No Resume': 'No Open No Resume - Indicates a trading halt or an opening delay is to be in effect for the rest of the trading day. Generally, a trading halt condition indicating the reason for the halt or delay is indicated prior to the input of Mode 16.',
    'Prior Reference Price': 'A trade that occurs at the prior day\'s closing price',
    'Rule 155 Trade (AMEX)': 'A trade that occurs as a result of an order being routed to multiple markets to obtain the best price',
    'Rule 127 NYSE': 'A trade that occurs as a result of an order being executed on the NYSE',
    'Opening Prints': 'Closing Prints - The trading days first drawings of a symbols candlestick charts.',
    'Stopped Stock (Regular Trade)': 'A trade that occurs after a stock has been halted',
    'Re-Opening Prints': 'A trade that occurs after a temporary halt in trading',
    'Seller': 'A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.',
    'Sold Last': 'Sold Last sale condition modifier is used when a trade prints in sequence but is reported late OR the trade is printed by Amex in conformance to the One or Two Point Rule. A Sold Last transaction should only impact the consolidated last sale price for an issue if the market center reporting the sold last transaction also reported the transaction setting the current last sale price.',
    'Order Influx': 'Order Influx - A non-regulatory halt used when there is a severe influx of buy and sell orders. To prevent adisorderly market, trading is temporarily suspended.',
    'Sold (out of Sequence)': 'Sold Out of Sequence is used when a trade is printed (reported) out of sequence and at a time different from the actual transaction time.',
    'Split Trade': 'Split Trade - An execution in two markets when the specialist or Market Maker in the market first receiving the order agrees to execute a portion of it at whatever price is realized in another market to which the balance of the order is forwarded for execution.',
    'Stock Option Trade': 'Stock Option Trade - This is typically the stock portion of a delta neutral option trade executed by an option market maker.',
    'Yellow Flag Regular Trade': 'Yellow Flag Regular Trade - Market Centers will have the ability to identify regular trades being reported during specific events as out of the ordinary by appending a new sale condition code Yellow Flag (“Y”) on each transaction reported to the UTP SIP. The new sale condition “.Y” will be eligible to update all market center and consolidated statistics. In certain instances, the UTP SIP will be required to append the .Y for the market center for trades reported as regular-way (Sale Condition @)',
    'Odd Lot Trade': 'A trade that occurs for less than the normal trading unit',
    'Corrected Consolidated Close (per listing market)': 'Corrected Consolidated Close - A transaction executed by the Listing Market to establish the official Consolidated Last Price as indicated by the Listing Exchange.',
    'Held': 'Held - Trades received from a non-primary Participant during a primary market regulatory halt. These trades are held by the CTS Processor and are disseminated after the close of the primary market with an appropriate Held Trade Indicator code applicable to the trade.',
    'Trade Thru Exempt': 'The Trade Through rule is a 20 year-old rule applied to NYSE-listed stocks that states that when a market receives an order, it cannot execute it at a price inferior to any found on another market. In modern electronic markets where trades are executed in milliseconds, this rule can prevent a broker’s ability to meet their “best execution” obligation--because speed provides certainty that the price that is advertised can be accessed.',
    'Contingent Trade': 'Contengent Trade - A Sale Condition code used to identify a transaction where the execution of the transaction is contingent upon some event.',
    'Qualified Contingent Trade': 'Qualified Contingent Trade - A transaction consisting of two or more component orders executed as agent or principal where the execution of one component is contingent upon the execution of all other components at or near the same time and the price is determined by the relationship between the component orders and not the current market price for the security.',
    'Placeholder for 611 exempt': '611 Exempt - Rule 611, which is the Trade Through Exemption of SEC Regulation NMS, is very lengthy to cover in detail. Parties interested in reading the rule in its entirely should type "SEC Rule 611" into an internet search engine. This is the portion of the document that is pertinent to IB traders, in a nutshell: Typically the trades involved are a multi-component trade involving orders for a security and a related derivative, or, in the alternative, orders for related securities, that are executed at or near the same time. The SIA (Securities Industry Association) notes that the economics of a contingent trade are based on the relationship between the prices of the security and the related derivative or security, and that the execution of one order is contingent upon the execution of the other order.',
    'SSR in Effect': 'SSR - Any stock that has dropped more than 10% intraday has SSR in effect for that day and the following.',
    'Cash Only Settlement': 'Cash Only Settlement - The buyer of the option is not required to purchase or sell the underlying security',
    'Closing': 'Closing - The Participant Closing Price represents the last qualifying trade paid for a security by a Participant during the trading day.',
    'Slow Due Set Slow List Bid Ask': 'A trade that occurs as a result of a slow due set slow list bid and ask order',
    'Manual Bid and Ask': 'Manual Bid and Ask - Slow Quote Due to a NYSE Liquidity Replenishment Point (LRP), NYSE MKT Stock Market Tolerance Breach (Spread, Momentum or Gap Trade Tolerance), or Gap Quote on Both the Bid and Offer Sides',
    'Multi Leg auto-electronic trade': 'A trade that occurs as a result of a multi-leg auto-electronic order',
    'Single Leg Auction Non ISO': 'A trade that occurs as a result of a single-leg auction non-ISO order',
    'Multi Leg Auction': 'A trade that occurs as a result of a multi-leg auction order',
    'Automatic Execution': 'A trade that occurs automatically as a result of an algorithm or trading strategy'
}
OPTIONS_EXCHANGES = { 
    300:'NYSE American Options',
    301:'Boston Options Exchange',
    302:'Chicago Board Options Exchange',
    303:'MIAX Emerald, LLC',
    304:'Cboe EDGX Options',
    307:'Nasdaq Global Markets Exchange Group',
    308:'International Securities Exchange, LLC',
    309:'Nasdaq MRX Options Exchange',
    312:'MIAX International Securities Exchange, LLC',
    313:'NYSE Arca, Inc. - Options',
    314:'Options Price Reporting Authority',
    315:'MIAX Pearl, LLC - Options',
    316:'Nasdaq Options Market',
    319:'Nasdaq BX - Options',
    322:'Cboe C2 Options Exchange',
    323:'Nasdaq Philadelphia Exchange, LLC - Options',
    325:'Cboe BZX Options Exchange'}

STOCK_EXCHANGES = {
1:'NYSE American, LLC',
2:'Nasdaq OMX BX, Inc.',
3:'NYSE National, Inc.',
4:'FINRA NYSE TRF',
4:'FINRA Nasdaq TRF Carteret',
4:'FINRA Nasdaq TRF Chicago',
4:'FINRA Alternative Display Facility',
5:'Unlisted Trading Privileges',
6:'International Securities Exchange, LLC - Stocks',
7:'Cboe EDGA',
8:'Cboe EDGX',
9:'NYSE Chicago, Inc.',
10:'New York Stock Exchange',
11:'NYSE Arca, Inc.',
12:'Nasdaq',
13:'Consolidated Tape Association',
14:'Long-Term Stock Exchange',
15:'Investors Exchange',
16:'Cboe Stock Exchange',
17:'Nasdaq Philadelphia Exchange LLC',
18:'Cboe BYX',
19:'Cboe BZX',
20:'MIAX Pearl',
21:'Members Exchange',
62:'OTC Equity Security',    
 }

TAPES = {1: "NYSE", 2: "AMEX", 3: "Nasdaq"}


indicators = {
    50: "Normal",
    51: "Bankrupt",
    52: "Deficient - Below listing requirements",
    53: "Delinquent - Late filing",
    54: "Bankrupt and Deficient",
    55: "Bankrupt and Delinquent",
    56: "Deficient and Delinquent",
    57: "Deficient, Delinquent, and Bankrupt",
    58: "Liquidation",
    59: "Creations Suspended",
    60: "Redemptions Suspended",
    61: "Creations and/or Redemptions Suspended",
    100: "Normal Trading",
    101: "Opening Delay",
    102: "Trading Halt",
    103: "Resume",
    104: "No Open/No Resume",
    105: "Price Indication",
    106: "Trading Range Indication",
    107: "Market Imbalance Buy",
    108: "Market Imbalance Sell",
    109: "Market On Close Imbalance Buy",
    110: "Market On Close Imbalance Sell",
    111: "No Market Imbalance",
    112: "No Market On Close Imbalance",
    113: "Short Sale Restriction",
    114: "Limit Up-Limit Down",
    115: "Quotation Resumption",
    116: "Trading Resumption",
    117: "Volatility Trading Pause",
    300: "NONE",
    301: "Short Sales Restriction Activated",
    302: "Short Sales Restriction Continued",
    303: "Short Sales Restriction Deactivated",
    304: "Short Sales Restriction in Effect",
    305: "Short Sales Restriction Max",

    601: "NBBO_NO_CHANGE",
    602: "NBBO_QUOTE_IS_NBBO",
    603: "NBBO_NO_BB_NO_BO",
    604: "NBBO_BB_BO_SHORT_APPENDAGE",
    605: "NBBO_BB_BO_LONG_APPENDAGE",

    621: "HELD_TRADE_NOT_LAST_SALE_AND_NOT_ON_CONSOLIDATED",
    622: "HELD_TRADE_LAST_SALE_BUT_NOT_ON_CONSOLIDATED",
    623: "HELD_TRADE_LAST_SALE_AND_ON_CONSOLIDATED",


    501: "RETAIL_INTEREST_ON_BID NYSE Retail interest fact sheet",
    502: "RETAIL_INTEREST_ON_ASK NYSE Retail interest fact sheet",
    503: "RETAIL_INTEREST_ON_BID_AND_ASK NYSE Retail interest fact sheet",
    504: "FINRA_BBO_NO_CHANGE",
    505: "FINRA_BBO_DOES_NOT_EXIST",
    506: "FINRA_BB_BO_EXECUTABLE",
    507: "FINRA_BB_BELOW_LOWER_BAND",
    508: "FINRA_BO_ABOVE_UPPER_BAND",
    509: "FINRA_BB_BELOW_LOWER_BAND_BO_ABOVE_UPPER_BAND",
    901: "CTA_NOT_DUE_TO_RELATED_SECURITY",
    902: "CTA_DUE_TO_RELATED_SECURITY",
    903: "CTA_NOT_IN_VIEW_OF_COMMON",
    904: "CTA_IN_VIEW_OF_COMMON",
    905: "CTA_PRICE_INDICATOR",
    906: "CTA_NEW_PRICE_INDICATOR",
    907: "CTA_CORRECTED_PRICE_INDICATION",
    908: "CTA_CANCELLED_MARKET_IMBALANCE_PRICE_TRADING_RANGE_INDICATION",}


stock_condition_desc_dict = {
    'Regular Sale': 'Regular Sale - A trade made without stated conditions is deemed regular way for settlement on the third business day following the transaction date.',
    'Financially Deficient': 'Financially Deficient - Company doesnt meet minimum listing requirements',
    'Acquisition': 'Acquisition - A transaction made on the Exchange as a result of an Exchange acquisition.',
    'Average Price Trade': 'Average Price Trade - A trade where the price reported is based upon an average of the prices for transactions in a security during all or any portion of the trading day.',
    'Automatic Execution': 'Automatic Execution - A sale condition code that identifies a NYSE trade that has been automatically executed without the potential benefit of price improvement.',
    'Bunched Trade': 'Bunched Trade - The combining of multiple odd-lot or round-lot orders for the same security so that they can all be executed at the same time. All affected clients must agree to the bunching before the order is submitted. Bunched trades may also be referred to as block trades.',
    'Bunched Sold Trade': 'Bunched Sold Trade - A bunched trade that is reported late.',
    'Cash Sale': 'Cash Sale - A transaction which requires delivery of securities and payment on the same day the trade takes place.',
    'Closing Prints': 'Closing Prints - The Participant Closing Price represents the last qualifying trade paid for a security by a Participant during the trading day.',
    'Cross Trade': 'Cross Trade - Indicates that the trade resulted from a Market Center’s crossing session.',
    'Derivatively Priced': 'Derivatively Priced - The transaction that constituted the trade-through was the execution of an order at a price that was not based, directly or indirectly, on the quoted price of the NMS stock at the time of execution, and for which the material terms were not reasonably determinable at the time the commitment to execute the order was made (REG NMS 611b7).',
    'Distribution': 'Distribution stock refers to a large blocks of a security that are carefully sold into the market gradually in smaller blocks so as to inundate the market with sell orders for the security and driving down its price.',
    'Form T': 'Form T - Identifies a trade that was executed outside of regular primary market hours and is reported as an extended hours trade.',
    'Short Sale Restriction In Effect': 'The stock has declined by more than 10% in one trading session - which triggered the Short Sale Rule. This ticker cannot be shorted on a down-tick, and the SSR rule will be active for the day it triggered as well as the following day until the end of the day.',
    'Extended Trading Hours (Sold Out of Sequence)': 'Extended Hours (Sold out of Sequence) - Identifies a trade that takes place outside of regular market hours and is reported as an extended hours trade out of sequence and at a time different from the actual transaction time.',
    'Intermarket Sweep': 'A trade that occurs as a result of an order being routed to multiple markets to obtain the best price',
    'Market Center Official Close': 'Market Center Official Close - Indicates the ‘Official’ closing value as determined by a Market Center. This transaction report will contain the market center generated closing price.',
    'Market Center Official Open': 'Market Center Official Open - Indicates the ‘Official’ opening value as determined by a Market Center. This transaction report will contain the market center generated opening price.',
    'Market Center Opening Trade': 'Market Center Opening Trade - The trade that constituted the trade-through was a single priced opening transaction by the Market Center (REG NMS Rule 611b3).',
    'Market Center Reopening Trade': 'Market Center Reopening Trade - The trade that constituted the trade-through was a single priced reopening transaction by the Market Center (REG NMS Rule 611b3).',
    'Market Center Closing Trade': 'Market Center Closing Trade - The transaction that constituted the trade-through was a single priced closing transaction by the Market Center (REG NMS Rule 611b3).',
    'Next Day': 'Next Day - A transaction that requires the delivery of securities on the first business day following the trade date.',
    'Price Variation Trade': 'A trade that occurs as a result of a price change',
    'No Open No Resume': 'No Open No Resume - Indicates a trading halt or an opening delay is to be in effect for the rest of the trading day. Generally, a trading halt condition indicating the reason for the halt or delay is indicated prior to the input of Mode 16.',
    'Prior Reference Price': 'A trade that occurs at the prior day\'s closing price',
    'Rule 155 Trade (AMEX)': 'A trade that occurs as a result of an order being routed to multiple markets to obtain the best price',
    'Rule 127 NYSE': 'A trade that occurs as a result of an order being executed on the NYSE',
    'Opening Prints': 'Closing Prints - The trading days first drawings of a symbols candlestick charts.',
    'Stopped Stock (Regular Trade)': 'A trade that occurs after a stock has been halted',
    'Re-Opening Prints': 'A trade that occurs after a temporary halt in trading',
    'Seller': 'A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.',
    'Sold Last': 'Sold Last sale condition modifier is used when a trade prints in sequence but is reported late OR the trade is printed by Amex in conformance to the One or Two Point Rule. A Sold Last transaction should only impact the consolidated last sale price for an issue if the market center reporting the sold last transaction also reported the transaction setting the current last sale price.',
    'Order Influx': 'Order Influx - A non-regulatory halt used when there is a severe influx of buy and sell orders. To prevent adisorderly market, trading is temporarily suspended.',
    'Sold (out of Sequence)': 'Sold Out of Sequence is used when a trade is printed (reported) out of sequence and at a time different from the actual transaction time.',
    'Split Trade': 'Split Trade - An execution in two markets when the specialist or Market Maker in the market first receiving the order agrees to execute a portion of it at whatever price is realized in another market to which the balance of the order is forwarded for execution.',
    'Stock Option Trade': 'Stock Option Trade - This is typically the stock portion of a delta neutral option trade executed by an option market maker.',
    'Yellow Flag Regular Trade': 'Yellow Flag Regular Trade - Market Centers will have the ability to identify regular trades being reported during specific events as out of the ordinary by appending a new sale condition code Yellow Flag (“Y”) on each transaction reported to the UTP SIP. The new sale condition “.Y” will be eligible to update all market center and consolidated statistics. In certain instances, the UTP SIP will be required to append the .Y for the market center for trades reported as regular-way (Sale Condition @)',
    'Odd Lot Trade': 'A trade that occurs for less than the normal trading unit',
    'Corrected Consolidated Close (per listing market)': 'Corrected Consolidated Close - A transaction executed by the Listing Market to establish the official Consolidated Last Price as indicated by the Listing Exchange.',
    'Held': 'Held - Trades received from a non-primary Participant during a primary market regulatory halt. These trades are held by the CTS Processor and are disseminated after the close of the primary market with an appropriate Held Trade Indicator code applicable to the trade.',
    'Trade Thru Exempt': 'The Trade Through rule is a 20 year-old rule applied to NYSE-listed stocks that states that when a market receives an order, it cannot execute it at a price inferior to any found on another market. In modern electronic markets where trades are executed in milliseconds, this rule can prevent a broker’s ability to meet their “best execution” obligation--because speed provides certainty that the price that is advertised can be accessed.',
    'Contingent Trade': 'Contengent Trade - A Sale Condition code used to identify a transaction where the execution of the transaction is contingent upon some event.',
    'Qualified Contingent Trade': 'Qualified Contingent Trade - A transaction consisting of two or more component orders executed as agent or principal where the execution of one component is contingent upon the execution of all other components at or near the same time and the price is determined by the relationship between the component orders and not the current market price for the security.',
    'Placeholder for 611 exempt': '611 Exempt - Rule 611, which is the Trade Through Exemption of SEC Regulation NMS, is very lengthy to cover in detail. Parties interested in reading the rule in its entirely should type "SEC Rule 611" into an internet search engine. This is the portion of the document that is pertinent to IB traders, in a nutshell: Typically the trades involved are a multi-component trade involving orders for a security and a related derivative, or, in the alternative, orders for related securities, that are executed at or near the same time. The SIA (Securities Industry Association) notes that the economics of a contingent trade are based on the relationship between the prices of the security and the related derivative or security, and that the execution of one order is contingent upon the execution of the other order.',
    'SSR in Effect': 'SSR - Any stock that has dropped more than 10% intraday has SSR in effect for that day and the following.',
    'Cash Only Settlement': 'Cash Only Settlement - The buyer of the option is not required to purchase or sell the underlying security',
    'Closing': 'Closing - The Participant Closing Price represents the last qualifying trade paid for a security by a Participant during the trading day.',
    'Slow Due Set Slow List Bid Ask': 'A trade that occurs as a result of a slow due set slow list bid and ask order',
    'Manual Bid and Ask': 'Manual Bid and Ask - Slow Quote Due to a NYSE Liquidity Replenishment Point (LRP), NYSE MKT Stock Market Tolerance Breach (Spread, Momentum or Gap Trade Tolerance), or Gap Quote on Both the Bid and Offer Sides',
    'Multi Leg auto-electronic trade': 'A trade that occurs as a result of a multi-leg auto-electronic order',
    'Single Leg Auction Non ISO': 'A trade that occurs as a result of a single-leg auction non-ISO order',
    'Multi Leg Auction': 'A trade that occurs as a result of a multi-leg auction order',
    'Automatic Execution': 'A trade that occurs automatically as a result of an algorithm or trading strategy'
}

option_condition_desc_dict = {
    
    "Canceled": "Transaction previously reported (other than as the last or opening report for the particular option contract) is now to be canceled.",
    "Late and Out Of Sequence": "Transaction is being reported late and is out of sequence; i.e., later transactions have been reported for the particular option contract.",
    "Last and Canceled": "Transaction is the last reported for the particular option contract and is now canceled.",
    "Late": "Transaction is being reported late, but is in the correct sequence; i.e., no later transactions have been reported for the particular option contract.",
    "Opening Trade and Canceled": "Transaction was the first one (opening) reported this day for this particular option contract. Although later transactions have been reported, this transaction is now to be canceled.",
    "Opening Trade, Late, and Out Of Sequence": "Transaction is a late report of the opening trade and is out of sequence; i.e., other transactions have been reported for the particular option contract.",
    "Only Trade and Canceled": "Transaction was the only one reported this day for the particular option contract and is now to be canceled.",
    "Opening Trade and Late": "Transaction is a late report of the opening trade, but is in the correct sequence; i.e., no other transactions have been reported for the particular option contract.",
    "Automatic Execution": "Transaction was executed electronically. Prefix appears solely for information; process as a regular transaction.",
    "Reopening Trade": "Transaction is a reopening of an option contract in which trading has been previously halted. Prefix appears solely for information; process as a regular transaction.",
    "Intermarket Sweep Order": "Transaction was the execution of an order identified as an Intermarket Sweep Order. Process like normal transaction.",
    "Single Leg Auction Non ISO": "Transaction was the execution of an electronic order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Single Leg Auction ISO": "Transaction was the execution of an Intermarket Sweep electronic order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism marked as ISO.",
    "Single Leg Cross Non ISO": "Transaction was the execution of an electronic order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross and QCC with a single option leg.",
    "Single Leg Cross ISO": "Transaction was the execution of an Intermarket Sweep electronic order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross.",
    "Single Leg Floor Trade": "Transaction represents a non-electronic trade executed on a trading floor. Execution of Paired and Non-Paired Auctions and Cross orders on an exchange floor are also included in this category.",
    "Multi Leg auto-electronic trade": "Transaction represents an electronic execution of a multi-leg order traded in a complex order book.",
    "Multi Leg Auction": "Transaction was the execution of an electronic multi-leg order which was stopped at a price and traded in a two-sided auction mechanism that goes through an exposure period in a complex order book. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Multi Leg Cross": "Transaction was the execution of an electronic multi-leg order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross and QCC with two or more options legs.",
    "Multi Leg floor trade": "Transaction represents a non-electronic multi-leg order trade executed against other multi-leg order(s) on a trading floor. Execution of Paired and Non-Paired Auctions and Cross orders on an exchange floor are also included in this category.",
    "Multi Leg auto-electronic trade against single leg(s)": "Transaction represents an electronic execution of a multi-leg order traded against single leg orders/quotes.",
    "Stock Options Auction": "Transaction was the execution of an electronic multi-leg stock/options order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period in a complex order book. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Multi Leg Auction against single leg(s)": "Transaction was the execution of an electronic multi-leg order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure period and trades against single leg orders/quotes. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Multi Leg floor trade against single leg(s)": "Transaction represents a non-electronic multi-leg order trade executed on a trading floor against single leg orders/quotes. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Stock Options auto-electronic trade": "Transaction represents the an electronic execution of a multi-leg stock/options order traded in a complex order book.",
    "Stock Options Cross": "Transaction was the execution of an electronic multi-leg stock/options order which was 'stopped' at a price and traded in a two-sided crossing mechanism that does not go through an exposure period. Such crossing mechanisms include and are not limited to Customer to Customer Cross.",
    "Stock Options floor trade": "Transaction represents a non-electronic multi-leg order stock/options trade executed on a trading floor in a complex order book. Execution of Paired and Non-Paired Auctions and Cross orders on an exchange floor are also included in this category.",
    "Stock Options auto-electronic trade against single leg(s)": "Transaction represents an electronic execution of a multi-leg stock/options order traded against single leg orders/quotes.",
    "Stock Options Auction against single leg(s)": "Transaction was the execution of an electronic multi-leg stock/options order which was 'stopped' at a price and traded in a two-sided auction mechanism that goes through an exposure perod and trades against single leg orders/quotes. Such auctions mechanisms include and are not limited to Price Improvement, Facilitation, or Solicitation Mechanism.",
    "Stock Options floor trade against single leg(s)": "Transaction represents a non-electronic multi-leg stock/options order trade executed on a trading floor against single leg orders/quotes. Execution of Paired and Non-Paired Auctions on an exchange floor are also included in this category.",
    "Multi Leg Floor Trade of Proprietary Products": "Transaction represents execution of a proprietary product non-electronic multi-leg order with at least 3 legs. The trade price may be outside the current NBBO.",
    "Multilateral Compression Trade of Proprietary Products": "Transaction represents an execution in a proprietary product done as part of a multilateral compression. Trades are executed outside of regular trading hours at prices derived from end of day markets. Trades do not update Open High, Low, and Closing Prices.",
    "Extended Hours Trade": "Transaction represents a trade that was executed outside of regular market hours. Trades do not update Open, High, Low, and Closing Prices."
}