"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const eks = require("@aws-cdk/aws-eks");
const core_1 = require("@aws-cdk/core");
const eksspot = require("./");
class IntegTesting {
    constructor() {
        const app = new core_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core_1.Stack(app, 'testing-stack', { env });
        const eksSpotCluter = new eksspot.EksSpotCluster(stack, 'Cluster', {
            env,
            clusterVersion: eks.KubernetesVersion.V1_18,
        });
        eksSpotCluter.addSpotFleet('FirstFleet', {
            blockDuration: eksspot.BlockDuration.SIX_HOURS,
            targetCapacity: 1,
            defaultInstanceType: new ec2.InstanceType('p3.2xlarge'),
            // validUntil: eksSpotCluter.addHours(new Date(), 6).toISOString(),
            terminateInstancesWithExpiration: true,
        });
        eksSpotCluter.addSpotFleet('SecondFleet', {
            blockDuration: eksspot.BlockDuration.ONE_HOUR,
            targetCapacity: 2,
            defaultInstanceType: new ec2.InstanceType('c5.large'),
            // validUntil: eksSpotCluter.addHours(new Date(), 1).toISOString(),
            terminateInstancesWithExpiration: true,
        });
        this.stack = [stack];
    }
    ;
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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