# Contributing to Bigraph-Schema

## Making a Contribution

Thank you for your interest in contributing to Vivarium Core! Here's how
you can get started:

1. Review the [Contributor License Agreement](CLA.md) (CLA). Whenever
   you submit a contribution to Vivarium Core, you are agreeing to the
   CLA, which grants us rights to use your contribution. You don't need
   to do anything special to "sign" the CLA. Instead, opening a pull
   request indicates your agreement to the CLA.
2. [Optional] If you want to make a contribution that isn't covered by
   an existing issue, go ahead an open a new one!
3. Once you have found or created an issue that describes the
   contribution you want to make, wait to get feedback from the project
   maintainers.
4. If the project maintainers agree that your proposal makes sense, you
   can fork the repository, make your changes, and open a pull request.
   If you haven't done this before, check out [GitHub's guide to open
   source
   contributions](https://docs.github.com/en/get-started/quickstart/contributing-to-projects).
5. Wait to get feedback from the project maintainers and then address
   any review comments they leave. Once your pull request is approved,
   the project maintainers will merge it.

## Contacting Us

* To request features or report bugs, please open an
  [issue](https://github.com/vivarium-collective/bigraph-schema/issues).
* To ask questions or request help, please open a [discussion
  thread](https://github.com/vivarium-collective/bigraph-schema/discussions).
* To contact the maintainers privately, for example to report a
  violation of our [code of conduct](CODE_OF_CONDUCT.md) or to notify us
  of a security issue, you can use the contact information in the
  [`AUTHORS.md` file](AUTHORS.md).

## Code of Conduct

We expect kindness and respect in all interactions with the Vivarium
Collective community. Harassing or insulting behavior is not welcome and will
result in enforcement actions. Please review our [code of
conduct](CODE_OF_CONDUCT.md), which describes our expectations and
enforcement actions in more detail.
