# Bigraph-schema

[![PyPI version](https://img.shields.io/pypi/v/bigraph-schema.svg)](https://pypi.org/project/bigraph-schema/)
[![Tutorial](https://img.shields.io/badge/GitHub%20Pages-Tutorial-brightgreen)](https://vivarium-collective.github.io/bigraph-schema/notebooks/demo.html)

Welcome to `bigraph-schema` – a library providing a serializable type schema for composite systems simulations. 
This library provides the core of the broader Vivarium 2.0 project.

The goal of `bigraph-schema` is to support interoperability and extensibility across composite simulation formats, 
facilitating integration with existing and future modeling platforms. This is achieved by establishing a 
standardized and serializable schema for the complex, hierarchical, and multiscale nature of biological systems.

## Installation

To install `bigraph-schema`, you can use pip:

```console
pip install bigraph-schema
```

## Getting Started

To get started with bigraph-schema, check out our resources:

* [Type System Overview](https://vivarium-collective.github.io/bigraph-schema/notebooks/core.html): A tutorial demonstrating the functionality of bigraph-schema's type system, "core".
* [Bigraph Schema Basics Tutorial](https://vivarium-collective.github.io/bigraph-viz/notebooks/basics.html): A  tutorial covering the essential aspects of the bigraph-schema library. 
This resource will guide you through the core concepts and methods, helping you to master the basic operations.

## License

Bigraph-schema is open-source software released under the [Apache 2 License](https://github.com/vivarium-collective/bigraph-schema/blob/main/LICENSE).
