# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNamespaceResult',
    'AwaitableGetNamespaceResult',
    'get_namespace',
    'get_namespace_output',
]

@pulumi.output_type
class GetNamespaceResult:
    """
    A collection of values returned by getNamespace.
    """
    def __init__(__self__, capabilities=None, description=None, id=None, meta=None, name=None, node_pool_configs=None, quota=None):
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if meta and not isinstance(meta, dict):
            raise TypeError("Expected argument 'meta' to be a dict")
        pulumi.set(__self__, "meta", meta)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_pool_configs and not isinstance(node_pool_configs, list):
            raise TypeError("Expected argument 'node_pool_configs' to be a list")
        pulumi.set(__self__, "node_pool_configs", node_pool_configs)
        if quota and not isinstance(quota, str):
            raise TypeError("Expected argument 'quota' to be a str")
        pulumi.set(__self__, "quota", quota)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetNamespaceCapabilityResult']:
        """
        `(block)` - Capabilities of the namespace
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        `(string)` - The description of the namespace.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Mapping[str, _builtins.str]:
        """
        `(map[string]string)` -  Arbitrary KV metadata associated with the namespace.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePoolConfigs")
    def node_pool_configs(self) -> Sequence['outputs.GetNamespaceNodePoolConfigResult']:
        return pulumi.get(self, "node_pool_configs")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> _builtins.str:
        """
        `(string)` - The quota associated with the namespace.
        """
        return pulumi.get(self, "quota")


class AwaitableGetNamespaceResult(GetNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceResult(
            capabilities=self.capabilities,
            description=self.description,
            id=self.id,
            meta=self.meta,
            name=self.name,
            node_pool_configs=self.node_pool_configs,
            quota=self.quota)


def get_namespace(name: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceResult:
    """
    Get information about a namespace in Nomad.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    namespaces = nomad.get_namespace(name="default")
    ```


    :param _builtins.str name: `(string)` - The name of the namespace.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nomad:index/getNamespace:getNamespace', __args__, opts=opts, typ=GetNamespaceResult).value

    return AwaitableGetNamespaceResult(
        capabilities=pulumi.get(__ret__, 'capabilities'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        meta=pulumi.get(__ret__, 'meta'),
        name=pulumi.get(__ret__, 'name'),
        node_pool_configs=pulumi.get(__ret__, 'node_pool_configs'),
        quota=pulumi.get(__ret__, 'quota'))
def get_namespace_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespaceResult]:
    """
    Get information about a namespace in Nomad.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    namespaces = nomad.get_namespace(name="default")
    ```


    :param _builtins.str name: `(string)` - The name of the namespace.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nomad:index/getNamespace:getNamespace', __args__, opts=opts, typ=GetNamespaceResult)
    return __ret__.apply(lambda __response__: GetNamespaceResult(
        capabilities=pulumi.get(__response__, 'capabilities'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        meta=pulumi.get(__response__, 'meta'),
        name=pulumi.get(__response__, 'name'),
        node_pool_configs=pulumi.get(__response__, 'node_pool_configs'),
        quota=pulumi.get(__response__, 'quota')))
