# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 jobspec: pulumi.Input[_builtins.str],
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 detach: Optional[pulumi.Input[_builtins.bool]] = None,
                 hcl2: Optional[pulumi.Input['JobHcl2Args']] = None,
                 json: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 rerun_if_dead: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[_builtins.str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[_builtins.bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[_builtins.bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input['JobHcl2Args'] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[_builtins.bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[_builtins.bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[_builtins.bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[_builtins.bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        """
        pulumi.set(__self__, "jobspec", jobspec)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if deregister_on_id_change is not None:
            pulumi.set(__self__, "deregister_on_id_change", deregister_on_id_change)
        if detach is not None:
            pulumi.set(__self__, "detach", detach)
        if hcl2 is not None:
            pulumi.set(__self__, "hcl2", hcl2)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if policy_override is not None:
            pulumi.set(__self__, "policy_override", policy_override)
        if purge_on_destroy is not None:
            pulumi.set(__self__, "purge_on_destroy", purge_on_destroy)
        if read_allocation_ids is not None:
            warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""", DeprecationWarning)
            pulumi.log.warn("""read_allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
        if read_allocation_ids is not None:
            pulumi.set(__self__, "read_allocation_ids", read_allocation_ids)
        if rerun_if_dead is not None:
            pulumi.set(__self__, "rerun_if_dead", rerun_if_dead)

    @_builtins.property
    @pulumi.getter
    def jobspec(self) -> pulumi.Input[_builtins.str]:
        """
        `(string: <required>)` - The contents of the jobspec to register.
        """
        return pulumi.get(self, "jobspec")

    @jobspec.setter
    def jobspec(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "jobspec", value)

    @_builtins.property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the job will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="deregisterOnIdChange")
    def deregister_on_id_change(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: true)` - Determines if the job will be
        deregistered if the ID of the job in the jobspec changes.
        """
        return pulumi.get(self, "deregister_on_id_change")

    @deregister_on_id_change.setter
    def deregister_on_id_change(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deregister_on_id_change", value)

    @_builtins.property
    @pulumi.getter
    def detach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: true)` - If true, the provider will return immediately
        after creating or updating, instead of monitoring.
        """
        return pulumi.get(self, "detach")

    @detach.setter
    def detach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "detach", value)

    @_builtins.property
    @pulumi.getter
    def hcl2(self) -> Optional[pulumi.Input['JobHcl2Args']]:
        """
        `(block: optional)` - Options for the HCL2 jobspec parser.
        """
        return pulumi.get(self, "hcl2")

    @hcl2.setter
    def hcl2(self, value: Optional[pulumi.Input['JobHcl2Args']]):
        pulumi.set(self, "hcl2", value)

    @_builtins.property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to `true` if your jobspec is structured with
        JSON instead of the default HCL.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "json", value)

    @_builtins.property
    @pulumi.getter(name="policyOverride")
    def policy_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Determines if the job will override any
        soft-mandatory Sentinel policies and register even if they fail.
        """
        return pulumi.get(self, "policy_override")

    @policy_override.setter
    def policy_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "policy_override", value)

    @_builtins.property
    @pulumi.getter(name="purgeOnDestroy")
    def purge_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to true if you want the job to
        be purged when the resource is destroyed.
        """
        return pulumi.get(self, "purge_on_destroy")

    @purge_on_destroy.setter
    def purge_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="readAllocationIds")
    @_utilities.deprecated("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
    def read_allocation_ids(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "read_allocation_ids")

    @read_allocation_ids.setter
    def read_allocation_ids(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_allocation_ids", value)

    @_builtins.property
    @pulumi.getter(name="rerunIfDead")
    def rerun_if_dead(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to true to force the job to run
        again if its status is `dead`.
        """
        return pulumi.get(self, "rerun_if_dead")

    @rerun_if_dead.setter
    def rerun_if_dead(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rerun_if_dead", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 allocation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 datacenters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_status: Optional[pulumi.Input[_builtins.str]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 detach: Optional[pulumi.Input[_builtins.bool]] = None,
                 hcl2: Optional[pulumi.Input['JobHcl2Args']] = None,
                 jobspec: Optional[pulumi.Input[_builtins.str]] = None,
                 json: Optional[pulumi.Input[_builtins.bool]] = None,
                 modify_index: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rerun_if_dead: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 task_groups: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskGroupArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allocation_ids: The IDs for allocations associated with this job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] datacenters: The target datacenters for the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.str] deployment_id: If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[_builtins.str] deployment_status: If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[_builtins.bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[_builtins.bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input['JobHcl2Args'] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[_builtins.str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[_builtins.bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[_builtins.str] modify_index: Integer that increments for each change. Used to detect any changes between plan and apply.
        :param pulumi.Input[_builtins.str] name: The name of the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[_builtins.bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[_builtins.str] region: The target region for the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        :param pulumi.Input[_builtins.str] status: The status of the job.
        :param pulumi.Input[_builtins.str] type: The type of the job, as derived from the jobspec.
        """
        if allocation_ids is not None:
            warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""", DeprecationWarning)
            pulumi.log.warn("""allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
        if allocation_ids is not None:
            pulumi.set(__self__, "allocation_ids", allocation_ids)
        if datacenters is not None:
            pulumi.set(__self__, "datacenters", datacenters)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_status is not None:
            pulumi.set(__self__, "deployment_status", deployment_status)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if deregister_on_id_change is not None:
            pulumi.set(__self__, "deregister_on_id_change", deregister_on_id_change)
        if detach is not None:
            pulumi.set(__self__, "detach", detach)
        if hcl2 is not None:
            pulumi.set(__self__, "hcl2", hcl2)
        if jobspec is not None:
            pulumi.set(__self__, "jobspec", jobspec)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if modify_index is not None:
            pulumi.set(__self__, "modify_index", modify_index)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if policy_override is not None:
            pulumi.set(__self__, "policy_override", policy_override)
        if purge_on_destroy is not None:
            pulumi.set(__self__, "purge_on_destroy", purge_on_destroy)
        if read_allocation_ids is not None:
            warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""", DeprecationWarning)
            pulumi.log.warn("""read_allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
        if read_allocation_ids is not None:
            pulumi.set(__self__, "read_allocation_ids", read_allocation_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rerun_if_dead is not None:
            pulumi.set(__self__, "rerun_if_dead", rerun_if_dead)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if task_groups is not None:
            pulumi.set(__self__, "task_groups", task_groups)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allocationIds")
    @_utilities.deprecated("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
    def allocation_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs for allocations associated with this job.
        """
        return pulumi.get(self, "allocation_ids")

    @allocation_ids.setter
    def allocation_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allocation_ids", value)

    @_builtins.property
    @pulumi.getter
    def datacenters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The target datacenters for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "datacenters")

    @datacenters.setter
    def datacenters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "datacenters", value)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_status")

    @deployment_status.setter
    def deployment_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_status", value)

    @_builtins.property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the job will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="deregisterOnIdChange")
    def deregister_on_id_change(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: true)` - Determines if the job will be
        deregistered if the ID of the job in the jobspec changes.
        """
        return pulumi.get(self, "deregister_on_id_change")

    @deregister_on_id_change.setter
    def deregister_on_id_change(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deregister_on_id_change", value)

    @_builtins.property
    @pulumi.getter
    def detach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: true)` - If true, the provider will return immediately
        after creating or updating, instead of monitoring.
        """
        return pulumi.get(self, "detach")

    @detach.setter
    def detach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "detach", value)

    @_builtins.property
    @pulumi.getter
    def hcl2(self) -> Optional[pulumi.Input['JobHcl2Args']]:
        """
        `(block: optional)` - Options for the HCL2 jobspec parser.
        """
        return pulumi.get(self, "hcl2")

    @hcl2.setter
    def hcl2(self, value: Optional[pulumi.Input['JobHcl2Args']]):
        pulumi.set(self, "hcl2", value)

    @_builtins.property
    @pulumi.getter
    def jobspec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The contents of the jobspec to register.
        """
        return pulumi.get(self, "jobspec")

    @jobspec.setter
    def jobspec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jobspec", value)

    @_builtins.property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to `true` if your jobspec is structured with
        JSON instead of the default HCL.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "json", value)

    @_builtins.property
    @pulumi.getter(name="modifyIndex")
    def modify_index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integer that increments for each change. Used to detect any changes between plan and apply.
        """
        return pulumi.get(self, "modify_index")

    @modify_index.setter
    def modify_index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_index", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="policyOverride")
    def policy_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Determines if the job will override any
        soft-mandatory Sentinel policies and register even if they fail.
        """
        return pulumi.get(self, "policy_override")

    @policy_override.setter
    def policy_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "policy_override", value)

    @_builtins.property
    @pulumi.getter(name="purgeOnDestroy")
    def purge_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to true if you want the job to
        be purged when the resource is destroyed.
        """
        return pulumi.get(self, "purge_on_destroy")

    @purge_on_destroy.setter
    def purge_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="readAllocationIds")
    @_utilities.deprecated("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
    def read_allocation_ids(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "read_allocation_ids")

    @read_allocation_ids.setter
    def read_allocation_ids(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_allocation_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target region for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rerunIfDead")
    def rerun_if_dead(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to true to force the job to run
        again if its status is `dead`.
        """
        return pulumi.get(self, "rerun_if_dead")

    @rerun_if_dead.setter
    def rerun_if_dead(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rerun_if_dead", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the job.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="taskGroups")
    def task_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskGroupArgs']]]]:
        return pulumi.get(self, "task_groups")

    @task_groups.setter
    def task_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskGroupArgs']]]]):
        pulumi.set(self, "task_groups", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("nomad:index/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 detach: Optional[pulumi.Input[_builtins.bool]] = None,
                 hcl2: Optional[pulumi.Input[Union['JobHcl2Args', 'JobHcl2ArgsDict']]] = None,
                 jobspec: Optional[pulumi.Input[_builtins.str]] = None,
                 json: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 rerun_if_dead: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create a Job resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[_builtins.bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[_builtins.bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input[Union['JobHcl2Args', 'JobHcl2ArgsDict']] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[_builtins.str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[_builtins.bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[_builtins.bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[_builtins.bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[_builtins.bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Job resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 detach: Optional[pulumi.Input[_builtins.bool]] = None,
                 hcl2: Optional[pulumi.Input[Union['JobHcl2Args', 'JobHcl2ArgsDict']]] = None,
                 jobspec: Optional[pulumi.Input[_builtins.str]] = None,
                 json: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 rerun_if_dead: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
            __props__.__dict__["deregister_on_id_change"] = deregister_on_id_change
            __props__.__dict__["detach"] = detach
            __props__.__dict__["hcl2"] = hcl2
            if jobspec is None and not opts.urn:
                raise TypeError("Missing required property 'jobspec'")
            __props__.__dict__["jobspec"] = jobspec
            __props__.__dict__["json"] = json
            __props__.__dict__["policy_override"] = policy_override
            __props__.__dict__["purge_on_destroy"] = purge_on_destroy
            __props__.__dict__["read_allocation_ids"] = read_allocation_ids
            __props__.__dict__["rerun_if_dead"] = rerun_if_dead
            __props__.__dict__["allocation_ids"] = None
            __props__.__dict__["datacenters"] = None
            __props__.__dict__["deployment_id"] = None
            __props__.__dict__["deployment_status"] = None
            __props__.__dict__["modify_index"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["namespace"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["task_groups"] = None
            __props__.__dict__["type"] = None
        super(Job, __self__).__init__(
            'nomad:index/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            datacenters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_status: Optional[pulumi.Input[_builtins.str]] = None,
            deregister_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            deregister_on_id_change: Optional[pulumi.Input[_builtins.bool]] = None,
            detach: Optional[pulumi.Input[_builtins.bool]] = None,
            hcl2: Optional[pulumi.Input[Union['JobHcl2Args', 'JobHcl2ArgsDict']]] = None,
            jobspec: Optional[pulumi.Input[_builtins.str]] = None,
            json: Optional[pulumi.Input[_builtins.bool]] = None,
            modify_index: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            policy_override: Optional[pulumi.Input[_builtins.bool]] = None,
            purge_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            read_allocation_ids: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rerun_if_dead: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            task_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobTaskGroupArgs', 'JobTaskGroupArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allocation_ids: The IDs for allocations associated with this job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] datacenters: The target datacenters for the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.str] deployment_id: If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[_builtins.str] deployment_status: If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[_builtins.bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[_builtins.bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[_builtins.bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input[Union['JobHcl2Args', 'JobHcl2ArgsDict']] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[_builtins.str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[_builtins.bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[_builtins.str] modify_index: Integer that increments for each change. Used to detect any changes between plan and apply.
        :param pulumi.Input[_builtins.str] name: The name of the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[_builtins.bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[_builtins.str] region: The target region for the job, as derived from the jobspec.
        :param pulumi.Input[_builtins.bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        :param pulumi.Input[_builtins.str] status: The status of the job.
        :param pulumi.Input[_builtins.str] type: The type of the job, as derived from the jobspec.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["allocation_ids"] = allocation_ids
        __props__.__dict__["datacenters"] = datacenters
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["deployment_status"] = deployment_status
        __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
        __props__.__dict__["deregister_on_id_change"] = deregister_on_id_change
        __props__.__dict__["detach"] = detach
        __props__.__dict__["hcl2"] = hcl2
        __props__.__dict__["jobspec"] = jobspec
        __props__.__dict__["json"] = json
        __props__.__dict__["modify_index"] = modify_index
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["policy_override"] = policy_override
        __props__.__dict__["purge_on_destroy"] = purge_on_destroy
        __props__.__dict__["read_allocation_ids"] = read_allocation_ids
        __props__.__dict__["region"] = region
        __props__.__dict__["rerun_if_dead"] = rerun_if_dead
        __props__.__dict__["status"] = status
        __props__.__dict__["task_groups"] = task_groups
        __props__.__dict__["type"] = type
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationIds")
    @_utilities.deprecated("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
    def allocation_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IDs for allocations associated with this job.
        """
        return pulumi.get(self, "allocation_ids")

    @_builtins.property
    @pulumi.getter
    def datacenters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The target datacenters for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "datacenters")

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[_builtins.str]:
        """
        If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_id")

    @_builtins.property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> pulumi.Output[_builtins.str]:
        """
        If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_status")

    @_builtins.property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the job will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @_builtins.property
    @pulumi.getter(name="deregisterOnIdChange")
    def deregister_on_id_change(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `(boolean: true)` - Determines if the job will be
        deregistered if the ID of the job in the jobspec changes.
        """
        return pulumi.get(self, "deregister_on_id_change")

    @_builtins.property
    @pulumi.getter
    def detach(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `(boolean: true)` - If true, the provider will return immediately
        after creating or updating, instead of monitoring.
        """
        return pulumi.get(self, "detach")

    @_builtins.property
    @pulumi.getter
    def hcl2(self) -> pulumi.Output[Optional['outputs.JobHcl2']]:
        """
        `(block: optional)` - Options for the HCL2 jobspec parser.
        """
        return pulumi.get(self, "hcl2")

    @_builtins.property
    @pulumi.getter
    def jobspec(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - The contents of the jobspec to register.
        """
        return pulumi.get(self, "jobspec")

    @_builtins.property
    @pulumi.getter
    def json(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to `true` if your jobspec is structured with
        JSON instead of the default HCL.
        """
        return pulumi.get(self, "json")

    @_builtins.property
    @pulumi.getter(name="modifyIndex")
    def modify_index(self) -> pulumi.Output[_builtins.str]:
        """
        Integer that increments for each change. Used to detect any changes between plan and apply.
        """
        return pulumi.get(self, "modify_index")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="policyOverride")
    def policy_override(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `(boolean: false)` - Determines if the job will override any
        soft-mandatory Sentinel policies and register even if they fail.
        """
        return pulumi.get(self, "policy_override")

    @_builtins.property
    @pulumi.getter(name="purgeOnDestroy")
    def purge_on_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to true if you want the job to
        be purged when the resource is destroyed.
        """
        return pulumi.get(self, "purge_on_destroy")

    @_builtins.property
    @pulumi.getter(name="readAllocationIds")
    @_utilities.deprecated("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the get_allocations data source instead.""")
    def read_allocation_ids(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "read_allocation_ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The target region for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rerunIfDead")
    def rerun_if_dead(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `(boolean: false)` - Set this to true to force the job to run
        again if its status is `dead`.
        """
        return pulumi.get(self, "rerun_if_dead")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the job.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="taskGroups")
    def task_groups(self) -> pulumi.Output[Sequence['outputs.JobTaskGroup']]:
        return pulumi.get(self, "task_groups")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "type")

