<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'cs', branch 'MOODLE_23_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Přístup zamítnut';
$string['accounts'] = 'Účty';
$string['additionalhtml'] = 'Další HTML';
$string['additionalhtml_desc'] = 'Toto nastavení vám umožňuje definovat vlastní HTML kód, který bude přidán na každou stránku. Vlastní kód je možno přidat buď do hlavičky stránky (HEAD), na začátek těla (BODY) stránky nebo těsně před konec těla stránky.<br />Tímto způsobem lze snadno přidat vlastní záhlaví či zápatí, popřípadě vložit kód potřebný pro služby jako je Google Analytics. Takto vložený kód není závislý na použitém grafickém motivu.';
$string['additionalhtmlfooter'] = 'Před koncem značky BODY';
$string['additionalhtmlfooter_desc'] = 'Tento obsah bude přidán ke každé stránce předtím, než bude uzavřen tag BODY.';
$string['additionalhtmlhead'] = 'Uvnitř značky HEAD';
$string['additionalhtmlhead_desc'] = 'Tento obsah bude přidán ke každé stránce předtím, než bude pro každou stránku uzavřen tag HEAD.';
$string['additionalhtml_heading'] = 'HTML kód bude přidán ke každé stránce.';
$string['additionalhtmltopofbody'] = 'Po začátku značky BODY';
$string['additionalhtmltopofbody_desc'] = 'Tento obsah bude přidán ke každé stránce po tom, než bude otevřen tag BODY.';
$string['admincategory'] = 'Kategorie: {$a}';
$string['adminseesall'] = 'Správci vidí vše';
$string['adminseesallevents'] = 'Správci vidí všechny události';
$string['adminseesownevents'] = 'Správci jsou jako obyčejní uživatelé';
$string['advancedfeatures'] = 'Pokročilé funkce';
$string['allcountrycodes'] = 'Všechny kódy zemí';
$string['allowbeforeblock'] = 'Nejprve porovnávat seznam povolených';
$string['allowbeforeblockdesc'] = 'Ve výchozím nastavení je nejprve porovnáván seznam blokovaných IP adres. Je-li tato volba povolena, jsou položky v seznamu povolených adres zpracovány před seznamem blokovaných.';
$string['allowblockstodock'] = 'Povolit zasouvání bloků';
$string['allowcategorythemes'] = 'Povolit motivy kategorií';
$string['allowcoursethemes'] = 'Povolit změnu motivu v kurzech';
$string['allowediplist'] = 'Seznam povolených IP adres';
$string['allowemailaddresses'] = 'Povolené emailové domény';
$string['allowframembedding'] = 'Povolit vkládání do rámce';
$string['allowframembedding_help'] = 'Povolit zobrazení vašeho Moodle v HTML rámci (frame) na jiných stránkách. Z bezpečnostních důvodů se nedoporučuje.';
$string['allowobjectembed'] = 'Povolit značky EMBED a OBJECT';
$string['allowthemechangeonurl'] = 'Povolit změnu motivu přes URL';
$string['allowuserblockhiding'] = 'Povolit uživatelům skrývat bloky';
$string['allowuserswitchrolestheycantassign'] = 'Uživatelům bez oprávnění přiřazovat role povolit role přepínat';
$string['allowuserthemes'] = 'Povolit uživatelům změnu motivu';
$string['antivirus'] = 'Antivir';
$string['appearance'] = 'Vzhled';
$string['aspellpath'] = 'Cesta k programu "aspell"';
$string['authentication'] = 'Ověřování uživatelů';
$string['authpreventaccountcreation'] = 'Zabránit vytváření nových účtů při ověřování uživatelů';
$string['authpreventaccountcreation_help'] = 'Je-li identita uživatele úspěšně ověřena, je mu automaticky založen účet na těchto stránkách. Pokud je pro ověřování uživatelů použit externí zdroj (např. LDAP), ale přístup do Moodle by měl být omezen pouze na uživatele, kteří zde již mají účet, aktivujte tuto možnost. Nové účty pak bude potřeba zakládat ručně nebo pomocí funkce importu uživatelských účtů. Toto nastavení se nevztahuje na ověřování přes MNet.';
$string['authsettings'] = 'Správa modulů pro ověřování uživatelů';
$string['autolang'] = 'Autodetekce jazyka';
$string['autologinguests'] = 'Automaticky přihlašovat hosty';
$string['availablelicenses'] = 'Dostupné licence';
$string['availableto'] = 'Dostupné do';
$string['backgroundcolour'] = 'Průhledná barva';
$string['backups'] = 'Zálohy';
$string['backup_shortname'] = 'Používat název kurzu ve jméně souboru zálohy';
$string['backup_shortnamehelp'] = 'Namísto identifikátoru kurzu ve jméně souboru zálohy se použije název kurzu.';
$string['badwordsconfig'] = 'Zadejte seznam zakázaných slov, jednotlivá slova oddělujte čárkou.';
$string['badwordsdefault'] = 'Pokud je seznam prázdný, použije se výchozí seznam uvedený v jazykovém balíčku.';
$string['badwordslist'] = 'Seznam zakázaných slov';
$string['blockediplist'] = 'Seznam blokovaných IP adres';
$string['blockinstances'] = 'Instance';
$string['blockmultiple'] = 'Povolit více instancí';
$string['blockprotect'] = 'Chránit proti smazání';
$string['blockprotect_help'] = 'Vybrané bloky budou chráněny proti smazání napříč celým webem. Toho se především používá k zamezení smazání navigace a bloků s nastavením, které může být obtížné vrátit zpět zejména v situaci, kdy jsou omylem smazány.';
$string['blocksettings'] = 'Nastavení bloků';
$string['blockunprotect'] = 'Nechránit';
$string['bloglevel'] = 'Viditelnost blogu';
$string['bookmarkadded'] = 'Záložka přidána';
$string['bookmarkalreadyexists'] = 'Tato stránka již obsahuje vaši záložku';
$string['bookmarkdeleted'] = 'Záložka odstraněna';
$string['bookmarkthispage'] = 'přidat záložku';
$string['cachejs'] = 'Vyrovnávací paměť Javascriptu';
$string['cachejs_help'] = 'Vyrovnávací paměť a komprese Javascriptu výrazně zrychluje načítání stránek. Pro stránky v ostrém produkčním režimu je silně doporučována. Naopak vývojáři pravděpodobně tuto možnost budou chtít zakázat.';
$string['cachetext'] = 'Udržet text ve vyrovnávací paměti po dobu';
$string['cachetype'] = 'Typ vyrovnávací paměti';
$string['calendarexportsalt'] = 'Náhodný řetězec (salt) pro export kalendáře';
$string['calendarsettings'] = 'Kalendář';
$string['calendar_weekend'] = 'Víkend';
$string['cannotdeletemodfilter'] = 'Nemůžete odinstalovat filtr "{$a->filter}", protože je součástí modulu "{$a->module}".';
$string['cfgwwwrootslashwarning'] = 'Máte špatně nastavenu hodnotu proměnné $CFG->wwwroot ve vašem souboru config.php. Máte na konci cesty navíc znak \'/\'. Odstraňte ho prosím, nebo se i nadále bude setkávat si chybami jako je <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>tato</a>';
$string['cfgwwwrootwarning'] = 'Máte špatně nastavenou hodnotu proměnné $CFG->wwwroot ve vašem souboru config.php. Hodnota nesouhlasí s URL, kterou používáte pro přístup na tuto stránku. Hodnotu prosím opravte, nebo se budete potýkat s chybami, jako je <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>tato</a>.';
$string['change'] = 'změnit';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Ano';
$string['choosefiletoedit'] = 'Vyberte soubor k editaci';
$string['clamfailureonupload'] = 'Při chybě antiviru clam';
$string['cleanup'] = 'Úklid';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'a';
$string['cliincorrectvalueerror'] = 'Chyba, nesprávná hodnota "{$a->value}" volby "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nesprávná hodnota, prosím zadejte znovu';
$string['clistatusdisabled'] = 'Stav: zakázáno';
$string['clistatusenabled'] = 'Stav: povoleno';
$string['clitypevalue'] = 'zadejte hodnotu';
$string['clitypevaluedefault'] = 'zadejte hodnotu nebo stiskněte Enter pro použití výchozí hodnoty ({$a})';
$string['cliunknowoption'] = 'Neznámé volby:
 {$a}
Použijte volbu --help pro získání nápovědy';
$string['cliupgradefinished'] = 'Server byl úspěšně aktualizován z příkazové řádky';
$string['cliupgradenoneed'] = 'Pro tuto verzi {$a} není aktualizace potřeba. Přesto díky, že jste se stavili!';
$string['cliyesnoprompt'] = 'zadejte a (pro "ano") nebo n (pro "ne")';
$string['commentsperpage'] = 'Počet komentářů na stránku';
$string['commonfiltersettings'] = 'Společné nastavení filtrů';
$string['commonsettings'] = 'Společná nastavení';
$string['componentinstalled'] = 'Komponenta nainstalována';
$string['computedfromlogs'] = 'Vypočteno z protokolů od {$a}.';
$string['condifmodeditdefaults'] = 'Zde definujete výchozí hodnoty pro formulář nastavení modulu činnosti, které se použijí, když činnost vytváříte. Také můžete určit, která nastavení jsou považována za pokročilá.';
$string['confeditorhidebuttons'] = 'Vyberte tlačítka, která mají být v HTML editoru skryta.';
$string['configallcountrycodes'] = 'Seznam zemí, z něhož je možno vybírat v různých formulářích, např. v uživatelském profilu. Ponecháte-li pole prázdné, bude použit seznam všech zemí dle ISO 3166-1 definovaný souboru countries.php. V případě, že chcete tento seznam omezit, vložte do tohoto pole čárkami oddělený seznam kódů zemí, které se mají nabízet, např. "CZ,SK". Pokud používáte vlastní nestandardizované kódy zemí, musíte příslušné definice přidat do souboru countries.php v anglickém jazykovém balíčku.';
$string['configallowassign'] = 'Uživatelé, jímž je přiřazena role uvedená vlevo (v prvním sloupci), budou moci dalším uživatelům přiřazovat role zaškrtnuté v jednotlivých sloupcích.';
$string['configallowblockstodock'] = 'Zda se má povolit funkce zasouvání postranních bloků do lišty. Tuto funkci musí rovněž podporovat váš motiv stránek.';
$string['configallowcategorythemes'] = 'Tímto lze povolit nastavování různých motivů v kategoriích kurzů. Motiv nastavený pro kategorii ovlivňuje všechny kurzy v této kategorii i ve všech jejích podkategoriích, dokud není řečeno jinak. POZOR: Toto nastavení může negativně ovlivnit výkon Moodlu.';
$string['configallowcoursethemes'] = 'Povolit vlastní motivy v kurzech. Motivy kurzů mají přednost před všemi ostatními motivy (tj. před motivem stránek, uživatele či sezení).';
$string['configallowemailaddresses'] = 'Chcete-li povolit nové e-mailové adresy pouze z určitých domén, uveďte je zde. Jednotlivé domény oddělte mezerou. Všechny ostatní adresy budou odmítnuty. Chcete-li povolit všechny subdomény, musí vložená položka začínat tečkou. Příklad: <strong>naseskola.cz .msmt.cz .cuni.cz</strong>';
$string['configallowobjectembed'] = 'Výchozí bezpečnostní nastavení nedovoluje normálním uživatelům vkládat přímo do HTML textu multimediální objekty (např. Flash) pomocí značek EMBED a OBJECT. (Bezpečné vkládání multimediálních objektů zajišťuje jeden z tzv. filtrů.) Chcete-li přesto použití uvedených značek povolit, aktivujte tuto volbu.';
$string['configallowoverride'] = 'Role uvedená vlevo (v prvním sloupci) bude moci přenastavovat oprávnění rolí zaškrtnutých v jednotlivých sloupcích.';
$string['configallowoverride2'] = 'Role uvedená vlevo (v prvním sloupci) bude moci přenastavovat oprávnění rolí zaškrtnutých v jednotlivých sloupcích.<br />Důležité upozornění: toto nastavení se bere v potaz pouze u těch uživatelů, kteří mají nastavenu pravomoc moodle/role:override nebo moodle/role:safeoverride';
$string['configallowswitch'] = 'Vyberte role, na které se budou moci uživatelé přepnout v závislosti na rolích, které již mají. Kromě nastavení v této tabulce musí uživatel rovněž disponovat pravomocí "Přepínat na jiné role" (moodle/role:switchroles).<br />Přepnout se je možno pouze na role, které dávají oprávnění "Vidět kurzy" (moodle/course:view) a zároveň nedávají "Možnost dělat cokoli" (moodle/site:doanything). Proto nemusejí být některé sloupce v této tabulce k dispozici.';
$string['configallowthemechangeonurl'] = 'Pokud je povoleno, můžete přidáním parametru theme=jméno_motivu k jakémukoliv URL v rámci Moodlu změnit motiv stránky.

Například http://nase.skola.cz/moodle/?theme=afterburner nebo http://nase.skola.cz/moodle/course/view.php?id=1&theme=afterburner';
$string['configallowuserblockhiding'] = 'Povolit uživatelům zasouvání/vysouvání postranních bloků? Tato funkce používá Javascript a soubory cookie. Nastavení se aplikuje vždy pouze na pohled příslušného uživatele.';
$string['configallowuserswitchrolestheycantassign'] = 'Při výchozím nastavení potřebují uživatelé oprávnění přiřazovat role (moodle/role:assign) i k tomu, aby si mohli role přepínat. Pokud povolíte toto nastavení, bude tato podmínka zrušena a uživatelům bude přístupná rozbalovací nabídka "Přepnout roli na..." pouze na základě nastavení matice "Povolit přidělování rolí". Doporučuje se, aby nastavení tabulky "Povolit přidělování rolí" nedovolovalo přepnout se uživatelům do role, která má větší pravomoce než jejich stávající role.';
$string['configallowuserthemes'] = 'Umožnit uživatelům vlastní výběr motivu stránek. Uživatelské nastavaní má přednost před globálním motivem, nikoliv však před nastavením kurzu.';
$string['configallusersaresitestudents'] = 'Považovat pro činnosti na hlavní stránce VŠECHNY uživatele za studenty? Pokud ANO, bude se moci činností na hlavní stránce účastnit jako student každý uživatel přihlášený k potvrzenému uživatelskému účtu. Pokud NE, budou mít tuto možnost pouze uživatelé zapsaní alespoň v jednom kurzu. Pouze administrátoři a zvlášť určení učitelé mohou na hlavní stránce vystupovat v roli učitele.';
$string['configauthenticationplugins'] = 'Aktivujte autentizační metody a pořadí, v jakém budou použity.';
$string['configautolang'] = 'Zjistí preferovaný jazyk z prohlížeče. Jestliže je tato volba vypnutá, použije se výchozí jazyk.';
$string['configautologinguests'] = 'Mají být návštěvníci vašich stránek automaticky přihlášeni jako hosté, jestliže vstupují do kurzů, které vstup hostů umožňují?';
$string['configbloglevel'] = 'Touto volbou nastavujete úroveň přístupu k blogům na vašich stránkách. Nastavení se týká ČTENÁŘŮ, nikoliv autorů či typů blogů. Pokud blogy nechcete používat, můžete je vypnout úplně.';
$string['configcachetext'] = 'U rozsáhlejších instalací používajících textové filtry může toto nastavení vést k výraznému nárůstu výkonu. Zpracovaný text zůstává po určenou dobu ve vyrovnávací paměti a není generován opakovaně při každém požadavku. Nastavení příliš nízké hodnoty může výkon mírně snížit, vysoké hodnoty mohou způsobovat opožděnou aktualizaci obsahu (např. nebudou okamžitě zobrazeny nově přidané odkazy).';
$string['configcachetype'] = 'Zvolte typ vyrovnávací paměti, kterou bude Moodle používat. Tímto si volíte pouze typ vyrovnávací paměti - nezapomeňte vyrovnávací paměť povolit v nastavení rcache. Vyrovnávací paměť použijte <strong>pouze v případě</strong>, kdy potřebujete snížit zatížení databázového systému. Její použití může ve finále běh Moodlu zpomalit. Stránky se středně náročným zatížením mohou profitovat z nastavení "internal". Na webovém serveru s nainstalovanými akcelerátory eAccelerator nebo Turckmmcache s <em>povoleným použitím sdílené paměti</em> můžete vyzkoušet "eaccelerator". Máte-li multiserverovou instalaci a používáte jeden nebo několik  běžících démonů memcached spolu s rozšířením PHP-memcached, zvolte volbu "memcached" a nastavte potřebné parametry uvedené dále.<br /><strong>Poznámka:</strong> pro efektivní využití vyrovnávací paměti je potřeba provést řadu testů a dolaďování. Akcelerátory eAccelerator a memcached patří mezi nejvýkonnější, ale zároveň mají velké nároky na využití procesorového času.';
$string['configcalendarexportsalt'] = 'Tento náhodný řetězec zvyšuje zabezpečení autentizačních zámků, které se používání při exportu kalendářů. Při změně této hodnoty se všechny stávající autentizační zámky zneplatní.';
$string['configclamactlikevirus'] = 'Považuj soubory za viry';
$string['configclamdonothing'] = 'Považuj soubory za neškodné';
$string['configclamfailureonupload'] = 'Jak se má Moodle zachovat při chybě v konfiguraci nebo v případě jiného problému s Clam AV. Při volbě \'Považuj soubory za viry\' budou soubory umístěny do karantény, nebo budou odstraněny. Při volbě \'Považuj soubory za neškodné\' budou soubory normálně uloženy do cílového umístění. Správci serveru budou v obou přpadech upozorněni, že se Clam AV nepodařilo spustit. Zvolíte-li \'Považuj soubory za viry\' a Clam AV se z nějakého důvodu nepodaří spustit (většinou proto, že zadáte neplatnou pathtoclam), budou VŠECHNY nahrávané soubory přesunuty do karantény nebo odstraněny! Zacházejte proto s tímto nastavením opatrně.';
$string['configconvertformat'] = 'Jsou-li na serveru dostupné programy <i>latex</i>, <i>dvips</i> a <i>convert</i>, budou matematické výrazy generovány do obrázků v následujícím formátu. Pokud dostupné nejsou, bude použit program mimeTeX dodávaný spolu s instalací Moodle a obrázky budou ve formátu GIF.';
$string['configcookiehttponly'] = 'Zapíná novou funkci z PHP 5.2.0, která nařizuje prohlížeči posílat cookies výhradně spolu s http požadavkem, takže cookies by neměly být přístupné skriptovacím jazykům. Tato funkce není podporována všemi prohlížeči a nemusí být plně kompatibilní se současným kódem. Tato funkce napomáhá předcházet XSS útokům.';
$string['configcookiesecure'] = 'Jestliže server přijímá pouze https připojení, pak se doporučuje zapnout zasílání zabezpečených cookies. Jestliže je zapnuto, ujistěte se prosím, že webový server neakceptuje i http://, nebo nastavte permanentní přesměrování na https://. Jestliže nebude hodnota <em>wwwroot</em> začínat na https://, pak se toto nastavené automaticky vypne.';
$string['configcountry'] = 'Výchozí nastavení země při vytváření nových uživatelů. Nezadáte-li nic, budou uživatelé nuceni vybrat si zemi sami.';
$string['configcourserequestnotify'] = 'Zadejte uživatelské jméno uživatele, kterému bude zasíláno upozornění na novou žádost o založení kurzu.';
$string['configcourserequestnotify2'] = 'Kteří uživatelé budou upozorněni na novou žádost o založení kurzu. Zobrazují se pouze uživatelé, kteří mají oprávnění schvalovat žádosti o založení kurzu.';
$string['configcoursesperpage'] = 'Počet kurzů na stránce při zobrazování seznamu kurzů.';
$string['configcronclionly'] = 'Je-li nastaveno, může být skript cron.php spouštěn pouze z příkazové řádky a nikoliv přes webové rozhraní. Tímto se zároveň ignoruje nastavení hesla  ke cronu (viz dále).';
$string['configcronremotepassword'] = 'Použijete-li toto nastavení, bude pro volání skriptu cron.php přes webové rozhraní nutné použít heslo předávané jako parametr podle vzoru: <pre>
        http://moodle.naseskola.cz/admin/cron.php?password=sezameotevrise</pre> Pokud necháte pole prázdné, bude možno volat skript cron.php i bez hesla.';
$string['configcurlcache'] = 'Hodnota doby životnosti cURL vyrovnávací paměti v sekundách.';
$string['configcustommenuitems'] = 'Zde můžete nadefinovat vlastní nabídku odkazů, kterou má vámi zvolený motiv zobrazit. Každý řádek sestává z textu nabídky, URL odkazu (volitelně) a textu titulku (volitelně). Položky na řádce oddělte svislítkem. Strukturu nabídky definujete pomocí pomlček na začátku řádky. Příklad:
<pre>
Hlavní stránka školy|http://nase.skola.cz
-Kontakty|http://nase.skola.cz/kontakty
-Předměty|http://nase.skola.cz/predmety
--Kabinet informatiky|http://nase.skola.cz/predmety/informatika
Další studijní materiály
-Wikimedia
--Wikipedia|http://www.wikipedia.org
--Wikimedia Commons|http://commons.wikimedia.org
</pre>
';
$string['configdbsessions'] = 'Je-li povoleno, bude se pro ukládání informací o stávajících sezeních (sessions) používat databáze. To může být užitečné pro velké/silně zatěžované servery nebo stránky postavené na serverových clusterech. Pro většinu instalací by tato volba měla zůstat zakázána -- informace se tak budou ukládat na disk. Upozornění: změna tohoto nastavení způsobí odhlášení všech momentálně přihlášených uživatelů (včetně vás). Pokud používáte MySQL, ujistěte se, že máte konfigurační proměnnou "max_allowed_packet" (v my.cnf nebo my.ini) nastavenu alespoň na hodnotu 4M.';
$string['configdebug'] = 'Zapnout vypisování varování a ladicích informací pomocí zvýšení úrovně PHP error_reporting. Užitečné hlavně pro vývojáře.';
$string['configdebugdisplay'] = 'Je-li zapnuto, zobrazují se chybová hlášení jako součást HTML stránky. To je sice praktické, ale obecně mohou chybová hlášení nabourávat XHTML, JavaScript, cookies a HTTP hlavičky. Při vypnutí budou chybová hlášení ukládána v protokolu webového serveru. Nastavení PHP proměnné error_log v souboru php.ini ovlivňuje, jaké informace jsou protokolovány.';
$string['configdebugpageinfo'] = 'Povolte, pokud chcete mít v zápatí vytištěné informace o stránce.';
$string['configdebugsmtp'] = 'Povolit podrobnější diagnostiku v průběhu odesílání zpráv na SMTP server.';
$string['configdebugvalidators'] = 'Povolte, pokud chcete v zápatí stránky zobrazovat odkazy na externí validátory. Možná budete muset vytvořit nového uživatele s uživatelským jménem <em>w3cvalidator</em> a povolit na vaše stránky vstup pro hosty. Tyto změny umožní neautorizovaný přístup na vaše stránky, nepoužívejte v produkčním prostředí.';
$string['configdefaulthomepage'] = 'Určuje domovskou stránku pro přihlášené uživatele.';
$string['configdefaultrequestcategory'] = 'Požadované kurzy budou automaticky umístěny v této kategorii.';
$string['configdefaultrequestedcategory'] = 'Do jaké kategorie zařadit požadované kurzy, pokud jsou schváleny?';
$string['configdefaultuserroleid'] = 'Přihlášení uživatelé získají na úrovni celého serveru všechna oprávnění vyplývající z uvedené role. Tato oprávnění budou přidána k ostatním oprávněním získaných z dalších rolí (a mohou je přebít pouze pomocí možnosti "Zakázat"). Vybraná role by měla zajišťovat, aby uživatelé disponovali pravomocemi, které nemohou získat na úrovni kurzů - např. publikovat příspěvky blogů, spravovat vlastní kalendář apod.).';
$string['configdeleteincompleteusers'] = 'Po uplynutí této lhůty dojde k odstranění účtů, u nichž nebyla dokončena registrace.';
$string['configdeleteunconfirmed'] = 'Jestliže používáte ověření na základě e-mailu, po uplynutí této doby jsou nepotvrzené účty automaticky odstraněny.';
$string['configdenyemailaddresses'] = 'Chcete-li z některých domén e-mailové adresy zakázat, zadejte je stejným způsobem. Adresy ze všech ostatních domén budou povoleny. Začíná-li hodnota tečkou, je tento filtr aplikován na všechny subdomény. Příklady: <b>hotmail.com yahoo.co.uk .live.com</b>';
$string['configdisableuserimages'] = 'Zakázat uživatelům možnost měnit si svou fotografii v profilu.';
$string['configdisplayloginfailures'] = 'Zvoleným uživatelům se budou zobrazovat informace o neúspěšných pokusech o přihlášení do systému.';
$string['configdocroot'] = 'Cesta k dokumentaci Moodlu. Upravte toto nastavení, pokud si přejete mít vlastní online dokumentaci. Ujistětě se, že vaše dokumentace zachovává stejný formát jako http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Otevírat stránky dokumentace v novém okně.';
$string['configeditordictionary'] = 'Tato hodnota je použita, pokud nemá aspell k dispozici slovník pro jazyk uživatele.';
$string['configeditorfontlist'] = 'Seznam fontů, které budou zobrazovány v nabídce HTML editoru.';
$string['configemailchangeconfirmation'] = 'Znovu vyžadovat potvrzení nové emailové adresy, pokud si ji uživatelé změní ve svém profilu.';
$string['configenableajax'] = 'Tímto povolujete technologii AJAX na úrovni celého serveru. Jedná se o pokročilé rozhraní mezi prohlížečem a webovým serverem, které využívá Javascript. I když je zde AJAX povolen, uživatelé si jeho použití mohou vypnout ve svých profilech.';
$string['configenablecalendarexport'] = 'Povolit export kalendářů nebo odebírání jejich položek';
$string['configenablecomments'] = 'Povolit komentáře';
$string['configenablecourserequests'] = 'Povolit uživatelům žádat o založení kurzu?';
$string['configenabledevicedetection'] = 'Povoluje detekování typu zařízení (tablet, smartphone, notebook apod.) za účelem aplikace přizpůsobeného vzhledu a dalších funkcí.';
$string['configenablegroupmembersonly'] = 'Je-li povoleno, bude přístup k činnostem v kurzu možno omezit pouze pro členy skupin. Může tím dojít ke zvýšené zátěži serveru z důvodu komplikovanějšího vyhodnocování přístupových práv. Navíc je nutno upravit kategorie položek hodnocení v klasifikaci a zajistit, že k nim nemají přístup nečlenové skupin.';
$string['configenablemobilewebservice'] = 'Povoluje mobilní služby pro podporu oficiální aplikace Moodle pro mobilní zařízení, případně další aplikace, které tyto služby využívají. Pro více informací vize {$a}';
$string['configenablerssfeeds'] = 'Povolení RSS kanálů pro celý server. Kanály musíte povolit zvlášť u každého modulu v jeho nastavení -- \'Správa -> Nastavení -> Moduly -> Nastavení modulu\'.';
$string['configenablerssfeedsdisabled'] = 'Tato volba není dostupná, protože RSS kanály jsou na těchto stránkách zakázány. Kanály povolíte v \'Správa -> Nastavení -> Obecné parametry\'.';
$string['configenablerssfeedsdisabled2'] = 'RSS kanály jsou na úrovni serveru vypnuté. Musíte je nejprve povolit v menu Server/RSS.';
$string['configenablesafebrowserintegration'] = 'Přidává pole "Vyžadovat prohlížeč Safe Exam" mezi bezpečnostní nastavení modulu Test. Více informací na http://www.safeexambrowser.org/';
$string['configenablestats'] = 'Při volbě \'Ano\' zpracuje cron protokoly o činnosti uživatelů a vytvoří z nich grafy a statistiky pro jednotlivé kurzy i celý server. Toto zpracování může nějakou dobu trvat, v závislosti na návštěvnosti vašeho serveru.';
$string['configenabletrusttext'] = 'Moodle standardně pročišťuje jakýkoliv text přicházející od uživatelů a snaží se odstranit potenciální bezpečnostní rizika, mezi něž patří i skripty, média apod. Pomocí funkce "Důvěryhodný obsah" můžete vybraným uživatelům dát privilegium používat i tyto pokročilé prvky bez dalších zásahů. Nejprve je potřeba povolit toto nastavení a poté udělit oprávnění "Důvěřovat uloženému obsahu" (moodle/site:trustcontent). vybraným rolím. Text, který byl vytvořen nebo nahrán uživatelem s takovou rolí, je pak označen jako důvěryhodný a není před zobrazením pročišťován.';
$string['configenablewebservices'] = 'Webové služby umožňují přístup externích aplikací k provádění různých operací s touto instalací Moodle. Pokud webové služby nepoužíváte, nechejte je vypnuté.';
$string['configenablewsdocumentation'] = 'Povolit auto-dokumentační funkce webových služeb. Uživatel má přístup k dokumentaci na své stránce s bezpečnostními klíči {$a}. Dokumentovány budou pouze povolené protokoly.';
$string['configerrorlevel'] = 'Vyberte rozsah zobrazovaných varování PHP. Většinou je nejlepší volbou \'Normální\'.';
$string['configextendedusernamechars'] = 'Povolit uživatelům používat libovolné znaky v uživatelských jménech (volba nemá vliv na znaky ve jméně a příjmení). Výchozí hodnota \'Ne\' povoluje v uživatelských jménech pouze alfanumerické znaky, podtržítko (_), pomlčku (-), tečku (.) a zavináč (@).';
$string['configextramemorylimit'] = 'Některé skripty (např. vyhledávání, záloha/obnova nebo cron) potřebují více paměti. U velkých instalací nastavte větší hodnotu.';
$string['configfilterall'] = 'Zpracovávat pomocí filtrů všechny řetězce včetně nadpisů, titulků, navigační lišty apod. To se hodí zejména při používání filtru vícejazyčné podpory (multilang), jinak tato volba představuje pouze zvýšenou zátěž pro váš server bez výrazného zisku.';
$string['configfiltermatchoneperpage'] = 'Filtry, které automaticky propojují obsah kurzů, vytvoří odkaz pouze u první nalezené shody na celé stránce. Ostatní výskyty jsou ignorovány.';
$string['configfiltermatchonepertext'] = 'Filry, které automaticky propojují obsah kurzů, vytvoří odkaz pouze u první nalezené shody v každém úseku textu (např. studijní materiál, blok apod.). Ostatní výskyty jsou ignorovány. Toto nastavení se nauplatní, pokud je proměnná \'Jedna shoda na stránku\' nastavena na \'Ano\'.';
$string['configfilteruploadedfiles'] = 'Filtrovat vložené textové a HTML soubory. (Při zapnutí této volby mohou nastat problémy s kódováním češtiny v textových souborech.)';
$string['configforcelogin'] = 'Vyžadovat přihlášení uživatele před zobrazením úvodní stránky nebo před jakoukoliv jinou činností na stránkách. V opačném případě je vyžadováno přihlášení až před vstupem do kurzu.';
$string['configforceloginforprofiles'] = 'Vynucovat přihlášení před zobrazením profilů ostatních uživatelů. Pokud zvolíte \'Ne\', můžete se dostat do situace, kdy někteří uživatelé publikují ve svém profilu nevhodný obsah (reklamu, porno), který je poté veřejně dostupný. Zejména pokud se na vašem serveru mohou libovolní návštěvníci registrovat sami, měli byste zvolit \'Ano\'.';
$string['configfrontpage'] = 'Položky vybrané výše budou zobrazeny na titulní stránce serveru.';
$string['configfrontpageloggedin'] = 'Přihlášeným uživatelům budou na titulní stránce serveru zobrazeny položky vybrané výše.';
$string['configfullnamedisplay'] = 'Vyberte způsob zobrazování jmen uživatelů. Nejvýhodnější je obvykle výchozí volba "Křestní jméno + Příjmení", můžete ale zobrazování příjmení zcela vypnout, nebo ponechat rozhodnutí na nastavení příslušného jazyka (různé jazyky mají různé konvence).';
$string['configgdversion'] = 'Verze nainstalované knihovny GD. Implicitně se zobrazuje verze, která byla zjištěna automaticky. Neměňte tuto hodnotu, pokud opravdu nevíte, co děláte.';
$string['configgeoipfile'] = 'Cesta k binárkám GeoIP City. Tento soubor není součástí distribuce moodle a musí být získán samostatně z <a href="http://www.maxmind.com/">MaxMind</a>. Můžete si zakoupit komerční verzi, nebo použít volně dostupnou verzi. <br />Jednoduše stáhněte soubor <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> a rozbalte ho do adresáře <b>{$a}</b> na vašem serveru.';
$string['configgetremoteaddrconf'] = 'Pokud je váš Moodle umístěný za reverzním proxy serverem, můžete zde určit, které HTTP hlavičky obsahují IP adresu koncového klienta. Hlavičky jsou hledány v uvedeném pořadí a použije se první nalezená.';
$string['configgooglemapkey'] = 'Na adrese <a href="http://code.google.com/apis/maps/signup.html" >http://code.google.com/apis/maps/signup.html</a> si vygenerujte API klíč pro použití Google map při zobrazení umístění IP adresy. Adresa vašeho serveru je {$a}';
$string['configgradebookroles'] = 'Které uživatele zobrazovat u výpisu klasifikace. Uživatelé potřebují alespoň jednu z těchto rolí v daném kurzu, aby byli zobrazeni u jeho popisu.';
$string['configgradeexport'] = 'Které z formátů pro export klasifikace chcete používat jako primární. Zvolené moduly nastaví a budou používat pole "naposledy exportováno" u každé známky. Toto může mj. vést k tomu, že exportované záznamy budou identifikovány jako "nové" nebo "aktualizované". Pokud si nejste jisti, nevolte žádnou z nabídek.';
$string['confighiddenuserfields'] = 'Která pole v profilech uživatelů mají být skryta před jinými uživateli, než jsou vyučující a správci? Pro označení více položek podržte klávesu CTRL.';
$string['configidnumber'] = 'Tato volba určuje, zda (a) uživatelé nejsou vůbec požádáni o ID číslo (např. rodné číslo, číslo občanského průkazu či jiný identifikátor); (b) uživatelé jsou požádáni o vyplnění ID čísla, ale nemusí jej zadávat; (c) uživatelé jsou požádáni o ID číslo a musejí je zadat. Je-li číslo zadáno, zobrazuje se v uživatelském profilu.';
$string['configintcachemax'] = 'Platí pouze pro typ vyrovnávací paměti "internal". Určuje maximální počet záznamů, které budou v paměti udržovány. Doporučená hodnota je 50. Nastavte nižší, pokud potřebujete snížit velikost obsazené paměti.';
$string['configintro'] = 'Na této stránce můžete určit hodnoty několika nastavitelných proměnných, díky nimž poběží Moodle na vašem serveru bez problémů. Nemějte obavy -- přednastavené hodnoty většinou postačují, a navíc se můžete na tuto stránku kdykoliv vrátit a nastavení změnit.';
$string['configintroadmin'] = 'Na této stránce byste měli nastavit váš hlavní administrátorský účet. Administrátor (správce) spravuje celou instalaci Moodlu. Ujistěte se, že zadáváte bezpečné uživatelské jméno a heslo, stejně jako platnou e-mailovou adresu. Později můžete vytvořit více administrátorských účtů.';
$string['configintrosite'] = 'Zde můžete nastavit vzhled titulní stránky a název stránek. Můžete se sem kdykoliv později vrátit a změnit toto nastavení ve Správě stránek.';
$string['configiplookup'] = 'Při kliknutí na IP adresu (jako např 86.49.131.129, typicky jsou zobrazovány v protokolech) se otevře mapa s vyznačením odhadované lokace daného počítače. Tuto funkci zajišťují různé zásuvné moduly, z nichž každý má své přednosti i nevýhody.';
$string['configkeeptagnamecase'] = 'Zaškrtněte, pokud si přejete, aby si štítky zachovávaly takovou velikost písmen, jakou použil uživatel, který je vložil.';
$string['configlang'] = 'Zvolte výchozí jazyk pro tyto stránky. Uživatelé si mohou nastavit svůj preferovaný jazyk ve svém profilu nebo vybrat jazyk pro aktuální sezení v nabídce na titulní stránce.';
$string['configlanglist'] = 'Seznam povolených jazyků. Jednotlivé kódy jazyků oddělte čárkami (např. "cs,en,es_es,fr,sk,it").

Ponecháte-li toto pole prázdné, budou si uživatelé moci vybrat libovolný nainstalovaný jazyk.';
$string['configlangmenu'] = 'Zobrazovat nabídku volby jazyka na titulní stránce, přihlašovací stránce apod. Tato volba neovlivňuje možnost nastavení jazyka v uživatelském profilu.';
$string['configlangstringcache'] = 'Zahrne do zkompilovaných souborů v datovém adresáři všechny jazykové řetězce. Pokud překládáte Moodle nebo měníte řetězce ve zdrojovém kódu Moodlu, budete tuto volbu pravděpodobně chtít vypnout. V ostatních případech ji nechte zapnutou, zlepší se tím výkon stránek.';
$string['configlatinexcelexport'] = 'Zvolte kódování pro exporty do MS Excel.';
$string['configlocale'] = 'Zde můžete přenastavit použitou sadu lokalizačních pravidel (locale) pro všechny jazykové balíčky. Příslušné locale musí být nainstalované na serveru. Ponecháte-li pole prázdné, bude pro češtinu použito locale "cs_CZ.utf8". V naprosté většině případů by toto pole mělo zůstat prázdné.';
$string['configloginhttps'] = 'Zapnout zapezpečenou komunikaci https pouze pro přihlašovací stránku a poté přejít zpět na nezabezpečenou komunikaci. POZOR: Https musí být plně funkční před zapnutím této volby -- v opačném případě se nebude moci nikdo přihlásit, ani vy!';
$string['configloglifetime'] = 'Doba, po kterou jsou uchovávány protokoly o činnosti uživatelů. Protokoly staršího data budou automaticky odstraňovány. Doporučujeme udržovat protokoly co nejdéle, mohou se vám hodit. Pokud však provozujete hodně využívaný server a máte problémy s jeho výkonem, zkraťte tuto dobu. Nedoporučuje se volit hodnoty nižší než 30, neboť poté může dojít k problémům při generování statistik.';
$string['configlookahead'] = 'Výhled';
$string['configmaxbytes'] = 'Určete maximální možnou velikost nahrávaných souborů platnou pro celé stránky. Tato hodnota je omezena parametry PHP post_max_size and a upload_max_filesize a parametrem Apache LimitRequestBody. U každého kurzu lze v rámci zde nastaveného rozmezí definovat vlastní maximální velikost nahrávaných souborů. Při hodnotě "Limit serveru" bude použita nejvyšší dostupná velikost.';
$string['configmaxconsecutiveidentchars'] = 'Heslo nesmí obsahovat více než tento počet za sebou následujících shodných znaků. Pokud chcete kontrolu vypnout, zadejte 0.';
$string['configmaxeditingtime'] = 'Kolik času mají uživatelé na úpravu odeslaných diskusních příspěvků, komentářů k heslům ve slovníku apod. Doporučujeme nastavit 30 minut.';
$string['configmaxevents'] = 'Počet událostí';
$string['configmemcachedhosts'] = 'Platí pro memcached. Čárkami oddělený seznam hostitelských počítačů, na kterých běží démon memcached. Zadejte IP adresy, pokud chcete předejít DNS zdržení. memcached může mít problémy, pakliže přidáte/odeberete hostitele za běhu.';
$string['configmemcachedpconn'] = 'Platí pro memcached. Zda používat trvalá spojení (persistent connections). Používejte s rozvahou - Apache/PHP může spadnout po restartu démona memcached.';
$string['configmessaging'] = 'Povolit zasílání zpráv mezi uživateli stránek?';
$string['configmessagingallowemailoverride'] = 'Povolit uživatelům odesílání emailových zpráv na jinou adresu než je emailová adresa v jejich profilu';
$string['configmessagingdeletereadnotificationsdelay'] = 'Přečtená upozornění mohou být odstraňována kvůli úspoře místa. Za jak dlouho poté, co je upozornění přečteno, může být odstraněno?';
$string['configmessaginghidereadnotifications'] = 'Zda se mají při prohlížení historie zpráv skrýt upozornění na události, jako např. upozornění na nový příspěvek ve fóru';
$string['configminpassworddigits'] = 'Minimální počet číslic v heslech.';
$string['configminpasswordlength'] = 'Minimální počet znaků v heslech.';
$string['configminpasswordlower'] = 'Minimální počet malých písmen v heslech.';
$string['configminpasswordnonalphanum'] = 'Minimální počet nealfanumerických znaků v heslech.';
$string['configminpasswordupper'] = 'Minimální počet velkých písmen v heslech.';
$string['configmycoursesperpage'] = 'Maximální počet kurzů, které se zobrazí na jakémkoliv výpisu kurzů uživatele';
$string['configmymoodleredirect'] = 'Používat stránku "Můj Moodle" namísto běžné úvodní stránky po přihlášení uživatelů?';
$string['configmypagelocked'] = 'Touto volbou je možno zamezit úpravám výchozí stránky samotnými uživateli. Správci mohou výchozí stránku upravovat vždy.';
$string['confignavcourselimit'] = 'Počet kurzů, které budou zobrazeny nepřihlášeným uživatelům nebo uživatelům, kteří nejsou v žádném kurzu zapsaní.';
$string['confignavshowallcourses'] = 'Zda se mají uživatelům v navigaci zobrazovat jejich kurzy v položce Moje kurzy i v seznamu kurzů. Je-li vypnuto, pak uživatelé uvidí v navigaci pouze položku Moje kurzy.';
$string['confignavshowcategories'] = 'Zda se mají v navigační liště a navigačním bloku zobrazovat i kategorie kurzů. V případě kurzů, do nichž je uživatel zapsán, se kategorie nezobrazuje a kurzy jsou uvedeny v části "Mé kurzy".';
$string['confignotifyloginfailures'] = 'Jestliže jsou zaznamenávány neúspěšné pokusy o přihlášení, vyberte, komu mají být zasílána hlášení.';
$string['confignotifyloginthreshold'] = 'Je-li aktivní upozorňování na neúspěšná přihlášení, po kolika neúspěšných pokusech na jednoho uživatele nebo jednu IP adresu se má upozornění rozeslat?';
$string['confignotloggedinroleid'] = 'Nepřihlášení návštěvníci vašich stránek budou považováni za uživatele, jimž je na globální úrovni celého serveru udělena tato role. Většinou je zde vhodné mít nastavenu roli Host, ale možná si budete chtít vytvořit vlastní roli s většími či menšími právy. Věci jako přidávání příspěvků apod. stále vyžadují platné přihlášení.';
$string['configopentogoogle'] = 'Dovolit vyhledávači Google indexovat obsah kurzů, které jsou přístupné pro hosty. Lidé, kteří se k vám dostanou pomocí vyhledávání v Googlu, budou automaticky přihlášeni jako host.';
$string['configoverride'] = 'Definováno v config.php';
$string['configpasswordpolicy'] = 'Zda má Moodle kontrolovat platnost hesla vůči zásadám bezpečných hesel. Tyto zásady můžete definovat níže. Při volbě \'Ne\' budou zásady bezpečných hesel ignorovány.';
$string['configpathtoclam'] = 'Cesta k programu Clam AV. Pravděpodobně /usr/bin/clamscan nebo /usr/bin/clamdscan. Jestliže chcete provádět antivirovou kontrolou, je nutné tento údaj zadat.';
$string['configpathtodu'] = 'Cesta k programu "du" (disk usage). Pravděpodobně něco jako /usr/bin/du. Zadáním této cesty se urychlí generování stránek, které zobrazují obsah adresáře s mnoha soubory.';
$string['configperfdebug'] = 'Vypisování údajů o výkonu vašeho serveru v zápatí standardního motivu stránek.';
$string['configprofileroles'] = 'Seznam rolí, jejichž přidělení je viditelné v uživatelských profilech a na stránce se seznamem účastníků v kurzu.';
$string['configprofilesforenrolledusersonly'] = 'Aby se zabránilo zneužití vašich stránek, je automaticky skrýváno pole s popisem v profilu uživatelů, kteří nejsou zapsáni v žádném kurzu. Noví uživatelé se proto musejí zapsat alespoň do jednoho kurzu předtím, než si mohou upravit svůj popis v uživatelském profilu.';
$string['configprotectusernames'] = 'Ve výchozím nastavení skript forget_password.php nezobrazuje žádnou nápovědu, která by usnadnila uhodnutí uživatelských jmen nebo adres.';
$string['configproxybypass'] = 'Čárkami oddělený seznam doménových jmen nebo IP adres (i částečných), které nemají používat proxy server (např.: 192.168., .mojedomena.cz) ';
$string['configproxyhost'] = 'Nastavení proxy serveru - jestliže váš Moodle server nemá přímý přístup do Internetu, zadejte adresu a port proxy serveru. Jinak ponechejte prázdné.';
$string['configproxypassword'] = 'Pokud je pro přístup na internet přes proxy vyžadováno heslo, napište ho sem. V opačném případě nevyplňujte (je vyžadováno PHP cURL).';
$string['configproxyport'] = 'Pokud se váš server potřebuje připojovat pomocí proxy, uveďte zde proxy port.';
$string['configproxytype'] = 'Typ proxy serveru (je vyžadováno PHP5 a cURL pro podporu SOCKS5)';
$string['configproxyuser'] = 'Pokud je pro přístup na internet přes proxy vyžadováno uživatelské jméno, napište ho sem. V opačném případě nevyplňujte (je vyžadováno PHP cURL).';
$string['configquarantinedir'] = 'Jestliže chcete přesouvat podezřelé soubory do karantény, zadejte zde název složky. Web server musí mít možnost zápisu do této složky. Jestliže nezadáte žádnou cestu, nebo cestu chybnou, soubory budou smazány. Cestu neukončujte lomítkem.';
$string['configrcache'] = 'Používat vyrovnávací paměť k dočasnému ukládání záznamů z databáze. Nezapomeňte rovněž nastavit "cachetype".';
$string['configrcachettl'] = 'Po jakou dobu (v sekundách) mají být záznamy udržovány ve vyrovnávací paměti. Zvolte hodnotu menší než 15';
$string['configrecaptchaprivatekey'] = 'Řetězec znaků používaný ke komunikaci mezi vaším Moodlem a serverem recaptcha.net. Získáte ho na stránce http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Řetězec znaků používaný při zobrazování prvku reCAPTCHA přihlašovacího formuláře. Generováno http://www.google.com/recaptcha';
$string['configrequestedstudentname'] = 'Slovo označující jednoho studenta v požadovaných kurzech';
$string['configrequestedstudentsname'] = 'Slovo označující více studentů v požadovaných kurzech';
$string['configrequestedteachername'] = 'Slovo označující jednoho učitele v požadovaných kurzech';
$string['configrequestedteachersname'] = 'Slovo označující více učitelů v požadovaných kurzech';
$string['configrequiremodintro'] = 'Pokud vypnete tuto možnost, uživatelé nebudou nuceni vkládat úvodní popis modulů činností v kurzech.';
$string['configrunclamavonupload'] = 'Používání antiviru clam pro kontrolu všech nahrávaných souborů.';
$string['configrunclamonupload'] = 'Kontrolovat nahrávané soubory pomocí Clam AV. Nezapomeňte nastavit cestu ke Clam AV. (Clam AV je volně dostupný antivirový program, více na http://www.clamav.net)';
$string['configsectioninterface'] = 'Rozhraní';
$string['configsectionmail'] = 'Pošta';
$string['configsectionmaintenance'] = 'Údržba';
$string['configsectionmisc'] = 'Různé';
$string['configsectionoperatingsystem'] = 'Operační systém';
$string['configsectionpermissions'] = 'Oprávnění';
$string['configsectionrequestedcourse'] = 'Žádosti o založení kurzů';
$string['configsectionsecurity'] = 'Zabezpečení';
$string['configsectionstats'] = 'Statistiky';
$string['configsectionuser'] = 'Uživatel';
$string['configsecureforms'] = 'Používat vyšší úroveň zabezpečení při přijímání údajů z webových formulářů? Je-li tato volba povolena, pak je proměnná prohlížeče HTTP_REFERER ověřována proti aktuální adrese formuláře. V ojedinělých případech může toto nastavení způsobovat problémy, zejména používá-li uživatel firewall (např. Zonealarm nebo Kerio Personal Firewall) nastavený tak, aby hodnotu proměnné HTTP_REFERER blokoval. K příznakům patří problémy s formuláři, například na přihlašovací stránce. Jste-li na pochybách, ponechejte zde hodnotu \'Ano\'.';
$string['configsessioncookie'] = 'Název souboru cookie používaného těmito stránkami. Jde o volitelné nastavení, které je užitečné pouze  v případě, že provozujete více instalací Moodlu na jednom serveru.';
$string['configsessioncookiedomain'] = 'Zde můžete změnit doménu, ze které jsou dostupné Moodlovské cookies. To se vám může hodit, pokud např. používáte vlastní autentizační moduly a/nebo potřebujete sdílet informace o aktuální session s jinou webovou aplikací na jiné subdoméně. <strong>UPOZORNĚNÍ: silně doporučujeme ponechat výchozí (tj. prázdnou) hodnotu. Chybné nastavení může způsobit, že se na vaše stránky nebude možno vůbec přihlásit.</strong>';
$string['configsessioncookiepath'] = 'Podadresář vašich webových stránek, kam prohlížeče odesílají soubory cookie vaší instalace Moodlu. Pravděpodobně vám bude vyhovovat výchozí \'/\'.';
$string['configsessiontimeout'] = 'Délka nečinnosti, po níž jsou uživatelé automaticky odhlášeni.';
$string['configshowcommentscount'] = 'Zobrazovat počet komentářů za cenu jednoho extra databázového dotazu při zobrazování odkazu na komentáře.';
$string['configshowsiteparticipantslist'] = 'Kdo má mít přístup k seznamu uživatelů stránek, který obsahuje všechny studenty a učitele?';
$string['configsitedefaultlicense'] = 'Výchozí licence';
$string['configsitedefaultlicensehelp'] = 'Výchozí licence pro publikování obsahu na vašich stránkách';
$string['configsitemaxcategorydepth'] = 'Maximální počet podkategorií';
$string['configsitemaxcategorydepthhelp'] = 'Do jaké hloubky se má zobrazovat hierarchie kategorií';
$string['configslasharguments'] = 'Soubory nahrané do Moodle (např. obrázky) mohou být v prohlížeči zobrazovány pomocí URL s názvem souboru za lomítkem. Tento způsob je efektivnější vzhledem ke snadnějšímu ukládání obrázků ve vyrovnávací paměti proxy serverů a prohlížečů. Bohužel, některé PHP servery tuto možnost nepodporují, takže pokud narazíte na problémy se zobrazováním připojených souborů nebo obrázků (např. fotografií uživatelů), zakažte tuto volbu.';
$string['configsmartpix'] = 'Je-li zapnuto, vyhledávají se ikony pomocí PHP skriptu nejprve v daném motivu, pak ve všech nadřazených motivech a nakonec ve složce /pix. Tím odpadá potřeba kopií obrázků napříč tématy, ale mírně se zvyšuje zátěž.';
$string['configstartwday'] = 'Začátek týdne';
$string['configstatsfirstrun'] = 'Jak daleko do minulosti se mají zpracovat statistiky <b>při prvním spuštění</b> této naplánované úlohy. Toto první zpracování může trvat dlouhou dobu a je docela náročné na systémové prostředky serveru. Jestliže je tedy na vašich stránkách velký provoz a navíc máte Moodle nainstalován na sdíleném hostingovém serveru, nedoporučujeme nastavovat příliš velkou hodnotu. Pro účely tohoto nastavení se jedním měsícem rozumí 28 dní. V generovaných grafech a statistikách odpovídá jeden měsíc jednomu kalendářnímu měsíci.';
$string['configstatsmaxruntime'] = 'Zpracování statistik může poměrně náročné. Využijte proto tohoto a následujícího pole a nastavte, kdy bude tato úloha spuštěna a jak dlouho poběží.';
$string['configstatsmaxruntime2'] = 'Zpracování může být poměrně náročné, proto určete maximální povolený čas na shromáždění statistik z jednoho dne. Maximální počet dní, které budou zpracovány při jednom spuštění cronu, je 31.';
$string['configstatsmaxruntime3'] = 'Kolik času dáte Moodlu na zpracování statistik za jeden den. Mějte na paměti, že zpracování statistik výrazně zatěžuje server. Počet dnů, které budou zpracovány v rámci jednoho spuštění služby cron, lze nastavit níže.';
$string['configstatsruntimedays'] = 'Kolik dnů může být zpracováno v rámci jednoho sběru statistik. Jsou-li vaše statistiky aktuální, bude zpracován pouze jeden (právě uplynulý) den. Upravte toto nastavení v závislosti na zatížení vašeho serveru. Snižte tuto hodnotu, pokud potřebujete kratší dobu provádění sběru statistik.';
$string['configstatsruntimestart'] = 'Kdy se má spustit úloha (cron) zpracovávající statistiky? Pokud na jednom stroji provozujete několik Moodle serverů, nastavte pro každý z nich jiný čas.';
$string['configstatsuserthreshold'] = 'Při vyhodnocování kurzů budou ignorovány kurzy, v nichž je zapsáno méně uživatelů (počítají se všechny role) než uvedená nenulová hodnota.';
$string['configstrictformsrequired'] = 'Je-li povoleno, nebudou uživatelé moci v určitých položkách formuláře zadávat mezery nebo konce řádků.';
$string['configstripalltitletags'] = 'Zda se mají odstranit HTML značky z názvů studijních materiálů a modulů činností. Používáte-li HTML v názvech modulů, nezaškrtávejte.';
$string['configsupportemail'] = 'Tato emailová adresa bude zveřejněna uživatelům pro případ obecné podpory na vašich stránkách (např. když si uživatel zakládá nový účet). Ponecháte-li prázdné, nebude tento kontakt na uživatelskou podporu uváděn.';
$string['configsupportname'] = 'Jméno osoby nebo instituce zodpovědné za uživatelskou podporu na vašich stránkách prostřednictvím emailu nebo webové stránky.';
$string['configsupportpage'] = 'Tato webová adresa bude zveřejněna uživatelům pro případ obecné podpory na vašich stránkách (např. když si uživatel zakládá nový účet). Ponecháte-li prázdné, nebude tento kontakt na uživatelskou podporu uváděn.';
$string['configthemedesignermode'] = 'Soubory s obrázky a s definicí kaskádových stylů (CSS) vašich grafických motivů jsou z důvodu výkonnosti ukládány ve vyrovnávací paměti serveru i prohlížečů. Pokud vyvíjíte vlastní grafický motiv nebo upravujete kód Moodle, můžete chtít zapnout tento speciální režim, při němž není vyrovnávací paměť používána a s každým požadavkem si prohlížeč stahuje celý motiv. Pozor, to samozřejmě způsobí zpomalení načítání vašich stránek pro všechny vaše uživatele. Jako alternativní řešení můžete proto zvolit jednorázový ruční reset vyrovnávacích pamětí na stránce s výběrem motivu.';
$string['configthemelist'] = 'Ponecháte-li toto pole prázdné, budou si uživatelé moci vybrat libovolný dostupný motiv vašich stránek. Jinak zde uveďte seznam povolených motivů. Jednotlivé názvy oddělte čárkou (např. \'standard,metal,garden\'). Pozor - nepoužívejte v seznamu mezery!';
$string['configtimezone'] = 'Vyberte časové pásmo, v němž se nachází váš server. Uživatelé si mohou toto nastavení změnit v uživatelském profilu. Úlohy spouštěné cronem se řídí zde nastaveným časovým pásmem.';
$string['configunzip'] = 'Umístění programu unzip (pouze pro Unix, volitelné). Pokud je zadáno, bude Moodle používat tento program k rozbalování zip archivů na serveru. Jinak bude používat vlastní knihovny.';
$string['configuseblogassociations'] = 'Mají mít uživatelé možnost nastavit příspěvky v jejich blogu jako související s konkrétními kurzy a moduly činností v těchto kurzech?';
$string['configuseexternalyui'] = 'Zda se mají namísto lokální kopie v Moodle používat YUI knihovny dostupné online přímo na serverech Yahoo. Pokud nebudou mít k dispozici připojení k Internetu, nebude AJAX fungovat uživatelům vůbec.

Toto nastavení není kompatibilní se stránkami zobrazovanými přes protokol https://.';
$string['configuserquota'] = 'Kolik maximálně celkem mohou zabírat soubory, které si uživatelé uložili do svých soukromých souborových oblastí. {$a->bytes} bajtů == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Zda se má v navigaci používat krátký název stránek namísto textu "Hlavní nabídka".';
$string['configusetags'] = 'Povolit funkci nálepek na těchto stránkách?';
$string['configvariables'] = 'Obecné parametry';
$string['configverifychangedemail'] = 'Povolit kontrolu změněných emailových adres oproti seznamu povolených a zakázaných emailových domén. Pokud toto nastavení není povoleno, pak se emailové adresy kontrolují pouze při zakládání účtu.';
$string['configvisiblecourses'] = 'Zobrazovat kurzy ve skrytých kategoriích normálně';
$string['configwarning'] = 'Následující hodnoty upravujte velmi opatrně -- nestandardní hodnoty mohou způsobovat problémy.';
$string['configxmlstrictheaders'] = 'Toto je nastavení užitečné pouze pro vývojáře. Určuje, zda se má stránka generovat pomocí XML http hlaviček a prologu, takže prohlížeče zobrazují XHTML chyby v těle stránky.';
$string['configyuicomboloading'] = 'Zda povolit optimalizaci nahrávání YUI knihoven. Z důvodu výkonnosti by mělo být vždy povoleno na produkčních serverech.';
$string['configzip'] = 'Umístění programu zip (pouze pro Unix, volitelné). Pokud je zadáno, bude Moodle používat tento program k vytváření zip archivů na serveru. Jinak bude používat vlastní knihovny.';
$string['confirmation'] = 'Potvrzení';
$string['confirmdeletecomments'] = 'Opravdu odstranit komentáře?';
$string['confirmed'] = 'Potvrzeno';
$string['convertformat'] = 'Výstupní formát programu <i>convert</i>';
$string['cookiehttponly'] = 'Pouze http cookies';
$string['cookiesecure'] = 'Pouze zabezbečená cookies';
$string['country'] = 'Výchozí země';
$string['coursecontact'] = 'Vedoucí kurzů';
$string['coursecontact_desc'] = 'Které uživatele zobrazovat u popisu kurzu. Uživatelé potřebují alespoň jednu z těchto rolí v daném kurzu, aby byli zobrazeni u jeho popisu.';
$string['courselistshortnames'] = 'Zobrazovat krátké názvy';
$string['courselistshortnames_desc'] = 'V seznamu kurzů budou kurzy uvedeny včetně svého krátkého názvu.';
$string['coursemgmt'] = 'Přidat/upravovat kurzy';
$string['courseoverview'] = 'Přehled kurzu';
$string['courserequestnotify'] = 'Upozornění na žádost o kurz';
$string['courserequestnotifyemail'] = '{$a->user} žádá o založení nového kurzu na {$a->link}';
$string['courserequests'] = 'Požadované kurzy';
$string['courserequestspending'] = 'Čekající žádosti o nový kurz';
$string['courses'] = 'Kurzy';
$string['coursesperpage'] = 'Počet kurzů na stránku';
$string['creatornewroleid'] = 'Role tvůrců v nových kurzech';
$string['creatornewroleid_help'] = 'Pokud uživatel ještě nemá oprávnění spravovat nový kurz, je automaticky zapsán pomocí této role.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Spouštění cronu pouze z příkazové řádky';
$string['cronerrorclionly'] = 'Je mi líto. Přístup na tuto stránku z webového rozhraní byl správcem zakázán.';
$string['cronerrorpassword'] = 'Je mi líto. Pro přístup na tuto stránku musíte použít platné heslo.';
$string['cron_help'] = 'Skript cron.php provádí naplánované úlohy Moodle serveru a spouští řadu úkonů souvisejících s jeho údržbou (např. rozesílá kopie příspěvků do diskusních fór emailem). Musíte zajistit pravidelné spouštění tohoto skriptu např. každých 5 minut.';
$string['cronremotepassword'] = 'Heslo pro spuštění cronu';
$string['cronwarning'] = 'Skript <a href="cron.php">cron.php</a>, který má na starosti běžnou údržbu serveru, nebyl během posledních 24 hodin spuštěn.';
$string['ctyperecommended'] = 'Rozšíření PHP ctype je velmi doporučováno z důvodů výkonu vašich stránek, obzvláště když pracujete s jazyky, které nepoužívají latinku.';
$string['ctyperequired'] = 'Rozšíření PHP ctype je Moodlem vyžadováno z důvodů výkonu a vícejazyčné podpory.';
$string['curlcache'] = 'TTL vyrovnávací paměti cURL';
$string['curlrecommended'] = 'Instalace volitelné knihovny cURL je vysoce doporučována, pokud chcete napojit váš Moodle server do sítě MNet.';
$string['curlrequired'] = 'Instalace knihovny cURL je nutná pro komunikaci s externími repozitáři obsahu.';
$string['curltimeoutkbitrate'] = 'Nejnižší předpokládaná rychlost stahování přes cURL (kb/s)';
$string['curltimeoutkbitrate_help'] = 'Když váš server stahuje obsah z internetu (např. ze vzdáleného repozitáře), může vždy předpokládat stahování alespoň touto nastavenou rychlostí. Podle toho si přepočítá potřebný čas pro vypršení spojení (timeout). Pro získání velikosti stahovaného souboru se použije HTTP požadavek typu HEAD.

Při vložení hodnoty 0 nebude odesílán žádný HEAD požadavek a čas pro vypršení spojení bude nastaven na fixní hodnotu definovanou v kódu.';
$string['currenttheme'] = 'Aktuální motiv';
$string['customcheck'] = 'Další kontroly';
$string['custommenu'] = 'Vlastní nabídka';
$string['custommenuitems'] = 'Položky vlastní nabídky';
$string['datarootsecurityerror'] = '<p><strong>BEZPEČNOSTNÍ VAROVÁNÍ!</strong></p><p>Váš datový adresář (dataroot) je chybně umístěn a je přímo dostupný přes WWW. Všechny privátní soubory Moodlu jsou dostupné komukoliv na Internetu. Některé z nich mohou posloužit útočníkům k získání neoprávněného přístupu na úrovni správce vašeho serveru!</p>
<p><em>Musíte</em> přesunout váš datový adresář ({$a}) tak, aby nebyl ve veřejném webovém adresáři a adekvátně tomu upravit nastavení <code>$CFG->dataroot</code> v souboru config.php.</p>';
$string['datarootsecuritywarning'] = 'Bezpečnostní varování - zkontrolujte si, že datový adresář ({$a}) není přímo dostupný přes webové rozhraní.';
$string['dbmigrate'] = 'Migrace databáze Moodlu';
$string['dbmigrateconnecerror'] = 'Nelze se připojit k určené databázi.';
$string['dbmigrateencodingerror'] = 'Zvolená databáze používá kódování {$a} namísto požadovaného UNICODE/UTF8.<br />Vyberte prosím jinou databázi.';
$string['dbmigratepostgres'] = 'Používáte zřejmě databázový server PostgreSQL. Pro pokračování migrace musíte ručně vytvořit novou databázi s kódováním \'UNICODE\' (PostgreSQL 7), nebo \'UTF8\' (PostgreSQL 8), do níž budou převedena data ze stávající databáze. Zadejte údaje pro připojení k této nové databázi:';
$string['dbmigratewarning'] = 'Před spuštěním tohoto procesu bezpodmínečně proveďte zálohu stávající databáze Moodlu! Pokud nevíte, jak to provést, obraťte se na administrátora vašeho serveru. Stránky Moodlu budou po zahájení migrace přepnuty do režimu údržby.';
$string['dbmigratewarning2'] = '<b>Upozornění: Hodláte spustit proces migrace databáze. Ujistěte se prosím pečlivě, že máte k dispozici zálohu celé vaší současné databáze Moodlu.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Proběhla migrace této databáze na novou databázi UTF8. Upravte soubor config.php a zadejte v něm údaje pro používání nové databáze. Původní databázi již nepoužívajte.</font>';
$string['dbmigrationdupfailed'] = 'Duplikace databáze selhala a vrátila následující chybu:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Informace o session ukládat v databázi';
$string['debug'] = 'Ladící informace';
$string['debugall'] = 'ALL: Zobrazovat všechny smysluplné ladící informace z PHP';
$string['debugdeveloper'] = 'DEVELOPER: extra informace pro vývojáře Moodlu';
$string['debugdisplay'] = 'Zobrazení ladících informací';
$string['debugging'] = 'Ladění';
$string['debugminimal'] = 'MINIMAL: Zobrazovat pouze fatální chyby';
$string['debugnone'] = 'NONE: Nezobrazuj žádné zprávy ani varování';
$string['debugnormal'] = 'NORMAL: Zobrazuj chyby, varování a upozornění';
$string['debugpageinfo'] = 'Zobrazovat ladící informace';
$string['debugsmtp'] = 'Ladit odesílání emailů';
$string['debugstringids'] = 'Zobrazovat identifikátory řetězců';
$string['debugstringids_desc'] = 'Tato funkce je užitečná zejména pro vývojáře a překladatele Moodlu. Je-li povolena, pak přidáním parametru strings=1 do URL stránky dojde k zobrazení identifikátoru řetězců vedle jejich samotného obsahu.';
$string['debugvalidators'] = 'Zobrazovat odkazy na validátory obsahu';
$string['defaultcity'] = 'Výchozí město';
$string['defaultcity_help'] = 'Město, které zde zadáte, bude výchozím městem při vytváření nových uživatelských účtů.';
$string['defaulthomepage'] = 'Výchozí domovská stránka uživatelů';
$string['defaultrequestcategory'] = 'Výchozí kategorie pro požadované kurzy';
$string['defaultsettinginfo'] = 'Výchozí: <b>{$a}</b>';
$string['defaultuserroleid'] = 'Výchozí role pro všechny uživatele';
$string['deletefilterareyousure'] = 'Opravdu chcete odstranit filtr "{$a}"?';
$string['deletefilterareyousuremessage'] = 'Chystáte se úplně odstranit filtr "{$a}". Opravdu jej chcete odinstalovat?';
$string['deletefilterfiles'] = 'Všechna data náležící filtru "{$a->filter}" byla odstraněna z databáze. Nyní byste měli odstranit adresář "{$a->directory}" na vašem serveru a zabránit tak reinstalace tohoto filtru.';
$string['deleteincompleteusers'] = 'Odstranit účty bez dokončené registrace po';
$string['deleteunconfirmed'] = 'Odstranit nepotvrzené a neúplné účty po';
$string['deleteuser'] = 'Odstranit uživatele';
$string['deletingfilter'] = 'Odstraňování filtru "{$a}"';
$string['density'] = 'Hustota';
$string['denyemailaddresses'] = 'Zakázané emailové domény';
$string['development'] = 'Vývoj';
$string['devicedetectregex'] = 'Regulární výrazy pro detekci zařízení';
$string['devicedetectregex_desc'] = 'Ve výchozím nastavení umí Moodle detekovat tzv. běžná zařízení ("default" - stolní počítače, notebooky), mobilní zařízení ("mobile" - mobilní telefony, hand held zařízení), tablety ("tablet" - iPad, Android tablet) a některé zastaralé prohlížeče ("legacy" - např. Internet Explorer 6). Nástroj pro volbu grafického motivu pak dovoluje vybrat různé motivy pro tyto jednotlivé typy zařízení. Pomocí tohoto nastavení je možno nadefinovat ještě jemnější rozlišování typu zařízení, které má pak přednost před uvedenými typy.

Například můžete zadat regulární výraz \'/(MIDP-1.0|Maemo|Windows CE)/\' a pojmenovat takto identifikovatelná zařízení vlastním označením, např. "featurephone". Na stránce s výběrem motivu pak můžete pro tato zařízení vybrat specificky upravený motiv, máte-li jej k dispozici. Všechny ostatní telefony by pak používaly motiv vybraný pro obecný typ zařízení "mobile".';
$string['devicedetectregexexpression'] = 'Regulární výraz';
$string['devicedetectregexvalue'] = 'Označení typu zařízení';
$string['devicetype'] = 'Typ zařízení';
$string['disableuserimages'] = 'Zakázat profilové fotografie uživatelů';
$string['displayerrorswarning'] = 'Povolené nastavení PHP <em>display_errors</em> není doporučováno v ostrém provozu, protože některá chybová hlášení mohou případným útočníkům prozradit citlivé informace o vaší instalaci.';
$string['displayloginfailures'] = 'Komu zobrazovat neúspěšná přihlášení:';
$string['dndallowtextandlinks'] = 'Pro nahrání přetáhněte text/odkaz';
$string['docroot'] = 'Umístění dokumentace';
$string['doctonewwindow'] = 'Otevírat v novém okně';
$string['download'] = 'Stáhnout';
$string['edithelpdocs'] = 'Upravit nápovědu';
$string['editingnoncorelangfile'] = 'Pokoušíte se měnit překlad přídavného modulu. Překlady dodatečných modulů od třetích stran můžete ukládat pouze do vaší složky _local. Možná bude vhodné přesunout soubor s překladem do adresáře lang, který je součástí daného modulu, a/nebo jej poslat osobě zodpovědné za jeho údržbu.';
$string['editlang'] = '<b>Úpravy</b>';
$string['editorbackgroundcolor'] = 'Barva pozadí';
$string['editordictionary'] = 'Slovník editoru';
$string['editorfontfamily'] = 'Rodina fontů';
$string['editorfontlist'] = 'Seznam fontů';
$string['editorfontsize'] = 'Velikost fontu';
$string['editorhidebuttons'] = 'Skrytá tlačítka';
$string['editorkillword'] = 'Čištění formátu z MS Word';
$string['editorspelling'] = 'Pravopis editoru';
$string['editorspellinghelp'] = 'Povolit nebo zakázat kontrolu pravopisu. Pokud je povoleno, musí být na serveru nainstalován <strong>aspell</strong>.';
$string['editstrings'] = 'Upravit textové řetězce';
$string['emailchangeconfirmation'] = 'Potvrzovat změnu emailu';
$string['emoticonalt'] = 'Alternativní text';
$string['emoticoncomponent'] = 'Komponenta obrázku';
$string['emoticonimagename'] = 'Jméno souboru';
$string['emoticons'] = 'Emotikony';
$string['emoticons_desc'] = 'Tento formulář definuje emotikony (smajlíky) používané na vašich stránkách. Chcete-li odstranit některý řádek, uložte formulář s prázdnou hodnotou v některém z povinných polí. K zaregistrování nové emotikony vyplňte řádek na konci formuláře. Pro návrat k výchozím hodnotám použijte odkaz níže.

* Text (povinný) - Tento text bude nahrazen nastaveným obrázkem. Musí obsahovat alespoň dva znaky.
* Jméno souboru (povinné) - Jméno souboru s emotikonou bez přípony, relativně k adresáři "pix" v dané komponentě
* Komponenta obrázku (povinná) - Komponenta obsahující obrázek s emotikonou
* Alternativní text (volitelný) - Identifikátor řetězce pro alternativní text obrázku a komponenta, jejíž jazykový balíček tento řetězec definuje.';
$string['emoticonsreset'] = 'Resetovat emotikony na výchozí hodnoty';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Prázdný';
$string['enableajax'] = 'Povolit AJAX';
$string['enablecalendarexport'] = 'Povolit export kalendáře';
$string['enablecomments'] = 'Povolit komentáře';
$string['enablecourserequests'] = 'Povolit požadování kurzů';
$string['enablecssoptimiser'] = 'Povolit optimalizaci CSS';
$string['enablecssoptimiser_desc'] = 'Optimalizace CSS slouží ke zmenšení velikosti CSS souborů odstraněním duplicitních pravidel a stylů, odstraněním nadbytečných mezer a přeformátováním souboru.

Povolení této volby v kombinaci s režimem úprav grafického motivu vede k výraznému poklesu výkonnosti, ale webdesignérům může pomoci navrhovat optimalizované CSS.';
$string['enabledevicedetection'] = 'Povolit detekci zařízení';
$string['enablegravatar'] = 'Povolit Gravatar';
$string['enablegravatar_help'] = 'Pokud si uživatel nenahraje svůj profilový obrázek, má se jej Moodle pokusit získat ze stránek Gravatar?';
$string['enablegroupmembersonly'] = 'Povolit řízení přístupu na základě členství ve skupině';
$string['enablemobilewebservice'] = 'Povolit webové služby pro mobilní zařízení';
$string['enablerecordcache'] = 'Povolit vyrovnávací paměť záznamů';
$string['enablerssfeeds'] = 'Povolit RSS zdroje';
$string['enablesafebrowserintegration'] = 'Povolit prohlížeč Safe exam';
$string['enablestats'] = 'Povolit statistiky';
$string['enabletrusttext'] = 'Povolit funkci důvěryhodného obsahu';
$string['enablewebservices'] = 'Povolit webové služby';
$string['enablewsdocumentation'] = 'Povolit automatické dokumentování webových služeb';
$string['enrolinstancedefaults'] = 'Výchozí nastavení zápisů do kurzu';
$string['enrolinstancedefaults_desc'] = 'Definuje výchozí hodnoty nastavení pro řízení zápisů v nových kurzech.';
$string['enrolmultipleusers'] = 'Zapsat tyto uživatele';
$string['environment'] = 'Programové prostředí';
$string['environmenterrortodo'] = 'Pro pokračování v instalaci této verze Moodlu je nutné nejdříve vyřešit problémy v programovém prostředí (chyby) serveru uvedené výše!';
$string['environmenterrorupgrade'] = 'Výstraha: předtím, než budete pokračovat s upgradem na tuto verzi Moodle, vyřešte prosím všechny problémy s prostředím, uvedené výše. Provedení upgrade před vyřešením těchto problémů by mohlo vést k problémům, až ke ztrátě dat. Chcete pokračovat?';
$string['environmentmustfixsetting'] = 'Je vyžadována změna nastavení PHP';
$string['environmentok'] = 'Prostředí Vašeho serveru plní všechny minimální požadavky.';
$string['environmentrecommendcustomcheck'] = 'Pokud tento test selhal, znamená to možné problémy';
$string['environmentrecommendinstall'] = 'mělo by být nainstalováno a povoleno';
$string['environmentrecommendversion'] = 'doporučena je verze {$a->needed}, nyní používáte verzi {$a->current}';
$string['environmentrequirecustomcheck'] = 'Tento test musí projít';
$string['environmentrequireinstall'] = 'musí být nainstalováno a povoleno';
$string['environmentrequireversion'] = 'vyžadována je verze {$a->needed}, nyní používáte verzi {$a->current}';
$string['environmentsettingok'] = 'detekováno doporučené nastavení';
$string['environmentshouldfixsetting'] = 'Je doporučená změna nastavení PHP';
$string['environmentxmlerror'] = 'Chyba při zjišťování údajů o programovém prostředí ({$a->error_code})';
$string['errordeletingconfig'] = 'Při odstraňování konfiguračních záznamů pro modul "{$a}" došlo k chybě.';
$string['errorsetting'] = 'Nelze uložit nastavení:';
$string['errorwithsettings'] = 'Některá nastavení nebyla změněna kvůli chybě.';
$string['everyonewhocan'] = 'Každý kdo může \'{$a}\'';
$string['exceptions'] = 'výjimky';
$string['experimental'] = 'Experimentální';
$string['experimentalsettings'] = 'Experimentální funkce';
$string['extendedusernamechars'] = 'Povolit nestandardní znaky v uživatelských jménech';
$string['extramemorylimit'] = 'Extra navýšení paměťového limitu PHP';
$string['fatalmagicquotesruntime'] = '<p>Byla detekována závažná chyba v konfiguraci serveru, prosím upozorněte jeho správce.</p><p>Pro správnou funkci Moodle je potřeba změnit nastavení PHP.</p><p>
<code>magic_quotes_runtime</code> musí být nastaveno na hodnotu <code>off</code>.</p><p>Toto nastavení lze změnit v souboru <code>php.ini</code>, v konfiguraci Apache či IIS nebo v souboru <code>.htaccess</code>.</p>';
$string['fatalsessionautostart'] = '<p>Byla nalezena vážná chyba nastavení, prosím kontaktujte správce serveru.</p><p>Pro správnou funkci Moodle je nutné změnit nastavení PHP.</p><p><code>session.auto_start</code> musí být nastaven na <code>off</code>.</p><p>Toto nastavení se provádí úpravou souboru <code>php.ini</code>, změnou nastavení Apache/IIS <br /> nebo úpravou souboru <code>.htaccess</code> na serveru.</p>';
$string['filecreated'] = 'Vytvořen nový soubor';
$string['filestoredin'] = 'Ukládat soubor do složky:';
$string['filestoredinhelp'] = 'Kde budou ukládány soubory';
$string['filterall'] = 'Použít filtry na všechny řetězce';
$string['filtermatchoneperpage'] = 'Jedna shoda na stránku';
$string['filtermatchonepertext'] = 'Jedna shoda na úsek textu';
$string['filters'] = 'Filtry';
$string['filtersettings'] = 'Správa filtrů';
$string['filtersettingsgeneral'] = 'Obecná nastavení filtru';
$string['filteruploadedfiles'] = 'Použít filtry na uploadované soubory';
$string['forcelogin'] = 'Vnutit přihlášení';
$string['forceloginforprofileimage'] = 'Pro zobrazení uživatelských fotografií vnutit přihlášení';
$string['forceloginforprofileimage_help'] = 'Zda se má zakázat zobrazení fotografií uživatelů anonymním návštěvníkům vašich stránek. Zároveň zajistí, že fotografie uživatelů odesílané jako součást e-mailu budou nahrazeny výchozím univerzálním obrázkem.';
$string['forceloginforprofiles'] = 'Vnutit přihlášení pro zobrazování profilů';
$string['forcetimezone'] = 'Vnutit výchozí časové pásmo';
$string['frontpage'] = 'Titulní stránka';
$string['frontpagebackup'] = 'Záloha titulní stránky';
$string['frontpagedefaultrole'] = 'Výchozí role na titulní stránce';
$string['frontpagefilters'] = 'Filtry na titulní stránce';
$string['frontpageloggedin'] = 'Položky na titulní stránce po přihlášení';
$string['frontpageoverrides'] = 'Přenastavení oprávnění na titulní stránce';
$string['frontpagequestions'] = 'Úlohy na titulní straně';
$string['frontpagerestore'] = 'Obnova titulní stránky';
$string['frontpageroles'] = 'Role na titulní stránce';
$string['frontpagesettings'] = 'Nastavení titulní stránky';
$string['fullnamedisplay'] = 'Formát celého jména';
$string['gdrecommended'] = 'Rozšíření GD se používá pro konverzi obrázků. Pokud toto rozšíření chybí, některé funkce (jako např. vkládání obrázků do profilů uživatele) nebudou k dispozici.';
$string['gdversion'] = 'Verze GD';
$string['generalsettings'] = 'Obecná nastavení';
$string['geoipfile'] = 'Datový soubor GeoIP City';
$string['getremoteaddrconf'] = 'Zdroj IP adresy klienta';
$string['globalsquoteswarning'] = '<p><b>Bezpečnostní upozornění</b>: pro správné fungování Moodlu je nutné upravit nastavení PHP <br />na vašem serveru.<p/><p><em>Musíte</em> nastavit <code>register_globals=off</code> a/nebo <code>magic_quotes_gpc=on</code>. <br />Nastavení <code>register_globals=off</code> zvyšuje obecné zabezpečení serveru, nastavit <code>magic_quotes_gpc=on</code> <br />se doporučuje ze stejného důvodu.<p/><p>Nastavení se provádějí v souboru <code>php.ini</code>, v konfiguračním souboru Apache/IIS, nebo v souboru <code>.htaccess</code>.</p>';
$string['globalswarning'] = '<p><strong>Bezpečnostní varování</strong>: Aby Moodle pracoval správně, potřebuje udělat změny v nastavení PHP.<p/><p><em>Musíte</em> nastavit <code>register_globals=off</code>. Tohoto nastavení dosáhnete buď úpravou soubor <code>php.ini</code> (Apache nebo IIS), nebo nastavením pomocí <code>.htaccess</code>.';
$string['googlemapkey'] = 'API klíč k mapám na Googlu';
$string['gotofirst'] = 'První chybějící řetězec';
$string['gradebook'] = 'Klasifikace';
$string['gradebookroles'] = 'Klasifikovaní uživatelé';
$string['gradeexport'] = 'Primární způsoby exportu známek';
$string['groupenrolmentkeypolicy'] = 'Použít bezpečnostní zásady na klíč pro zápis do skupiny.';
$string['groupenrolmentkeypolicy_desc'] = 'Pokud je povoleno, budou nadefinované zásady bezpečného hesla aplikovány též na klíče pro zápis do skupiny.';
$string['guestroleid'] = 'Role hosta';
$string['guestroleid_help'] = 'Tato role je automaticky přiřazována anonymním uživatelům, kteří na stránky přistupují pomocí tlačítka "Přihlásit se jako host". Role je rovněž dočasně přidělena přihlášeným uživatelům, kteří vstupují do kurzu, do něhož nejsou zapsaní a který povoluje vstup pro hosty.';
$string['helpadminseesall'] = 'Vidí správci všechny události v kalendáři, nebo jen ty, které se na ně vztahují?';
$string['helpcalendarsettings'] = 'Konfigurace kalendáře a dalších aspektů Moodlu, které se týkají data a času';
$string['helpforcetimezone'] = 'Zvolte, zda chcete umožnit uživatelům změnu časového pásma, nebo vyberte jedno pásmo společné pro všechny.';
$string['helpsitemaintenance'] = 'Pro případ upgradů a jiné údržby';
$string['helpstartofweek'] = 'Kterým dnem u vás začíná týden. Jestli nevíte, zvolte pondělí ;-)';
$string['helpupcominglookahead'] = 'V kolika následujících dnech se mají implicitně vyhledávat tzv. nadcházející události?';
$string['helpupcomingmaxevents'] = 'Kolik nadcházející událostí se má maximálně zobrazovat?';
$string['helpweekenddays'] = 'Které z dnů v týdnu se mají považovat za \'víkend\' a zobrazovat se v kalendáři odlišnou barvou?';
$string['hiddenuserfields'] = 'Skrýt uživatelská pole';
$string['hidefromall'] = 'Skrýt před všemi uživateli';
$string['hidefromnone'] = 'Neskrývat před nikým';
$string['hidefromstudents'] = 'Skrývat před studenty';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Nastavení HTML editoru';
$string['htmlsettings'] = 'Nastavení HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Zabezpečení HTTP';
$string['hubs'] = 'Komunitní úložiště';
$string['iconvrecommended'] = 'Instalace volitelné knihovny ICONV je silně doporučena, neboť zvyšuje výkon stránek, zejména pokud používáte jazyky nezaložené na latince.';
$string['iconvrequired'] = 'Je vyžadováno rozšíření ICONV';
$string['ignore'] = 'Ignorovat';
$string['includemoduleuserdata'] = 'Zahrnout uživatelská data modulu';
$string['incompatibleblocks'] = 'Nekompatibilní bloky';
$string['installhijacked'] = 'Instalace musí být dokončena ze stejné IP adresy, ze které byla odstartována.';
$string['installsessionerror'] = 'Nelze inicializovat PHP session. Ujistěte sem že váš prohlížeč podporuje cookies.';
$string['intcachemax'] = 'Maximum interních záznamů';
$string['intlrecommended'] = 'Rozšíření intl umožňuje lepší podporu lokalizace Moodle, např. při abecedním řazení dle jazykových pravidel';
$string['invalidsection'] = 'Neplatná sekce';
$string['invaliduserchangeme'] = 'Uživatelské jméno \'changeme\' je rezervováno -- nelze je použít pro vytvoření účtu.';
$string['ipblocked'] = 'Tyto stránky nejsou momentálně k dispozici.';
$string['ipblocker'] = 'Blokování IP adres';
$string['ipblockersyntax'] = 'Vložte každý záznam na samostatný řádek. Platným záznamem je celá IP adresa (např. <b>192.168.10.1</b>)
';
$string['iplookup'] = 'Umístění IP adresy';
$string['iplookupgeoplugin'] = 'Momentálně se pro získání geografického umístění používá služba <a href="http://www.geoplugin.com">geoPlugin</a>. Pro přesnější výsledky se doporučuje nainstalovat kopii databáze MaxMind GeoLite na váš server.';
$string['iplookupinfo'] = 'Ve výchozím nastavení Moodle používá volně dostupnou službu NatGeo (The Internet Geograpic Database) k vyhledávání IP adres. Bohužel tato databáze již není udržována a může poskytovat velmi nepřesné údaje. Doporučujeme nainstalovat lokální kopii zdarma dostupné databáze GeoLite City od MaxMind. Umístění IP adresy se zobrazí na jednoduché mapě nebo na Google Maps. Pamatujte, že budete potřebovat účet u Googlu, abyste získali API klíč k spuštění interaktivních map.';
$string['iplookupmaxmindnote'] = 'Tento produkt využívá databázi GeoLite vytvořenou společností <a href = "http://www.maxmind.com/">MAxMind</a>.';
$string['keeptagnamecase'] = 'Zachovat velikost písmen v názvech štítků';
$string['lang'] = 'Výchozí jazyk';
$string['langcache'] = 'Seznam jazyků ve vyrovnávací paměti';
$string['langcache_desc'] = 'Zda se má používat vyrovnávací paměť pro nabídku dostupných jazyků. Vyrovnávací paměť je automaticky aktualizována, pokud instalujete nebo odstraňujete jazykový balíček přes vestavěný nástroj pro jejich správu. Pokud kopírujete jazykový balíček na server ručně, musíte rovněž ručně vymazat všechny vyrovnávací paměti.';
$string['langlist'] = 'Které jazyky zobrazovat v nabídce';
$string['langmenu'] = 'zobrazovat nabídku jazyků';
$string['langpackwillbeupdated'] = 'Během přechodu na vyšší verzi se Moodle pokusí automaticky aktualizovat i váš český jazykový balíček.';
$string['langstringcache'] = 'Používat cache pro textové řetězce';
$string['languagesettings'] = 'Jazyková nastavení';
$string['latexpreamble'] = 'Preambule LaTeX';
$string['latexsettings'] = 'Nastavení rendereru LaTeX';
$string['latinexcelexport'] = 'Kódování Excel-u';
$string['legacyfilesinnewcourses'] = 'Povolit starý způsob ukládání souborů v nových kurzech';
$string['legacyfilesinnewcourses_help'] = 'Starý způsob ukládání souborů je standardně dostupný pouze v kurzech, které pocházejí z verze 1.9. Některé nové funkce (jako např. zálohování jednoho modulu) nejsou s tímto nastavením kompatibilní.';
$string['licensesettings'] = 'Nastavení licencí';
$string['linkadmincategories'] = 'Správa stránek v navigaci';
$string['linkadmincategories_help'] = 'Zda se mají jednotlivé kategorie správy stránek zobrazovat jako odkazy v navigaci.';
$string['loading'] = 'Nahrávám';
$string['localetext'] = 'Proměnná locale';
$string['localstringcustomization'] = 'Lokální úprava překladu';
$string['location'] = 'Umístění';
$string['locationsettings'] = 'Nastavení umístění';
$string['locked'] = 'zamknuto';
$string['log'] = 'Protokoly';
$string['logguests'] = 'Protokolovat přístupy hostů';
$string['logguests_help'] = 'Zda se mají do protokolů zaznamenávat i činnosti návštěvníků, kteří se přihlásili jako host, nebo se nepřihlásili vůbec. Velké instalace s masivním přístupem anonymních návštěvníků mohou mít problémy s výkonností, ale jinak se v produkčním prostředí doporučuje ponechat volbu zapnutou.';
$string['loginhttps'] = 'Při přihlášení používat HTTPS';
$string['loginpageautofocus'] = 'Automaticky umístit kurzor do přihlašovacího formuláře';
$string['loginpageautofocus_help'] = 'Povolením této možnosti zjednodušíte přihlašování, v některých případech (např. pokud vaši uživatelé používají čtečky obrazovky) to ovšem může být považováno za chybu přístupnosti.';
$string['loginpasswordautocomplete'] = 'Zabránit ukládání hesel v prohlížeči';
$string['loginpasswordautocomplete_help'] = 'Je-li vypnuto, uživatelé si budou moci uložit své přihlašovací heslo ve svém prohlížeči. Pokud většina vašich uživatelů přistupuje k Moodle ze sdílených počítačů (např. ve školních počítačových učebnách), můžete chtít tuto volbu zapnout. Vaše stránky tím ale přestanou být validní podle standardu XHTML Strict.';
$string['loglifetime'] = 'Udržovat protokoly po dobu';
$string['longtimewarning'] = '<b>Prosím pozor, tento proces může trvat dlouho.</b>';
$string['maintenancemode'] = 'V režimu údržby';
$string['maintfileopenerror'] = 'Chyba při otevírání souborů údržby!';
$string['maintinprogress'] = 'Probíhá údržba serveru...';
$string['managelang'] = 'Správa';
$string['managelicenses'] = 'Správa licencí';
$string['manageqbehaviours'] = 'Správa chování testových úloh';
$string['manageqtypes'] = 'Správa typů testových úloh';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release candidate';
$string['maturity200'] = 'Stabilní verze';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Tip: Můžete chtít tento skript spouštět s volbou --allow-unstable';
$string['maturitycoreinfo'] = 'Váš server běží na verzi označené jako "{$a}", která není určena pro produkční nasazení.';
$string['maturitycorewarning'] = 'Chystáte se se instalovat nebo aktualizovat Moodle na verzi označenou jako "{$a}"
která není určena pro produkční nasazení. Ujistěte se, že se jedná o váš záměr
a že máte správnou verzi
zdrojových kódů Moodle.';
$string['maxbytes'] = 'Maximální velikost nahrávaných souborů';
$string['maxconsecutiveidentchars'] = 'Počet stejných po sobě jdoucích znaků';
$string['maxeditingtime'] = 'Časový limit pro úpravu vložených příspěvků';
$string['mbstringrecommended'] = 'Instalace volitelné knihovny MBSTRING je silně doporučena, neboť zvyšuje výkon stránek, zejména pokud používáte jazyky nezaložené na latince.';
$string['mediapluginavi'] = 'Aktivovat filtr .avi';
$string['mediapluginflv'] = 'Aktivovat filtr .flv';
$string['mediapluginimg'] = 'Automaticky vkládat odkazované obrázky';
$string['mediapluginmov'] = 'Aktivovat filtr .mov';
$string['mediapluginmp3'] = 'Aktivovat filtr .mp3';
$string['mediapluginmpg'] = 'Aktivovat filtr .mpg';
$string['mediapluginogg'] = 'Aktivovat filtr .ogg';
$string['mediapluginogv'] = 'Aktivovat filtr .ogv';
$string['mediapluginram'] = 'Aktivovat filtr .ram';
$string['mediapluginrm'] = 'Aktivovat filtr .rm';
$string['mediapluginrpm'] = 'Aktivovat filtr .rpm';
$string['mediapluginswf'] = 'Aktivovat filtr .swf';
$string['mediapluginswfnote'] = 'Výchozí bezpečnostní nastavení nedovoluje řadovým uživatelům vkládat přímo do HTML textu soubory swf.';
$string['mediapluginwmv'] = 'Aktivovat filtr .wmv';
$string['mediapluginyoutube'] = 'Povolit filtr Odkaz na YouTube';
$string['memcachedhosts'] = 'Hostitelé memcached';
$string['memcachedpconn'] = 'memcached používá trvalé spojení';
$string['messaging'] = 'Povolit systém zasílání zpráv';
$string['messagingallowemailoverride'] = 'Přenastavení oznamovacího e-mailu';
$string['messagingdeletereadnotificationsdelay'] = 'Odstranit přečtená upozornění';
$string['messaginghidereadnotifications'] = 'Skrýt přečtená upozornění';
$string['minpassworddigits'] = 'Číslic';
$string['minpasswordlength'] = 'Délka hesla';
$string['minpasswordlower'] = 'Malých písmen';
$string['minpasswordnonalphanum'] = 'Nealfanumerických znaků';
$string['minpasswordupper'] = 'Velkých písmen';
$string['misc'] = 'Různé';
$string['mnetrestore_extusers'] = '<strong>Poznámka:</strong> Tato záloha obsahuje vzdálené uživatele sítě Moodle Network. Vzdálené účty budou v průběhu tohoto procesu obnoveny.';
$string['mnetrestore_extusers_admin'] = '<strong>Poznámka:</strong> Tato záloha pravděpodobně pochází z jiné instalace Moodlu a obsahuje vzdálené uživatelské účty ze serverů sítě MNet. Moodle se v průběhu obnovy pokusí vytvořit vzdálené uživatelské účty odpovídající vašim hostitelům sítě MNet. Uživatelské účty, pro které nebude nalezen vzdálený MNet hostitel, budou převedeny do režimu interní autentizace (namísto mnet). Bližší informace naleznete v protokolu.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Poznámka:</strong> Tato záloha evidentně pochází z odlišné instalace Moodlu a obsahuje vzdálené uživatelské účty ze serverů sítě MNet. Obnova těchto účtů může selhat, tato operace není podporovaná. Pokud jste si jistí, že záloha pochází z této instalace, nebo můžete zajistit, že jsou správně nastaveny všechny hostitelské počítače v síti MNet, můžete se přesto pokusit o obnovu.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Poznámka:</strong> Tato záloha pravděpodobně pochází z jiné instalace Moodlu a obsahuje vzdálené uživatelské účty ze serverů sítě MNet. Nemáte oprávnění provést tento typ obnovy. Spojte se se správcem vašeho serveru, případně tento kurz obnovte bez jakýchkoliv uživatelských dat.';
$string['mnetrestore_extusers_switchuserauth'] = 'Vzdálený uživatel {$a->username} (pocházející z {$a->mnethosturl}) obnoven jako místní uživatel ověřován pomocí {$a->auth}';
$string['modeditdefaults'] = 'Výchozí hodnoty pro nastavení modulů činností';
$string['modsettings'] = 'Správa činností';
$string['modulesecurity'] = 'Zabezpečení modulů';
$string['multilangforceold'] = 'Vnutit starou syntaxi vícejazyčného obsahu: značka &lt;lang&gt; a značka &lt;span&gt; bez parametru class="multilang"';
$string['mustenablestats'] = 'Na těchto stránkách nejsou statistiky povoleny';
$string['mycoursesperpage'] = 'Maximální počet kurzů';
$string['mydashboard'] = 'Systémová výchozí plocha';
$string['mymoodle'] = 'Můj Moodle';
$string['mymoodleredirect'] = 'Vnutit uživatelům použití stránky Můj Moodle';
$string['mypage'] = 'Výchozí stránka Můj Moodle';
$string['mypagelocked'] = 'Zamknout výchozí stránku';
$string['myprofile'] = 'Výchozí profilová stránka';
$string['mysql416bypassed'] = 'Pokud ovšem ve vaší instalaci Moodlu používáte POUZE jazyky založené na latince (iso-8859-1), můžete nadále používat momentálně nainstalovanou verzi MySQL 4.1.12 (nebo vyšší).';
$string['mysql416required'] = 'Minimální verzí požadovanou pro Moodle 1.6 -- a pro pozdější bezpečný převod všech dat do UTF-8 -- je MySQL 4.1.16.';
$string['navadduserpostslinks'] = 'Odkazy na příspěvky uživatele';
$string['navadduserpostslinks_help'] = 'Zda se mají v navigaci zobrazovat u každého uživatele odkazy na seznam všech odstartovaných diskusí a všech vložených příspěvků na stránkách nebo v daném kurzu.';
$string['navcourselimit'] = 'Limit počtu kurzů';
$string['navigationupgrade'] = 'V průběhu upgrade budou vytvořeny dva nové bloky, které nahrazují původní bloky Správa stránek, Kurzy, Činnosti a Osoby. Pokud jste upravovali přístupová práva k těmto původním blokům, ujistěte se, že se po upgrade chovají nové bloky Navigace a Správa dle vašich potřeb.';
$string['navshowallcourses'] = 'Zobrazit všechny kurzy';
$string['navshowcategories'] = 'Zobrazit kategorie kurzů';
$string['navshowfrontpagemods'] = 'Zobrazit činnosti z titulní stránky v navigaci';
$string['navshowmycoursecategories'] = 'Zobrazit kategorie mých kurzů';
$string['neverdeleteruns'] = 'Nikdy neodstraňovat proběhnutá měření';
$string['nobookmarksforuser'] = 'Nemáte žádné záložky';
$string['nodatabase'] = 'Žádná databáze';
$string['nohttpsformobilewarning'] = 'Doporučuje se povolit šifrované spojení přes HTTPS s platným certifikátem. Moodle app se vždy nejprve pokusí používat zabezpečené spojení.';
$string['nomissingstrings'] = 'Žádné chybějící řetězce';
$string['nonewsettings'] = 'V průběhu aktualizace nebylo přidáno žádné nové nastavení.';
$string['nonexistentbookmark'] = 'Požadovaná záložka neexistuje';
$string['noresults'] = 'Bez výsledků';
$string['noroles'] = 'Žádné role';
$string['notifications'] = 'Upozornění';
$string['notifyloginfailures'] = 'Posílat neúspěšná přihlášení emailem';
$string['notifyloginthreshold'] = 'Práh pro upozornění emailem';
$string['notloggedinroleid'] = 'Role návštěvníků';
$string['numberofmissingstrings'] = 'Chybějících řetězců: {$a}';
$string['numberofstrings'] = 'Celkový počet řetězců: {$a->strings}<br />Chybí: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['numcoursesincombo'] = 'Počet kurzů na titulní stránce';
$string['numcoursesincombo_help'] = 'Kategorizovaný seznam kurzů na titulní stránce se zobrazuje pomalu při masivním počtu kurzů. Pokud počet kurzů na vašem serveru překročí hodnotu uvedenou v tomto nastavení, bude se na titulní stránce namísto kategorizovaného seznamu kurzů zobrazovat odkaz na samostatnou stránku s tímto seznamem.';
$string['opensslrecommended'] = 'Pro běh síťových funkcionalit ("Moodle Networking") je potřeba nainstalovat volitelnou knihovnu OpenSSL.';
$string['opentogoogle'] = 'Povolit prohledávání Googlem';
$string['optionalmaintenancemessage'] = 'Volitelná zpráva pro uživatele po dobu údržby';
$string['order1'] = 'První';
$string['order2'] = 'Druhý';
$string['order3'] = 'Třetí';
$string['order4'] = 'Čtvrtý';
$string['passwordpolicy'] = 'Zásady bezpečného hesla';
$string['pathconvert'] = 'Cesta k binárnímu souboru <i>convert</i>';
$string['pathdvips'] = 'Cesta k binárnímu souboru <i>dvips</i>';
$string['pathlatex'] = 'Cesta k binárnímu souboru <i>latex</i>';
$string['pathtoclam'] = 'Cesta k clam';
$string['pathtodot'] = 'Cesta k programu "dot"';
$string['pathtodot_help'] = 'Úplná cesta ke spustitelnému programu "dot". Pravděpodobně /usr/bin/dot. Program slouží ke generování grafiky ze souborů ve formátu DOT. Momentálně se používá pouze ve vestavěném nástroji pro profilování (vizte Vývoj > Profilování).';
$string['pathtodu'] = 'Cesta k programu "du"';
$string['pathtopgdump'] = 'Cesta k pg_dump';
$string['pathtopgdumpdesc'] = 'Tento údaj je nutné zadat pouze v případě, že provozujete více než jednu verzi pg_dump (např. pokud je na serveru instalována více než jedna verze postgresql).';
$string['pathtopgdumpinvalid'] = 'Neplatná cesta k pg_dump -- buď je zadána chybná cesta, nebo nelze odkazovaný soubor spustit.';
$string['pathtopsql'] = 'Cesta k psql';
$string['pathtopsqldesc'] = 'Tento údaj je nutné zadat pouze v případě, že provozujete více než jednu verzi psql (např. pokud je na serveru instalována více než jedna verze postgresql).';
$string['pathtopsqlinvalid'] = 'Neplatná cesta k psql -- buď je zadána chybná cesta, nebo nelze odkazovaný soubor spustit.';
$string['pathtounzip'] = 'Cesta k unzip';
$string['pathtozip'] = 'Cesta k zip';
$string['perfdebug'] = 'Informace o výkonnosti';
$string['performance'] = 'Výkonnost';
$string['pgcluster'] = 'PostgreSQL cluster';
$string['pgclusterdescription'] = 'Parametry PostgreSQL version/cluster pro operace prováděné z příkazové řádky. Pokud provozujete pouze jednu instanci PostgreSQL, nebo pokud si nejste jisti, ponechte pole prázdné.';
$string['php50restricted'] = 'V PHP 5.0.x bylo nalezeno množství chyb; přejděte buď na vyšší verzi 5.1.x, nebo na nižší verzi 4.3.x či 4.4.x.';
$string['php533warning'] = 'Doporučená je verze PHP 5.3.3 nebo vyšší';
$string['phpfloatproblem'] = 'Byl zjištěn neočekávaný problém ve způsobu zpracování čísel s plovoucí desetinnou čárkou ve vašem PHP - {$a}';
$string['pleaserefreshregistration'] = 'Vaše stránka byla zaregistrována na moodle.org. Zvažte prosím aktualizaci vaší registrace, jestliže na vašich stránkách dojde k významnějším změnám. Vaše registrace byla naposledy aktualizována: {$a}';
$string['pleaseregister'] = 'Chcete-li se zbavit tohoto tlačítka, zaregistrujte svou instalaci Moodlu';
$string['plugin'] = 'Modul';
$string['plugins'] = 'Moduly';
$string['pluginscheck'] = 'Kontrola závislostí modulů';
$string['pluginschecktodo'] = 'Před zahájením instalace této verze Moodle musíte vyřešit všechny požadavky modulů!';
$string['pluginsoverview'] = 'Přehled modulů';
$string['profilecategory'] = 'Katogorie';
$string['profilecategoryname'] = 'Název kategorie (musí být jedinečný)';
$string['profilecategorynamenotunique'] = 'Tento název kategorie je již používán';
$string['profilecommonsettings'] = 'Společná nastavení';
$string['profileconfirmcategorydeletion'] = 'Bylo nalezeno {$a} polí, která budou přesunuta do vyšší kategorie (nebo nižší, pokud se jedná o nejvyšší kategorii).<br />Stále si přejete tuto kategorii odstranit?';
$string['profileconfirmfielddeletion'] = 'Bylo nalezeno {$a} záznamů, které používají toto pole. Informace uložená v poli bude nenávratně ztracena. Stále si přejete pole odstranit?';
$string['profilecreatecategory'] = 'Vytvořit novou kategorii profilů';
$string['profilecreatefield'] = 'Vytvořit nové pole profilu:';
$string['profilecreatenewcategory'] = 'Vytvářím novou kategorii';
$string['profilecreatenewfield'] = 'Vytvářím nové pole "{$a}"';
$string['profiledefaultcategory'] = 'Další pole';
$string['profiledefaultchecked'] = 'Ve výchozím nastavení zaškrtnuto';
$string['profiledefaultdata'] = 'Výchozí hodnota';
$string['profiledeletecategory'] = 'Odstraňuji kategorii';
$string['profiledeletefield'] = 'Odstraňuji pole "{$a}"';
$string['profiledescription'] = 'Popis pole';
$string['profiledscript'] = 'Tento skript byl profilován';
$string['profiledscriptview'] = 'Zobrazit informace o profilování tohoto skriptu';
$string['profileeditcategory'] = 'Úprava kategorie: {$a}';
$string['profileeditfield'] = 'Úprava pole profilu: {$a}';
$string['profilefield'] = 'Pole profilu';
$string['profilefieldcolumns'] = 'Sloupce';
$string['profilefieldispassword'] = 'Je toto políčko pro heslo?';
$string['profilefieldlink'] = 'Odkaz';
$string['profilefieldlink_help'] = 'Má-li se vložený text převádět automaticky na odkaz, vložte zde adresu URL obsahující řetězec $$. Tato dvojice znaků dolaru bude nahrazena hodnotou, kterou zadal uživatel. Například: http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Cíl odkazu';
$string['profilefieldmaxlength'] = 'Maximální délka';
$string['profilefieldrows'] = 'Řádky';
$string['profilefields'] = 'Vlastní pole profilu';
$string['profilefieldsize'] = 'Velikost zobrazení';
$string['profileforceunique'] = 'Měly by být údaje jedinečné?';
$string['profileinvaliddata'] = 'Neplatná hodnota';
$string['profilelocked'] = 'Je pole zamknuto?';
$string['profilemenudefaultnotinoptions'] = 'Výchozí hodnota není jedna z nabízených možností';
$string['profilemenunooptions'] = 'Nebyly dodány žádné možnosti';
$string['profilemenuoptions'] = 'Možnosti (každá na jeden řádek)';
$string['profilemenutoofewoptions'] = 'je potřeba vložit alespoň dvě možnosti';
$string['profilename'] = 'Název';
$string['profilenofieldsdefined'] = 'Nebyla definována žádná pole';
$string['profilerequired'] = 'Je vyplnění pole povinné?';
$string['profileroles'] = 'Role viditelné v profilu';
$string['profilesforenrolledusersonly'] = 'Profily pouze pro zapsané uživatele';
$string['profileshortname'] = 'Krátký název (jedinečný)';
$string['profileshortnamenotunique'] = 'Tento krátký název je již používán';
$string['profilesignup'] = 'Zobrazit v registračním formuláři?';
$string['profilespecificsettings'] = 'Specifická nastavení';
$string['profilevisible'] = 'Kdo může vidět obsah pole?';
$string['profilevisibleall'] = 'Veřejné pole - viditelné pro všechny';
$string['profilevisible_help'] = '<p>Každému uživatelskému poli lze přiřadit tři úrovně viditelnosti:
   skryté, soukromé a veřejné. Skryté pole je typicky vytvořeno správcem,
   který jeho pomocí udržuje o uživatelích zcela neveřejné informace.
   Soukromé pole je určeno pro citlivé údaje, veřejné pole lze použít
   pro ukládání informací libovolného typu.</p>';
$string['profilevisiblenone'] = 'Skryté pole - neviditelné';
$string['profilevisibleprivate'] = 'Soukromé pole - viditelné pouze pro daného uživatele';
$string['profiling'] = 'Profilování';
$string['profilingallowall'] = 'Souvislé profilování';
$string['profilingallowall_help'] = 'Je-li toto nastavení povoleno, můžete v kterémkoliv okamžiku zapnout profilování pomocí parametru PROFILEALL (funguje post, get i cookie). Od té chvíle budou profilovány všechny skripty v dané session. Analogicky lze použít parametr PROFILEALLSTOP k zastavení profilování.';
$string['profilingallowme'] = 'Výběrové profilování';
$string['profilingallowme_help'] = 'Je-li toto nastavení povoleno, můžete si vybrat konkrétní skripty, jejichž provádění chcete profilovat pomocí parametru PROFILEME (funguje post, get i cookie). Analogicky lze použít parametr DONTPROFILEME pro zabránění profilování konkrétního skriptu.';
$string['profilingautofrec'] = 'Automatické profilování';
$string['profilingautofrec_help'] = 'Pomocí tohoto nastavení lze automaticky profilovat náhodně zvolené požadavky. Četnost zapnutí profilování lze měnit nastavenou hodnotou od jedné do x. Nulová hodnota vypíná automatické profilování. Výsledky automatického profilování jsou ukládány pro pozdější analýzu. Při automatickém profilování se uplatňuje nastavení "Vyloučit z profilování" a "Zahrnout do profilování".';
$string['profilingenabled'] = 'Povolit profilování';
$string['profilingenabled_help'] = 'Profilování je vyhledávání míst v programu, které jsou vhodné pro optimalizaci. Pokud povolíte tuto funkci, budete moci pomocí dalších parametrů konfigurovat průběh profilování.';
$string['profilingexcluded'] = 'Vyloučit z profilování';
$string['profilingexcluded_help'] = 'Čárkami oddělený seznam adres, které budou vyloučeny z profilování. Adresy se uvádí relativně ke kořenovému adresáři Moodle s lomítkem na začátku.

Příklad: /admin/index.php,/course/index.php';
$string['profilingincluded'] = 'Zahrnout do profilování';
$string['profilingincluded_help'] = 'Čárkami oddělený seznam adres, které budou vždy při volání profilovány. Adresy se uvádí relativně ke kořenovému adresáři Moodle s lomítkem na začátku a lze použít hvězdičkovou konvenci.

Příklad: /index.php,/course/view.php,/mod/forum/*,/mod/*/view.php';
$string['profilinglifetime'] = 'Uchovat záznam o proběhnutém profilování';
$string['profilinglifetime_help'] = 'Po jak dlouho dobu budou uchováván záznam o proběhnutém profilování. Starší záznamy budou pravidelně odstraňovány. Toto se netýká referenčních záznamů.';
$string['protectusernames'] = 'Chránit uživatelská jména';
$string['proxybypass'] = 'Nepoužívat proxy server';
$string['proxyhost'] = 'Proxy server';
$string['proxypassword'] = 'Heslo k proxy';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Typ proxy';
$string['proxyuser'] = 'Uživatelské jméno k proxy';
$string['purgecaches'] = 'Vymazat všechny dočasné paměti';
$string['purgecachesconfirm'] = 'Z důvodů vyšší výkonnosti Moodle ukládá CSS styly, Javascript, jazykové řetězce, filtrovaný text, RSS zdroje a další vypočítávaná data do dočasné paměti na serveru. Po vymazání se tato paměť znovu začne naplňovat aktuálními údaji tak, jak budou postupně používány. Vymazání dočasné paměti je bezpečné, může ovšem dojít ke chvilkovému snížení rychlosti načítání stránek z důvodu nutného znovunačtení dat do prohlížečů.';
$string['purgecachesfinished'] = 'Dočasná paměť byla vymazána.';
$string['qtyperqpwillberemoved'] = 'Během upgrade bude odstraněn typ testové úlohy RQP. Tento typ jste nepoužívali, takže byste neměli zaznamenta žádné problémy.';
$string['qtyperqpwillberemovedanyway'] = 'Během upgrade bude odstraněn typ testové úlohy RQP. Ve vaší databázi existuje několik takových úloh a ty nebudou fungovat, dokud nepřeinstalujete kód z http://moodle.org/mod/data/view.php?d=13&amp;rid=797 před pokračováním upgrade.';
$string['quarantinedir'] = 'Adresář karantény';
$string['question'] = 'Úloha';
$string['questionbehaviours'] = 'Chování testových úloh';
$string['questioncwqpfscheck'] = 'Jedna nebo více náhodně vybíraných úloh se losuje ze směsice sdílených a nesdílených  kategorií. Prosím, seznamte se se zprávou publikovanou <a href="{$a->reporturl}">zde</a> a pročtěte si dokumentaci <a href="{$a->docsurl}">zde</a>.';
$string['questioncwqpfsok'] = 'Dobrá zpráva - nebyly nalezeny žádné úlohy, které by byly losovány ze směsice sdílených a nesdílených kategorií.';
$string['questiontype'] = 'Typ testové úlohy';
$string['questiontypes'] = 'Typy testových úloh';
$string['rcache'] = 'Vyrovnávací paměť DB záznamů';
$string['rcachettl'] = 'Platnost dočasných záznamů';
$string['recaptchaprivatekey'] = 'ReCAPTCHA soukromý klíč';
$string['recaptchapublickey'] = 'ReCAPTCHA veřejný klíč';
$string['register'] = 'Zaregistrujte vaše stránky';
$string['registermoodleorg'] = 'Když zaregistrujete své stránky na {$a}';
$string['registerwithmoodleorg'] = 'Registrovat na Moodle.org';
$string['registration'] = 'Registrace';
$string['registrationwarning'] = 'Vaše stránky nejsou ještě registrovány';
$string['releasenoteslink'] = 'Informace o této verzi Moodlu najdete v <a target="_new" href="{$a}">Poznámkách k verzi</a>';
$string['rememberusername'] = 'Zapamatovat jméno uživatele';
$string['reportsdeleteconfirm'] = 'Chystáte se zcela odstranit sestavu \'{$a}\'. To odstraní v databázi vše, co souvisí s tímto pluginem. Jste si jisti, že chcete pokračovat?';
$string['reportsmanage'] = 'Správa sestav';
$string['requiredentrieschanged'] = '<strong>ČTĚTE - DŮLEŽITÉ UPOZORNĚNÍ<br/>(tato zpráva se zobrazuje pouze jednou při tomto upgrade)</strong>
<br />Vzhledem k provedené opravě chyby se mění chování modulů Databáze, které používají nastavení \'Počet požadovaných záznamů\' a \'Počet záznamů požadovaných před zpřístupněním databáze\'. Podrobnější vysvětlení změn najdete <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">v diskusním fóru k modulu Databáze</a>. Očekávané chování tohoto nastavení je popsáno <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">v anglické dokumentaci</a>.
<br/><br/>Tato změna ovlivní následující Databáze ve vašich kurzech. Tento seznam si uložte a po skončení upgrade ověřte, že tyto moduly stále pracují dle záměru vyučujících:<br/><strong style="color:red">{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Vyžadovat popis činnosti';
$string['requires'] = 'Vyžaduje';
$string['restorernewroleid'] = 'Obnovené role v kurzu';
$string['reverseproxy'] = 'Reverzní proxy server';
$string['riskconfig'] = 'Uživatelé mohou měnit nastavení a chování stránek (serveru)';
$string['riskconfigshort'] = 'Riziko zásahu do konfigurace';
$string['riskdataloss'] = 'Uživatelé mohou zničit velké množství obsahu nebo informací';
$string['riskdatalossshort'] = 'Riziko ztráty dat';
$string['riskmanagetrust'] = 'Uživatelé mohou měnit úroveň důvěryhodnosti jiných uživatelů';
$string['riskmanagetrustshort'] = 'Správa důvěryhodnosti';
$string['riskpersonal'] = 'Uživatelé mohou získat přístup k soukromým informacím jiných uživatelů';
$string['riskpersonalshort'] = 'Riziko zásahu do soukromí';
$string['riskspam'] = 'Uživatelé mohou zasílat nevyžádnou korespondenci (spam) dalším uživatelům';
$string['riskspamshort'] = 'Riziko spamu';
$string['riskxss'] = 'Uživatelé mohou přidávat soubory či texty umožňující Cross-Site Scripting (XSS).';
$string['riskxssshort'] = 'Riziko XSS';
$string['roleswithexceptions'] = '{$a->roles}, s {$a->exceptions}';
$string['rssglobaldisabled'] = 'Zakázáno na úrovni serveru';
$string['runclamavonupload'] = 'Použít clam AV pro nahrávané soubory';
$string['save'] = 'Uložit';
$string['savechanges'] = 'Uložit změny';
$string['search'] = 'Hledej';
$string['searchinsettings'] = 'Hledej v nastavení';
$string['searchresults'] = 'Výsledky hledání';
$string['sectionerror'] = 'Chyba sekce!';
$string['secureforms'] = 'Použít přidané zabezpečení formuláře';
$string['security'] = 'Zabezpečení';
$string['selectdevice'] = 'Výběr zařízení';
$string['selecttheme'] = 'Výběr motivu pro zařízení {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Kontroly serveru';
$string['serverlimit'] = 'Omezení na straně serveru';
$string['sessionautostartwarning'] = '<p>Byla detekována závažná chyba v konfiguraci serveru. Prosím, upozorněte jeho správce: Moodle vyžaduje změny v nastavení PHP.</p><p>Konfigurační parametr <code>session.auto_start</code> musí být nastaven na hodnotu <code>off</code>.</p><p>Toto nastavení lze například změnit v souboru <code>php.ini</code>, v konfiguraci Apache/IIS nebo pomocí souboru <code>.htaccess</code>.</p>';
$string['sessioncookie'] = 'Předpona názvu cookie';
$string['sessioncookiedomain'] = 'Doména platnosti cookie';
$string['sessioncookiepath'] = 'Cesta platnosti cookie';
$string['sessionhandling'] = 'Session';
$string['sessiontimeout'] = 'Časový limit';
$string['settingfileuploads'] = 'Moodle používá funkci nahrávání souborů. Je třeba ji povolit v nastavení vašeho PHP.';
$string['settingmemorylimit'] = 'Bylo zjištěno nedostatečné množství dostupné paměti. Je třeba navýšit memory_limit v nastavení PHP.';
$string['settingsafemode'] = 'PHP je momentálně provozováno v omezeném režimu, známém jako "safe mode". Moodle není s tímto režimem kompatibilní. Budete-li provozovat Moodle v safe mode, můžete čelit různým problémům s funkcionalitou stránek. Požádejte správce serveru o vypnutí tohoto režimu.';
$string['showcommentscount'] = 'Zobrazit počet komentářů';
$string['showdetails'] = 'Zobrazit details';
$string['showuseridentity'] = 'Zobrazovat identitu uživatele';
$string['simplexmlrequired'] = 'PHP rozšíření SimpleXML je vyžadováno';
$string['sitemaintenance'] = 'Momentálně pracujeme na údržbě těchto stránek, proto nejsou dočasně k dispozici.';
$string['sitemaintenancemode'] = 'Režim údržby';
$string['sitemaintenanceoff'] = 'Režim údržby byl ukončen a stránky zase běží v normálním režimu.';
$string['sitemaintenanceon'] = 'Momentálně probíhá údržba stránek, přihlásit se mohou pouze správci.';
$string['sitemaintenancewarning'] = 'Momentálně probíhá údržba stránek, přihlásit se mohou pouze správci. Režim údržby můžete ukončit <a href="maintenance.php">zde</a>.';
$string['sitemaintenancewarning2'] = 'Momentálně probíhá údržba stránek, přihlásit se mohou pouze správci. Pro návrat k normálnímu režimu <a href="{$a}">vypněte režim údržby</a>.';
$string['sitepolicies'] = 'Pravidla provozu stránek';
$string['sitepolicy'] = 'URL k pravidlům provozu stránek';
$string['sitepolicyguest'] = 'URL pravidel používání stránek pro hosty';
$string['sitepolicyguest_help'] = 'Pokud máte někde publikovaná pravidla provozu vašich stránek, s nimiž musejí všichni hosté souhlasit, uveďte sem jejich URL adresu. Jinak ponechte pole prázdné. Poznámka: přístup nepřihlášených uživatelů můžete i úplně zakázat pomocí nastavení "forcelogin".';
$string['sitepolicy_help'] = 'Máte-li vytvořen text pravidel pro používání stránek, s nímž musejí všichni uživatelé souhlasit, uveďte zde jeho URL. Jinak nechte toto pole prázdné. URL může ukazovat kamkoliv -- jedním z vhodných míst je soubor vložený mezi soubory Moodlu na hlavní stránce, např. http://vas.moodleserver.cz/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Je-li vybráno, zobrazuje se na hlavní stránce serveru tématická sekce.';
$string['slasharguments'] = 'Předávání argumentů za lomítkem';
$string['smartpix'] = 'Vylepšené vyhledávání ikon';
$string['soaprecommended'] = 'Instalace rozšíření SOAP je užitečné pro podporu webových služeb (web services) a pro některé přídavné moduly.';
$string['spellengine'] = 'Kontrola pravopisu';
$string['splrequired'] = 'Rozšíření PHP SPL je povinné.';
$string['stats'] = 'Statistiky';
$string['statsfirstrun'] = 'Maximální interval zpracování';
$string['statsmaxruntime'] = 'Maximální runtime';
$string['statsmoodleorg'] = 'statistiky';
$string['statsruntimedays'] = 'Počet dnů ke zpracování';
$string['statsruntimestart'] = 'Spouštět v';
$string['statsuserthreshold'] = 'Uživatelský práh';
$string['stickyblocks'] = 'Povinné bloky';
$string['stickyblockscourseview'] = 'Stránka kursu';
$string['stickyblocksduplicatenotice'] = 'Pokud se vybraný blok na zvolené stránce již vyskytuje, bude se na ní zobrazovat dvakrát.<br />Povinný blok nebude možné upravovat, duplicitní (nepovinný) blok ano.';
$string['stickyblocksmymoodle'] = 'Můj Moodle';
$string['stickyblockspagetype'] = 'Typ stránky';
$string['strictformsrequired'] = 'Přísné ověřování požadovaných polí';
$string['stripalltitletags'] = 'Odstranit HTML z názvů modulů';
$string['supportcontact'] = 'Kontakt na uživatelskou podporu';
$string['supportemail'] = 'Emailová podpora';
$string['supportname'] = 'Uživatelskou podporu zajišťuje';
$string['supportpage'] = 'Webová podpora';
$string['suspenduser'] = 'Suspendovat účet uživatele';
$string['switchlang'] = 'Přepnout umístění jazyka';
$string['systempaths'] = 'Cesty k souborům';
$string['tablenosave'] = 'Změny v této tabulce jsou ukládány automaticky';
$string['tablesnosave'] = 'Změny v tabulkách jsou ukládány automaticky.';
$string['tabselectedtofront'] = 'Má se v tabulkách, které používají navigaci pomocí záložek, přesunout řádek s právě vybranou záložkou do popředí?';
$string['tabselectedtofronttext'] = 'Přinést vybranou kartu do popředí';
$string['themedesignermode'] = 'Režim úprav grafického motivu';
$string['themelist'] = 'Seznam motivů';
$string['themenoselected'] = 'Není zvolen žádný motiv';
$string['themeresetcaches'] = 'Vymazat dočasné paměti motivů';
$string['themeselect'] = 'Zvolte motiv';
$string['themeselector'] = 'Volba motivu';
$string['themesettings'] = 'Nastavení motivu';
$string['therewereerrors'] = 'Data obsahují chyby.';
$string['timezone'] = 'Výchozí časové pásmo';
$string['timezoneforced'] = 'Správce nepovolil změny';
$string['timezoneisforcedto'] = 'Vnutit nastavení všem uživatelům';
$string['timezonenotforced'] = 'Uživatelé si mohou vybrat časové pásmo';
$string['tokenizerrecommended'] = 'Instalace volitelného rozšíření PHP Tokenizer je doporučována - zlepšuje možnosti Moodle Networking.';
$string['tools'] = 'Nástroje správce';
$string['toolsmanage'] = 'Správa nástrojů správce';
$string['unattendedoperation'] = 'Bez obsluhy';
$string['unbookmarkthispage'] = 'Odstranit záložku na tuto stránku';
$string['unicoderecommended'] = 'Doporučujeme ukládání dat v kódování Unicode (UTF-8). Nové instalace by měly být založeny nad databází s výchozím kódováním Unicode. Pokud přecházíte z nižších verzí, měli byste podstoupit proces migrace na UTF-8 (viz stránku Správa).';
$string['unicoderequired'] = 'Je nezbytné ukládání dat v kódování Unicode (UTF-8). Nové instalace musí být založeny nad databází s výchozím kódováním Unicode. Pokud přecházíte z nižších verzí, měli byste podstoupit proces migrace na UTF-8 (viz stránku Správa).';
$string['uninstallplugin'] = 'Odinstalovat';
$string['unsettheme'] = 'Zrušit nastavení motivu';
$string['unsupported'] = 'Nepodporováno';
$string['unsuspenduser'] = 'Aktivovat účet uživatele';
$string['updateaccounts'] = 'Aktualizovat stávající účty';
$string['updateautocheck'] = 'Automaticky kontrolovat dostupné aktualizace';
$string['updateautocheck_desc'] = 'Zda se mají automaticky kontrolovat dostupné aktualizace kódu Moodle a všech dalších modulů. Správci stránek jsou upozorňováni na nové aktualizace.';
$string['updateavailable'] = 'Je dostupná novější verze Moodle!';
$string['updateavailabledetailslink'] = 'Více informací na {$a->url}';
$string['updateavailableforplugin'] = 'Pro některé z vašich modulů jsou dostupné novější verze.';
$string['updateavailable_moreinfo'] = 'Více informací ...';
$string['updateavailablenot'] = 'Váš Moodle běží na aktuální verzi';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verze {$a}';
$string['updatecomponent'] = 'Aktualizovat komponentu';
$string['updatenotifications'] = 'Dostupné aktualizace';
$string['updatenotificationsubject'] = 'Pro váš Moodle jsou dostupné aktualizace';
$string['updatenotifybuilds'] = 'Upozorňovat na aktualizace stávající verze';
$string['updatenotifybuilds_desc'] = 'Zda chcete být rovněž informování o aktualizacích stávající verze (tzv. "build" nebo "plus verze"). Aktualizace pro stávající verze jsou většinou vydávány každý týden a obsahují nejnovější opravy zdrojového kódu. Je-li toto zakázáno, budete informováni pouze o vydání vyšších verzí Moodle (tj. pokud bude dostupná verze s vyšším číslem). Toto nastavení neovlivňuje kontrolu dostupných aktualizací rozšiřujících modulů.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 obsahuje řadu bezpečnostních opatření pro ukládání uživatelských hesel a tvorbu záloh kurzů.<br />
Některá nastavení a oprávnění týkající se tvorby záloh kurzů mohla být změněna.<br />
Podrobné informace najdete na stránce <a href="http://docs.moodle.org/dev/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a></p>';
$string['upgrade197noticesubject'] = 'Upgrade na Moodle 1.9.7 - bezpečnostní opatření';
$string['upgrade197salt'] = 'Pokud ukládáte hesla vašich uživatelů v Moodle databázi, měli byste zvážit aktivaci <a href="{$a}" target="_blank">Solení hesel</a> ke snížení rizika odhalení hesel vašich uživatelů.';
$string['upgradeerror'] = 'Neznámá chyba při aktualizaci modulu {$a->plugin} na verzi {$a->version}, nelze pokračovat';
$string['upgradeforumread'] = 'Do Moodlu 1.5 byla přidána nová funkce, která umožňuje sledovat a označovat stav diskusních příspěvků \'přečteno/nepřečteno\'.<br />Chcete-li tuto funkci používat, musíte <a href="{$a}">aktualizovat tabulky v databázi</a>.';
$string['upgradeforumreadinfo'] = 'Do Moodlu 1.5 byla přidána nová funkce, která umožňuje u každého uživatele zaznamenávat stav příspěvků \'přečteno/nepřečteno\'. Chcete-li tuto funkci používat, je třeba doplnit ke stávajícím příspěvkům potřebné informace. Tento proces může v závislosti na rozsahu vašich stránek trvat až několik hodin a na vašem databázovém serveru bude celkem rušno, takže doporučujeme provést tuto činnost ve vhodném čase (např. o víkendu v noci). Vaše stránky budou nicméně stále v provozu a práce uživatelů by neměla být výrazněji ovlivněna. Jakmile proces spustíte, měli byste jej nechat dokončit (tj. nechat otevřené příslušné okno prohlížeče). Ale nemějte obavy, pokud okno zavřete a proces ukončíte, můžete kdykoliv začít znovu.<br /><br />Chcete nyní spustit aktualizaci databáze?';
$string['upgradelogs'] = 'Pro plnou funkčnost je nutné vaše staré protokoly aktualizovat. <a href="{$a}">Více informací</a>';
$string['upgradelogsinfo'] = 'Ve způsobu uchovávání protokolů došlo ke změnám. Chcete-li zobrazovat vaše dosavadní protokoly podle činností, je nutné všechny uložené protokoly aktualizovat. V závislosti na jejich množství to může trvat delší dobu (i několik hodin), na rozsáhlejších stránkách tento proces výrazně zatíží databázi. Jakmile jednou proces spustíte, měli byste jej nechat dokončit (tj. nechte okno prohlížeče otevřené). Nemusíte mít obavy -- vaše stránky budou v průběhu aktualizace pro uživatele stále dostupné.<br /><br />Chcete nyní aktualizovat protokoly?';
$string['upgradepluginsfirst'] = 'Musíte si stáhnout a nainstalovat dostupné aktualizace ručně';
$string['upgradepluginsinfo'] = 'Aktualizace modulů';
$string['upgradesettings'] = 'Nová nastavení';
$string['upgradesettingsintro'] = 'V průběhu poslední aktualizace přibyla následující nová nastavení. Proveďte nezbytné úpravy oproti výchozím hodnotám a stiskněte tlačítko "Uložit změny" na konci této stránky.';
$string['upgradestalefiles'] = 'Byly zjištěny neplatné soubory, aktualizace nemůže pokračovat';
$string['upgradestart'] = 'Aktualizovat databázi Moodle';
$string['upgradesure'] = 'Soubory Moodlu byly změněny a chystáte se upgradovat server na verzi: <br /><br /><strong>{$a}</strong><br /><br />Jakmile tak učiníte, není cesty zpět. Ujistěte se, že máte k dispozici potřebné zálohy.<br /><br />Upgrade může v závislosti na okolnostech trvat i velmi dlouhou dobu.<br /><br />Jste si jisti, že chcete upgradovat server na tuto verzi?';
$string['upgradetimedout'] = 'Vypršel časový limit. Restartujte aktualizaci.';
$string['upgradingdata'] = 'Aktualizace dat';
$string['upgradinglogs'] = 'Aktualizace protokolů';
$string['upgradingversion'] = 'Upgraduji na novou verzi';
$string['upwards'] = 'a vyšší';
$string['useblogassociations'] = 'Povolit asociování';
$string['useexternalyui'] = 'Používat online verzi YUI knihoven';
$string['usehtmleditor'] = 'Použít HTML editor';
$string['user'] = 'Uživatel';
$string['userbulk'] = 'Hromadné operace';
$string['userlist'] = 'Seznam uživatelů';
$string['userpolicies'] = 'Zásady správy uživatelů';
$string['userpreference'] = 'Uživatelské předvolby';
$string['userquota'] = 'Uživatelská kvóta';
$string['users'] = 'Uživatelé';
$string['usesitenameforsitepages'] = 'Pro tyto stránky použijte jméno webu';
$string['usetags'] = 'Povolit štítky';
$string['validateerror'] = 'Tato hodnota není validní:';
$string['verifychangedemail'] = 'Omezit domény při změně emailu';
$string['warningcurrentsetting'] = 'Neplatná současná hodnota:<b>{$a}</b>';
$string['webproxy'] = 'Proxy server';
$string['webproxyinfo'] = 'Vyplňte následující informace, jestliže tento Moodle nemá přístup k internetu. Přístup k internetu je třeba ke stahování jazykových balíčků, RSS kanálům, časových zón, atd.<br/><em>Velmi doporučená je instalace PHP cURL.</em>';
$string['xmlrpcrecommended'] = 'Instalace rozšíření pro podporu XML-RPC je velmi užitečná pro síťové funkce Moodlu.';
$string['xmlstrictheaders'] = 'XML strict hlavičky';
$string['yuicomboloading'] = 'Kombinované nahrávání YUI knihoven';
$string['ziprequired'] = 'PHP rozšíření ZIP je povinné. Nelze již používat binárky info-ZIP nebo knihovnu PclZip.';
