# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.5 on 2023-09-18 08:09

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import weblate.utils.fields
import weblate.utils.render


class Migration(migrations.Migration):
    replaces = [
        ("accounts", "0001_squashed_0019_auto_20200403_2004"),
        ("accounts", "0002_profile_nearby_strings"),
        ("accounts", "0003_auto_20200630_1321"),
        ("accounts", "0004_profile_commented"),
        ("accounts", "0005_update_comment_count"),
        ("accounts", "0006_auto_20200903_0817"),
        ("accounts", "0007_auto_20200904_0840"),
        ("accounts", "0008_auto_20200923_1216"),
        ("accounts", "0009_auto_20200923_2023"),
        ("accounts", "0010_auto_20201213_1314"),
        ("accounts", "0011_auto_20210106_1903"),
        ("accounts", "0012_profile_auto_watch"),
        ("accounts", "0013_auto_20210217_1653"),
        ("accounts", "0014_auto_20210506_1421"),
        ("accounts", "0015_auto_20210512_1955"),
        ("accounts", "0016_alter_auditlog_activity"),
        ("accounts", "0017_alter_verifiedemail_email"),
        ("accounts", "0018_alter_profile_language"),
        ("accounts", "0019_alter_auditlog_user"),
        ("accounts", "0020_anonymous_auditlog"),
        ("accounts", "0021_profile_commit_email_verifiedemail_is_deliverable"),
        ("accounts", "0022_alter_profile_linkedin"),
        ("accounts", "0023_cleanup_deleted_users"),
        ("accounts", "0024_rename_be_latn"),
        ("accounts", "0025_profile_theme"),
        ("accounts", "0026_alter_subscription_notification_and_more"),
        ("accounts", "0027_alter_subscription_notification"),
        ("accounts", "0028_auditlog_params_new"),
        ("accounts", "0029_jsonfield"),
        ("accounts", "0030_remove_auditlog_params"),
        ("accounts", "0031_rename_params_new_auditlog_params"),
        ("accounts", "0032_alter_auditlog_activity"),
        ("accounts", "0033_alter_auditlog_activity"),
        ("accounts", "0034_alter_subscription_frequency_and_more"),
    ]

    initial = True

    dependencies = [
        ("lang", "0001_squashed_weblate_5"),
        ("social_django", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("authtoken", "0002_auto_20160226_1747"),
        ("trans", "0001_squashed_weblate_5"),
    ]

    operations = [
        migrations.CreateModel(
            name="Profile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        choices=settings.LANGUAGES,
                        max_length=10,
                        verbose_name="Interface Language",
                    ),
                ),
                ("suggested", models.IntegerField(db_index=True, default=0)),
                ("translated", models.IntegerField(db_index=True, default=0)),
                (
                    "languages",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Choose the languages you can translate to. These will be offered to you on the dashboard for easier access to your chosen translations.",
                        to="lang.language",
                        verbose_name="Translated languages",
                    ),
                ),
                (
                    "secondary_languages",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Choose languages you can understand, strings in those languages will be shown in addition to the source string.",
                        related_name="secondary_profile_set",
                        to="lang.language",
                        verbose_name="Secondary languages",
                    ),
                ),
                (
                    "watched",
                    models.ManyToManyField(
                        blank=True,
                        help_text="You can receive notifications for watched projects and they are shown on the dashboard by default.",
                        to="trans.project",
                        verbose_name="Watched projects",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "hide_completed",
                    models.BooleanField(
                        default=False,
                        verbose_name="Hide completed translations on the dashboard",
                    ),
                ),
                (
                    "secondary_in_zen",
                    models.BooleanField(
                        default=True,
                        verbose_name="Show secondary translations in the Zen mode",
                    ),
                ),
                (
                    "hide_source_secondary",
                    models.BooleanField(
                        default=False,
                        verbose_name="Hide source if a secondary translation exists",
                    ),
                ),
                (
                    "dashboard_component_list",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="trans.componentlist",
                        verbose_name="Default component list",
                    ),
                ),
                (
                    "dashboard_view",
                    models.IntegerField(
                        choices=[
                            (1, "Watched translations"),
                            (6, "Component lists"),
                            (4, "Component list"),
                            (5, "Suggested translations"),
                        ],
                        default=1,
                        verbose_name="Default dashboard view",
                    ),
                ),
                (
                    "editor_link",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Enter a custom URL to be used as link to the source code. You can use {{branch}} for branch, {{filename}} and {{line}} as filename and line placeholders.",
                        max_length=200,
                        validators=[weblate.utils.render.validate_editor],
                        verbose_name="Editor link",
                    ),
                ),
                (
                    "special_chars",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="You can specify additional special visual keyboard characters to be shown while translating. It can be useful for characters you use frequently, but are hard to type on your keyboard.",
                        max_length=30,
                        verbose_name="Special characters",
                    ),
                ),
                ("uploaded", models.IntegerField(db_index=True, default=0)),
                (
                    "translate_mode",
                    models.IntegerField(
                        choices=[(0, "Full editor"), (1, "Zen mode")],
                        default=0,
                        verbose_name="Translation editor mode",
                    ),
                ),
                (
                    "zen_mode",
                    models.IntegerField(
                        choices=[(0, "Top to bottom"), (1, "Side by side")],
                        default=0,
                        verbose_name="Zen editor mode",
                    ),
                ),
                (
                    "nearby_strings",
                    models.SmallIntegerField(
                        default=settings.NEARBY_MESSAGES,
                        help_text="Number of nearby strings to show in each direction in the full editor.",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Number of nearby strings",
                    ),
                ),
                ("commented", models.IntegerField(db_index=True, default=0)),
                (
                    "company",
                    models.CharField(
                        blank=True, max_length=100, verbose_name="Company"
                    ),
                ),
                (
                    "github",
                    models.SlugField(
                        blank=True, db_index=False, verbose_name="GitHub username"
                    ),
                ),
                (
                    "linkedin",
                    models.SlugField(
                        allow_unicode=True,
                        blank=True,
                        db_index=False,
                        help_text="Your LinkedIn profile name from linkedin.com/in/profilename",
                        verbose_name="LinkedIn profile name",
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        blank=True, max_length=100, verbose_name="Location"
                    ),
                ),
                (
                    "public_email",
                    weblate.utils.fields.EmailField(
                        blank=True, max_length=190, verbose_name="Public e-mail"
                    ),
                ),
                (
                    "twitter",
                    models.SlugField(
                        blank=True, db_index=False, verbose_name="Twitter username"
                    ),
                ),
                ("website", models.URLField(blank=True, verbose_name="Website URL")),
                (
                    "codesite",
                    models.URLField(
                        blank=True,
                        help_text="Link to your code profile for services like Codeberg or GitLab.",
                        verbose_name="Code site URL",
                    ),
                ),
                (
                    "fediverse",
                    models.URLField(
                        blank=True,
                        help_text="Link to your Fediverse profile for federated services like Mastodon or diaspora*.",
                        verbose_name="Fediverse URL",
                    ),
                ),
                (
                    "liberapay",
                    models.SlugField(
                        blank=True,
                        db_index=False,
                        help_text="Liberapay is a platform to donate money to teams, organizations and individuals.",
                        verbose_name="Liberapay username",
                    ),
                ),
                (
                    "auto_watch",
                    models.BooleanField(
                        default=settings.DEFAULT_AUTO_WATCH,
                        help_text="Whenever you translate a string in a project, you will start watching it.",
                        verbose_name="Automatically watch projects on contribution",
                    ),
                ),
                (
                    "commit_email",
                    weblate.utils.fields.EmailField(
                        blank=True, max_length=190, verbose_name="Commit e-mail"
                    ),
                ),
                (
                    "theme",
                    models.CharField(
                        choices=[
                            ("auto", "Sync with system"),
                            ("light", "Light"),
                            ("dark", "Dark"),
                        ],
                        default="auto",
                        max_length=10,
                        verbose_name="Theme",
                    ),
                ),
            ],
            options={
                "verbose_name": "User profile",
                "verbose_name_plural": "User profiles",
            },
        ),
        migrations.CreateModel(
            name="VerifiedEmail",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("email", weblate.utils.fields.EmailField(max_length=190)),
                (
                    "social",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="social_django.usersocialauth",
                    ),
                ),
                ("is_deliverable", models.BooleanField(default=True)),
            ],
            options={
                "verbose_name": "Verified e-mail",
                "verbose_name_plural": "Verified e-mails",
            },
        ),
        migrations.CreateModel(
            name="AuditLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "activity",
                    models.CharField(
                        choices=[
                            ("accepted", "accepted"),
                            ("auth-connect", "auth-connect"),
                            ("auth-disconnect", "auth-disconnect"),
                            ("autocreated", "autocreated"),
                            ("blocked", "blocked"),
                            ("connect", "connect"),
                            ("email", "email"),
                            ("failed-auth", "failed-auth"),
                            ("full_name", "full_name"),
                            ("invited", "invited"),
                            ("locked", "locked"),
                            ("login", "login"),
                            ("login-new", "login-new"),
                            ("password", "password"),
                            ("register", "register"),
                            ("removal-request", "removal-request"),
                            ("removed", "removed"),
                            ("reset", "reset"),
                            ("reset-request", "reset-request"),
                            ("sent-email", "sent-email"),
                            ("tos", "tos"),
                            ("trial", "trial"),
                            ("username", "username"),
                        ],
                        db_index=True,
                        max_length=20,
                    ),
                ),
                ("address", models.GenericIPAddressField(null=True)),
                ("timestamp", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("user_agent", models.CharField(default="", max_length=200)),
                ("params", models.JSONField(default=dict)),
            ],
            options={
                "verbose_name": "Audit log entry",
                "verbose_name_plural": "Audit log entries",
            },
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "notification",
                    models.CharField(
                        choices=[
                            (
                                "RepositoryNotification",
                                "Operation was performed in the repository",
                            ),
                            ("LockNotification", "Component was locked or unlocked"),
                            ("LicenseNotification", "License was changed"),
                            ("ParseErrorNotification", "Parse error occurred"),
                            (
                                "NewStringNotificaton",
                                "New string is available for translation",
                            ),
                            (
                                "NewContributorNotificaton",
                                "Contributor made their first translation",
                            ),
                            ("NewSuggestionNotificaton", "Suggestion was added"),
                            ("NewCommentNotificaton", "Comment was added"),
                            (
                                "MentionCommentNotificaton",
                                "You were mentioned in a comment",
                            ),
                            (
                                "LastAuthorCommentNotificaton",
                                "Your translation received a comment",
                            ),
                            (
                                "TranslatedStringNotificaton",
                                "String was edited by user",
                            ),
                            ("ApprovedStringNotificaton", "String was approved"),
                            ("ChangedStringNotificaton", "String was changed"),
                            (
                                "NewTranslationNotificaton",
                                "New language was added or requested",
                            ),
                            (
                                "NewComponentNotificaton",
                                "New translation component was created",
                            ),
                            (
                                "NewAnnouncementNotificaton",
                                "Announcement was published",
                            ),
                            ("NewAlertNotificaton", "New alert emerged in a component"),
                            ("MergeFailureNotification", "Repository operation failed"),
                            (
                                "PendingSuggestionsNotification",
                                "Pending suggestions exist",
                            ),
                            ("ToDoStringsNotification", "Unfinished strings exist"),
                        ],
                        max_length=100,
                    ),
                ),
                (
                    "scope",
                    models.IntegerField(
                        choices=[
                            (0, "All"),
                            (10, "Watched"),
                            (20, "Administered"),
                            (30, "Project"),
                            (40, "Component"),
                        ]
                    ),
                ),
                (
                    "frequency",
                    models.IntegerField(
                        choices=[
                            (0, "No notification"),
                            (1, "Instant notification"),
                            (2, "Daily digest"),
                            (3, "Weekly digest"),
                            (4, "Monthly digest"),
                        ]
                    ),
                ),
                (
                    "component",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.component",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.project",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("onetime", models.BooleanField(default=False)),
            ],
            options={
                "unique_together": {
                    ("notification", "scope", "project", "component", "user")
                },
                "verbose_name": "Notification subscription",
                "verbose_name_plural": "Notification subscriptions",
            },
        ),
    ]
