# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.1.4 on 2024-12-11 11:35

from django.db import migrations


def disable_bot_notifications(apps, schema_editor) -> None:
    Subscription = apps.get_model("accounts", "Subscription")
    Subscription.objects.filter(user__is_bot=True).delete()


class Migration(migrations.Migration):
    dependencies = [
        ("accounts", "0012_alter_auditlog_activity_profile_last_2fa"),
        ("weblate_auth", "0003_alter_autogroup_options_alter_autogroup_group_and_more"),
    ]

    operations = [
        migrations.RunPython(
            disable_bot_notifications, migrations.RunPython.noop, elidable=True
        ),
    ]
