# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.2.6 on 2025-11-01 09:36

from django.db import migrations


def update_audit_log(apps, schema_editor) -> None:
    """Remove detailed audit log info for admin actions."""
    AuditLog = apps.get_model("accounts", "AuditLog")
    AuditLog.objects.filter(
        activity__in={
            "invited",
            "admin-locked",
            "autocreated",
            "blocked",
            "enabled",
            "disabled",
            "disabled-expiry",
        }
    ).update(address=None, user_agent="")


class Migration(migrations.Migration):
    dependencies = [
        ("accounts", "0020_alter_auditlog_activity"),
    ]

    operations = [
        migrations.RunPython(
            update_audit_log, migrations.RunPython.noop, elidable=True
        ),
    ]
