# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 4.2.5 on 2024-02-28 10:14

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("trans", "0012_alter_announcement_notify"),
        ("addons", "0002_remove_addon_project_scope_addon_project_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="AddonActivityLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "event",
                    models.IntegerField(
                        choices=[
                            (1, "repository post-push"),
                            (2, "repository post-update"),
                            (3, "repository pre-commit"),
                            (4, "repository post-commit"),
                            (5, "repository post-add"),
                            (6, "unit post-create"),
                            (7, "storage post-load"),
                            (8, "unit post-save"),
                            (9, "repository pre-update"),
                            (10, "repository pre-push"),
                            (11, "daily"),
                            (12, "component update"),
                        ]
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("details", models.JSONField(default=dict)),
                (
                    "addon",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="addons.addon"
                    ),
                ),
                (
                    "component",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.component",
                    ),
                ),
            ],
            options={
                "verbose_name": "add-on activity log",
                "verbose_name_plural": "add-on activity logs",
                "ordering": ["-created"],
            },
        ),
    ]
