# Copyright © Michal Čihař <michal@weblate.org>
#
# SPDX-License-Identifier: GPL-3.0-or-later

# Generated by Django 5.2 on 2025-07-27 17:19

from django.db import migrations

from weblate.trans.filter import FILTERS


def update_autotranslate_filter_type(apps, schema_editor) -> None:
    """
    Update filter_type to use search queries for autotranslate addons.

    Maps old filter types to their corresponding search queries.
    """
    Addon = apps.get_model("addons", "Addon")

    filter_mapping = {x[0]: x[2] for x in FILTERS.full_list}

    addons = Addon.objects.filter(
        name="weblate.autotranslate.autotranslate", configuration__has_key="filter_type"
    )

    for addon in addons:
        config = addon.configuration
        # preserve filter_type in the configuration for reverse migration
        old_filter = config.get("filter_type")
        config["q"] = filter_mapping[old_filter]
        addon.save(update_fields=["configuration"])


class Migration(migrations.Migration):
    dependencies = [
        ("addons", "0006_alter_addonactivitylog_component"),
    ]

    operations = [
        migrations.RunPython(
            update_autotranslate_filter_type,
            migrations.RunPython.noop,
            elidable=True,
        ),
    ]
